/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.rmi;

import java.io.DataInput;
import java.io.DataOutput;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.UnexpectedException;
import java.util.Map;
import jeus.rmi.spec.ClientInterceptor;
import jeus.rmi.spec.InterceptorContextProvider;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.spi.LoginService;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.client.TMContextCarrier;
import jeus.util.ByteUtil;
import jeus.util.trace.GID;
import jeus.util.trace.GIDException;

public class EJBClientInterceptor
implements ClientInterceptor {
    private static final String RETURN_TX_KEY = "RETURN_TX";
    private static final long serialVersionUID = 2254896728115055864L;

    public void intercept(DataOutput dout, InterceptorContextProvider invoker) throws Exception {
        Map context = invoker.getContext();
        try {
            dout.writeByte(0);
            byte[] currentSubject = LoginService.getCurrentSubjectSerialized();
            dout.writeInt(currentSubject.length);
            dout.write(currentSubject);
            byte[] txContext = ContextSenderReceiver.getPropagationContext();
            if (txContext[0] == -2 || txContext[0] == -3) {
                context.put(RETURN_TX_KEY, RETURN_TX_KEY);
            }
            dout.write(txContext);
            byte[] gidBytes = GID.getCurrentGIDBytes();
            byte[] lenBytes = new byte[4];
            int length = 0;
            if (GID.useGID) {
                if (gidBytes == null) {
                    GID.createCurrentGID();
                    GID.increaseSeqNumber();
                    gidBytes = GID.getCurrentGIDBytes();
                } else {
                    GID.increaseSeqNumber();
                }
                length = gidBytes.length;
            }
            ByteUtil.putInt((byte[])lenBytes, (int)0, (int)length);
            dout.write(lenBytes);
            if (length > 0) {
                dout.write(gidBytes);
            }
        }
        catch (ServiceException e) {
            throw new UnexpectedException("undeclared checked exception");
        }
        catch (SecurityException e) {
            throw new UnexpectedException("undeclared checked exception");
        }
    }

    public void afterIntercept(DataInput din, InterceptorContextProvider invoker) throws Exception {
        if (invoker.getContext().get(RETURN_TX_KEY) != null) {
            ContextSenderReceiver.readTMCtx(din);
        }
        byte[] lenBytes = new byte[4];
        din.readFully(lenBytes);
        int gidLen = ByteUtil.convertToInt((byte[])lenBytes);
        if (gidLen > 0) {
            byte[] gidBytes = new byte[gidLen];
            din.readFully(gidBytes);
            GID.setCurrentGID(gidBytes);
        }
    }

    public void exceptionOccurred(Throwable exception, InterceptorContextProvider interceptorContextProvider) throws Throwable {
        if (exception instanceof TMContextCarrier) {
            TMContextCarrier car = (TMContextCarrier)exception;
            ContextSenderReceiver.contextPropagated(car.ctx, null);
            exception = car.ex;
        }
        if (exception instanceof GIDException) {
            GIDException gex = (GIDException)exception;
            GID.setCurrentGID(gex.gidBytes);
            exception = gex.ex;
        }
        if (exception instanceof ServerException) {
            ServerException e = (ServerException)exception;
            if (e.detail != null && e.detail instanceof RemoteException) {
                throw (RemoteException)e.detail;
            }
        }
        throw exception;
    }
}

