/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.rmi;

import java.io.IOException;
import java.io.ObjectOutput;
import java.rmi.server.RemoteCall;
import java.rmi.server.Skeleton;
import jeus.ejb.bean.rmi.InterceptedServerInvokerImpl;
import jeus.ejb.bean.rmi.RMIInterceptorProvider;
import jeus.rmi.spec.InterceptorContextProvider;
import jeus.rmi.spec.ServerInterceptor;
import jeus.util.logging.JeusLogger;

public abstract class RMISkeleton
implements Skeleton {
    private static ThreadLocal serverInvoker = new ThreadLocal();
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.cluster");
    private ServerInterceptor serverInterceptor;

    protected void callServerInterceptor(RemoteCall call) throws Exception {
        if (this.serverInterceptor != null) {
            InterceptorContextProvider interceptedServerInvoker = (InterceptorContextProvider)serverInvoker.get();
            if (interceptedServerInvoker == null) {
                interceptedServerInvoker = new InterceptedServerInvokerImpl();
                serverInvoker.set(interceptedServerInvoker);
            } else {
                interceptedServerInvoker.getContext().clear();
            }
            this.serverInterceptor.intercept(call.getInputStream(), interceptedServerInvoker);
        }
    }

    protected ObjectOutput callAfterServerInterceptor(RemoteCall call) throws IOException {
        ObjectOutput stream = call.getResultStream(true);
        if (this.serverInterceptor != null) {
            InterceptedServerInvokerImpl interceptedServerInvoker = (InterceptedServerInvokerImpl)serverInvoker.get();
            this.serverInterceptor.afterIntercept(stream, interceptedServerInvoker);
        }
        return stream;
    }

    protected void exceptionOccurred(Exception ex) throws Throwable {
        if (this.serverInterceptor == null) {
            throw ex;
        }
        InterceptedServerInvokerImpl interceptedServerInvoker = (InterceptedServerInvokerImpl)serverInvoker.get();
        this.serverInterceptor.exceptionOccurred(ex, interceptedServerInvoker);
    }

    protected void handleFinally() {
        if (this.serverInterceptor != null) {
            InterceptedServerInvokerImpl interceptedServerInvoker = (InterceptedServerInvokerImpl)serverInvoker.get();
            this.serverInterceptor.handleFinally(interceptedServerInvoker);
        }
    }

    protected void setServerInterceptor(RMIInterceptorProvider provider) {
        this.serverInterceptor = provider.getServerInterceptor();
    }
}

