/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.bean.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.ejb.EJBObject;
import jeus.ejb.bean.objectbase.SessionCluster;
import jeus.ejb.bean.rmi.JEUSRMIStub;
import jeus.ejb.bean.rmi.RMIStub;
import jeus.ejb.bean.rmi.StubClusterSupport;
import jeus.ejb.client.BusinessHome;
import jeus.ejb.client.RemoteBusinessObjectClientHandler;

public class StatefulSessionStubClusterSupport
extends StubClusterSupport {
    private String sessionID;
    private String businessInterfaceName;

    public StatefulSessionStubClusterSupport(Object stub) {
        super(stub);
    }

    public StatefulSessionStubClusterSupport() {
    }

    public StatefulSessionStubClusterSupport(Object stub, String businessInterfaceName, String sessionID) {
        super(stub);
        this.sessionID = sessionID;
        this.businessInterfaceName = businessInterfaceName;
    }

    protected Object getActualStubFromHome(Object homeStub) throws Exception {
        if (this.businessInterfaceName == null) {
            EJBObject obj = ((SessionCluster)homeStub).findByInstanceKey(this.sessionID);
            if (obj instanceof JEUSRMIStub) {
                this.sessionID = ((StatefulSessionStubClusterSupport)((JEUSRMIStub)obj).getClusterSupport()).sessionID;
            } else if (obj instanceof RMIStub) {
                this.sessionID = ((StatefulSessionStubClusterSupport)((RMIStub)obj).getClusterSupport()).sessionID;
            }
            return obj;
        }
        Object bizObjectStub = ((BusinessHome)homeStub).findByInstanceKey(this.businessInterfaceName, this.sessionID);
        InvocationHandler iv = Proxy.getInvocationHandler(bizObjectStub);
        this.sessionID = ((RemoteBusinessObjectClientHandler)iv).getSessionID();
        return iv;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }
}

