/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import jeus.ejb.client.BusinessHome;
import jeus.ejb.client.RemoteBusinessHomeClientHandler;
import jeus.jndi.objectfactory.ObjectRefAddr;

public class BusinessObjectFactory
implements ObjectFactory {
    public static final String ADDR_HOME_JNDINAME = "home.jndiname";
    public static final String ADDR_INTERFACE = "interface";
    public static final String INTERFACE_CLASS = "interface.class";

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        StringRefAddr homeAddr = (StringRefAddr)ref.get(ADDR_HOME_JNDINAME);
        StringRefAddr interfaceAddr = (StringRefAddr)ref.get(ADDR_INTERFACE);
        ObjectRefAddr interfaceClassAddr = (ObjectRefAddr)ref.get(INTERFACE_CLASS);
        String homeJndiName = (String)homeAddr.getContent();
        String interfaze = (String)interfaceAddr.getContent();
        try {
            Object businessObject;
            InitialContext ctx = new InitialContext(environment);
            BusinessHome home = (BusinessHome)ctx.lookup(homeJndiName);
            if (home instanceof RemoteBusinessHomeClientHandler) {
                ClassLoader loader;
                Class<?> currentInterfaceClass;
                Class interfaceClass;
                boolean isLocalCall = false;
                if (interfaceClassAddr != null && (interfaceClass = (Class)interfaceClassAddr.getContent()) != null && (currentInterfaceClass = (loader = Thread.currentThread().getContextClassLoader()).loadClass(interfaze)) == interfaceClass) {
                    isLocalCall = true;
                }
                businessObject = ((RemoteBusinessHomeClientHandler)home).create(interfaze, isLocalCall);
            } else {
                businessObject = home.create(interfaze);
            }
            ctx.close();
            return businessObject;
        }
        catch (NamingException ex) {
            throw ex;
        }
        catch (EJBException ex) {
            throw ex;
        }
        catch (RemoteException ex) {
            throw new EJBException((Exception)ex);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }
}

