/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import jeus.ejb.bean.objectbase.JEUSClusterStub;
import jeus.ejb.client.BusinessHome;
import jeus.ejb.client.rmi.RemoteInvocationImpl;
import jeus.ejb.client.rmi.RemoteInvoker;
import jeus.ejb.client.rmi.RemoteInvokerClient;
import jeus.ejb.util.MethodUtils;

public class RemoteBusinessHomeClientHandler
extends RemoteInvokerClient
implements BusinessHome {
    private static final long serialVersionUID = 60L;
    public static final String createMethodSig;
    public static final String findByInstanceKeyMethodSig;
    public static final String pingMethodSig;
    private transient BusinessHome localBusinessHome;

    public RemoteBusinessHomeClientHandler(RemoteInvoker stub) {
        super(stub);
    }

    private boolean hasLocalStub() {
        return this.localBusinessHome != null;
    }

    public void setLocalStub(BusinessHome businessHome) {
        this.localBusinessHome = businessHome;
    }

    public void ping() throws RemoteException {
        if (this.hasLocalStub()) {
            this.localBusinessHome.ping();
        } else {
            RemoteInvocationImpl invocation = new RemoteInvocationImpl();
            invocation.setSignature(pingMethodSig);
            this.invokeRemoteMethod(invocation);
        }
    }

    public Object create(String interfaze, boolean isLocalCall) throws RemoteException {
        if (isLocalCall && this.hasLocalStub()) {
            return this.localBusinessHome.create(interfaze);
        }
        return this.create(interfaze);
    }

    public Object create(String interfaze) throws RemoteException {
        RemoteInvocationImpl invocation = new RemoteInvocationImpl();
        invocation.setSignature(createMethodSig);
        invocation.setArgs(new Object[]{interfaze});
        return this.invokeRemoteMethod(invocation);
    }

    public Object findByInstanceKey(String interfaze, String sessionID) throws RemoteException {
        RemoteInvocationImpl invocation = new RemoteInvocationImpl();
        invocation.setSignature(findByInstanceKeyMethodSig);
        invocation.setArgs(new Object[]{interfaze, sessionID});
        return this.invokeRemoteMethod(invocation);
    }

    private Object invokeRemoteMethod(RemoteInvocationImpl invocation) throws RemoteException {
        try {
            Object obj = super.invoke(invocation);
            if (this.clustered) {
                InvocationHandler handler;
                if (obj instanceof JEUSClusterStub) {
                    ((JEUSClusterStub)obj).__jeus_setCluster(this.clusterSupport.getExportName(), this.clusterSupport.getCluster());
                } else if (obj != null && Proxy.isProxyClass(obj.getClass()) && (handler = Proxy.getInvocationHandler(obj)) instanceof JEUSClusterStub) {
                    ((JEUSClusterStub)((Object)handler)).__jeus_setCluster(this.clusterSupport.getExportName(), this.clusterSupport.getCluster());
                }
            }
            return obj;
        }
        catch (Throwable ex) {
            if (ex instanceof ServerException) {
                ServerException e = (ServerException)ex;
                if (e.detail != null && e.detail instanceof RemoteException) {
                    ex = e.detail;
                }
            }
            if (ex instanceof RemoteException) {
                throw (RemoteException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RemoteException("", ex);
        }
    }

    static {
        try {
            Method createMethod = RemoteBusinessHomeClientHandler.class.getMethod("create", String.class);
            createMethodSig = MethodUtils.getSignature(createMethod);
            Method findByInstanceKeyMethod = RemoteBusinessHomeClientHandler.class.getMethod("findByInstanceKey", String.class, String.class);
            findByInstanceKeyMethodSig = MethodUtils.getSignature(findByInstanceKeyMethod);
            Method pingMethod = RemoteBusinessHomeClientHandler.class.getMethod("ping", new Class[0]);
            pingMethodSig = MethodUtils.getSignature(pingMethod);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

