/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.IOException;
import java.lang.reflect.Method;
import jeus.ejb.compiler.RMICompilerConstant;
import jeus.ejb.util.CodeWriter;
import jeus.rmi.impl.server.Util;
import jeus.util.StringUtil;
import jeus.util.codegen.ClassWriter;
import jeus.util.codegen.MethodWriter;

public class JEUSRMICompilerConstant
implements RMICompilerConstant {
    private int seq;

    public void writeStubStaticInitializer(ClassWriter cw, Class[] remoteInterfaceClasses, String implClassName) {
        String f = "private static final String[] _remoteInterfaces = {";
        for (int j = 0; j < remoteInterfaceClasses.length; ++j) {
            Class remoteInterfaceClass = remoteInterfaceClasses[j];
            f = JEUSRMICompilerConstant.writeInterfaceNames(f, remoteInterfaceClass);
        }
        f = f + "};";
        cw.addField(f);
        MethodWriter mw1 = cw.addMethod("public String[] getRemoteInterfaces()");
        mw1.wln("return _remoteInterfaces;");
        cw.addField("private static final String _implName = \"" + implClassName + "\";");
        MethodWriter mw = cw.addMethod("public String getImpleName()");
        mw.wln("return _implName;");
        cw.addField("private static final long serialVersionUID = 2;");
    }

    private static String writeInterfaceNames(String f, Class interfaceClass) {
        f = f + "\"" + interfaceClass.getName() + "\", ";
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            f = f + "\"" + anInterface.getName() + "\", ";
            f = JEUSRMICompilerConstant.writeInterfaceNames(f, anInterface);
        }
        return f;
    }

    public void writeStubStaticInitializer(CodeWriter p, Class[] remoteInterfaceClasses, String implClassName) throws IOException {
        p.write("private static final String[] _remoteInterfaces = {");
        p.TabIn();
        for (int j = 0; j < remoteInterfaceClasses.length; ++j) {
            Class remoteInterfaceClass = remoteInterfaceClasses[j];
            JEUSRMICompilerConstant.writeInterfaceNames(p, remoteInterfaceClass);
        }
        p.TabOut();
        p.write("};");
        p.write("");
        p.write("public String[] getRemoteInterfaces() {");
        p.write("   return _remoteInterfaces;");
        p.write("}");
        p.write("");
        p.write("private static final String _implName = \"" + implClassName + "\";");
        p.write("public String getImpleName() {");
        p.write("   return _implName;");
        p.write("}");
        p.write("private static final long serialVersionUID = 2;");
    }

    private static void writeInterfaceNames(CodeWriter p, Class interfaceClass) throws IOException {
        p.write("\"" + interfaceClass.getName() + "\", ");
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            p.write("\"" + anInterface.getName() + "\", ");
            JEUSRMICompilerConstant.writeInterfaceNames(p, anInterface);
        }
    }

    public String getHomeStubSuperClassName() {
        return "jeus.ejb.bean.rmi.JEUSRMIStub";
    }

    public String getRemoteRefQualifiedClassName() {
        return "jeus.rmi.spec.server.RemoteRef";
    }

    public String getRemoteCallQualifiedClassName() {
        return "jeus.rmi.spec.RemoteCall";
    }

    public String getOperationClassName() {
        return "jeus.rmi.spec.server.Operation";
    }

    public void writeMethodInitializer(ClassWriter cw, Method method, Class[] paramTypes) {
        cw.addField("private static java.lang.reflect.Method $method_" + this.seq + ";");
        cw.addField("private static boolean $method_" + this.seq + "_sp;");
        cw.addField("private static byte $method_" + this.seq + "_rtn;");
        cw.addField("private static boolean $method_" + this.seq + "_vr;");
        MethodWriter mw = cw.addStatic();
        mw.indentIn();
        mw.wtry();
        mw.indentIn();
        mw.wln("$method_" + this.seq + " = " + method.getDeclaringClass().getName() + ".class.getMethod(\"" + method.getName() + "\", new java.lang.Class[] {");
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                mw.w(", ");
            }
            mw.w(StringUtil.getTypeDeclaration((Class)paramTypes[i]) + ".class");
        }
        mw.wln("});");
        mw.wln("$method_" + this.seq + "_sp = jeus.rmi.impl.server.MethodInfo.isSimpleParams($method_" + this.seq + ");");
        mw.wln("$method_" + this.seq + "_rtn = jeus.rmi.impl.server.MethodInfo.getReturnTypeNumber($method_" + this.seq + ");");
        mw.wln("$method_" + this.seq + "_vr = jeus.rmi.impl.server.MethodInfo.isVoidReturn($method_" + this.seq + "_rtn);");
        mw.indentOut();
        mw.wcatch("Exception ex");
        mw.wln("   throw new RuntimeException(ex);");
        mw.wtryend();
    }

    public void writeMethodInitializer(CodeWriter p, Method method, Class[] paramTypes) throws IOException {
        p.write("private static java.lang.reflect.Method $method_" + this.seq + ";");
        p.write("private static boolean $method_" + this.seq + "_sp;");
        p.write("private static byte $method_" + this.seq + "_rtn;");
        p.write("private static boolean $method_" + this.seq + "_vr;");
        p.write("static {");
        p.TabIn();
        p.write("try {");
        p.TabIn();
        p.write("$method_" + this.seq + " = " + method.getDeclaringClass().getName() + ".class.getMethod(\"" + method.getName() + "\", new java.lang.Class[] {");
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                p.cwrite(", ");
            }
            p.cwrite(StringUtil.getTypeDeclaration((Class)paramTypes[i]) + ".class");
        }
        p.write("});");
        p.write("$method_" + this.seq + "_sp = jeus.rmi.impl.server.MethodInfo.isSimpleParams($method_" + this.seq + ");");
        p.write("$method_" + this.seq + "_rtn = jeus.rmi.impl.server.MethodInfo.getReturnTypeNumber($method_" + this.seq + ");");
        p.write("$method_" + this.seq + "_vr = jeus.rmi.impl.server.MethodInfo.isVoidReturn($method_" + this.seq + "_rtn);");
        p.TabOut();
        p.write("} catch (Exception ex) {");
        p.write("   throw new RuntimeException(ex);");
        p.write("}");
        p.TabOut();
        p.write("}");
    }

    public void writeCallOperation(MethodWriter mw, String stubVariableName, int opnum, Method callMethod, String[] paramNames, Class[] paramTypes) {
        mw.wln("Object result = ref.invoke(" + stubVariableName + ", $method_" + this.seq + ", ");
        mw.indentIn();
        if (paramNames.length == 0) {
            mw.wln("null");
        } else {
            mw.w("new Object[] {");
            for (int i = 0; i < paramNames.length; ++i) {
                if (i > 0) {
                    mw.w(", ");
                }
                mw.w(JEUSRMICompilerConstant.wrapArgumentCode(paramTypes[i], paramNames[i]));
            }
            mw.wln("}");
        }
        mw.wln(", " + Util.computeMethodHash(callMethod) + "L, $method_" + this.seq + "_sp, $method_" + this.seq + "_rtn, $method_" + this.seq + "_vr, " + opnum + ");");
        mw.indentOut();
        ++this.seq;
    }

    public void writeCallOperation(CodeWriter p, String stubVariableName, int opnum, Method callMethod, String[] paramNames, Class[] paramTypes) throws IOException {
        p.write("Object result = ref.invoke(" + stubVariableName + ", $method_" + this.seq + ", ");
        p.TabIn();
        if (paramNames.length == 0) {
            p.write("null");
        } else {
            p.cwrite("new Object[] {");
            for (int i = 0; i < paramNames.length; ++i) {
                if (i > 0) {
                    p.cwrite(", ");
                }
                p.cwrite(JEUSRMICompilerConstant.wrapArgumentCode(paramTypes[i], paramNames[i]));
            }
            p.write("}");
        }
        p.write(", " + Util.computeMethodHash(callMethod) + "L, $method_" + this.seq + "_sp, $method_" + this.seq + "_rtn, $method_" + this.seq + "_vr, " + opnum + ");");
        p.TabOut();
        ++this.seq;
    }

    public void writeAfterCallOperation(MethodWriter mw, String stubVariableName, int opnum, Class[] paramTypes, String[] paramNames, Class returnType) {
    }

    public void writeAfterCallOperation(CodeWriter p, String stubVariableName, int opnum, Class[] paramTypes, String[] paramNames, Class returnType) throws IOException {
    }

    public void writeReturnVariable(CodeWriter p, Class returnType) throws IOException {
    }

    public void writeReturnVariable(MethodWriter mw, Class returnType) {
    }

    public void writeReturnOperation(CodeWriter p, Class returnType) throws IOException {
        p.write("return " + JEUSRMICompilerConstant.unwrapArgumentCode(returnType, "result") + ";");
    }

    public void writeReturnOperation(MethodWriter mw, Class returnType) {
        mw.wln("return " + JEUSRMICompilerConstant.unwrapArgumentCode(returnType, "result") + ";");
    }

    private static String unwrapArgumentCode(Class type, String name) {
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return "((java.lang.Boolean) " + name + ").booleanValue()";
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return "((java.lang.Byte) " + name + ").byteValue()";
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return "((java.lang.Character) " + name + ").charValue()";
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return "((java.lang.Short) " + name + ").shortValue()";
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return "((java.lang.Integer) " + name + ").intValue()";
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return "((java.lang.Long) " + name + ").longValue()";
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return "((java.lang.Float) " + name + ").floatValue()";
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return "((java.lang.Double) " + name + ").doubleValue()";
        }
        return "((" + StringUtil.getTypeDeclaration((Class)type) + ") " + name + ")";
    }

    public String getRemoteObjectClassName() {
        return "jeus.rmi.spec.server.RemoteObject";
    }

    public void addImport(ClassWriter cw) {
        cw.addImport("jeus.rmi.spec.server.RemoteRef");
        cw.addImport("jeus.rmi.impl.server.MethodInfo");
    }

    private static String wrapArgumentCode(Class type, String name) {
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return "new java.lang.Boolean(" + name + ")";
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return "new java.lang.Byte(" + name + ")";
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return "new java.lang.Character(" + name + ")";
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return "new java.lang.Short(" + name + ")";
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return "new java.lang.Integer(" + name + ")";
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return "new java.lang.Long(" + name + ")";
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return "new java.lang.Float(" + name + ")";
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return "new java.lang.Double(" + name + ")";
        }
        return name;
    }
}

