/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.IOException;
import java.lang.reflect.Method;
import jeus.ejb.compiler.RMICompilerConstant;
import jeus.ejb.compiler.RMICompilerException;
import jeus.ejb.util.CodeWriter;
import jeus.util.StringUtil;
import jeus.util.codegen.ClassWriter;
import jeus.util.codegen.MethodWriter;

public class JavaRMICompilerConstant
implements RMICompilerConstant {
    public String getHomeStubSuperClassName() {
        return "jeus.ejb.bean.rmi.RMIStub";
    }

    public void writeStubStaticInitializer(ClassWriter cw, Class[] remoteInterfaceClasses, String implClassName) {
    }

    public void writeStubStaticInitializer(CodeWriter p, Class[] remoteInterfaceClasses, String implClassName) {
    }

    public String getRemoteRefQualifiedClassName() {
        return "java.rmi.server.RemoteRef";
    }

    public String getRemoteCallQualifiedClassName() {
        return "java.rmi.server.RemoteCall";
    }

    public String getOperationClassName() {
        return "java.rmi.server.Operation";
    }

    public void writeMethodInitializer(ClassWriter cw, Method method, Class[] paramTypes) {
    }

    public void writeMethodInitializer(CodeWriter p, Method method, Class[] paramTypes) throws IOException {
    }

    public void writeCallOperation(MethodWriter mw, String stubVariableName, int opnum, Method callMethod, String[] paramNames, Class[] paramTypes) {
        mw.wln(this.getRemoteCallQualifiedClassName() + " call = ref.newCall(" + stubVariableName + ", operations, " + opnum + ", interfaceHash);");
    }

    public void writeCallOperation(CodeWriter p, String stubVariableName, int opnum, Method callMethod, String[] paramNames, Class[] paramTypes) throws IOException {
        p.cwrite(this.getRemoteCallQualifiedClassName() + " call = ref.newCall(" + stubVariableName);
        p.write(", operations, " + opnum + ", interfaceHash);");
    }

    public void writeAfterCallOperation(MethodWriter mw, String stubVariableName, int opnum, Class[] paramTypes, String[] paramNames, Class returnType) {
        mw.wtry();
        mw.wln("callClientInterceptors(call);");
        mw.wln("java.io.ObjectOutput out = call.getOutputStream();");
        for (int i = 0; i < paramTypes.length; ++i) {
            JavaRMICompilerConstant.writeMarshalArgument(mw, "out", paramTypes[i], paramNames[i]);
            mw.wln(";");
        }
        mw.wcatch("java.io.IOException e");
        mw.wln("throw new java.rmi.MarshalException(\"error marshalling arguments\" , e);");
        mw.wtryend();
        mw.wtry();
        mw.wln("ref.invoke(call);");
        mw.wcatch("java.lang.Exception ex");
        mw.wln("setException(ex);");
        mw.wln(" throw ex;");
        mw.wtryend();
        mw.wtry();
        mw.wln("callAfterClientInterceptors(call);");
        boolean objectRead = false;
        if (!returnType.getName().equals("void")) {
            mw.wln("java.io.ObjectInput in = call.getInputStream();");
            objectRead = JavaRMICompilerConstant.writeUnmarshalArgument(mw, "in", returnType, "result");
            mw.wln(";");
        }
        mw.wcatch("java.io.IOException e");
        mw.wln("throw new java.rmi.UnmarshalException(\"error unmarshalling return\" , e);");
        if (objectRead) {
            mw.wcatch("java.lang.ClassNotFoundException e");
            mw.wln("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
        }
        mw.wfinally();
        mw.wln("ref.done(call);");
        mw.wtryend();
        mw.wln();
    }

    public void writeAfterCallOperation(CodeWriter p, String stubVariableName, int opnum, Class[] paramTypes, String[] paramNames, Class returnType) throws IOException {
        p.write("callClientInterceptors(call);");
        p.write("try {");
        p.TabIn();
        p.write("java.io.ObjectOutput out = call.getOutputStream();");
        for (int i = 0; i < paramTypes.length; ++i) {
            JavaRMICompilerConstant.writeMarshalArgument(p, "out", paramTypes[i], paramNames[i]);
            p.write(";");
        }
        p.write("ref.invoke(call);");
        p.TabOut();
        p.write("} catch(Exception ex) {");
        p.write("\t setException(ex);");
        p.write("\t throw ex;");
        p.write("}");
        p.write("callAfterClientInterceptors(call);");
        p.write("try {");
        p.TabIn();
        p.write("java.io.ObjectInput in = call.getInputStream();");
        boolean objectRead = false;
        if (!returnType.getName().equals("void")) {
            objectRead = JavaRMICompilerConstant.writeUnmarshalArgument(p, "in", returnType, "result");
            p.write(";");
        }
        p.TabOut();
        p.write("} catch (java.io.IOException e) {");
        p.TabIn();
        p.write("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
        if (objectRead) {
            p.TabOut();
            p.write("} catch (java.lang.ClassNotFoundException e) {");
            p.TabIn();
            p.write("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
        }
        p.TabOut();
        p.write("} finally {");
        p.TabIn();
        p.write("ref.done(call);");
        p.TabOut();
        p.write("}");
        p.write("");
    }

    public void writeReturnVariable(MethodWriter mw, Class returnType) {
        mw.wln(StringUtil.getTypeDeclaration((Class)returnType) + " result;");
    }

    public void writeReturnVariable(CodeWriter p, Class returnType) throws IOException {
        p.write(StringUtil.getTypeDeclaration((Class)returnType) + " result;");
    }

    public void writeReturnOperation(MethodWriter mw, Class returnType) {
        mw.wln("return result;");
    }

    public void writeReturnOperation(CodeWriter p, Class returnType) throws IOException {
        p.write("return result;");
    }

    public String getRemoteObjectClassName() {
        return "java.rmi.server.RemoteObject";
    }

    public void addImport(ClassWriter stubWriter) {
    }

    public static void writeMarshalArgument(MethodWriter mw, String streamName, Class type, String name) {
        if (type == Boolean.TYPE) {
            mw.w(streamName + ".writeBoolean(" + name + ")");
        } else if (type == Byte.TYPE) {
            mw.w(streamName + ".writeByte(" + name + ")");
        } else if (type == Character.TYPE) {
            mw.w(streamName + ".writeChar(" + name + ")");
        } else if (type == Short.TYPE) {
            mw.w(streamName + ".writeShort(" + name + ")");
        } else if (type == Integer.TYPE) {
            mw.w(streamName + ".writeInt(" + name + ")");
        } else if (type == Long.TYPE) {
            mw.w(streamName + ".writeLong(" + name + ")");
        } else if (type == Float.TYPE) {
            mw.w(streamName + ".writeFloat(" + name + ")");
        } else if (type == Double.TYPE) {
            mw.w(streamName + ".writeDouble(" + name + ")");
        } else {
            mw.w(streamName + ".writeObject(" + name + ")");
        }
    }

    public static void writeMarshalArgument(CodeWriter p, String streamName, Class type, String name) throws RMICompilerException, IOException {
        if (type == Boolean.TYPE) {
            p.cwrite(streamName + ".writeBoolean(" + name + ")");
        } else if (type == Byte.TYPE) {
            p.cwrite(streamName + ".writeByte(" + name + ")");
        } else if (type == Character.TYPE) {
            p.cwrite(streamName + ".writeChar(" + name + ")");
        } else if (type == Short.TYPE) {
            p.cwrite(streamName + ".writeShort(" + name + ")");
        } else if (type == Integer.TYPE) {
            p.cwrite(streamName + ".writeInt(" + name + ")");
        } else if (type == Long.TYPE) {
            p.cwrite(streamName + ".writeLong(" + name + ")");
        } else if (type == Float.TYPE) {
            p.cwrite(streamName + ".writeFloat(" + name + ")");
        } else if (type == Double.TYPE) {
            p.cwrite(streamName + ".writeDouble(" + name + ")");
        } else {
            p.cwrite(streamName + ".writeObject(" + name + ")");
        }
    }

    public static boolean writeUnmarshalArgument(MethodWriter mw, String streamName, Class type, String name) {
        boolean readObject = false;
        if (name != null) {
            mw.w(name + " = ");
        }
        if (type == Boolean.TYPE) {
            mw.w(streamName + ".readBoolean()");
        } else if (type == Byte.TYPE) {
            mw.w(streamName + ".readByte()");
        } else if (type == Character.TYPE) {
            mw.w(streamName + ".readChar()");
        } else if (type == Short.TYPE) {
            mw.w(streamName + ".readShort()");
        } else if (type == Integer.TYPE) {
            mw.w(streamName + ".readInt()");
        } else if (type == Long.TYPE) {
            mw.w(streamName + ".readLong()");
        } else if (type == Float.TYPE) {
            mw.w(streamName + ".readFloat()");
        } else if (type == Double.TYPE) {
            mw.w(streamName + ".readDouble()");
        } else {
            mw.w("(" + StringUtil.getTypeDeclaration((Class)type) + ") " + streamName + ".readObject()");
            readObject = true;
        }
        return readObject;
    }

    public static boolean writeUnmarshalArgument(CodeWriter p, String streamName, Class type, String name) throws RMICompilerException, IOException {
        boolean readObject = false;
        if (name != null) {
            p.cwrite(name + " = ");
        }
        if (type == Boolean.TYPE) {
            p.cwrite(streamName + ".readBoolean()");
        } else if (type == Byte.TYPE) {
            p.cwrite(streamName + ".readByte()");
        } else if (type == Character.TYPE) {
            p.cwrite(streamName + ".readChar()");
        } else if (type == Short.TYPE) {
            p.cwrite(streamName + ".readShort()");
        } else if (type == Integer.TYPE) {
            p.cwrite(streamName + ".readInt()");
        } else if (type == Long.TYPE) {
            p.cwrite(streamName + ".readLong()");
        } else if (type == Float.TYPE) {
            p.cwrite(streamName + ".readFloat()");
        } else if (type == Double.TYPE) {
            p.cwrite(streamName + ".readDouble()");
        } else {
            p.cwrite("(" + StringUtil.getTypeDeclaration((Class)type) + ") " + streamName + ".readObject()");
            readObject = true;
        }
        return readObject;
    }
}

