/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import jeus.ejb.compiler.EJBSourceGenerator;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.compiler.InterfaceInfo;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.FieldRW;
import jeus.ejb.util.CodeWriter;
import jeus.util.ErrorMsgManager;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;
import jeus.xml.binding.ejbHelper.EntityBeanPair;
import jeus.xml.binding.ejbHelper.StatefulSessionBeanPair;

class ObjectInfo
extends InterfaceInfo {
    String[] remoteResources = new String[]{"getEJBHomeRsc", "getHandleRsc", "isIdenticalRRsc", "getPrimaryKeyRRsc"};
    private String[] remoteResourceMethods = new String[]{"getEJBHome", "getHandle", "isIdentical", "getPrimaryKey"};
    private String[] remoteResourceMethodParamClasses = new String[]{"", "", "javax.ejb.EJBObject.class", ""};
    String[] localResources = new String[]{"getEJBLocalHomeRsc", "isIdenticalLRsc", "getPrimaryKeyLRsc"};
    private String[] localResourceMethods = new String[]{"getEJBLocalHome", "isIdentical", "getPrimaryKey"};
    private String[] localResourceMethodParamClasses = new String[]{"", "javax.ejb.EJBLocalObject.class", ""};
    EJBSQLGenerator sqlGen;

    ObjectInfo() {
    }

    void initEJBObjectInfo(EJBSourceGenerator generator) throws EJBSourceGeneratorException {
        this.generator = generator;
        this.beanInfo = generator.getBeanInfo();
        ClassLoader loader = generator.getClassLoader();
        BeanPair deployD = generator.getDescriptor();
        String moduleDomain = generator.getModuleDomain();
        this.sqlGen = generator.sqlGen;
        if (deployD.getEJBObjectClassName() != null) {
            try {
                String remoteClassName = deployD.getEJBObjectClassName();
                this.classObject = loader.loadClass(remoteClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7074);
            }
            if (!EJBObject.class.isAssignableFrom(this.classObject)) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7075);
            }
        }
        if (deployD.getEJBLocalObjectClassName() != null) {
            try {
                this.localClassObject = loader.loadClass(deployD.getEJBLocalObjectClassName());
            }
            catch (ClassNotFoundException ex) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7076);
            }
            if (!EJBLocalObject.class.isAssignableFrom(this.localClassObject)) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7077, deployD.getEJBLocalObjectClassName());
            }
        }
        this.localBaseClassName = "jeus.ejb.bean.objectbase.EJBLocalObjectImpl";
        if (!this.beanInfo.isEntity) {
            if (deployD instanceof StatefulSessionBeanPair) {
                this.baseClassName = "EJBStatefulSessionObjectImpl";
            } else {
                this.baseClassName = "EJBStatelessSessionObjectImpl";
                this.beanInfo.isStatelessSession = true;
            }
        } else {
            this.beanInfo.engineType = ((EntityBeanPair)deployD).getEngineType();
            this.baseClassName = this.beanInfo.engineType != 3 ? "EJBEntityObjectImpl" : "EJBEntityMObjectImpl";
            if (deployD instanceof CMEntityBeanPair) {
                this.beanInfo.isConManaged = true;
            } else {
                this.beanInfo.isBeanManaged = true;
            }
            this.beanInfo.nmMethods = ((EntityBeanPair)deployD).getNMMethods();
            if (this.beanInfo.isAllNMMethods()) {
                this.beanInfo.isReadOnlyBean = true;
            }
        }
        if (this.baseClassName == null) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7078);
        }
        this.implClassName = this.getImplClassName(deployD, moduleDomain);
        deployD.setIIOPEJBObjectImplClassName(this.implClassName + "_IIOP");
        if (this.classObject != null) {
            this.className = StringUtil.cutPackagePart((String)this.classObject.getName());
            this.classMethods = this.getApplicationMethods(false, false);
        }
        if (this.localClassObject != null) {
            this.localClassName = StringUtil.cutPackagePart((String)this.localClassObject.getName());
            this.localImplClassName = this.getLocalImplClassName(deployD, moduleDomain);
            this.localClassMethods = this.getApplicationMethods(false, true);
        }
        this.postInitialize();
    }

    protected String getLocalImplClassPostfix() {
        return "LocalObjectImpl";
    }

    protected String getImplClassPostfix() {
        return "ObjectImpl";
    }

    protected String getGenerationInterface() {
        return null;
    }

    void setObjectPackageName(BeanPair deployD) throws EJBSourceGeneratorException {
        String objectClassName;
        int index;
        String localObjectClassName = deployD.getEJBLocalObjectClassName();
        if (localObjectClassName != null) {
            index = localObjectClassName.lastIndexOf(46);
            if (index == -1) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7080);
            }
            this.localClassPackageName = localObjectClassName.substring(0, index);
        }
        if ((objectClassName = deployD.getEJBObjectClassName()) != null) {
            index = objectClassName.lastIndexOf(46);
            if (index == -1) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7080);
            }
            this.classPackageName = objectClassName.substring(0, index);
        } else {
            this.classPackageName = this.localClassPackageName;
        }
    }

    protected void writeResourceCodes(CodeWriter codewriter) throws IOException {
        this.writeResourceAccessor(codewriter, this.remoteResources);
        this.writeResourceAccessor(codewriter, this.localResources);
        this.writeResourceInitialization(codewriter, this.remoteResources, this.remoteResourceMethods, this.remoteResourceMethodParamClasses, false, this.className == null);
        this.writeResourceInitialization(codewriter, this.localResources, this.localResourceMethods, this.localResourceMethodParamClasses, true, this.localClassName == null);
        codewriter.cwrite("private static int type = ");
        if (this.generator.getHomeLocalClassObject() != null && this.generator.getHomeClassObject() == null) {
            codewriter.write("0;");
        } else if (this.generator.getHomeLocalClassObject() == null && this.generator.getHomeClassObject() != null) {
            codewriter.write("1;");
        } else if (this.generator.getHomeLocalClassObject() != null && this.generator.getHomeClassObject() != null) {
            codewriter.write("2;");
        }
        codewriter.write("public int __jeus_getType()");
        codewriter.write("{");
        codewriter.write("\treturn type;");
        codewriter.write("}");
        codewriter.write("");
    }

    protected void writeInterfaceMethods(CodeWriter codewriter) throws IOException {
        if (this.classObject != null) {
            this.generateUserDefinedMethods(codewriter, this.classMethods, false);
            this.generateRemoveMethod(codewriter, false);
        }
        if (this.localClassObject != null) {
            this.generateUserDefinedMethods(codewriter, this.localClassMethods, true);
            this.generateRemoveMethod(codewriter, true);
        }
    }

    void generateUserDefinedMethods(CodeWriter codewriter, Method[] methods, boolean isLocal) throws IOException {
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            int methodID = this.generator.getMethodID();
            if (!this.CheckMappedInterfaceMethod(m.getName(), m, true)) {
                throw new EJBSourceGeneratorException(JeusMessage_EJB11._7079, m.getName());
            }
            this.generateInterfaceMethod(codewriter, methods[i], 0, isLocal, false, methodID);
        }
    }

    protected String[] writeImplementedInterfaceSignature(CodeWriter codewriter) throws IOException {
        Vector<String> implementedInterfaces = new Vector<String>();
        if (this.classObject != null) {
            implementedInterfaces.add(this.classPackageName + "." + this.className);
        }
        for (int i = 0; i < implementedInterfaces.size(); ++i) {
            if (i == 0) {
                codewriter.write(" implements ");
            } else {
                codewriter.write(", ");
            }
            codewriter.cwrite((String)implementedInterfaces.get(i));
        }
        if (implementedInterfaces.size() > 0) {
            return implementedInterfaces.toArray(new String[0]);
        }
        return null;
    }

    protected void writeWorkingBody(CodeWriter codewriter, int methodType, Method m, boolean isLocalIntf, Class[] params, Class[] exceptions, int methodID) throws IOException {
        FieldRW fieldRW;
        codewriter.write("try {");
        codewriter.TabIn();
        codewriter.write("RemoteRequest request = new RemoteRequest();");
        codewriter.write("request.ejbObject = this;");
        codewriter.write("request.methodType = 0;");
        if (this.beanInfo.isEntity || this.beanInfo.isContainerManagedTX) {
            codewriter.write("request.txAttr = " + this.beanInfo.getTxAttribute(m, this.getGenerationType(isLocalIntf)) + ";");
        }
        if (this.beanInfo.isEntity && (this.beanInfo.isReadOnlyBean || this.beanInfo.isNonModifyingMethod(m))) {
            codewriter.write("request.updating = false;");
        }
        codewriter.write("");
        this.writeInitializingReturnValueForNormalMethod(m, codewriter);
        codewriter.write("");
        codewriter.write("try {");
        codewriter.TabIn();
        String methodName = m.getName();
        boolean writeBody = true;
        if (this.beanInfo.isConManaged && methodName.startsWith("set") && (fieldRW = this.sqlGen.getFieldRWByFieldName(methodName.substring(3))) != null && fieldRW.isReadOnly()) {
            writeBody = false;
            if (fieldRW instanceof CMPFieldRW) {
                codewriter.write("throw new JeusRuntimeException(\"The cmp field shared with a cmr field is read-only : " + fieldRW.fieldName + "\");");
            } else {
                codewriter.write("throw new JeusRuntimeException(\"The cmr field shared with primary key cmp fields is read-only : " + fieldRW.fieldName + "\");");
            }
        }
        if (writeBody) {
            this.writeStatusSettingCode(codewriter);
            codewriter.write("this.container.preInvoke(request);");
            codewriter.write(this.beanInfo.beanClassName + " ejbBean = (" + this.beanInfo.beanClassName + ") request.ejbContext.ejbBean;");
            this.writeSecurityChecking(codewriter, isLocalIntf, m, methodID);
            if (this.beanInfo.isUseAccessControl()) {
                Class<?> returnType = m.getReturnType();
                if (returnType != Void.TYPE) {
                    this.writeTypeConversion(codewriter, returnType, "method" + methodID + "Obj");
                } else {
                    codewriter.write("\tEJBSecurity.runEJBBusinessCode(ejbBean, method" + methodID + "Obj, args);");
                }
                codewriter.write("} catch(PrivilegedActionException ex) {");
                codewriter.write("\trequest.exception = ex.getException();");
                codewriter.write("\tlogger.log(Level." + JeusMessage_EJB11._7060_LEVEL.toString() + ", \"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7060) + "\",ex);");
            } else {
                if (m.getReturnType() != Void.TYPE) {
                    codewriter.cwrite("\treturnValue = ");
                }
                codewriter.cwrite("\tejbBean." + m.getName() + "(");
                for (int i = 0; i < params.length; ++i) {
                    if (i != 0) {
                        codewriter.cwrite(", ");
                    }
                    codewriter.cwrite("arg" + i);
                }
                codewriter.write(");");
            }
        }
        codewriter.write("} catch(Throwable ex) {");
        codewriter.write("\trequest.exception = ex;");
        codewriter.write("\tlogger.log(Level." + JeusMessage_EJB11._7060_LEVEL.toString() + ", \"" + ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7060) + "\",ex);");
        codewriter.write("} finally {");
        this.writeStatusRecoveringCode(codewriter);
        codewriter.write("\tthis.container.postInvoke(request);");
        codewriter.write("}");
        this.writeRecoveringEnvironment(codewriter, m, true);
        this.writeExceptionHandler(codewriter, exceptions);
        if (m.getReturnType() != Void.TYPE) {
            codewriter.write("return returnValue;");
        }
        codewriter.TabOut();
        codewriter.write("} finally {");
        codewriter.write("}");
    }

    protected void writeStatusRecoveringCode(CodeWriter codewriter) throws IOException {
    }

    protected void writeStatusSettingCode(CodeWriter codewriter) throws IOException {
    }

    protected void writeSecurityChecking(CodeWriter codewriter, boolean isLocalIntf, Method m, int methodID) throws IOException {
        this.writeSecurityChecking(codewriter, isLocalIntf, m, null, methodID, this.beanInfo.isUseAccessControl());
    }

    protected void writeExceptionHandlerPerClass(CodeWriter codewriter) throws IOException {
        codewriter.write("if(request.exception instanceof javax.transaction.TransactionRolledbackException) {");
        codewriter.write("\tthrow (javax.transaction.TransactionRolledbackException)request.exception; ");
        codewriter.write("}else if(request.exception instanceof javax.transaction.TransactionRequiredException) {");
        codewriter.write("\tthrow (javax.transaction.TransactionRequiredException)request.exception; ");
        codewriter.write("}else if(request.exception instanceof java.rmi.NoSuchObjectException) {");
        codewriter.write("\tthrow (java.rmi.NoSuchObjectException)request.exception; ");
        codewriter.write("}else if(request.exception instanceof java.rmi.RemoteException) {");
        codewriter.write("\tthrow (java.rmi.RemoteException)request.exception; ");
        codewriter.write("}");
    }

    private void generateRemoveMethod(CodeWriter codewriter, boolean isLocalIntf) throws EJBSourceGeneratorException, IOException {
        Method m;
        try {
            m = isLocalIntf ? EJBLocalObject.class.getDeclaredMethod("remove", new Class[0]) : EJBObject.class.getDeclaredMethod("remove", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new EJBSourceGeneratorException(JeusMessage_EJB11._7081);
        }
        int methodID = this.generator.getMethodID();
        this.writeResourceFieldDeclaration(codewriter, methodID, isLocalIntf, m, true);
        codewriter.write("public void " + (isLocalIntf ? "__" : "") + "remove() throws RemoveException, RemoteException");
        codewriter.write("{");
        codewriter.TabIn();
        this.writeSettingEnvironment(codewriter, isLocalIntf, m);
        codewriter.write("RemoteRequest request = new RemoteRequest();");
        codewriter.write("request.methodType = 4;");
        if (this.beanInfo.isEntity) {
            codewriter.write("request.txAttr = " + this.beanInfo.getTxAttribute(m, this.getGenerationType(isLocalIntf)) + ";");
        }
        codewriter.write("try {");
        codewriter.write("\tinnerRemove(request, nullObjectArray, method" + methodID + "Rsc, " + isLocalIntf + ");");
        codewriter.write("} finally {");
        codewriter.TabIn();
        this.writeRecoveringEnvironment(codewriter, m, false);
        codewriter.TabOut();
        codewriter.write("}");
        codewriter.TabOut();
        codewriter.write("}");
    }

    protected int getGenerationType(boolean isLocalIntf) {
        return isLocalIntf ? 1 : 0;
    }

    protected String getGenerationInterface(boolean isLocalIntf) {
        return isLocalIntf ? "Local" : "Remote";
    }
}

