/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.compiler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import jeus.deploy.archivist.AbstractArchive;
import jeus.ejb.compiler.EJBCodeGenerator;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.compiler.JEUSRMICompilerConstant;
import jeus.ejb.compiler.JavaRMICompilerConstant;
import jeus.ejb.compiler.RMICompilerConstant;
import jeus.ejb.compiler.RMICompilerException;
import jeus.ejb.util.CodeWriter;
import jeus.ejb.util.EJBCompiler;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.StringUtil;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;
import jeus.xml.binding.jeusDD.ClusteringType;

public class RMICompiler
extends EJBCodeGenerator {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.compiler.generator.rmi");
    private static final String fs = System.getProperty("file.separator");
    private static final char fsc = fs.charAt(0);
    private ArchiveArrayClassLoader loader;
    private ClusteringType clusterDesc;
    private boolean enableInstantQL = false;
    private AbstractArchive tempArchive;
    protected static final int CW_BUFFER = 4096;
    private static final JEUSRMICompilerConstant jeusCompilerConstant;
    private static final JavaRMICompilerConstant javaCompilerConstant;
    private RMICompilerConstant compilerConstant;

    public RMICompiler(AbstractArchive tempArchive, ArchiveArrayClassLoader loader, EJBCompiler compiler, boolean useJeusRmi) throws RMICompilerException {
        super(compiler);
        try {
            this.loader = loader;
        }
        catch (Throwable ex) {
            throw new RMICompilerException(JeusMessage_EJB11._7033, ex);
        }
        this.tempArchive = tempArchive;
        this.compilerConstant = useJeusRmi ? jeusCompilerConstant : javaCompilerConstant;
    }

    OutputStream makeFileOf(String className) throws IOException {
        return new BufferedOutputStream(this.tempArchive.addEntry(className.replace('.', fsc) + ".java"), 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileEJB(String[] implementedHomeInterfaces, String appHomeImplName, String appObjectName, String appObjectImplName, BeanPair deployD, String keyClassName, int type) throws RMICompilerException {
        Class<?> appObject;
        this.clusterDesc = deployD.getClusterDesc();
        if (deployD instanceof CMEntityBeanPair && ((CMEntityBeanPair)deployD).isEnableInstantQL()) {
            this.enableInstantQL = true;
        }
        int size = implementedHomeInterfaces.length;
        Class[] homeImplInterfaces = new Class[size];
        int index = -1;
        try {
            if (this.enableInstantQL) {
                homeImplInterfaces = new Class[size + 1];
                index = size;
                homeImplInterfaces[size] = this.loader.loadClass("jeus.ejb.bean.objectbase.EJBInstanceFinder");
            }
            for (index = 0; index < implementedHomeInterfaces.length; ++index) {
                homeImplInterfaces[index] = this.loader.loadClass(implementedHomeInterfaces[index]);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RMICompilerException(JeusMessage_EJB11._7034, index == size ? "jeus.ejb.bean.objectbase.EJBInstanceFinder" : implementedHomeInterfaces[index], (Throwable)e);
        }
        Method[] interfacesMethods = null;
        interfacesMethods = this.getInterfacesMethods(homeImplInterfaces);
        try {
            appObject = this.loader.loadClass(appObjectName);
        }
        catch (ClassNotFoundException e) {
            throw new RMICompilerException(JeusMessage_EJB11._7034, appObjectName, (Throwable)e);
        }
        ArrayList<String> generatedFiles = new ArrayList<String>();
        try {
            String skelFileName;
            String stubFileName;
            Method[] ejbHomeMethods = this.getApplicationMethods(interfacesMethods);
            OutputStream outStub = null;
            try {
                if (logger.isLoggable(JeusMessage_EJB11._7035_LEVEL)) {
                    logger.log(JeusMessage_EJB11._7035_LEVEL, JeusMessage_EJB11._7035);
                }
                stubFileName = appHomeImplName + "_Stub";
                outStub = this.makeFileOf(stubFileName);
                this.writeStub(outStub, homeImplInterfaces, appHomeImplName, ejbHomeMethods, true, -1);
                generatedFiles.add(stubFileName);
            }
            catch (Throwable e) {
                throw new RMICompilerException(JeusMessage_EJB11._7036, e);
            }
            finally {
                if (outStub != null) {
                    try {
                        outStub.close();
                    }
                    catch (Throwable t) {}
                }
            }
            OutputStream outSkel = null;
            if (!deployD.useJeusRmi()) {
                try {
                    if (logger.isLoggable(JeusMessage_EJB11._7037_LEVEL)) {
                        logger.log(JeusMessage_EJB11._7037_LEVEL, JeusMessage_EJB11._7037);
                    }
                    skelFileName = appHomeImplName + "_Skel";
                    outSkel = this.makeFileOf(skelFileName);
                    this.writeSkeleton(outSkel, appHomeImplName, ejbHomeMethods);
                    generatedFiles.add(skelFileName);
                }
                catch (Throwable e) {
                    throw new RMICompilerException(JeusMessage_EJB11._7038, e);
                }
                finally {
                    if (outSkel != null) {
                        try {
                            outSkel.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            Method[] ejbObjectMethods = this.getApplicationMethods(appObject.getMethods());
            outStub = null;
            try {
                if (logger.isLoggable(JeusMessage_EJB11._7039_LEVEL)) {
                    logger.log(JeusMessage_EJB11._7039_LEVEL, JeusMessage_EJB11._7039);
                }
                stubFileName = appObjectImplName + "_Stub";
                outStub = this.makeFileOf(stubFileName);
                this.writeStub(outStub, new Class[]{appObject}, appObjectImplName, ejbObjectMethods, false, type);
                generatedFiles.add(stubFileName);
            }
            catch (Throwable e) {
                throw new RMICompilerException(JeusMessage_EJB11._7040, e);
            }
            finally {
                if (outStub != null) {
                    try {
                        outStub.close();
                    }
                    catch (Throwable t) {}
                }
            }
            if (!deployD.useJeusRmi()) {
                outSkel = null;
                try {
                    if (logger.isLoggable(JeusMessage_EJB11._7041_LEVEL)) {
                        logger.log(JeusMessage_EJB11._7041_LEVEL, JeusMessage_EJB11._7041);
                    }
                    skelFileName = appObjectImplName + "_Skel";
                    outSkel = this.makeFileOf(skelFileName);
                    this.writeSkeleton(outSkel, appObjectImplName, ejbObjectMethods);
                    generatedFiles.add(skelFileName);
                }
                catch (Throwable e) {
                    throw new RMICompilerException(JeusMessage_EJB11._7042, e);
                }
                finally {
                    if (outSkel != null) {
                        try {
                            outSkel.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            try {
                this.compile_generatedFiles(generatedFiles.toArray(new String[0]), 7);
            }
            catch (Throwable t) {
                throw new RMICompilerException(JeusMessage_EJB11._7043, t);
            }
        }
        finally {
            if (logger.isLoggable(JeusMessage_EJB11._7044_LEVEL)) {
                logger.log(JeusMessage_EJB11._7044_LEVEL, JeusMessage_EJB11._7044);
            }
        }
    }

    private Method[] getInterfacesMethods(Class[] homeImplInterfaces) {
        int interfaceNum = homeImplInterfaces.length;
        Method[][] methods = new Method[interfaceNum][];
        int methodNum = 0;
        for (int i = 0; i < interfaceNum; ++i) {
            Class aInterface = homeImplInterfaces[i];
            methods[i] = aInterface.getMethods();
            methodNum += methods[i].length;
        }
        Method[] interfacesMethods = new Method[methodNum];
        int interfacesMethodsIndex = 0;
        for (int j = 0; j < interfaceNum; ++j) {
            Method[] aInterfaceMethods = methods[j];
            for (int k = 0; k < aInterfaceMethods.length; ++k) {
                interfacesMethods[interfacesMethodsIndex++] = aInterfaceMethods[k];
            }
        }
        return interfacesMethods;
    }

    private Method[] getApplicationMethods(Method[] appMethods) throws RMICompilerException {
        try {
            if (appMethods.length == 0) {
                return appMethods;
            }
            block2: for (int i = 0; i < appMethods.length - 1; ++i) {
                Method method1 = appMethods[i];
                if (method1 == null) continue;
                Class<?>[] paramTypes1 = method1.getParameterTypes();
                Class[] exceptions1 = method1.getExceptionTypes();
                block3: for (int j = i + 1; j < appMethods.length; ++j) {
                    Class<?>[] paramTypes2;
                    Method method2 = appMethods[j];
                    if (method2 == null || !method2.getName().equals(method1.getName()) || paramTypes1.length != (paramTypes2 = method2.getParameterTypes()).length) continue;
                    for (int k = 0; k < paramTypes1.length; ++k) {
                        if (paramTypes1[k] != paramTypes2[k]) continue block3;
                    }
                    Class[] exceptions2 = method2.getExceptionTypes();
                    if (this.isSubExceptions(exceptions1, exceptions2)) {
                        appMethods[j] = null;
                        continue;
                    }
                    if (!this.isSubExceptions(exceptions2, exceptions1)) continue;
                    appMethods[i] = null;
                    continue block2;
                }
            }
            ArrayList<Method> result = new ArrayList<Method>();
            for (int i = 0; i < appMethods.length; ++i) {
                if (appMethods[i] == null) continue;
                result.add(appMethods[i]);
            }
            int size = result.size();
            Method[] methods = result.toArray(new Method[0]);
            ArrayList<Method> sorted = new ArrayList<Method>(size);
            for (int i = 0; i < size - 1; ++i) {
                int idx = i;
                String biggest = methods[i].getName();
                block7: for (int j = i + 1; j < size; ++j) {
                    Class<?>[] paramTypes3;
                    int paramsize3;
                    String curr = methods[j].getName();
                    if (biggest.compareTo(curr) < 0) {
                        biggest = curr;
                        idx = j;
                        continue;
                    }
                    if (biggest.compareTo(curr) != 0) continue;
                    Class<?>[] paramTypes2 = methods[idx].getParameterTypes();
                    int paramsize2 = paramTypes2.length;
                    if (paramsize2 == (paramsize3 = (paramTypes3 = methods[j].getParameterTypes()).length)) {
                        for (int k = 0; k < paramsize2; ++k) {
                            String currArg;
                            String biggestArg = paramTypes2[k].getName();
                            if (biggestArg.compareTo(currArg = paramTypes3[k].getName()) >= 0) continue;
                            biggest = curr;
                            idx = j;
                            continue block7;
                        }
                        continue;
                    }
                    if (paramsize2 <= paramsize3) continue;
                    biggest = curr;
                    idx = j;
                }
                if (idx != i) {
                    Method tmp = methods[i];
                    methods[i] = methods[idx];
                    methods[idx] = tmp;
                }
                sorted.add(methods[i]);
            }
            sorted.add(methods[size - 1]);
            return sorted.toArray(new Method[0]);
        }
        catch (Throwable e) {
            throw new RMICompilerException(JeusMessage_EJB11._7052, e);
        }
    }

    private boolean isSubExceptions(Class[] exceptions1, Class[] exceptions2) {
        for (int k = 0; k < exceptions2.length; ++k) {
            int j;
            if (RuntimeException.class.isAssignableFrom(exceptions2[k])) continue;
            for (j = 0; j < exceptions1.length && !exceptions1[j].isAssignableFrom(exceptions2[k]); ++j) {
            }
            if (j != exceptions1.length) continue;
            return false;
        }
        return true;
    }

    private String getOperationString(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        String temp = StringUtil.getTypeDeclaration(method.getReturnType()) + " " + method.getName() + "(";
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                temp = temp + ", ";
            }
            temp = temp + StringUtil.getTypeDeclaration(parameters[i]);
        }
        temp = temp + ")";
        return temp;
    }

    private void writeStub(OutputStream out, Class[] remoteInterfaceClasses, String className, Method[] methods, boolean isEJBHome, int type) throws RMICompilerException, IOException {
        int i;
        CodeWriter p = new CodeWriter(out);
        String stubClassName = StringUtil.cutPackagePart((String)(className + "_Stub"));
        p.write("// This is generated by JEUS RMI Compiler.");
        p.write("// Do not edit any part of this.");
        p.write("package " + className.substring(0, className.lastIndexOf(46)) + ";");
        p.write("");
        p.write("import java.util.*;");
        p.write("import java.rmi.RemoteException;");
        p.write("import javax.naming.*;");
        p.write("");
        p.write("public final class " + stubClassName);
        p.TabIn();
        p.write("extends " + this.compilerConstant.getHomeStubSuperClassName());
        p.cwrite("implements ");
        for (int j = 0; j < remoteInterfaceClasses.length; ++j) {
            if (j != 0) {
                p.write(",");
            }
            p.cwrite(remoteInterfaceClasses[j].getName());
        }
        p.write("");
        p.TabOut();
        p.write("{");
        p.TabIn();
        p.write("private static final " + this.compilerConstant.getOperationClassName() + "[] operations = {");
        p.TabIn();
        for (i = 0; i < methods.length; ++i) {
            if (i > 0) {
                p.write(",");
            }
            p.cwrite("new " + this.compilerConstant.getOperationClassName() + "(\"" + this.getOperationString(methods[i]) + "\")");
        }
        p.write("");
        p.TabOut();
        p.write("};");
        p.write("");
        p.write("private static final long interfaceHash = " + this.computeInterfaceHash(methods) + "L;");
        p.write("");
        this.compilerConstant.writeStubStaticInitializer(p, remoteInterfaceClasses, className);
        boolean clustering = false;
        if (this.clusterDesc != null && this.clusterDesc.isEnableClustering().booleanValue()) {
            clustering = true;
        }
        p.write("// constructors");
        p.write("public " + stubClassName + "() {");
        p.TabIn();
        p.write("super();");
        if (clustering) {
            this.writeStubClusterSupportCreation(p, isEJBHome, type);
        }
        p.TabOut();
        p.write("}");
        p.write("public " + stubClassName + "(" + this.compilerConstant.getRemoteRefQualifiedClassName() + " ref) {");
        p.TabIn();
        p.write("super(ref);");
        if (clustering) {
            this.writeStubClusterSupportCreation(p, isEJBHome, type);
        }
        p.TabOut();
        p.write("}");
        p.write("");
        if (methods.length > 0) {
            p.write("// methods from remote interfaces");
            for (i = 0; i < methods.length; ++i) {
                p.write("");
                if (clustering) {
                    this.writeStubMethod(isEJBHome, p, methods[i], i, clustering, BeanPair.matchMethodInList(this.clusterDesc, isEJBHome, methods[i]));
                    continue;
                }
                this.writeStubMethod(isEJBHome, p, methods[i], i, false, false);
            }
        }
        p.TabOut();
        p.write("}");
        p.close();
    }

    private void writeStubClusterSupportCreation(CodeWriter p, boolean isEJBHome, int type) throws IOException {
        p.write("clusterSupport = jeus.ejb.bean.rmi.StubClusterSupport.createStubClusterSupport(");
        p.TabIn();
        if (isEJBHome) {
            p.write("jeus.ejb.bean.rmi.StubClusterSupport.HOME_CLUSTER");
        } else if (type == 1) {
            p.write("jeus.ejb.bean.rmi.StubClusterSupport.STATELESS_CLUSTER");
        } else if (type == 2) {
            p.write("jeus.ejb.bean.rmi.StubClusterSupport.STATEFUL_CLUSTER");
        } else {
            p.write("jeus.ejb.bean.rmi.StubClusterSupport.ENTITY_CLUSTER");
        }
        p.write(", this);");
        p.TabOut();
    }

    private void writeStubMethod(boolean isEJBHome, CodeWriter p, Method method, int opnum, boolean clustering, boolean idempotent) throws RMICompilerException, IOException {
        int i;
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        Class[] paramTypes = method.getParameterTypes();
        String[] paramNames = new String[paramTypes.length];
        for (i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = "param_" + (i + 1);
        }
        Vector catchList = new Vector();
        catchList.add(RuntimeException.class);
        catchList.add(RemoteException.class);
        block1: for (i = 0; i < exceptionTypes.length; ++i) {
            if (exceptionTypes[i].isAssignableFrom(Exception.class)) {
                catchList.clear();
                break;
            }
            if (!Exception.class.isAssignableFrom(exceptionTypes[i])) continue;
            int j = 0;
            while (j < catchList.size()) {
                Class exception = (Class)catchList.elementAt(j);
                if (exception.isAssignableFrom(exceptionTypes[i])) continue block1;
                if (exceptionTypes[i].isAssignableFrom(exception)) {
                    catchList.removeElementAt(j);
                    continue;
                }
                ++j;
            }
            catchList.addElement(exceptionTypes[i]);
        }
        this.compilerConstant.writeMethodInitializer(p, method, paramTypes);
        p.write("// implementation of " + this.getOperationString(method));
        p.cwrite("public " + StringUtil.getTypeDeclaration(returnType) + " " + methodName + "(");
        RMICompiler.writeParamTypesAndNames(paramTypes, p, paramNames);
        p.write(")");
        p.TabIn();
        if (exceptionTypes.length > 0) {
            p.cwrite("throws ");
            for (i = 0; i < exceptionTypes.length; ++i) {
                if (i > 0) {
                    p.cwrite(", ");
                }
                p.cwrite(exceptionTypes[i].getName());
            }
            p.write("");
        }
        p.TabOut();
        p.write("{");
        p.TabIn();
        if (!returnType.getName().equals("void")) {
            this.compilerConstant.writeReturnVariable(p, returnType);
        }
        p.write("try {");
        p.TabIn();
        if (clustering) {
            p.write("String currExportName;");
            p.write(this.compilerConstant.getRemoteObjectClassName() + " currStub;");
            p.write("");
            p.write("while(true) {");
            p.TabIn();
            p.write("synchronized(clusterSupport)");
            p.write("{");
            p.write("\tcurrExportName = clusterSupport.getExportName();");
            p.write("\tcurrStub = (" + this.compilerConstant.getRemoteObjectClassName() + ") clusterSupport.getStub();");
            p.write("}");
            p.write("");
            p.write(this.compilerConstant.getRemoteRefQualifiedClassName() + " ref = currStub.getRef();");
            p.write("try {");
            p.TabIn();
            this.compilerConstant.writeCallOperation(p, "currStub", opnum, method, paramNames, paramTypes);
        } else {
            p.write(this.compilerConstant.getRemoteRefQualifiedClassName() + " ref = this.getRef();");
            this.compilerConstant.writeCallOperation(p, "this", opnum, method, paramNames, paramTypes);
        }
        this.compilerConstant.writeAfterCallOperation(p, "this", opnum, paramTypes, paramNames, returnType);
        if (returnType.getName().equals("void")) {
            p.write("return;");
        } else {
            if (clustering && isEJBHome) {
                p.write("if(result instanceof jeus.ejb.bean.objectbase.JEUSClusterStub) {");
                p.write("\t((jeus.ejb.bean.objectbase.JEUSClusterStub)result).__jeus_setCluster(clusterSupport.getExportName(), clusterSupport.getCluster());");
                p.write("}");
            }
            this.compilerConstant.writeReturnOperation(p, returnType);
        }
        if (clustering) {
            p.TabOut();
            p.write("} catch(java.rmi.RemoteException ex) {");
            p.TabIn();
            p.write("clusterSupport.handleException(ex, currExportName, " + idempotent + ");");
            p.TabOut();
            p.write("}");
            p.write("");
            p.TabOut();
            p.write("}");
        }
        p.TabOut();
        p.write("} catch (java.rmi.ServerException e) {");
        p.TabIn();
        p.write("if(e.detail != null && e.detail instanceof java.rmi.RemoteException)");
        p.write("\tthrow (java.rmi.RemoteException)e.detail;");
        p.write("else");
        p.write("throw e;");
        if (catchList.size() > 0) {
            Enumeration enum1 = catchList.elements();
            while (enum1.hasMoreElements()) {
                Class ex = (Class)enum1.nextElement();
                p.TabOut();
                p.write("} catch (" + ex.getName() + " e) {");
                p.TabIn();
                p.write("throw e;");
            }
            p.TabOut();
            p.write("} catch (java.lang.Exception e) {");
            p.TabIn();
            p.write("throw new java.rmi.UnexpectedException(\"undeclared checked exception\", e);");
        }
        p.TabOut();
        p.write("}");
        p.TabOut();
        p.write("}");
    }

    public static void writeParamTypesAndNames(Class[] paramTypes, CodeWriter p, String[] paramNames) throws IOException {
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                p.cwrite(", ");
            }
            p.cwrite(StringUtil.getTypeDeclaration((Class)paramTypes[i]) + " " + paramNames[i]);
        }
    }

    private void writeSkeleton(OutputStream out, String className, Method[] methods) throws RMICompilerException, IOException {
        int opnum;
        CodeWriter p = new CodeWriter(out);
        String skelClassName = StringUtil.cutPackagePart((String)(className + "_Skel"));
        p.write("// This is generated by JEUS RMI Compiler.");
        p.write("// Do not edit any part of this.");
        p.write("package " + className.substring(0, className.lastIndexOf(46)) + ";");
        p.write("");
        p.write("import jeus.util.*;");
        p.write("import java.util.logging.Level;");
        p.write("import java.rmi.RemoteException;");
        p.write("");
        p.write("public final class " + skelClassName);
        p.TabIn();
        p.write("extends jeus.ejb.bean.rmi.RMISkeleton");
        p.TabOut();
        p.write("{");
        p.TabIn();
        p.write("private static final java.rmi.server.Operation[] operations = {");
        p.TabIn();
        for (int i = 0; i < methods.length; ++i) {
            if (i > 0) {
                p.write(",");
            }
            p.cwrite("new java.rmi.server.Operation(\"" + this.getOperationString(methods[i]) + "\")");
        }
        p.write("");
        p.TabOut();
        p.write("};");
        p.write("");
        p.write("public static final long interfaceHash = " + this.computeInterfaceHash(methods) + "L;");
        p.write("");
        p.write("public " + skelClassName + "() {");
        p.write("}");
        p.write("");
        p.write("public java.rmi.server.Operation[] getOperations() {");
        p.TabIn();
        p.write("return (java.rmi.server.Operation[]) operations.clone();");
        p.TabOut();
        p.write("}");
        p.write("");
        p.write("public void dispatch(java.rmi.Remote  obj, java.rmi.server.RemoteCall call, int opnum, long hash)");
        p.TabIn();
        p.write("throws java.lang.Exception");
        p.TabOut();
        p.write("{");
        p.TabIn();
        p.write("if (hash != interfaceHash)");
        p.TabIn();
        p.write("throw new java.rmi.server.SkeletonMismatchException(\"interface hash mismatch\");");
        p.TabOut();
        p.write("");
        p.write(className + " server = (" + className + ") obj;");
        p.write("if (server instanceof jeus.ejb.bean.rmi.RMIInterceptorProvider) {");
        p.write("\tsetServerInterceptor((jeus.ejb.bean.rmi.RMIInterceptorProvider) server);");
        p.write("}");
        p.write("try {");
        p.TabIn();
        if (methods.length < 100) {
            p.write("switch (opnum) {");
            p.TabIn();
            for (opnum = 0; opnum < methods.length; ++opnum) {
                this.writeSkeletonDispatchCase(p, methods[opnum], opnum);
            }
            p.TabOut();
            p.write("default:");
            p.TabIn();
            p.write("throw new java.rmi.UnmarshalException(\"invalid method number\");");
            p.TabOut();
            p.write("}");
        } else {
            for (opnum = 0; opnum < methods.length; opnum += 100) {
                if (opnum != 0) {
                    p.cwrite("else ");
                }
                p.write("if(" + opnum + " <= opnum && opnum < " + (opnum + 100) + ")");
                p.write("\t__switchFunction" + opnum + "(server, call, opnum);");
            }
            p.write("else");
            p.write("\tthrow new java.rmi.UnmarshalException(\"invalid method number\");");
        }
        p.TabOut();
        p.write("} catch (RuntimeException t) {");
        p.write("\tif( !(t instanceof javax.ejb.EJBException) )");
        p.write("\t\tlogger.log(Level.WARNING, \"a problem in dispatch()\",t);");
        p.write("\tthrow t;");
        p.write("}");
        p.TabOut();
        p.write("}");
        p.write("");
        if (methods.length >= 100) {
            for (opnum = 0; opnum < methods.length; opnum += 100) {
                this.writeSwitchFunction(p, className, methods, opnum);
            }
        }
        p.TabOut();
        p.write("}");
        p.close();
    }

    private void writeSwitchFunction(CodeWriter p, String className, Method[] methods, int opnum) throws RMICompilerException, IOException {
        p.write("public void __switchFunction" + opnum + "(" + className + " server, java.rmi.server.RemoteCall call, int opnum) throws java.lang.Exception");
        p.write("{");
        p.TabIn();
        p.write("switch (opnum) {");
        p.TabIn();
        int end = opnum + 100 < methods.length ? opnum + 100 : methods.length;
        for (int i = opnum; i < end; ++i) {
            this.writeSkeletonDispatchCase(p, methods[i], i);
        }
        p.TabOut();
        p.write("default:");
        p.TabIn();
        p.write("throw new java.rmi.UnmarshalException(\"invalid method number\");");
        p.TabOut();
        p.write("}");
        p.TabOut();
        p.write("}");
    }

    private void writeSkeletonDispatchCase(CodeWriter p, Method method, int opnum) throws RMICompilerException, IOException {
        int i;
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        String[] paramNames = new String[paramTypes.length];
        for (i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = "param_" + (i + 1);
        }
        p.write("case " + opnum + ": // " + this.getOperationString(method));
        p.write("{");
        p.TabIn();
        if (paramTypes.length + 2 > 0) {
            for (i = 0; i < paramTypes.length; ++i) {
                p.write(StringUtil.getTypeDeclaration(paramTypes[i]) + " " + paramNames[i] + ";");
            }
            p.write("try {");
            p.TabIn();
            p.write("try {");
            p.TabIn();
            p.write("callServerInterceptor(call);");
            p.write("java.io.ObjectInput in = call.getInputStream();");
            for (i = 0; i < paramTypes.length; ++i) {
                JavaRMICompilerConstant.writeUnmarshalArgument(p, "in", paramTypes[i], paramNames[i]);
                p.write(";");
            }
            p.TabOut();
            p.write("} catch (java.rmi.RemoteException e) {");
            p.TabIn();
            p.write("throw e;");
            p.TabOut();
            p.write("} catch (java.io.IOException e) {");
            p.TabIn();
            p.write("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
            p.TabOut();
            p.write("} finally {");
            p.TabIn();
            p.write("call.releaseInputStream();");
            p.TabOut();
            p.write("}");
        } else {
            p.write("call.releaseInputStream();");
        }
        p.write("java.io.ObjectOutput out;");
        if (!returnType.getName().equals("void")) {
            p.write(StringUtil.getTypeDeclaration(returnType) + " result;");
        }
        p.write("try {");
        p.TabIn();
        if (!returnType.getName().equals("void")) {
            p.cwrite("result = ");
        }
        p.cwrite("server." + methodName + "(");
        for (i = 0; i < paramNames.length; ++i) {
            if (i > 0) {
                p.cwrite(", ");
            }
            p.cwrite(paramNames[i]);
        }
        p.write(");");
        p.TabOut();
        p.write("} catch(Exception e) {");
        p.TabIn();
        p.write("try {");
        p.TabIn();
        p.write("exceptionOccurred(e);");
        p.TabOut();
        p.write("} catch (Throwable ex) {");
        p.TabIn();
        p.write("if (ex instanceof Exception)");
        p.TabIn();
        p.write("throw (Exception) ex;");
        p.TabOut();
        p.write("else");
        p.TabIn();
        p.write("throw (Error) ex;");
        p.TabOut();
        p.TabOut();
        p.write("}");
        p.write("");
        p.write("throw e;");
        p.TabOut();
        p.write("}");
        p.write("try {");
        p.TabIn();
        p.write("out = callAfterServerInterceptor(call);");
        p.TabOut();
        p.write("} catch (java.io.IOException e) {");
        p.TabIn();
        p.write("throw new java.rmi.MarshalException(\"error marshalling return\", e);");
        p.TabOut();
        p.write("}");
        if (!returnType.getName().equals("void")) {
            p.write("try {");
            p.TabIn();
            JavaRMICompilerConstant.writeMarshalArgument(p, "out", returnType, "result");
            p.write(";");
            p.TabOut();
            p.write("} catch (java.io.IOException e) {");
            p.TabIn();
            p.write("throw new java.rmi.MarshalException(\"error marshalling return\", e);");
            p.TabOut();
            p.write("}");
        }
        p.TabOut();
        p.write("} finally {");
        p.TabIn();
        p.write("handleFinally();");
        p.TabOut();
        p.write("}");
        p.write("break;");
        p.TabOut();
        p.write("}");
    }

    private long computeInterfaceHash(Method[] remoteMethods) throws RMICompilerException {
        long hash = 0L;
        ByteArrayOutputStream sink = new ByteArrayOutputStream(512);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, md));
            out.writeInt(1);
            for (int i = 0; i < remoteMethods.length; ++i) {
                out.writeUTF(this.getOperationString(remoteMethods[i]));
            }
            out.flush();
            byte[] hashArray = md.digest();
            for (int i = 0; i < Math.min(8, hashArray.length); ++i) {
                hash += (long)(hashArray[i] & 0xFF) << i * 8;
            }
        }
        catch (Throwable e) {
            throw new RMICompilerException(JeusMessage_EJB11._7048, e);
        }
        return hash;
    }

    private String[] makeCompileCommand(String[] fileNames) {
        String[] args = new String[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            args[i] = this.tempArchive.getArchiveUri() + fs + fileNames[i].replace('.', fsc) + ".java";
        }
        return args;
    }

    private void compile_generatedFiles(String[] fileNames, int type) throws EJBSourceGeneratorException {
        String[] compile_args = this.makeCompileCommand(fileNames);
        super.compile_generatedFiles(type, compile_args, fileNames, false);
    }

    static {
        clsp = File.separator.equals("/") ? ":" : ";";
        jeusCompilerConstant = new JEUSRMICompilerConstant();
        javaCompilerConstant = new JavaRMICompilerConstant();
    }
}

