/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.transaction.TransactionManager;
import jeus.ejb.BeanContainer;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBEngine;
import jeus.ejb.EJBLoggers;
import jeus.ejb.EJBStatus;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.baseimpl.RemoteExporter;
import jeus.ejb.baseimpl.RemoteInvocationManager;
import jeus.ejb.bean.rmi.EJBServerInterceptor;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.IsolatedReference;
import jeus.ejb.container.RMIExporter;
import jeus.ejb.container.RemoteInvocationManagerImpl;
import jeus.ejb.container.TimerContainer;
import jeus.ejb.container.TransactionAssociationManager;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.util.IsolatedStubWrapper;
import jeus.ejb.util.LeftTime;
import jeus.ejb.util.ThreadLocalStack;
import jeus.jndi.objectfactory.SerializableRefAddr;
import jeus.management.j2ee.EJB;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.statistics.StatisticListener;
import jeus.security.base.Subject;
import jeus.security.spi.SecurityInstaller;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.transaction.TMInfo;
import jeus.transaction.TMServer;
import jeus.transaction.TxHelper;
import jeus.util.RemoteClassLoaderRepository;
import jeus.util.concurrent50.concurrent.atomic.AtomicInteger;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB4;
import jeus.xml.binding.jeusDD.DurableTimerServiceType;
import org.omg.CORBA.Object;

public abstract class AbstractContainer
implements BeanContainer,
StatisticListener {
    protected static final JeusLogger logger = EJBLoggers.logger;
    protected static final JeusLogger timerLogger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.timer");
    protected static ThreadLocalStack<EJBContextImpl> contexts = new ThreadLocalStack();
    protected final RemoteInvocationManagerImpl remoteInvocationManager;
    protected final TransactionAssociationManager associatedTransactionManager = new TransactionAssociationManager();
    private EJBServerInterceptor ejbServerInterceptor;
    private final AtomicInteger activeThreadCounter = new AtomicInteger();
    public static final TransactionManager txManager = TxHelper.getTransactionManager();
    protected EJBEngine engine = EJBEngine.getDefaultEngine();
    protected final BeanInfo beanInfo;
    protected final String appName;
    protected final String moduleName;
    protected final String beanName;
    protected final String ejbId;
    protected final ArchiveArrayClassLoader loader;
    protected Class<?> beanClass;
    protected boolean isLocalInvocationOptimized;
    protected boolean singleVMOnly;
    protected boolean isWebserviceConsumer;
    protected final boolean isUseAccessControl;
    protected final String securityPolicyID;
    protected final String securityDomainName;
    protected Subject runAsSubject;
    protected Method ejbTimeoutMethod;
    protected Vector<Long> timerIds = new Vector();
    protected Hashtable<java.lang.Object, Vector<Long>> timerPks = new Hashtable();
    public boolean isClustered;
    public boolean exportIIOP;
    public Object ejbPOA;
    protected Class ejbObjectImplIIOPClass;
    protected boolean isHttpInvocation;
    protected String httpContext;
    protected int httpPort;
    public int exportPort;
    protected String exportName;
    protected String localExportName;
    protected RMIExporter rmiExporter;
    protected final AtomicReference<EJBStatus> status = new AtomicReference<EJBStatus>(EJBStatus.PREDEPLOYMENT);
    protected final boolean forcedShutdown = false;
    protected java.lang.Object statSync = new java.lang.Object();
    protected long numRequest = 0L;
    protected CountStatisticImpl createCount = new CountStatisticImpl("create", "CreateCount", "times", "the number of times the bean's create method was called");
    protected CountStatisticImpl removeCount = new CountStatisticImpl("remove", "RemoveCount", "times", "the number of times the bean's remove method was called");
    protected RangeStatisticImpl passivatedBeanCount = new RangeStatisticImpl("passivated-bean", "PassiveCount", "bean", "the number of beans that are in the passivated state");
    protected RangeStatisticImpl totalEJBBeanCount = new RangeStatisticImpl("total-bean", "TotalEJBBeanCount", "bean", "the number of bean instances made by object pool");
    protected RangeStatisticImpl activeEJBBeanCount = new RangeStatisticImpl("active-bean", "ActiveEJBBeanCount", "bean", "the number of bean instances is active, not in the object pool");
    protected CountStatisticImpl autoRemovedEJBObjectCount = new CountStatisticImpl("timed-obj", "AutoRemovedEJBObjectCount", "object", "the number of EJB object instances removed by disconnect timeout");
    protected RangeStatisticImpl totalEJBObjectCount = new RangeStatisticImpl("total-obj", "TotalEJBObjectCount", "object", "the number of EJB object instances made by object pool");
    protected RangeStatisticImpl activeEJBObjectCount = new RangeStatisticImpl("active-obj", "ActiveEJBObjectCount", "object", "the number of EJB object instances activated, not in the object pool");
    protected RangeStatisticImpl totalThreadCount = new RangeStatisticImpl("total-remote-thread", "TotalThreadCount", "thread", "the number of remote thread can be allowed for the ejb bean in the setting");
    protected RangeStatisticImpl activeThreadCount = new RangeStatisticImpl("active-thread", "ActiveThreadCount", "thread", "the number of thread processing requests");
    protected CountStatisticImpl requestCount = new CountStatisticImpl("request", "RequestCount", "request", "the number of request arrived");
    protected CountStatisticImpl committedCount = new CountStatisticImpl("comitted", "CommittedCount", "transaction", "the number of committed transactions");
    protected CountStatisticImpl rolledbackCount = new CountStatisticImpl("rolledback", "RolledbackCount", "transaction", "the number of rolled-back transactions");
    protected CountStatisticImpl timeoutRolledbackCount = new CountStatisticImpl("timed-rb", "TimeoutRolledbackCount", "transaction", "the number of rolled-back transactions");
    private static final String LOCATION_ATTR_NAME = "location";
    private static final BasicAttributes BIND_ATTRS = new BasicAttributes("location", TMServer.getTMInfo());

    protected AbstractContainer(BeanInfo beanInfo, ArchiveArrayClassLoader loader, String securityDomain) {
        this.status.set(EJBStatus.DEPLOYING);
        this.beanInfo = beanInfo;
        this.loader = loader;
        this.appName = beanInfo.getModuleInfo().getAppName();
        this.moduleName = beanInfo.getModuleInfo().getModuleName();
        this.beanName = beanInfo.getBeanName();
        this.ejbId = AbstractContainer.createEJBId(this.moduleName, this.beanName);
        this.isLocalInvocationOptimized = beanInfo.isLocalInvocationOptimized();
        this.securityPolicyID = beanInfo.getSecurityPolicyID();
        this.isUseAccessControl = beanInfo.isUseAccessControl();
        this.securityDomainName = securityDomain == null ? SecurityInstaller.getDefaultDomainName() : securityDomain;
        this.remoteInvocationManager = new RemoteInvocationManagerImpl(this, beanInfo.getThreadPoolMax());
    }

    protected void postConstruct() throws EJBDeploymentException {
    }

    protected void preStartService() throws ContainerException {
    }

    protected void startService() throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB4._3006_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3006_LEVEL, "Container", "startService", JeusMessage_EJB4._3006, (java.lang.Object)this.beanName);
        }
    }

    public final EJBEngine getEngine() {
        return this.engine;
    }

    public final String getModuleName() {
        return this.moduleName;
    }

    public final String getBeanName() {
        return this.beanName;
    }

    public final String getEJBId() {
        return this.ejbId;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public final boolean isLocalInvocationOptimized() {
        return this.isLocalInvocationOptimized;
    }

    public final String getSecurityDomain() {
        return this.securityDomainName;
    }

    public final Subject getRunAsSubject() {
        return this.runAsSubject;
    }

    public final String getSecurityPolicyID() {
        return this.securityPolicyID;
    }

    public final boolean isWebserviceConsumer() {
        return this.isWebserviceConsumer;
    }

    public final void setIsWebserviceConsumer(boolean flag) {
        this.isWebserviceConsumer = flag;
    }

    public final ClassLoader getClassLoader() {
        return this.loader;
    }

    public boolean isTimedObject() {
        return this.ejbTimeoutMethod != null;
    }

    public final EJBStatus getStatus() {
        return this.status.get();
    }

    public final boolean isRunning() {
        return this.getStatus() == EJBStatus.RUNNING;
    }

    public final boolean isSuspended() {
        return this.getStatus() == EJBStatus.SUSPENDED;
    }

    public final boolean isUndeployed() {
        return this.getStatus() == EJBStatus.UNDEPLOYED;
    }

    public void startAccess() {
        this.incActiveThreadCount();
    }

    public void endAccess() {
        this.decActiveThreadCount();
    }

    protected void initDurableTimers(ClassLoader timerClassLoader) {
        DurableTimerServiceType durableSetting = this.getDurableTimerSetting();
        if (durableSetting == null) {
            return;
        }
        if (!durableSetting.isEnableDurableTimers().booleanValue()) {
            if (logger.isLoggable(JeusMessage_EJB4._3007_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3007_LEVEL, "Container", "initDurableTimers", JeusMessage_EJB4._3007);
            }
            return;
        }
        if (logger.isLoggable(JeusMessage_EJB4._3008_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3008_LEVEL, "Container", "initDurableTimers", JeusMessage_EJB4._3008);
        }
        TimerContainer timerContainer = TimerContainer.currentTimerContainer();
        timerContainer.initDurableTimers(this, durableSetting.isIgnoreDurableTimersAtDeploy(), timerClassLoader);
        if (logger.isLoggable(JeusMessage_EJB4._3009_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3009_LEVEL, "Container", "initDurableTimers", JeusMessage_EJB4._3009);
        }
    }

    public void addTimerId(Long timerId) {
        if (timerLogger.isLoggable(JeusMessage_EJB4._3045_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3045_LEVEL, "Container", "addTimerId", JeusMessage_EJB4._3045, (java.lang.Object)String.valueOf(timerId));
        }
        this.timerIds.add(timerId);
    }

    public void addTimerId(java.lang.Object primaryKey, Long timerId) {
        if (timerLogger.isLoggable(JeusMessage_EJB4._3046_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3046_LEVEL, "Container", "addTimerId", JeusMessage_EJB4._3046, new java.lang.Object[]{String.valueOf(timerId), primaryKey});
        }
        if (primaryKey != null) {
            if (this.timerPks.containsKey(primaryKey)) {
                this.timerPks.get(primaryKey).add(timerId);
            } else {
                Vector<Long> timers = new Vector<Long>();
                timers.add(timerId);
                this.timerPks.put(primaryKey, timers);
            }
        }
        this.addTimerId(timerId);
    }

    public Enumeration getTimerIds() {
        if (timerLogger.isLoggable(JeusMessage_EJB4._3047_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3047_LEVEL, "Container", "getTimerIds", JeusMessage_EJB4._3047);
        }
        return this.timerIds.elements();
    }

    public Enumeration getTimerIds(java.lang.Object primaryKey) {
        if (timerLogger.isLoggable(JeusMessage_EJB4._3048_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3048_LEVEL, "Container", "getTimerIds", JeusMessage_EJB4._3048, primaryKey);
        }
        if (primaryKey == null) {
            return this.getTimerIds();
        }
        Vector<Long> timers = this.timerPks.get(primaryKey);
        if (timers != null) {
            return timers.elements();
        }
        return new Vector(0).elements();
    }

    public void remove(Long timerId) {
        if (timerLogger.isLoggable(JeusMessage_EJB4._3049_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3049_LEVEL, "Container", "remove", JeusMessage_EJB4._3049, (java.lang.Object)String.valueOf(timerId));
        }
        this.timerIds.remove(timerId);
    }

    public void remove(java.lang.Object primaryKey, Long timerId) {
        if (timerLogger.isLoggable(JeusMessage_EJB4._3050_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3050_LEVEL, "Container", "remove", JeusMessage_EJB4._3050, new java.lang.Object[]{String.valueOf(timerId), primaryKey});
        }
        this.remove(timerId);
        if (primaryKey != null) {
            this.timerPks.get(primaryKey).remove(timerId);
        }
    }

    protected void destoryTimers() {
        if (timerLogger.isLoggable(JeusMessage_EJB4._3051_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3051_LEVEL, "Container", "destoryTimers", JeusMessage_EJB4._3051);
        }
        TimerContainer timerContainer = TimerContainer.currentTimerContainer();
        timerContainer.destroyTimers(this.moduleName, this.beanName, this.getDurableTimerSetting());
        if (timerLogger.isLoggable(JeusMessage_EJB4._3052_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3052_LEVEL, "Container", "destoryTimers", JeusMessage_EJB4._3052);
        }
    }

    public void setBeanModel(EJB mo) {
        mo.setStatistic((StatisticImpl)this.createCount);
        mo.setStatistic((StatisticImpl)this.removeCount);
        mo.setStatistic((StatisticImpl)this.requestCount);
        mo.setStatistic((StatisticImpl)this.committedCount);
        mo.setStatistic((StatisticImpl)this.rolledbackCount);
        mo.setStatistic((StatisticImpl)this.timeoutRolledbackCount);
        mo.setStatisticListener(this);
    }

    public static String createEJBId(String moduleName, String beanName) {
        return moduleName + "/" + beanName;
    }

    public static String[] getModuleNameAndBeanNameFromEJBId(String ejbId) {
        int i = ejbId.indexOf("/");
        if (i == -1) {
            throw new IllegalArgumentException("Invalid EJB ID value: " + ejbId);
        }
        String[] values = new String[]{ejbId.substring(0, i), ejbId.substring(i + 1, ejbId.length())};
        return values;
    }

    protected static String getHashCode(String s) {
        return "@" + s.hashCode();
    }

    protected static void bindAgedObject(DirContext ctx, String name, java.lang.Object obj) throws NamingException {
        Attributes attr;
        try {
            attr = ctx.getAttributes(name);
        }
        catch (NamingException ex) {
            ctx.bind(name, obj, (Attributes)BIND_ATTRS);
            return;
        }
        Attribute locationAttr = attr.get(LOCATION_ATTR_NAME);
        if (locationAttr == null) {
            throw new NameAlreadyBoundException("the name " + name + " is already bounded for other object that is not EJB Home");
        }
        TMInfo tmInfo = (TMInfo)locationAttr.get();
        TMInfo localTMInfo = TMServer.getTMInfo();
        if (localTMInfo != null && localTMInfo.isSameLocation(tmInfo)) {
            if (localTMInfo.getTime() == tmInfo.getTime()) {
                throw new NameAlreadyBoundException("the name " + name + " is already bounded in this container");
            }
        } else {
            throw new NameAlreadyBoundException("the name " + name + " is already bounded in another container " + tmInfo);
        }
        ctx.rebind(name, obj, (Attributes)BIND_ATTRS);
    }

    protected static java.lang.Object getStubObject(java.lang.Object stub, Class ejbHomeClass) throws Exception {
        IsolatedReference ref = new IsolatedReference(stub.getClass().getName(), "jeus.ejb.container.IsolatedStubFactory", null);
        ref.add(0, new SerializableRefAddr("stub_object", new IsolatedStubWrapper(stub)));
        ref.add(1, new StringRefAddr("interface_name", ejbHomeClass.getName()));
        return ref;
    }

    public static boolean isIIOP() {
        return Thread.currentThread().getName().startsWith("jeus.corba.iiop_");
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    public RemoteExporter getRemoteExporter() throws IllegalStateException {
        if (this.rmiExporter == null) {
            throw new IllegalStateException("There is no remote exporter - bug?");
        }
        return this.rmiExporter;
    }

    public Remote export(Remote obj) throws RemoteException {
        assert (this.rmiExporter != null);
        return this.rmiExporter.export(obj);
    }

    public void unexport(Remote obj, boolean force) throws NoSuchObjectException {
        assert (this.rmiExporter != null);
        this.rmiExporter.unexport(obj, force);
    }

    public RemoteInvocationManager getRemoteInvocationManager() {
        return this.remoteInvocationManager;
    }

    public TransactionAssociationManager getAssociatedTransactionManager() {
        return this.associatedTransactionManager;
    }

    public EJBServerInterceptor getEjbServerInterceptor() {
        if (this.ejbServerInterceptor == null) {
            this.ejbServerInterceptor = new EJBServerInterceptor(this);
        }
        return this.ejbServerInterceptor;
    }

    protected void undeploy() {
        RemoteClassLoaderRepository.removeRemoteClassLoaderRepository(this.loader);
    }

    public void incActiveThreadCount() {
        this.activeThreadCounter.incrementAndGet();
    }

    public void decActiveThreadCount() {
        this.activeThreadCounter.decrementAndGet();
    }

    protected int getActiveThreadNum() {
        return this.activeThreadCounter.get();
    }

    public float getActiveThreadRatio() {
        int total = this.beanInfo.getThreadPoolMax();
        if (total == 0) {
            return 0.0f;
        }
        return (float)this.remoteInvocationManager.getActiveCount() / (float)total;
    }

    public void suspend() {
        this.status.set(EJBStatus.SUSPENDING);
        if (logger.isLoggable(JeusMessage_EJB4._3004_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3004_LEVEL, "Container", "suspend", JeusMessage_EJB4._3004);
        }
        this.status.set(EJBStatus.SUSPENDED);
    }

    public void resume() {
        this.status.set(EJBStatus.RESUMING);
        if (logger.isLoggable(JeusMessage_EJB4._3005_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3005_LEVEL, "Container", "resume", JeusMessage_EJB4._3005);
        }
        this.status.set(EJBStatus.RUNNING);
    }

    public final void stop() {
        this.status.set(EJBStatus.UNDEPLOYING);
        this.stopService();
    }

    protected void stopService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy(long gracePeriodInMillis) {
        block15: {
            if (gracePeriodInMillis > 0L) {
                try {
                    LeftTime leftTime = new LeftTime(gracePeriodInMillis);
                    if (logger.isLoggable(JeusMessage_EJB4._3063_LEVEL)) {
                        logger.log(JeusMessage_EJB4._3063_LEVEL, JeusMessage_EJB4._3063, new java.lang.Object[]{this.ejbId, gracePeriodInMillis});
                    }
                    if (this.remoteInvocationManager.waitUntilEmpty(leftTime.leftTime())) {
                        leftTime.check();
                        if (logger.isLoggable(JeusMessage_EJB4._3064_LEVEL)) {
                            logger.log(JeusMessage_EJB4._3064_LEVEL, JeusMessage_EJB4._3064, (java.lang.Object)this.ejbId);
                        }
                        if (!this.associatedTransactionManager.waitUntilEmpty(leftTime.leftTime()) && logger.isLoggable(JeusMessage_EJB4._3065_LEVEL)) {
                            logger.log(JeusMessage_EJB4._3065_LEVEL, JeusMessage_EJB4._3065, (java.lang.Object)this.ejbId);
                        }
                    } else if (logger.isLoggable(JeusMessage_EJB4._3066_LEVEL)) {
                        logger.log(JeusMessage_EJB4._3066_LEVEL, JeusMessage_EJB4._3066, (java.lang.Object)this.ejbId);
                    }
                }
                catch (InterruptedException e) {
                    if (!logger.isLoggable(JeusMessage_EJB4._3067_LEVEL)) break block15;
                    logger.log(JeusMessage_EJB4._3067_LEVEL, JeusMessage_EJB4._3067, (java.lang.Object)this.ejbId);
                }
            }
        }
        if (logger.isLoggable(JeusMessage_EJB4._3068_LEVEL)) {
            logger.log(JeusMessage_EJB4._3068_LEVEL, JeusMessage_EJB4._3068, (java.lang.Object)this.ejbId);
        }
        try {
            this.undeploy();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            this.status.set(EJBStatus.UNDEPLOYED);
        }
    }

    public void passivate(long timeStamp) throws ContainerException {
    }

    public static void pushEJBContext(EJBContextImpl context) {
        ((LinkedList)contexts.get()).add(context);
    }

    public static void popEJBContext() {
        ((LinkedList)contexts.get()).removeLast();
    }

    public static EJBContextImpl getCurrentEJBContext() {
        LinkedList list = (LinkedList)contexts.get();
        if (list.size() == 0) {
            return null;
        }
        return (EJBContextImpl)list.getLast();
    }
}

