/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import jeus.ejb.BeanState;
import jeus.ejb.bean.RemoteRequest;
import jeus.ejb.bean.context.EJBContextImpl;
import jeus.ejb.bean.context.EntityContextImpl;
import jeus.ejb.bean.objectbase.EJBEntityMObjectImpl;
import jeus.ejb.bean.objectbase.EJBEntityObjectImpl;
import jeus.ejb.bean.objectbase.EJBLocalObjectImpl;
import jeus.ejb.bean.objectbase.EJBObjectImpl;
import jeus.ejb.bean.objectbase.FieldAccessor;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.EntityContainer;
import jeus.ejb.container.RelationManager;
import jeus.ejb.metadata.EntityBeanInfo;
import jeus.ejb.persistence.database.PersistenceLayer;
import jeus.ejb.schema.CMPField;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.EJBCacher;
import jeus.ejb.schema.EJBCreator;
import jeus.ejb.schema.EJBFinder;
import jeus.ejb.schema.EJBKeyGenerator;
import jeus.ejb.schema.EJBLoader;
import jeus.ejb.schema.EJBRemover;
import jeus.ejb.schema.EJBStorer;
import jeus.ejb.schema.EJBTableChecker;
import jeus.ejb.schema.EJBTableCreator;
import jeus.ejb.schema.EJBTableRemover;
import jeus.ejb.schema.cmp20.EJBDynamicFinder;
import jeus.ejb.schema.cmp20.EJBResultSet;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.transaction.TMService;
import jeus.transaction.TransactionImpl;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB3;
import jeus.util.properties.JeusEJBProperties;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;
import jeus.xml.binding.jeusDD.CreatingTableType;

public class CMEntityContainer
extends EntityContainer {
    private int cmpVersion;
    private PersistenceLayer pLayer;
    private String dataSourceName;
    private String tableName;
    private boolean initCaching;
    public RelationManager rMan;
    public EJBDynamicFinder dynFinder;
    private boolean hasLocalIntf;
    private CreatingTableType creatingTable;
    private boolean deletingTable;
    private Field[] cmFields;
    private Field[] cmPkeyFields;
    private int[] cmFieldTypeIDs;
    private Field[] pkeyClassFields;
    private boolean isPkeyField;
    private boolean isLocalIntfForManagement;
    public int fetchSize;
    private EJBTableCreator tableCreator;
    private EJBTableRemover tableRemover;
    private EJBCreator creator;
    private EJBRemover remover;
    private EJBLoader loader;
    private EJBStorer storer;
    private EJBFinder finder;
    private EJBCacher cacher;
    private EJBTableChecker tableChecker;
    private EJBKeyGenerator ejbKeyGenerator;
    private boolean isAutoPK;
    private boolean isDelayDatabaseInsertUntilCommit;
    private boolean isDelayDatabaseInsertUntilPostCreate;
    private CMRFieldRW[] sharedReadOnlyCMRFielsRWs;

    public CMEntityContainer(EntityBeanInfo beanInfo, Map transactionInfo, ArchiveArrayClassLoader loader, String securityDomain) throws ContainerException {
        super(beanInfo, transactionInfo, loader, securityDomain);
    }

    protected void makePersistentLayer() throws ContainerException {
        this.pLayer = new PersistenceLayer(this.dataSourceName);
        if (JeusEJBProperties.CHECK_TABLE && this.creatingTable == null) {
            this.checkTable();
        } else if (this.creatingTable != null) {
            if (this.creatingTable.getUseExistingTable() != null) {
                try {
                    this.checkTable();
                    if (logger.isLoggable(JeusMessage_EJB3._2653_LEVEL)) {
                        logger.logp(JeusMessage_EJB3._2653_LEVEL, "CMEntityContainer", "makePersistentLayer", JeusMessage_EJB3._2653, new Object[]{this.tableName, this.beanName});
                    }
                }
                catch (Exception ex) {
                    this.createTable();
                }
            } else if (this.creatingTable.getForceCreatingTable() != null) {
                if (logger.isLoggable(JeusMessage_EJB3._2652_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2652_LEVEL, "CMEntityContainer", "makePersistentLayer", JeusMessage_EJB3._2652, new Object[]{this.tableName, this.beanName});
                }
                try {
                    this.checkTable();
                    if (logger.isLoggable(JeusMessage_EJB3._2651_LEVEL)) {
                        logger.logp(JeusMessage_EJB3._2651_LEVEL, "CMEntityContainer", "makePersistentLayer", JeusMessage_EJB3._2651, (Object)this.tableName);
                    }
                    this.deleteTable();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.createTable();
            } else {
                this.createTable();
            }
        }
        if (this.cmpVersion == 2) {
            this.rMan.setContainer(this);
        }
        if (this.dynFinder != null) {
            this.dynFinder.setPersistenceLayer(this.pLayer);
            this.dynFinder.setContainer(this);
        }
        if (logger.isLoggable(JeusMessage_EJB3._2654_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2654_LEVEL, "CMEntityContainer", "makePersistentLayer", JeusMessage_EJB3._2654);
        }
    }

    protected void initializeDBInformation() throws ContainerException {
        CMEntityBeanPair beanPair = (CMEntityBeanPair)this.deployD;
        this.cmpVersion = beanPair.getCMPVersion();
        this.initCaching = beanPair.isInitCaching();
        this.fetchSize = beanPair.getFetchSize();
        this.rMan = beanPair.getRelationManager();
        this.dynFinder = beanPair.getEJBDynamicFinder();
        this.hasLocalIntf = beanPair.getEJBLocalHomeClassName() != null;
        boolean bl = this.isLocalIntfForManagement = beanPair.getLocalExportName() == null;
        if (beanPair.getDelayDatabaseInsertUntil().equals("commit")) {
            this.isDelayDatabaseInsertUntilCommit = true;
        } else if (beanPair.getDelayDatabaseInsertUntil().equals("ejbPostCreate")) {
            this.isDelayDatabaseInsertUntilPostCreate = true;
        }
        this.readEJBDBInfo();
        this.loadPkeyClass();
        if (beanPair.getPkeyClassName().equals("java.lang.Integer") && beanPair.isAutoKeyGenerator()) {
            if (logger.isLoggable(JeusMessage_EJB3._2656_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2656_LEVEL, "CMEntityContainer", "initializeDBInformation", JeusMessage_EJB3._2656);
            }
            this.ejbKeyGenerator = beanPair.getEJBKeyGeneratorForContainer();
            this.isAutoPK = true;
        }
        if (logger.isLoggable(JeusMessage_EJB3._2657_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2657_LEVEL, "CMEntityContainer", "initializeDBInformation", JeusMessage_EJB3._2657);
        }
    }

    private void readEJBDBInfo() throws ContainerException {
        CMEntityBeanPair beanPair = (CMEntityBeanPair)this.deployD;
        try {
            int i;
            this.dataSourceName = beanPair.getDataSourceName();
            this.tableName = beanPair.getTableName();
            ArrayList cmFieldList = beanPair.getCMFieldsForContainer();
            this.cmFields = new Field[cmFieldList.size()];
            for (i = 0; i < cmFieldList.size(); ++i) {
                this.cmFields[i] = this.beanClass.getField(((CMPField)cmFieldList.get(i)).getName());
            }
            ArrayList cmPkeyFieldList = beanPair.getCMPkeyFieldsForContainer();
            this.cmPkeyFields = new Field[cmPkeyFieldList.size()];
            for (i = 0; i < cmPkeyFieldList.size(); ++i) {
                this.cmPkeyFields[i] = this.beanClass.getField(((CMPField)cmPkeyFieldList.get(i)).getName());
            }
            this.cmFieldTypeIDs = beanPair.getCMFieldTypeIDs();
            this.isPkeyField = beanPair.isPkeyField();
            if (!this.isPkeyField) {
                ArrayList pkeyClassFieldList = beanPair.getPkeyClassFieldListForContainer();
                this.pkeyClassFields = new Field[pkeyClassFieldList.size()];
                for (i = 0; i < pkeyClassFieldList.size(); ++i) {
                    this.pkeyClassFields[i] = (Field)pkeyClassFieldList.get(i);
                }
            }
            this.sharedReadOnlyCMRFielsRWs = beanPair.getSharedReadOnlyCMRFieldRWsForContainer();
            this.creatingTable = beanPair.getCreatingTable();
            this.deletingTable = beanPair.isDeletingTable();
            this.tableCreator = beanPair.getEJBTableCreatorForContainer();
            this.tableRemover = beanPair.getEJBTableRemoverForContainer();
            this.creator = beanPair.getEJBCreatorForContainer();
            this.loader = beanPair.getEJBLoaderForContainer();
            this.storer = beanPair.getEJBStorerForContainer();
            this.remover = beanPair.getEJBRemoverForContainer();
            this.remover.setRelationManager(this.rMan);
            this.finder = beanPair.getEJBFinderForContainer();
            this.cacher = beanPair.getEJBCacherForContainer();
            this.tableChecker = beanPair.getEJBTableCheckerForContainer();
            this.cacher.setContainer(this);
            this.finder.setContainer(this);
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2659, ex);
        }
        if (logger.isLoggable(JeusMessage_EJB3._2660_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2660_LEVEL, "CMEntityContainer", "readEJBDBInfo", JeusMessage_EJB3._2660);
        }
    }

    public int getEngineType() {
        return this.engineType;
    }

    public boolean isLocalIntfForManagement() {
        return this.isLocalIntfForManagement;
    }

    public int getCMPVersion() {
        return this.cmpVersion;
    }

    protected void beforeExportHome() throws ContainerException {
        if (this.initCaching) {
            if (logger.isLoggable(JeusMessage_EJB3._2664_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2664_LEVEL, "CMEntityContainer", "beforeExportHome", JeusMessage_EJB3._2664);
            }
            try {
                Vector objects = this.getAllEntities();
                Enumeration e = objects.elements();
                while (e.hasMoreElements()) {
                    this.ejbObjects.addElement((EJBEntityObjectImpl)e.nextElement());
                }
                if (logger.isLoggable(JeusMessage_EJB3._2665_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2665_LEVEL, "CMEntityContainer", "beforeExportHome", JeusMessage_EJB3._2665);
                }
            }
            catch (Throwable ex) {
                throw new ContainerException(JeusMessage_EJB3._2666, ex);
            }
        }
    }

    protected void afterGetEJBObjectImpl(EntityContextImpl ejbCon, EJBEntityObjectImpl ejbObj) {
        if (this.cmpVersion == 2) {
            EJBLocalObjectImpl obj = null;
            if (this.hasLocalIntf) {
                obj = ejbObj.getEJBLocalObjectImpl();
            }
            ((FieldAccessor)ejbCon.ejbBean)._init(this, obj);
        }
    }

    public EJBLocalObjectImpl getEJBLocalObjectStub() {
        EJBLocalObjectImpl localStub = super.getEJBLocalObjectStub();
        localStub.setContainer(this);
        return localStub;
    }

    public void registerEJBBean(RemoteRequest request) throws RemoteException, CreateException {
        Object pKey;
        try {
            EntityBean bean = this.engineType != 3 ? (EntityBean)request.ejbObject.getContext().ejbBean : (EntityBean)request.ejbContext.ejbBean;
            pKey = this.getPrimaryKey(bean);
            if (this.sharedReadOnlyCMRFielsRWs != null) {
                for (int i = 0; i < this.sharedReadOnlyCMRFielsRWs.length; ++i) {
                    this.sharedReadOnlyCMRFielsRWs[i].restoreFromSharedCMPField(bean);
                }
            }
            if (!this.isDelayDatabaseInsertUntilCommit && !this.isDelayDatabaseInsertUntilPostCreate) {
                pKey = this.cmEJBCreate(bean, request.tx, pKey);
            }
            if (logger.isLoggable(JeusMessage_EJB3._2669_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2669_LEVEL, "CMEntityContainer", "registerEJBBean", JeusMessage_EJB3._2669);
            }
        }
        catch (CreateException e) {
            if (logger.isLoggable(JeusMessage_EJB3._2670_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2670_LEVEL, "CMEntityContainer", "registerEJBBean", JeusMessage_EJB3._2670, (Object)request, (Throwable)e);
            }
            throw e;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2671, request.toString(), ex);
        }
        this.internalRegisterEJBBean(request, pKey);
    }

    public void registerEJBBean(EJBEntityObjectImpl ejbObj, Transaction tx) throws RemoteException, CreateException {
        try {
            EntityContextImpl context = this.engineType != 3 ? (EntityContextImpl)ejbObj.getContext() : ((EJBEntityMObjectImpl)ejbObj).checkContext(tx);
            EntityBean bean = (EntityBean)context.ejbBean;
            Object pKey = context.getPrimaryKey();
            if (this.isDelayDatabaseInsertUntilCommit || this.isDelayDatabaseInsertUntilPostCreate) {
                this.cmEJBCreate(bean, tx, pKey);
            }
        }
        catch (CreateException e) {
            if (logger.isLoggable(JeusMessage_EJB3._2674_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2674_LEVEL, "CMEntityContainer", "registerEJBBean", JeusMessage_EJB3._2674, (Object)ejbObj, (Throwable)e);
            }
            throw e;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2675, ejbObj.toString(), ex);
        }
    }

    protected void undeployPerContainer() {
        if (logger.isLoggable(JeusMessage_EJB3._2676_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2676_LEVEL, "CMEntityContainer", "undeployPerContainer", JeusMessage_EJB3._2676);
        }
        if (this.deletingTable) {
            if (this.creatingTable == null) {
                throw new JeusRuntimeException("Cannot delete table if the <creating-table> is not set");
            }
            this.deleteTable();
        }
    }

    protected boolean isReentrantNotAvailable(RemoteRequest request, EJBEntityObjectImpl ejbObj) {
        boolean notAvail = !request.isForRelationship && !this.isReentrant && ejbObj.isInvoking();
        return notAvail;
    }

    protected void setTxToObject(RemoteRequest request) throws RemoteException {
        if (this.engineType != 3) {
            if (request.methodType == 1) {
                request.ejbObject.setTransaction(request.tx);
            }
        } else if (request.methodType != 2) {
            EJBContextImpl ejbContext;
            EJBEntityMObjectImpl ejbEntityMObject = (EJBEntityMObjectImpl)request.ejbObject;
            request.ejbContext = ejbContext = ejbEntityMObject.setContextWithTx(request.tx);
        }
    }

    protected void initCMFields(RemoteRequest request) throws Throwable {
        if (request.methodType == 1) {
            if (this.engineType != 3) {
                this.initCMFields((EntityBean)request.ejbObject.getContext().ejbBean);
            } else {
                this.initCMFields((EntityBean)request.ejbContext.ejbBean);
            }
        }
    }

    private void initCMFields(EntityBean bean) throws RemoteException {
        try {
            if (this.cmpVersion == 2) {
                ((FieldAccessor)bean)._initFields();
            } else {
                block12: for (int i = 0; i < this.cmFields.length; ++i) {
                    Field f = this.cmFields[i];
                    if (f.getType().isPrimitive()) {
                        switch (this.cmFieldTypeIDs[i]) {
                            case -7: {
                                f.setBoolean(bean, false);
                                continue block12;
                            }
                            case -6: {
                                f.setByte(bean, (byte)0);
                                continue block12;
                            }
                            case 5: {
                                f.setShort(bean, (short)0);
                                continue block12;
                            }
                            case 1: {
                                f.setChar(bean, '\u0000');
                                continue block12;
                            }
                            case 4: {
                                f.setInt(bean, 0);
                                continue block12;
                            }
                            case -5: {
                                f.setLong(bean, 0L);
                                continue block12;
                            }
                            case 7: {
                                f.setFloat(bean, 0.0f);
                                continue block12;
                            }
                            case 8: {
                                f.setDouble(bean, 0.0);
                                continue block12;
                            }
                            default: {
                                throw new ContainerException(JeusMessage_EJB3._2683, String.valueOf(this.cmFieldTypeIDs[i]));
                            }
                        }
                    }
                    f.set(bean, null);
                }
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2684, bean.toString(), ex);
        }
    }

    protected boolean handleObjectAfterInvokeHome(RemoteRequest request, EJBEntityObjectImpl ejbObj) {
        EJBContextImpl context = request.ejbContext;
        switch (request.methodType) {
            case 2: {
                return true;
            }
            case 3: {
                if (context != null) {
                    context.setStatus(BeanState.READY);
                }
                if (request.ejbObject.isRemoved()) break;
                this.restoreResources(request, false);
                return true;
            }
            case 1: {
                if (context != null) {
                    context.setStatus(BeanState.READY);
                }
                if (request.exception != null) break;
                long currentTime = System.currentTimeMillis();
                ejbObj.setLastAccessTime(currentTime);
                if (this.engineType == 3) {
                    ((EntityContextImpl)request.ejbContext).setLastAccessTime(currentTime);
                }
                this.ejbObjects.addElement(ejbObj);
                break;
            }
            default: {
                if (!logger.isLoggable(JeusMessage_EJB3._2694_LEVEL)) break;
                logger.logp(JeusMessage_EJB3._2694_LEVEL, "CMEntityContainer", "handleObjectAfterInvokeHome", JeusMessage_EJB3._2694, (Object)String.valueOf(request.methodType));
            }
        }
        return false;
    }

    public Object findEntities(RemoteRequest request, Object[] args, boolean isLocal, boolean isLocalIntf) throws RemoteException, FinderException {
        Connection con = this.getConnection(request.tx);
        Object objectImpls = null;
        try {
            Object object = objectImpls = this.finder.find(con, request.method, args, isLocal, isLocalIntf, this.fetchSize);
            return object;
        }
        catch (FinderException e) {
            if (logger.isLoggable(JeusMessage_EJB3._2697_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2697_LEVEL, "CMEntityContainer", "findEntities", JeusMessage_EJB3._2697, (Object)request.method, (Throwable)e);
            }
            throw e;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2698, request.method, ex);
        }
        finally {
            if (objectImpls == null || !(objectImpls instanceof EJBResultSet)) {
                this.closeConnection(con);
            }
        }
    }

    public Object[] findByPrimaryKeys(ArrayList pkeys, boolean isLocalIntf) throws ContainerException {
        try {
            long currentTime = System.currentTimeMillis();
            int listSize = pkeys.size();
            Object[] ejbObjs = isLocalIntf ? new EJBLocalObjectImpl[listSize] : new EJBObjectImpl[listSize];
            for (int i = 0; i < listSize; ++i) {
                Object pKey = pkeys.get(i);
                if (pKey != null) {
                    EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)this.ejbObjects.get(pKey, EJBEntityObjectImpl.getHashCode(pKey));
                    if (ejbObj == null) {
                        ejbObj = this.getEJBObjectWithPkey(pKey);
                        ejbObj.setLastAccessTime(currentTime);
                        ejbObj = this.ejbObjects.checkedAddElement(ejbObj);
                    }
                    if (isLocalIntf) {
                        ejbObjs[i] = ejbObj.getEJBLocalObjectImpl();
                        continue;
                    }
                    ejbObjs[i] = ejbObj;
                    continue;
                }
                ejbObjs[i] = null;
            }
            return ejbObjs;
        }
        catch (Throwable t) {
            throw new ContainerException(JeusMessage_EJB3._2703, String.valueOf(pkeys.size()), t);
        }
    }

    protected void processExceptionInClientTx(Throwable exception, RemoteRequest request) {
        String errorMsg = exception.getMessage();
        errorMsg = errorMsg != null ? ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7188) + ":" + errorMsg : ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7188);
        request.exception = new TransactionRolledbackException(errorMsg);
        ((RemoteException)request.exception).detail = exception;
        if (request.methodType != 2) {
            this.destroyInstance((EJBEntityObjectImpl)request.ejbObject, request.tx);
        }
    }

    protected void processExceptionInNullTx(Throwable exception, RemoteRequest request) {
        if (exception instanceof RemoteException) {
            request.exception = exception;
        } else {
            String errorMsg = exception.getMessage();
            errorMsg = errorMsg != null ? ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7188) + ":" + errorMsg : ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB11._7188);
            request.exception = new RemoteException(errorMsg, exception);
        }
        if (request.methodType != 2) {
            this.destroyInstance((EJBEntityObjectImpl)request.ejbObject, request.tx);
        }
    }

    protected boolean needCompletionForNullTransaction(RemoteRequest request) {
        return request.tx == TMService.nullTransaction && request.ejbObject != null && ((EJBEntityObjectImpl)request.ejbObject).isIdentified();
    }

    protected boolean needToStoreForBeforeCompletion(EntityContextImpl ejbCon) {
        return this.cmpVersion == 2 || ejbCon.isModified();
    }

    private void createTable() throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB3._2650_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2650_LEVEL, "CMEntityContainer", "makePersistentLayer", JeusMessage_EJB3._2650, new Object[]{this.tableName, this.beanName});
        }
        TMService.associateNullTransaction();
        Connection con = null;
        try {
            con = this.pLayer.getConnectionForDDL();
            this.tableCreator.createTable(con);
            if (logger.isLoggable(JeusMessage_EJB3._2707_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2707_LEVEL, "CMEntityContainer", "createTable", JeusMessage_EJB3._2707);
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2708, this.tableCreator.toString(), ex);
        }
        finally {
            this.closeConnection(con);
        }
    }

    private void closeConnection(Connection con) {
        block4: {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Throwable e) {
                if (logger.isLoggable(JeusMessage_EJB3._2710_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2710_LEVEL, "CMEntityContainer", "closeConnection", JeusMessage_EJB3._2710, (Object)con);
                }
                if (!logger.isLoggable(JeusMessage_EJB3._2780_LEVEL)) break block4;
                logger.logp(JeusMessage_EJB3._2780_LEVEL, "CMEntityContainer", "closeConnection", JeusMessage_EJB3._2780, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTable() {
        if (logger.isLoggable(JeusMessage_EJB3._2711_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2711_LEVEL, "CMEntityContainer", "deleteTable", JeusMessage_EJB3._2711);
        }
        if (!JeusEJBProperties.ENABLE_CONFIG_DELETE) {
            throw new JeusRuntimeException("Cannot delete table for forced-creating-table or undeploy, please turn on jeus.ejb.enable.configDeleteOption system property");
        }
        TMService.associateNullTransaction();
        if (this.pLayer != null) {
            Connection con = null;
            try {
                con = this.pLayer.getConnectionForDDL();
                this.tableRemover.removeTable(con);
                if (logger.isLoggable(JeusMessage_EJB3._2712_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2712_LEVEL, "CMEntityContainer", "deleteTable", JeusMessage_EJB3._2712);
                }
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_EJB3._2713_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2713_LEVEL, "CMEntityContainer", "deleteTable", JeusMessage_EJB3._2713, ex);
                }
            }
            finally {
                this.closeConnection(con);
            }
        }
    }

    private void checkTable() throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB3._2714_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2714_LEVEL, "CMEntityContainer", "checkTable", JeusMessage_EJB3._2714);
        }
        TMService.associateNullTransaction();
        Connection con = null;
        try {
            con = this.pLayer.getConnection(false);
            this.tableChecker.checkTable(con, this.rMan);
            if (logger.isLoggable(JeusMessage_EJB3._2715_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2715_LEVEL, "CMEntityContainer", "checkTable", JeusMessage_EJB3._2715);
            }
        }
        catch (ContainerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2717, this.tableName, ex);
        }
        finally {
            this.closeConnection(con);
        }
    }

    public Vector getAllEntities() throws ContainerException {
        Connection con;
        TMService.associateNullTransaction();
        try {
            con = this.pLayer.getConnection(false);
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2721, ex);
        }
        try {
            Vector v;
            Vector vector = v = this.cacher.cache(con, this.fetchSize);
            return vector;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2723, ex);
        }
        finally {
            this.closeConnection(con);
        }
    }

    public void cmEJBPostLoad(EntityBean bean) {
        Connection con;
        try {
            con = this.getConnection(txManager.getTransaction());
        }
        catch (Throwable e) {
            throw new JeusRuntimeException(JeusMessage_EJB3._2725, e);
        }
        try {
            this.loader.load(bean, con);
        }
        catch (Throwable ex) {
            throw new JeusRuntimeException(JeusMessage_EJB3._2726, ex);
        }
        finally {
            this.closeConnection(con);
        }
    }

    protected Object cmEJBCreate(EntityBean bean, Transaction tx, Object pkey) throws ContainerException, CreateException {
        block11: {
            if (logger.isLoggable(JeusMessage_EJB3._2728_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2728_LEVEL, "CMEntityContainer", "cmEJBCreate", JeusMessage_EJB3._2728, new Object[]{pkey, bean, tx});
            }
            if (pkey == null && this.isAutoPK && this.ejbKeyGenerator.isGenKeyBeforeInsert()) {
                throw new ContainerException(JeusMessage_EJB3._2729);
            }
            Connection con = this.getConnection(tx);
            try {
                this.creator.create(bean, con);
                if (!this.isAutoPK || this.ejbKeyGenerator.isGenKeyBeforeInsert()) break block11;
                pkey = this.ejbKeyGenerator.getKeyQuery(con);
                if (this.isPkeyField) {
                    this.cmPkeyFields[0].set(bean, pkey);
                    break block11;
                }
                throw new ContainerException(JeusMessage_EJB3._2730);
            }
            catch (Exception ex) {
                if (this.finder.checkForPrimaryKeyExistence(pkey, con)) {
                    throw new DuplicateKeyException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB3._2731, (Object)pkey));
                }
                if (logger.isLoggable(JeusMessage_EJB3._2732_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2732_LEVEL, "CMEntityContainer", "cmEJBCreate", JeusMessage_EJB3._2732, new Object[]{pkey, bean, tx}, (Throwable)ex);
                }
                throw new ContainerException(JeusMessage_EJB3._2732, new String[]{pkey.toString(), bean.toString(), tx.toString()}, (Throwable)ex);
            }
            finally {
                this.closeConnection(con);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB3._2733_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2733_LEVEL, "CMEntityContainer", "cmEJBCreate", JeusMessage_EJB3._2733);
        }
        return pkey;
    }

    private Object getPrimaryKey(EntityBean bean) throws ContainerException {
        Object pkey;
        try {
            if (this.isPkeyField) {
                if (this.isAutoPK) {
                    if (this.ejbKeyGenerator.isGenKeyBeforeInsert()) {
                        pkey = this.ejbKeyGenerator.getNextKey();
                        this.cmPkeyFields[0].set(bean, pkey);
                    } else {
                        pkey = null;
                    }
                } else {
                    pkey = this.cmPkeyFields[0].get(bean);
                }
            } else {
                pkey = this.pkeyClass.newInstance();
                for (int i = 0; i < this.pkeyClassFields.length; ++i) {
                    this.pkeyClassFields[i].set(pkey, this.cmPkeyFields[i].get(bean));
                }
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2738, bean.toString(), ex);
        }
        return pkey;
    }

    private Connection getConnection(Transaction tx) throws ContainerException {
        Connection con;
        try {
            if (tx == null || tx == TMService.nullTransaction) {
                if (logger.isLoggable(JeusMessage_EJB3._2778_LEVEL)) {
                    logger.log(JeusMessage_EJB3._2778_LEVEL, JeusMessage_EJB3._2778);
                }
                con = this.pLayer.getConnection(false);
            } else {
                if (logger.isLoggable(JeusMessage_EJB3._2779_LEVEL)) {
                    logger.log(JeusMessage_EJB3._2779_LEVEL, JeusMessage_EJB3._2779, (Object)tx);
                }
                con = this.pLayer.getConnection(true);
            }
        }
        catch (Throwable e) {
            throw new ContainerException(JeusMessage_EJB3._2741, tx == null ? "null" : tx.toString(), e);
        }
        return con;
    }

    protected void cmEJBRemove(EntityBean bean, Transaction tx) throws ContainerException {
        Connection con = this.getConnection(tx);
        try {
            this.remover.remove(bean, con, tx);
        }
        catch (ContainerException e) {
            if (logger.isLoggable(JeusMessage_EJB3._2744_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2744_LEVEL, "CMEntityContainer", "cmEJBRemove", JeusMessage_EJB3._2744, (Object)bean, (Throwable)((Object)e));
            }
            throw e;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2745, bean.toString(), ex);
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cmEJBLoad(EntityBean bean, Transaction tx) throws ContainerException {
        Connection con = this.cmpVersion != 2 ? this.getConnection(tx) : null;
        try {
            this.loader.load(bean, con, 0);
        }
        finally {
            this.closeConnection(con);
        }
    }

    public void cmEJBPostLoad(EntityBean bean, int loaderIdx) {
        Connection con;
        try {
            con = this.getConnection(txManager.getTransaction());
        }
        catch (Throwable e) {
            throw new JeusRuntimeException(JeusMessage_EJB3._2750, e);
        }
        try {
            this.loader.postLoad(bean, con, loaderIdx);
        }
        catch (Throwable ex) {
            String beanString = bean.toString();
            if (logger.isLoggable(JeusMessage_EJB3._2751_LEVEL)) {
                logger.log(JeusMessage_EJB3._2751_LEVEL, JeusMessage_EJB3._2751, (Object)beanString, ex);
            }
            throw new JeusRuntimeException(JeusMessage_EJB3._2751, (Object)beanString, ex);
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cmEJBStore(EntityBean bean, Transaction tx) throws ContainerException {
        Connection con = this.getConnection(tx);
        try {
            this.storer.store(bean, con);
        }
        finally {
            this.closeConnection(con);
        }
    }

    protected void cmEJBActivate(EntityBean bean, Object pkey) throws ContainerException {
        try {
            if (this.isPkeyField) {
                this.cmPkeyFields[0].set(bean, pkey);
            } else {
                for (int i = 0; i < this.cmPkeyFields.length; ++i) {
                    this.cmPkeyFields[i].set(bean, this.pkeyClassFields[i].get(pkey));
                }
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2756, new String[]{bean.toString(), pkey.toString()}, ex);
        }
    }

    protected void setContextStatus(RemoteRequest request) {
        switch (request.methodType) {
            case 1: {
                request.ejbContext.setStatus(BeanState.POST_CONSTRUCT);
                break;
            }
            case 4: {
                request.ejbContext.setStatus(BeanState.PRE_DESTROY);
                break;
            }
            case 3: {
                request.ejbContext.setStatus(BeanState.EJB_HOME);
            }
        }
    }

    public Object cmEJBSelect(String methodName, Object[] args, boolean isIncludeUpdate) throws EJBException, FinderException {
        try {
            RemoteRequest request = new RemoteRequest();
            request.method = methodName;
            request.tx = txManager.getTransaction();
            if (request.tx == null) {
                request.tx = TMService.nullTransaction;
            } else if (isIncludeUpdate) {
                ((TransactionImpl)request.tx).flush();
            }
            Object obj = this.findEntities(request, args, false, false);
            return obj;
        }
        catch (FinderException e) {
            if (logger.isLoggable(JeusMessage_EJB3._2762_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2762_LEVEL, "CMEntityContainer", "cmEJBSelect", JeusMessage_EJB3._2762, (Object)methodName, (Throwable)e);
            }
            throw e;
        }
        catch (Exception t) {
            throw new EJBException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB3._2763, (Object)methodName), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(EJBObject ejbObject, Transaction tx) {
        try {
            this.beforeCompletion(ejbObject, tx, true);
        }
        finally {
            ((EJBEntityObjectImpl)ejbObject).setCommitting(false);
        }
    }

    public Collection findWithInstantQL(String ejbQL, boolean isLocal, boolean isLocalIntf) throws FinderException {
        if (this.dynFinder == null) {
            throw new FinderException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB3._2764));
        }
        return this.dynFinder.find(ejbQL, isLocal, isLocalIntf);
    }

    protected EJBObjectImpl getByPrimaryKeyInternal(RemoteRequest request, Object primaryKey) throws Exception {
        return (EJBObjectImpl)this.findEntities(request, new Object[]{primaryKey}, true, false);
    }

    protected void setContextToRequest(RemoteRequest request) {
        if (this.engineType != 3 && request.methodType != 2) {
            EntityContextImpl ejbCon = (EntityContextImpl)request.ejbObject.checkContext();
            request.ejbContext = ejbCon;
        }
    }
}

