/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityContext;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.security.jacc.EJBMethodPermission;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import jeus.descriptor.ejb.TransactionInfo;
import jeus.ejb.BeanState;
import jeus.ejb.EJBServerUtils;
import jeus.ejb.bean.RemoteRequest;
import jeus.ejb.bean.context.EJBContextImpl;
import jeus.ejb.bean.context.EntityContextImpl;
import jeus.ejb.bean.objectbase.EJBEntityMObjectImpl;
import jeus.ejb.bean.objectbase.EJBEntityObjectImpl;
import jeus.ejb.bean.objectbase.EJBObjectImpl;
import jeus.ejb.bean.objectbase.IIOPObject;
import jeus.ejb.container.ConcurrentAccessException;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.EJBSynchronizationImpl;
import jeus.ejb.container.EntityCache;
import jeus.ejb.container.EntitySessionManager;
import jeus.ejb.container.InstantRecycler;
import jeus.ejb.container.InstantRecyclerControlable;
import jeus.ejb.container.InterfaceContainer;
import jeus.ejb.container.SerEnumeration;
import jeus.ejb.container.TimerContainer;
import jeus.ejb.container.TimerState;
import jeus.ejb.ejbserver.containerinfo.EntityContainerInfo;
import jeus.ejb.metadata.EntityBeanInfo;
import jeus.management.j2ee.EJB;
import jeus.management.j2ee.EntityBean;
import jeus.management.j2ee.statistics.RangeStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.security.container.ejb.EJBSecurity;
import jeus.server.enginecontainer.InvocationManager;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.transaction.GTID;
import jeus.transaction.TMService;
import jeus.transaction.TransactionImpl;
import jeus.util.ErrorMsgManager;
import jeus.util.ExecutionContext;
import jeus.util.ExecutionContextStack;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.UserLogger;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB4;
import jeus.util.message.JeusMessage_EJB5;
import jeus.util.properties.JeusEJBProperties;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.EntityBeanPair;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;

public abstract class EntityContainer
extends InterfaceContainer {
    protected Class pkeyClass;
    protected int engineType;
    protected InstantRecycler ejbBeanPool;
    protected EntitySessionManager ejbObjects;
    protected InstantRecycler connectPool;
    protected EntityCache cache;
    protected long passivationTimeout;
    protected long disconnectTimeout;
    protected boolean isReentrant;
    protected int passivatedBeans;
    protected long numPassivation;
    protected long autoRemoved;
    protected int tmpPassivated;
    protected int tmpActiveBean;
    protected int numActiveBean;
    private boolean delayUpdateUntilTx = true;
    protected final Object npSync = new Object();
    protected final Object arSync = new Object();
    public static final int EXCLUSIVE_ACCESS = 1;
    public static final int SINGLE_OBJECT = 2;
    public static final int MULTIPLE_OBJECT = 3;
    private Method methodSetEntityContextObj;
    private Method methodUnsetEntityContextObj;
    private Method methodEjbLoadObj;
    private Method methodEjbStoreObj;
    private static final int ERR_CORBA = 9998;
    RangeStatisticImpl readyCountStat = new RangeStatisticImpl("ReadyCount", "bean", "the number of bean instances in the ready state");
    RangeStatisticImpl pooledCountStat = new RangeStatisticImpl("PooledCount", "bean", "the number of bean instances in the pooled state");

    public EntityContainer(EntityBeanInfo beanInfo, Map transactionInfo, ArchiveArrayClassLoader loader, String securityDomain) throws ContainerException {
        super(beanInfo, transactionInfo, loader, securityDomain);
    }

    public EJB createMBean(ObjectName parent) throws InstanceAlreadyExistsException {
        EJB mo = (EJB)EntityBean.createMBean(this.beanName, parent, this);
        this.setBeanModel(mo);
        return mo;
    }

    protected void initializePool(BeanPair deployD) throws ContainerException {
        this.ejbObjects = new EntitySessionManager(deployD.getCapacity());
        this.ejbBeanPool = new InstantRecycler(deployD.getEJBBeanPoolSize(), deployD.getEJBBeanPoolMax(), deployD.getEJBBeanResizingPeriod(), new BeanPoolController());
        this.connectPool = new InstantRecycler(deployD.getConnectPoolSize(), deployD.getConnectPoolMax(), deployD.getConnectPoolResizingPeriod(), new ObjectPoolController());
        int entityCacheSize = ((EntityBeanPair)deployD).getEntityCacheSize();
        if (this.engineType == 1 && entityCacheSize != 0) {
            if (logger.isLoggable(JeusMessage_EJB4._3203_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3203_LEVEL, "EntityContainer", "<init>", JeusMessage_EJB4._3203);
            }
            this.cache = new EntityCache(entityCacheSize, this.internalCreateEJBObject(), this.ejbBeanPool, this);
        }
        this.beforeExportHome();
    }

    protected abstract void makePersistentLayer() throws ContainerException;

    protected abstract void initializeDBInformation() throws ContainerException;

    protected final void loadPkeyClass() throws ContainerException {
        String pkClassName = ((EntityBeanPair)this.deployD).getPkeyClassName();
        try {
            this.pkeyClass = this.loader.loadClass(pkClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new ContainerException(JeusMessage_EJB4._3208, pkClassName, (Throwable)ex);
        }
    }

    protected void preStartService() throws ContainerException {
        super.preStartService();
        try {
            if (this.isUseAccessControl) {
                this.methodSetEntityContextObj = this.beanClass.getMethod("setEntityContext", EntityContext.class);
                this.methodUnsetEntityContextObj = this.beanClass.getMethod("unsetEntityContext", EJBServerUtils.null_classes);
                this.methodEjbLoadObj = this.beanClass.getMethod("ejbLoad", EJBServerUtils.null_classes);
                this.methodEjbStoreObj = this.beanClass.getMethod("ejbStore", EJBServerUtils.null_classes);
            }
            if (this.deployD.getPassivationTimeout() != null) {
                this.passivationTimeout = this.deployD.getPassivationTimeout() > 0L ? this.deployD.getPassivationTimeout() : -1L;
                if (logger.isLoggable(JeusMessage_EJB12._9016_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9016_LEVEL, JeusMessage_EJB12._9016, (Object)this.passivationTimeout);
                }
            } else if (JeusEJBProperties.EJB_ENTITY_PASSIVATE_TIMEOUT != null) {
                this.passivationTimeout = JeusEJBProperties.EJB_ENTITY_PASSIVATE_TIMEOUT;
                if (this.passivationTimeout <= 0L) {
                    this.passivationTimeout = -1L;
                }
                if (logger.isLoggable(JeusMessage_EJB12._9017_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9017_LEVEL, JeusMessage_EJB12._9017, (Object)this.disconnectTimeout);
                }
            } else if (JeusEJBProperties.EJB_PASSIVATE_TIMEOUT != null) {
                this.passivationTimeout = JeusEJBProperties.EJB_PASSIVATE_TIMEOUT;
                if (this.passivationTimeout <= 0L) {
                    this.passivationTimeout = -1L;
                }
                if (logger.isLoggable(JeusMessage_EJB12._9018_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9018_LEVEL, JeusMessage_EJB12._9018, (Object)this.passivationTimeout);
                }
            } else {
                this.passivationTimeout = 300000L;
                if (logger.isLoggable(JeusMessage_EJB12._9019_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9019_LEVEL, JeusMessage_EJB12._9019, (Object)this.passivationTimeout);
                }
            }
            if (this.deployD.getDisconnectTimeout() != null) {
                this.disconnectTimeout = this.deployD.getDisconnectTimeout() > 0L ? this.deployD.getDisconnectTimeout() : -1L;
                if (logger.isLoggable(JeusMessage_EJB12._9020_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9020_LEVEL, JeusMessage_EJB12._9020, (Object)this.disconnectTimeout);
                }
            } else if (JeusEJBProperties.EJB_ENTITY_DISCONNECT_TIMEOUT != null) {
                this.disconnectTimeout = JeusEJBProperties.EJB_ENTITY_DISCONNECT_TIMEOUT;
                if (this.disconnectTimeout <= 0L) {
                    this.disconnectTimeout = -1L;
                }
            } else if (JeusEJBProperties.EJB_DISCONNECT_TIMEOUT != null) {
                this.disconnectTimeout = JeusEJBProperties.EJB_DISCONNECT_TIMEOUT;
                if (this.disconnectTimeout <= 0L) {
                    this.disconnectTimeout = -1L;
                }
                if (logger.isLoggable(JeusMessage_EJB12._9021_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9021_LEVEL, JeusMessage_EJB12._9021, (Object)this.disconnectTimeout);
                }
            }
            this.isReentrant = ((EntityBeanPair)this.deployD).isReentrant();
            this.engineType = ((EntityBeanPair)this.deployD).getEngineType();
            this.delayUpdateUntilTx = ((EntityBeanPair)this.deployD).getDelayUpdateUntilTx();
            this.initializeDBInformation();
            this.initializeMetaData(this.pkeyClass, false, false);
            this.registerEnviroments();
            this.makePersistentLayer();
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB4._3204, ex);
        }
    }

    protected void startService() throws ContainerException {
        super.startService();
        this.initializePool(this.deployD);
        this.registerEJBHome();
        this.initDurableTimers(this.loader);
    }

    protected abstract void beforeExportHome() throws ContainerException;

    protected synchronized EJBEntityObjectImpl internalCreateEJBObject() throws ContainerException {
        EJBEntityObjectImpl ejbObj;
        try {
            ejbObj = (EJBEntityObjectImpl)this.ejbObjectImplClass.newInstance();
            ejbObj.setContainer(this);
            if (this.exportIIOP) {
                Constructor constructor = this.ejbObjectImplIIOPClass.getConstructor(this.ejbObjectImplClass);
                IIOPObject ejbObjectImplIIOPImpl = (IIOPObject)constructor.newInstance(ejbObj);
                ejbObj.setIIOPObjectImpl(ejbObjectImplIIOPImpl);
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB4._3212, ex);
        }
        return ejbObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized EntityContextImpl internalCreateEJBBean(javax.ejb.EntityBean ejbBean) throws ContainerException {
        EntityContextImpl ejbCon;
        try {
            if (ejbBean == null) {
                ejbBean = (javax.ejb.EntityBean)this.beanClass.newInstance();
            }
            ejbCon = new EntityContextImpl(this, (EnterpriseBean)ejbBean);
            ejbCon.setStatus(BeanState.DEP_INJECTION);
            GTID id = TMService.suspendCurrentTransaction();
            try {
                ExecutionContext.push(this.getContextMap());
                Object[] args = new Object[]{ejbCon};
                EJBSecurity.setEJBSecurityContext(this.securityPolicyID, ejbBean, args, null);
                if (this.isUseAccessControl) {
                    EJBSecurity.runEJBBusinessCode(ejbBean, this.methodSetEntityContextObj, args);
                } else {
                    ejbBean.setEntityContext((EntityContext)ejbCon);
                }
                ejbCon.setStatus(BeanState.READY);
                this.pooledCountStat.increase();
            }
            finally {
                EJBSecurity.clearEJBSecurityContext();
                TMService.resumeCurrentTransaction(id);
                ExecutionContext.pop();
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB4._3223, ex);
        }
        return ejbCon;
    }

    public EJBObjectImpl getEJBObjectInstance() throws RemoteException {
        EJBEntityObjectImpl ejbObj = this.getInitializedObject();
        EntityContextImpl ejbCon = this.connectObjectWithNewContext(ejbObj);
        this.afterGetEJBObjectImpl(ejbCon, ejbObj);
        return ejbObj;
    }

    private EJBEntityObjectImpl getInitializedObject() throws ContainerException {
        EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)this.connectPool.getObject();
        ejbObj.initialize();
        return ejbObj;
    }

    private EntityContextImpl connectObjectWithNewContext(EJBEntityObjectImpl ejbObj) throws ContainerException {
        EntityContextImpl ejbCon = (EntityContextImpl)this.ejbBeanPool.getObject();
        ejbCon.setIsModified(false);
        ejbCon.syncRequired = false;
        ejbCon.resetIsInvoking();
        ejbObj.setContext(ejbCon);
        ejbCon.setEJBObject(ejbObj);
        return ejbCon;
    }

    protected abstract void afterGetEJBObjectImpl(EntityContextImpl var1, EJBEntityObjectImpl var2);

    protected EJBEntityObjectImpl getEJBObjectWithPkey(Object pKey) throws RemoteException {
        EJBEntityObjectImpl ejbObj = this.getInitializedObject();
        ejbObj.setPrimaryKey(pKey);
        return ejbObj;
    }

    protected void internalRegisterEJBBean(RemoteRequest request, Object pKey) throws ContainerException {
        EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)request.ejbObject;
        ejbObj.setPrimaryKey(pKey);
        ejbObj.setCreatedInTx(true);
        Transaction currentTx = request.tx;
        if (currentTx != TMService.nullTransaction) {
            try {
                EJBSynchronizationImpl sync = new EJBSynchronizationImpl(this, request.ejbObject, currentTx);
                currentTx.registerSynchronization((Synchronization)sync);
            }
            catch (Throwable e) {
                throw new ContainerException(JeusMessage_EJB4._3232, e);
            }
        }
        request.ejbContext.setStatus(BeanState.ENTITY_POST_CREATE);
    }

    protected void undeploy() {
        if (logger.isLoggable(JeusMessage_EJB4._3235_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3235_LEVEL, "EntityContainer", "undeploy", JeusMessage_EJB4._3235);
        }
        try {
            super.undeploy();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB4._3236_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3236_LEVEL, "EntityContainer", "undeploy", JeusMessage_EJB4._3236);
        }
        try {
            if (this.beanClass != null) {
                this.ejbBeanPool.clear();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB4._3237_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3237_LEVEL, "EntityContainer", "undeploy", JeusMessage_EJB4._3237);
        }
        try {
            if (this.ejbObjects != null) {
                ArrayList list = this.ejbObjects.removeAll();
                for (int i = 0; i < list.size(); ++i) {
                    EJBObjectImpl ejbObject = (EJBObjectImpl)list.get(i);
                    ejbObject.unexport();
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB4._3238_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3238_LEVEL, "EntityContainer", "undeploy", JeusMessage_EJB4._3238);
        }
        try {
            if (this.connectPool != null) {
                this.connectPool.clear();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            if (this.cache != null) {
                if (logger.isLoggable(JeusMessage_EJB4._3239_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3239_LEVEL, "EntityContainer", "undeploy", JeusMessage_EJB4._3239);
                }
                this.cache.removeAll();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            this.undeployPerContainer();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB4._3240_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3240_LEVEL, "EntityContainer", "undeploy", JeusMessage_EJB4._3240);
        }
    }

    protected abstract void undeployPerContainer();

    protected void preTxFilter(RemoteRequest request) throws RemoteException {
        if (logger.isLoggable(JeusMessage_EJB4._3241_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3241_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3241);
        }
        try {
            Transaction callerTx;
            try {
                request.callerTx = callerTx = txManager.getTransaction();
            }
            catch (Throwable ex) {
                throw new ContainerException(JeusMessage_EJB4._3244, ex);
            }
            if (logger.isLoggable(JeusMessage_EJB4._3245_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3245_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3245, (Object)TransactionInfo.state[request.txAttr]);
            }
            switch (request.txAttr) {
                case 0: {
                    if (callerTx != null) {
                        if (logger.isLoggable(JeusMessage_EJB4._3246_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3246_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3246);
                        }
                        txManager.suspend();
                    } else if (logger.isLoggable(JeusMessage_EJB4._3247_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3247_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3247);
                    }
                    request.isIncludeUpdates = false;
                    break;
                }
                case 1: {
                    if (callerTx == null) {
                        if (logger.isLoggable(JeusMessage_EJB4._3248_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3248_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3248);
                        }
                        txManager.begin();
                        request.tx = txManager.getTransaction();
                        request.isIncludeUpdates = false;
                        break;
                    }
                    if (logger.isLoggable(JeusMessage_EJB4._3249_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3249_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3249);
                    }
                    request.tx = callerTx;
                    break;
                }
                case 2: {
                    if (callerTx != null) {
                        if (logger.isLoggable(JeusMessage_EJB4._3250_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3250_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3250);
                        }
                        request.tx = callerTx;
                        break;
                    }
                    if (logger.isLoggable(JeusMessage_EJB4._3251_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3251_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3251);
                    }
                    request.isIncludeUpdates = false;
                    break;
                }
                case 3: {
                    if (callerTx != null) {
                        if (logger.isLoggable(JeusMessage_EJB4._3252_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3252_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3252);
                        }
                        request.callerTx = txManager.suspend();
                    }
                    if (logger.isLoggable(JeusMessage_EJB4._3253_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3253_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3253);
                    }
                    txManager.begin();
                    request.tx = txManager.getTransaction();
                    request.isIncludeUpdates = false;
                    break;
                }
                case 4: {
                    if (callerTx == null) {
                        if (logger.isLoggable(JeusMessage_EJB4._3254_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3254_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3254);
                        }
                        throw new TransactionRequiredException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB4._3254));
                    }
                    if (logger.isLoggable(JeusMessage_EJB4._3255_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3255_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3255);
                    }
                    request.tx = callerTx;
                    break;
                }
                case 5: {
                    if (callerTx != null) {
                        if (logger.isLoggable(JeusMessage_EJB4._3256_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3256_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3256);
                        }
                        throw new ContainerException(JeusMessage_EJB4._3256);
                    }
                    request.isIncludeUpdates = false;
                    break;
                }
                default: {
                    throw new ContainerException(JeusMessage_EJB4._3257, TransactionInfo.state[request.txAttr]);
                }
            }
            if (request.tx == null) {
                request.tx = TMService.nullTransaction;
            }
        }
        catch (RemoteException ex) {
            if (logger.isLoggable(JeusMessage_EJB4._3258_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3258_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3258, (Throwable)ex);
            }
            throw ex;
        }
        catch (Throwable e) {
            throw new ContainerException(JeusMessage_EJB4._3259, e);
        }
        if (logger.isLoggable(JeusMessage_EJB4._3260_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3260_LEVEL, "EntityContainer", "preTxFilter", JeusMessage_EJB4._3260);
        }
    }

    protected abstract Object cmEJBCreate(javax.ejb.EntityBean var1, Transaction var2, Object var3) throws ContainerException, CreateException;

    protected abstract void cmEJBRemove(javax.ejb.EntityBean var1, Transaction var2) throws ContainerException;

    protected abstract void cmEJBLoad(javax.ejb.EntityBean var1, Transaction var2) throws ContainerException;

    public abstract void cmEJBPostLoad(javax.ejb.EntityBean var1, int var2);

    protected abstract void cmEJBStore(javax.ejb.EntityBean var1, Transaction var2) throws ContainerException;

    protected abstract void cmEJBActivate(javax.ejb.EntityBean var1, Object var2) throws ContainerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void preInvokeTx(RemoteRequest request, boolean newTxToBean, boolean loadRequired) throws RemoteException {
        boolean isContextPushed = false;
        EntityContextImpl ejbCon = null;
        try {
            block28: {
                EJBObjectImpl ejbObj;
                block29: {
                    block30: {
                        Transaction currentTx = request.tx;
                        if (newTxToBean && currentTx != TMService.nullTransaction) {
                            try {
                                EJBSynchronizationImpl sync = new EJBSynchronizationImpl(this, request.ejbObject, currentTx);
                                currentTx.registerSynchronization((Synchronization)sync);
                                if (logger.isLoggable(JeusMessage_EJB4._3267_LEVEL)) {
                                    logger.logp(JeusMessage_EJB4._3267_LEVEL, "EntityContainer", "preInvokeTx", JeusMessage_EJB4._3267);
                                }
                            }
                            catch (Throwable e) {
                                throw new ContainerException(JeusMessage_EJB4._3268);
                            }
                        }
                        ejbObj = request.ejbObject;
                        if (this.engineType == 3) break block29;
                        ejbCon = (EntityContextImpl)ejbObj.checkContext();
                        if (ejbCon == null) break block30;
                        if (this.engineType == 2 && loadRequired || ejbCon.syncRequired) {
                            if (logger.isLoggable(JeusMessage_EJB4._3269_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3269_LEVEL, "EntityContainer", "ejbLoad", JeusMessage_EJB4._3269);
                            }
                            this.cmEJBLoad((javax.ejb.EntityBean)ejbCon.ejbBean, request.tx);
                            isContextPushed = true;
                            EntityContainer.pushEJBContext(ejbCon);
                            try {
                                EnterpriseBean bean = ejbCon.ejbBean;
                                Object[] args = EJBServerUtils.null_objects;
                                EJBSecurity.setEJBSecurityContext(this.securityPolicyID, bean, args, null);
                                if (this.isUseAccessControl) {
                                    EJBSecurity.runEJBBusinessCode(bean, this.methodEjbLoadObj, args);
                                } else {
                                    ((javax.ejb.EntityBean)bean).ejbLoad();
                                }
                                if (logger.isLoggable(JeusMessage_EJB4._3271_LEVEL)) {
                                    logger.logp(JeusMessage_EJB4._3271_LEVEL, "EntityContainer", "ejbLoad", JeusMessage_EJB4._3271);
                                }
                            }
                            finally {
                                EJBSecurity.clearEJBSecurityContext();
                            }
                            ejbCon.syncRequired = false;
                        }
                        break block28;
                    }
                    ejbCon = (EntityContextImpl)ejbObj.getContext();
                    break block28;
                }
                ejbCon = (EntityContextImpl)request.ejbContext;
                isContextPushed = true;
                EntityContainer.pushEJBContext(request.ejbContext);
                if (loadRequired) {
                    if (logger.isLoggable(JeusMessage_EJB4._3272_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3272_LEVEL, "EntityContainer", "ejbLoad", JeusMessage_EJB4._3272);
                    }
                    this.callEjbActivate(ejbCon);
                    this.cmEJBActivate((javax.ejb.EntityBean)ejbCon.ejbBean, ejbObj.getPrimaryKey());
                    this.cmEJBLoad((javax.ejb.EntityBean)ejbCon.ejbBean, request.tx);
                    try {
                        EnterpriseBean bean = ejbCon.ejbBean;
                        Object[] args = EJBServerUtils.null_objects;
                        EJBSecurity.setEJBSecurityContext(this.securityPolicyID, bean, args, null);
                        if (this.isUseAccessControl) {
                            EJBSecurity.runEJBBusinessCode(bean, this.methodEjbLoadObj, args);
                        } else {
                            ((javax.ejb.EntityBean)bean).ejbLoad();
                        }
                        if (logger.isLoggable(JeusMessage_EJB4._3274_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3274_LEVEL, "EntityContainer", "ejbLoad", JeusMessage_EJB4._3274);
                        }
                    }
                    finally {
                        EJBSecurity.clearEJBSecurityContext();
                    }
                }
            }
            if (!ejbCon.isModified() && request.updating && request.methodType != 4) {
                ejbCon.setIsModified(true);
            }
            if (isContextPushed) return;
        }
        catch (RuntimeException ex) {
            try {
                if (!logger.isLoggable(JeusMessage_EJB4._3275_LEVEL)) throw ex;
                logger.logp(JeusMessage_EJB4._3275_LEVEL, "EntityContainer", "ejbLoad", JeusMessage_EJB4._3275, (Throwable)ex);
                throw ex;
                catch (RemoteException ex1) {
                    if (!logger.isLoggable(JeusMessage_EJB4._3276_LEVEL)) throw ex1;
                    logger.logp(JeusMessage_EJB4._3276_LEVEL, "EntityContainer", "ejbLoad", JeusMessage_EJB4._3276, (Throwable)ex1);
                    throw ex1;
                }
                catch (Throwable ex2) {
                    throw new ContainerException(JeusMessage_EJB4._3277, ex2);
                }
            }
            catch (Throwable throwable) {
                if (isContextPushed) throw throwable;
                EntityContainer.pushEJBContext(ejbCon);
                throw throwable;
            }
        }
        EntityContainer.pushEJBContext(ejbCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvoke(RemoteRequest request) throws RemoteException, ConcurrentAccessException {
        boolean newTxToBean = false;
        boolean loadRequired = false;
        boolean isContextPushed = false;
        this.startAccess();
        try {
            EJBObjectImpl.setInContainerMethod(this);
            EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)request.ejbObject;
            this.preTxFilter(request);
            Object object = ejbObj;
            synchronized (object) {
                if (ejbObj.isRemoved() || ejbObj.isUnexported()) {
                    if (logger.isLoggable(JeusMessage_EJB4._3281_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3281_LEVEL, "EntityContainer", "preInvoke", JeusMessage_EJB4._3281);
                    }
                    throw new NoSuchObjectException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB4._3281));
                }
                if (this.engineType != 3) {
                    if (ejbObj.isDiamondCase(request.tx)) {
                        if (this.isReentrantNotAvailable(request, ejbObj)) {
                            throw new ConcurrentAccessException(JeusMessage_EJB4._3283);
                        }
                    } else {
                        block29: {
                            if (ejbObj.isWaiting() || ejbObj.inTx()) {
                                try {
                                    ejbObj.waitLock();
                                    if (ejbObj.isRemoved()) {
                                        this.releaseSingleObject(ejbObj);
                                        throw new ContainerException(JeusMessage_EJB4._3284);
                                    }
                                }
                                catch (InterruptedException e) {
                                    if (!logger.isLoggable(JeusMessage_EJB4._3285_LEVEL)) break block29;
                                    logger.logp(JeusMessage_EJB4._3285_LEVEL, "EntityContainer", "preInvoke", JeusMessage_EJB4._3285);
                                }
                            }
                        }
                        ejbObj.setTransaction(request.tx);
                        newTxToBean = true;
                    }
                    ejbObj.setIsInvoking(true);
                } else {
                    EntityContextImpl ejbCon = ((EJBEntityMObjectImpl)ejbObj).checkContext(request.tx);
                    if (ejbObj.isDiamondCase(request.tx)) {
                        if (this.isReentrantNotAvailable(request, ejbObj)) {
                            throw new ContainerException(JeusMessage_EJB4._3286);
                        }
                    } else {
                        EntityContextImpl newContext = this.connectObjectWithNewContext(ejbObj);
                        ((EJBEntityMObjectImpl)ejbObj).setContextWithTx(request.tx);
                        if (ejbCon == EJBEntityMObjectImpl.passivatedContext) {
                            if (logger.isLoggable(JeusMessage_EJB4._3287_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3287_LEVEL, "EntityContainer", "preInvoke", JeusMessage_EJB4._3287);
                            }
                            loadRequired = true;
                        } else {
                            if (logger.isLoggable(JeusMessage_EJB4._3288_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3288_LEVEL, "EntityContainer", "preInvoke", JeusMessage_EJB4._3288);
                            }
                            newTxToBean = true;
                        }
                        this.afterGetEJBObjectImpl(newContext, ejbObj);
                        ejbCon = newContext;
                    }
                    request.ejbContext = ejbCon;
                    ejbCon.setIsInvoking(true);
                    ejbObj.setIsInvoking(true);
                }
            }
            object = this.statSync;
            synchronized (object) {
                this.requestCount.increase();
                ++this.numRequest;
            }
            if (newTxToBean) {
                loadRequired = true;
            }
            isContextPushed = true;
            this.preInvokeTx(request, newTxToBean, loadRequired);
            this.setContextToRequest(request);
            this.setContextStatus(request);
        }
        finally {
            EJBObjectImpl.clearInContainerMethod();
            if (!isContextPushed) {
                EntityContainer.pushEJBContext(request.ejbContext);
            }
            ExecutionContextStack.push(this.getContextMap());
            InvocationManager.preInvoke(false);
        }
    }

    protected abstract void setContextStatus(RemoteRequest var1);

    protected abstract boolean isReentrantNotAvailable(RemoteRequest var1, EJBEntityObjectImpl var2);

    protected void throwMappedException(Throwable t) throws SystemException {
        if (t instanceof NoSuchObjectException) {
            throw new OBJECT_NOT_EXIST(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (t instanceof AccessException) {
            throw new NO_PERMISSION(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (t instanceof MarshalException) {
            throw new MARSHAL(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (t instanceof TransactionRolledbackException) {
            throw new TRANSACTION_ROLLEDBACK(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (t instanceof TransactionRequiredException) {
            throw new TRANSACTION_REQUIRED(9998, CompletionStatus.COMPLETED_MAYBE);
        }
        if (t instanceof InvalidTransactionException) {
            throw new INVALID_TRANSACTION(9998, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    protected void restoreResources(RemoteRequest request, boolean hasID) {
        block10: {
            if (logger.isLoggable(JeusMessage_EJB4._3292_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3292_LEVEL, "EntityContainer", "restoreResources", JeusMessage_EJB4._3292, (Object)(hasID ? "" : "dummy "));
            }
            EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)request.ejbObject;
            try {
                EJBContextImpl ejbCon;
                if (hasID) {
                    ejbObj.setIsRemoved(true);
                }
                if ((ejbCon = this.engineType != 3 ? ejbObj.disconnectContext() : ((EJBEntityMObjectImpl)ejbObj).disconnectContext(request.tx)) != null) {
                    ejbCon.setEJBObject(null);
                    if (logger.isLoggable(JeusMessage_EJB4._3293_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3293_LEVEL, "EntityContainer", "restoreResources", JeusMessage_EJB4._3293);
                    }
                    this.ejbBeanPool.putObject(ejbCon);
                }
                if (!hasID) {
                    if (logger.isLoggable(JeusMessage_EJB4._3294_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3294_LEVEL, "EntityContainer", "restoreResources", JeusMessage_EJB4._3294);
                    }
                    ejbObj.unexport();
                    if (logger.isLoggable(JeusMessage_EJB4._3295_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3295_LEVEL, "EntityContainer", "restoreResources", JeusMessage_EJB4._3295);
                    }
                    this.connectPool.putObject(ejbObj);
                }
                if (logger.isLoggable(JeusMessage_EJB4._3296_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3296_LEVEL, "EntityContainer", "restoreResources", JeusMessage_EJB4._3296);
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB4._3297_LEVEL)) break block10;
                logger.logp(JeusMessage_EJB4._3297_LEVEL, "EntityContainer", "restoreResources", JeusMessage_EJB4._3297, (Object)(hasID ? "" : "dummy "), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEJBBean(RemoteRequest request) throws RemoveException, ContainerException {
        EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)request.ejbObject;
        if (logger.isLoggable(JeusMessage_EJB4._3298_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3298_LEVEL, "EntityContainer", "removeEJBBean", JeusMessage_EJB4._3298, (Object)ejbObj);
        }
        try {
            EJBObjectImpl.setInContainerMethod(this);
            Object[] args = EJBServerUtils.null_objects;
            EnterpriseBean bean = request.ejbContext.ejbBean;
            if (this.runAsSubject != null) {
                EJBSecurity.setEJBRunAsIdentity(this.runAsSubject);
            }
            if (this.isUseAccessControl) {
                EJBSecurity.runEJBBusinessCode(bean, this.removeMethod, args);
            } else {
                ((javax.ejb.EntityBean)bean).ejbRemove();
            }
            TimerContainer timerContainer = TimerContainer.currentTimerContainer();
            Object primaryKey = ejbObj.getPrimaryKey();
            if (logger.isLoggable(JeusMessage_EJB4._3301_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3301_LEVEL, "EntityContainer", "removeEJBBean", JeusMessage_EJB4._3301, primaryKey);
            }
            Enumeration timers = this.getTimerIds(primaryKey);
            while (timers.hasMoreElements()) {
                Long timerID = (Long)timers.nextElement();
                try {
                    timerContainer.cancelTimer(timerID);
                }
                catch (NoSuchObjectLocalException ex) {
                    if (!logger.isLoggable(JeusMessage_EJB4._3302_LEVEL)) continue;
                    logger.logp(JeusMessage_EJB4._3302_LEVEL, "EntityContainer", "removeEJBBean", JeusMessage_EJB4._3302, (Throwable)ex);
                }
            }
            this.cmEJBRemove((javax.ejb.EntityBean)bean, request.tx);
            Object object = this.statSync;
            synchronized (object) {
                this.readyCountStat.decrease();
                this.pooledCountStat.increase();
                this.removeCount.increase();
            }
            this.restoreResources(request, true);
            if (logger.isLoggable(JeusMessage_EJB4._3303_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3303_LEVEL, "EntityContainer", "removeEJBBean", JeusMessage_EJB4._3303);
            }
        }
        catch (EJBException e1) {
            if (logger.isLoggable(JeusMessage_EJB4._3304_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3304_LEVEL, "EntityContainer", "removeEJBBean", JeusMessage_EJB4._3304, (Throwable)e1);
            }
            throw e1;
        }
        catch (RemoveException e2) {
            if (logger.isLoggable(JeusMessage_EJB4._3305_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3305_LEVEL, "EntityContainer", "removeEJBBean", JeusMessage_EJB4._3305, (Throwable)e2);
            }
            throw e2;
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB4._3306, ex);
        }
        finally {
            if (this.runAsSubject != null) {
                try {
                    EJBSecurity.clearEJBRunAsIdentity();
                }
                catch (Exception e) {}
            }
            EJBObjectImpl.clearInContainerMethod();
        }
    }

    protected void disconnectEJBBean(EJBEntityObjectImpl ejbObj) throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB4._3307_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3307_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3307, (Object)ejbObj);
        }
        try {
            if (this.engineType != 3) {
                if (!ejbObj.isPassivated()) {
                    try {
                        if (logger.isLoggable(JeusMessage_EJB4._3308_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3308_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3308);
                        }
                        this.passivateEJB(ejbObj, ejbObj.getTransaction());
                        if (logger.isLoggable(JeusMessage_EJB4._3309_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3309_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3309);
                        }
                    }
                    catch (ContainerException ex) {
                        if (logger.isLoggable(JeusMessage_EJB4._3310_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3310_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3310, (Throwable)((Object)ex));
                        }
                    }
                }
            } else {
                this.passivateEJBs((EJBEntityMObjectImpl)ejbObj, System.currentTimeMillis(), true);
            }
            if (logger.isLoggable(JeusMessage_EJB4._3311_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3311_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3311);
            }
            this.ejbObjects.removeCurrent();
            ejbObj.setUnexported();
            ejbObj.unexport();
            if (this.engineType != 3) {
                this.callUnsetEntityContext(ejbObj.getContext());
            }
            this.passivatedBeanCount.decrease();
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB4._3312, ejbObj.toString(), ex);
        }
        if (logger.isLoggable(JeusMessage_EJB4._3313_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3313_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3313);
        }
    }

    private void callUnsetEntityContext(EJBContextImpl ejbCon) throws ContainerException {
        GTID id = TMService.suspendCurrentTransaction();
        try {
            ExecutionContext.push(this.getContextMap());
            Object[] args = EJBServerUtils.null_objects;
            EnterpriseBean bean = ejbCon.ejbBean;
            EJBSecurity.setEJBSecurityContext(this.securityPolicyID, bean, args, null);
            if (this.isUseAccessControl) {
                EJBSecurity.runEJBBusinessCode(bean, this.methodUnsetEntityContextObj, args);
            } else {
                ((javax.ejb.EntityBean)bean).unsetEntityContext();
            }
            this.pooledCountStat.decrease();
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB4._3317, ejbCon.toString(), ex);
        }
        finally {
            EJBSecurity.clearEJBSecurityContext();
            TMService.resumeCurrentTransaction(id);
            ExecutionContext.pop();
        }
    }

    public void removeWithPrimaryKey(Object pKey, RemoteRequest request, EJBMethodPermission perm, Object[] args) throws RemoteException, RemoveException {
        EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)this.ejbObjects.get(pKey, EJBEntityObjectImpl.getHashCode(pKey));
        if (ejbObj != null) {
            ejbObj = this.checkValidObjectImpl(ejbObj);
        }
        if (ejbObj == null) {
            ejbObj = this.getEJBObjectWithPkey(pKey);
        }
        ejbObj.innerRemove(request, args, perm, false);
    }

    protected void destroyInstance(EJBEntityObjectImpl ejbObj, Transaction tx) {
        block3: {
            try {
                EJBContextImpl ejbCon = this.engineType != 3 ? ejbObj.disconnectContext() : ((EJBEntityMObjectImpl)ejbObj).disconnectContext(tx);
                if (ejbCon != null) {
                    ejbCon.setEJBObject(null);
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_EJB4._3322_LEVEL)) break block3;
                logger.logp(JeusMessage_EJB4._3322_LEVEL, "EntityContainer", "destroyInstance", JeusMessage_EJB4._3322, t);
            }
        }
    }

    public Object getEJBObjectOfInternal(Object pKeys, boolean isLocalIntf, boolean isLocal) throws ContainerException {
        long currentTime = System.currentTimeMillis();
        try {
            EJBEntityObjectImpl ejbObj;
            if (pKeys instanceof Enumeration) {
                if (logger.isLoggable(JeusMessage_EJB4._3323_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3323_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3323);
                }
                Enumeration e = (Enumeration)pKeys;
                SerEnumeration ejbObjs = new SerEnumeration();
                while (e.hasMoreElements()) {
                    Object ejbObject;
                    EJBEntityObjectImpl ejbObj2;
                    Object pKey = e.nextElement();
                    if (logger.isLoggable(JeusMessage_EJB4._3324_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3324_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3324, pKey);
                    }
                    if ((ejbObj2 = (EJBEntityObjectImpl)this.ejbObjects.get(pKey, EJBEntityObjectImpl.getHashCode(pKey))) != null) {
                        if (logger.isLoggable(JeusMessage_EJB4._3325_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3325_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3325);
                        }
                        ejbObj2 = this.checkValidObjectImpl(ejbObj2);
                    } else if (logger.isLoggable(JeusMessage_EJB4._3326_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3326_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3326);
                    }
                    if (ejbObj2 == null) {
                        ejbObj2 = this.getEJBObjectWithPkey(pKey);
                        ejbObj2.setLastAccessTime(currentTime);
                        if (logger.isLoggable(JeusMessage_EJB4._3327_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3327_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3327);
                        }
                        ejbObj2 = this.ejbObjects.checkedAddElement(ejbObj2);
                    }
                    if (isLocalIntf) {
                        if (logger.isLoggable(JeusMessage_EJB4._3328_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3328_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3328);
                        }
                        ejbObject = ejbObj2.getEJBLocalObjectImpl();
                    } else if (isLocal) {
                        if (logger.isLoggable(JeusMessage_EJB4._3329_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3329_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3329);
                        }
                        ejbObject = ejbObj2;
                    } else if (this.exportIIOP && EntityContainer.isIIOP()) {
                        if (logger.isLoggable(JeusMessage_EJB4._3330_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3330_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3330);
                        }
                        ejbObject = ejbObj2.getIIOPStub();
                    } else {
                        if (logger.isLoggable(JeusMessage_EJB4._3331_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3331_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3331);
                        }
                        ejbObject = ejbObj2.getRMIStub();
                    }
                    ejbObjs.add(ejbObject);
                }
                return ejbObjs;
            }
            if (pKeys instanceof Collection) {
                if (logger.isLoggable(JeusMessage_EJB4._3332_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3332_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3332);
                }
                Collection c = (Collection)pKeys;
                Iterator it = c.iterator();
                ArrayList<Object> ejbObjs = new ArrayList<Object>();
                while (it.hasNext()) {
                    Object ejbObject;
                    EJBEntityObjectImpl ejbObj3;
                    Object pKey = it.next();
                    if (logger.isLoggable(JeusMessage_EJB4._3333_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3333_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3333, pKey);
                    }
                    if ((ejbObj3 = (EJBEntityObjectImpl)this.ejbObjects.get(pKey, EJBEntityObjectImpl.getHashCode(pKey))) != null) {
                        if (logger.isLoggable(JeusMessage_EJB4._3334_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3334_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3334);
                        }
                        ejbObj3 = this.checkValidObjectImpl(ejbObj3);
                    } else if (logger.isLoggable(JeusMessage_EJB4._3335_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3335_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3335);
                    }
                    if (ejbObj3 == null) {
                        ejbObj3 = this.getEJBObjectWithPkey(pKey);
                        ejbObj3.setLastAccessTime(currentTime);
                        if (logger.isLoggable(JeusMessage_EJB4._3336_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3336_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3336);
                        }
                        ejbObj3 = this.ejbObjects.checkedAddElement(ejbObj3);
                    }
                    if (isLocalIntf) {
                        if (logger.isLoggable(JeusMessage_EJB4._3337_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3337_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3337);
                        }
                        ejbObject = ejbObj3.getEJBLocalObjectImpl();
                    } else if (isLocal) {
                        if (logger.isLoggable(JeusMessage_EJB4._3338_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3338_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3338);
                        }
                        ejbObject = ejbObj3;
                    } else if (this.exportIIOP && EntityContainer.isIIOP()) {
                        if (logger.isLoggable(JeusMessage_EJB4._3339_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3339_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3339);
                        }
                        ejbObject = ejbObj3.getIIOPStub();
                    } else {
                        if (logger.isLoggable(JeusMessage_EJB4._3340_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3340_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3340);
                        }
                        ejbObject = ejbObj3.getRMIStub();
                    }
                    ejbObjs.add(ejbObject);
                }
                return ejbObjs;
            }
            if (logger.isLoggable(JeusMessage_EJB4._3341_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3341_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3341, pKeys);
            }
            if (logger.isLoggable(JeusMessage_EJB4._3342_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3342_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3342, pKeys);
            }
            if ((ejbObj = (EJBEntityObjectImpl)this.ejbObjects.get(pKeys, EJBEntityObjectImpl.getHashCode(pKeys))) != null) {
                if (logger.isLoggable(JeusMessage_EJB4._3343_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3343_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3343);
                }
                ejbObj = this.checkValidObjectImpl(ejbObj);
            } else if (logger.isLoggable(JeusMessage_EJB4._3344_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3344_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3344);
            }
            if (ejbObj == null) {
                ejbObj = this.getEJBObjectWithPkey(pKeys);
                ejbObj.setLastAccessTime(currentTime);
                if (logger.isLoggable(JeusMessage_EJB4._3345_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3345_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3345);
                }
                ejbObj = this.ejbObjects.checkedAddElement(ejbObj);
            }
            if (isLocalIntf) {
                if (logger.isLoggable(JeusMessage_EJB4._3346_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3346_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3346);
                }
                return ejbObj.getEJBLocalObjectImpl();
            }
            if (isLocal) {
                if (logger.isLoggable(JeusMessage_EJB4._3347_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3347_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3347);
                }
                return ejbObj;
            }
            if (this.exportIIOP && EntityContainer.isIIOP()) {
                if (logger.isLoggable(JeusMessage_EJB4._3348_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3348_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3348);
                }
                return ejbObj.getIIOPStub();
            }
            if (logger.isLoggable(JeusMessage_EJB4._3349_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3349_LEVEL, "EntityContainer", "getEJBObjectOfInternal", JeusMessage_EJB4._3349);
            }
            return ejbObj.getRMIStub();
        }
        catch (Throwable t) {
            throw new ContainerException(JeusMessage_EJB4._3350, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJBEntityObjectImpl checkValidObjectImpl(EJBEntityObjectImpl ejbObj) {
        EJBEntityObjectImpl eJBEntityObjectImpl = ejbObj;
        synchronized (eJBEntityObjectImpl) {
            if (ejbObj.isUnexported() || ejbObj.isRemoved()) {
                ejbObj = null;
            } else {
                ejbObj.setLastAccessTime(System.currentTimeMillis());
            }
        }
        return ejbObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBContextImpl connectContext(EJBObjectImpl ejbObject, Transaction tx) throws Throwable {
        if (logger.isLoggable(JeusMessage_EJB4._3354_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3354_LEVEL, "EntityContainer", "connectContext", JeusMessage_EJB4._3354, (Object)ejbObject);
        }
        try {
            EntityContextImpl ejbCon;
            EJBObjectImpl.setInContainerMethod(this);
            EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)ejbObject;
            if (this.cache != null) {
                Object primaryKey;
                if (logger.isLoggable(JeusMessage_EJB4._3355_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3355_LEVEL, "EntityContainer", "connectContext", JeusMessage_EJB4._3355);
                }
                if ((ejbCon = this.cache.remove(primaryKey = ejbObj.getPrimaryKey())) != null) {
                    ejbCon.setEJBObject(ejbObj);
                    if (logger.isLoggable(JeusMessage_EJB4._3356_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3356_LEVEL, "EntityContainer", "connectContext", JeusMessage_EJB4._3356);
                    }
                    EntityContextImpl entityContextImpl = ejbCon;
                    return entityContextImpl;
                }
            }
            try {
                ejbCon = this.prepareNewEjbContext(ejbObj);
                if (tx != null) {
                    this.loadBean(ejbCon, tx);
                }
            }
            finally {
                EntityContainer.popEJBContext();
            }
            EntityContextImpl entityContextImpl = ejbCon;
            return entityContextImpl;
        }
        catch (NoSuchEntityException e) {
            if (logger.isLoggable(JeusMessage_EJB4._3362_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3362_LEVEL, "EntityContainer", "connectContext", JeusMessage_EJB4._3362, (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            throw new ContainerException(JeusMessage_EJB4._3363, (Throwable)ex);
        }
        finally {
            EJBObjectImpl.clearInContainerMethod();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBean(EntityContextImpl ejbCon, Transaction transaction) throws Throwable {
        this.cmEJBLoad((javax.ejb.EntityBean)ejbCon.ejbBean, transaction);
        try {
            EnterpriseBean bean = ejbCon.ejbBean;
            Object[] args = EJBServerUtils.null_objects;
            EJBSecurity.setEJBSecurityContext(this.securityPolicyID, bean, args, null);
            if (this.isUseAccessControl) {
                EJBSecurity.runEJBBusinessCode(bean, this.methodEjbLoadObj, args);
            } else {
                ((javax.ejb.EntityBean)bean).ejbLoad();
            }
        }
        finally {
            EJBSecurity.clearEJBSecurityContext();
        }
    }

    private EntityContextImpl prepareNewEjbContext(EJBEntityObjectImpl ejbObj) throws Throwable {
        EntityContextImpl ejbCon = (EntityContextImpl)this.ejbBeanPool.getObject();
        if (logger.isLoggable(JeusMessage_EJB4._3358_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3358_LEVEL, "EntityContainer", "connectContext", JeusMessage_EJB4._3358);
        }
        EntityContainer.pushEJBContext(ejbCon);
        ejbCon.resetIsInvoking();
        ejbCon.setEJBObject(ejbObj);
        this.afterGetEJBObjectImpl(ejbCon, ejbObj);
        this.callEjbActivate(ejbCon);
        this.cmEJBActivate((javax.ejb.EntityBean)ejbCon.ejbBean, ejbObj.getPrimaryKey());
        return ejbCon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callEjbActivate(EntityContextImpl ejbCon) throws Throwable {
        GTID id = TMService.suspendCurrentTransaction();
        ejbCon.setStatus(BeanState.POST_ACTIVATE);
        try {
            Object[] args = EJBServerUtils.null_objects;
            EnterpriseBean bean = ejbCon.ejbBean;
            EJBSecurity.setEJBSecurityContext(this.securityPolicyID, bean, args, null);
            if (this.isUseAccessControl) {
                EJBSecurity.runEJBBusinessCode(bean, this.methodEjbActivateObj, args);
            } else {
                ((javax.ejb.EntityBean)bean).ejbActivate();
            }
            Object object = this.statSync;
            synchronized (object) {
                this.pooledCountStat.decrease();
                this.readyCountStat.increase();
                this.passivatedBeanCount.decrease();
            }
        }
        finally {
            EJBSecurity.clearEJBSecurityContext();
            ejbCon.setStatus(BeanState.READY);
            TMService.resumeCurrentTransaction(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivateEJB(EJBEntityObjectImpl ejbObj, Transaction tx) throws ContainerException {
        block20: {
            if (logger.isLoggable(JeusMessage_EJB4._3370_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3370_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3370, new Object[]{ejbObj, tx});
            }
            try {
                if (logger.isLoggable(JeusMessage_EJB4._3371_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3371_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3371);
                }
                EntityContextImpl ejbCon = this.engineType != 3 ? (EntityContextImpl)ejbObj.checkContext() : ((EJBEntityMObjectImpl)ejbObj).checkContext(tx);
                if (logger.isLoggable(JeusMessage_EJB4._3372_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3372_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3372);
                }
                if (this.cache != null) {
                    if (logger.isLoggable(JeusMessage_EJB4._3377_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3377_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3377);
                    }
                    try {
                        EJBObjectImpl.setInContainerMethod(this);
                        ejbCon = (EntityContextImpl)ejbObj.disconnectContext();
                        ejbCon.setEJBObject(null);
                        ejbCon.setPrimaryKey(ejbObj.getPrimaryKey());
                        if (logger.isLoggable(JeusMessage_EJB4._3378_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3378_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3378);
                        }
                        this.cache.addElement(ejbCon);
                    }
                    finally {
                        EJBObjectImpl.clearInContainerMethod();
                    }
                    if (logger.isLoggable(JeusMessage_EJB4._3379_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3379_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3379);
                    }
                    break block20;
                }
                this.callEjbPassivate(ejbCon);
                if (logger.isLoggable(JeusMessage_EJB4._3380_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3380_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3380);
                }
                ejbCon = this.engineType != 3 ? (EntityContextImpl)ejbObj.disconnectContext() : (EntityContextImpl)((EJBEntityMObjectImpl)ejbObj).passivateContext(tx);
                ejbCon.setEJBObject(null);
                if (logger.isLoggable(JeusMessage_EJB4._3381_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3381_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3381);
                }
                if (logger.isLoggable(JeusMessage_EJB4._3382_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3382_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3382);
                }
                this.ejbBeanPool.putObject(ejbCon);
            }
            catch (Throwable ex) {
                String ejbObjString = ejbObj == null ? "null" : ejbObj.toString();
                String txString = tx == null ? "null" : tx.toString();
                throw new ContainerException(JeusMessage_EJB4._3383, new String[]{ejbObjString, txString}, ex);
            }
        }
        Object object = this.npSync;
        synchronized (object) {
            ++this.numPassivation;
        }
        if (logger.isLoggable(JeusMessage_EJB4._3384_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3384_LEVEL, "EntityContainer", "passivateEJB", JeusMessage_EJB4._3384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callEjbPassivate(EJBContextImpl ejbCon) throws Throwable {
        javax.ejb.EntityBean ejbBean = (javax.ejb.EntityBean)ejbCon.ejbBean;
        ejbCon.setStatus(BeanState.PRE_PASSIVATE);
        try {
            EntityContainer.pushEJBContext(ejbCon);
            Object[] args = EJBServerUtils.null_objects;
            EJBSecurity.setEJBSecurityContext(this.securityPolicyID, ejbBean, args, null);
            if (this.isUseAccessControl) {
                EJBSecurity.runEJBBusinessCode(ejbBean, this.methodEjbPassivateObj, args);
            } else {
                ejbBean.ejbPassivate();
            }
            Object object = this.statSync;
            synchronized (object) {
                this.readyCountStat.decrease();
                this.pooledCountStat.increase();
                this.passivatedBeanCount.increase();
            }
        }
        finally {
            EJBSecurity.clearEJBSecurityContext();
            EntityContainer.popEJBContext();
            ejbCon.setStatus(BeanState.READY);
        }
    }

    protected void passivateEJBs(EJBEntityMObjectImpl ejbObj, long current_time, boolean isDisconnected) {
        if (logger.isLoggable(JeusMessage_EJB4._3391_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3391_LEVEL, "EntityContainer", "passivateEJBs", JeusMessage_EJB4._3391, (Object)ejbObj);
        }
        Transaction[] txs = new Transaction[ejbObj.contexts.size()];
        int idx = 0;
        Enumeration e = ejbObj.contexts.keys();
        while (e.hasMoreElements()) {
            Transaction tx = (Transaction)e.nextElement();
            EntityContextImpl ejbCon = (EntityContextImpl)ejbObj.contexts.get(tx);
            if (ejbCon != EJBEntityMObjectImpl.passivatedContext) {
                ++this.tmpActiveBean;
                if (!isDisconnected && (this.passivationTimeout == -1L || this.passivationTimeout >= current_time - ejbCon.getLastAccessTime() || ejbCon.isInvoking() || ejbCon.isCommitting() || tx != TMService.nullTransaction)) continue;
                txs[idx++] = tx;
                continue;
            }
            ++this.tmpPassivated;
        }
        if (logger.isLoggable(JeusMessage_EJB4._3392_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3392_LEVEL, "EntityContainer", "passivateEJBs", JeusMessage_EJB4._3392, (Object)String.valueOf(idx));
        }
        for (int i = 0; i < idx; ++i) {
            try {
                this.passivateEJB(ejbObj, txs[i]);
                continue;
            }
            catch (ContainerException ex) {
                if (!logger.isLoggable(JeusMessage_EJB4._3393_LEVEL)) continue;
                logger.logp(JeusMessage_EJB4._3393_LEVEL, "EntityContainer", "passivateEJBs", JeusMessage_EJB4._3393, (Object)ejbObj, (Throwable)((Object)ex));
            }
        }
        if (logger.isLoggable(JeusMessage_EJB4._3394_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3394_LEVEL, "EntityContainer", "passivateEJBs", JeusMessage_EJB4._3394, (Object)String.valueOf(idx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate(long timeStamp) throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB4._3395_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3395_LEVEL, "EntityContainer", "passivator", JeusMessage_EJB4._3395);
        }
        try {
            ExecutionContext.push(this.getContextMap());
            long current_time = System.currentTimeMillis();
            int numPassive = 0;
            if (this.engineType == 3) {
                this.tmpPassivated = 0;
                this.tmpActiveBean = 0;
            }
            EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)this.ejbObjects.getFirstElement();
            while (ejbObj != null) {
                block28: {
                    EJBEntityObjectImpl eJBEntityObjectImpl = ejbObj;
                    synchronized (eJBEntityObjectImpl) {
                        if (this.disconnectTimeout != -1L && this.disconnectTimeout < current_time - ejbObj.getLastAccessTime() && !ejbObj.isInvoking() && !ejbObj.inTx()) {
                            block27: {
                                if (logger.isLoggable(JeusMessage_EJB4._3396_LEVEL)) {
                                    logger.logp(JeusMessage_EJB4._3396_LEVEL, "EntityContainer", "passivator", JeusMessage_EJB4._3396, (Object)String.valueOf(this.disconnectTimeout));
                                }
                                try {
                                    this.disconnectEJBBean(ejbObj);
                                    Object object = this.arSync;
                                    synchronized (object) {
                                        ++this.autoRemoved;
                                        this.autoRemovedEJBObjectCount.increase();
                                    }
                                }
                                catch (ContainerException ex) {
                                    if (!logger.isLoggable(JeusMessage_EJB4._3397_LEVEL)) break block27;
                                    logger.logp(JeusMessage_EJB4._3397_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3397, (Throwable)((Object)ex));
                                }
                            }
                            break block28;
                        }
                        if (this.engineType != 3) {
                            if (!(this.passivationTimeout == -1L || this.passivationTimeout >= current_time - ejbObj.getLastAccessTime() || ejbObj.isInvoking() || ejbObj.isCommitting() || ejbObj.inTx() || ejbObj.isPassivated())) {
                                if (logger.isLoggable(JeusMessage_EJB4._3398_LEVEL)) {
                                    logger.logp(JeusMessage_EJB4._3398_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3398, (Object)String.valueOf(this.passivationTimeout));
                                }
                                ++numPassive;
                                try {
                                    this.passivateEJB(ejbObj, ejbObj.getTransaction());
                                }
                                catch (ContainerException ex) {
                                    if (logger.isLoggable(JeusMessage_EJB4._3399_LEVEL)) {
                                        logger.logp(JeusMessage_EJB4._3399_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3399, (Throwable)((Object)ex));
                                    }
                                }
                            }
                        } else {
                            this.passivateEJBs((EJBEntityMObjectImpl)ejbObj, current_time, false);
                        }
                    }
                }
                ejbObj = (EJBEntityObjectImpl)this.ejbObjects.getNext();
            }
            if (this.cache != null) {
                this.cache.rearrangeCache();
            }
            if (this.engineType != 3) {
                this.passivatedBeans = numPassive;
            } else {
                this.passivatedBeans = this.tmpPassivated;
                this.numActiveBean = this.tmpActiveBean;
            }
            this.ejbBeanPool.tryShrink();
            this.connectPool.tryShrink();
        }
        finally {
            ExecutionContext.pop();
        }
        if (logger.isLoggable(JeusMessage_EJB4._3400_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3400_LEVEL, "EntityContainer", "disconnectEJBBean", JeusMessage_EJB4._3400, (Object)this.beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContainerInfo(EntityContainerInfo conInfo) {
        super.getContainerInfo(conInfo);
        Object object = this.statSync;
        synchronized (object) {
            conInfo.setRequest(this.numRequest);
        }
        conInfo.setPassivatedEJBBean(this.passivatedBeans);
        if (this.engineType != 3) {
            conInfo.setPooledEJBBean(this.ejbObjects.size() + this.ejbBeanPool.available());
            int active = this.ejbObjects.size() - this.passivatedBeans;
            conInfo.setActiveEJBBean(active > 0 ? active : 0);
        } else {
            conInfo.setPooledEJBBean(this.numActiveBean + this.ejbBeanPool.available());
            conInfo.setActiveEJBBean(this.numActiveBean);
        }
        Object object2 = this.npSync;
        synchronized (object2) {
            conInfo.setPassivation(this.numPassivation);
        }
        object2 = this.arSync;
        synchronized (object2) {
            conInfo.setAutoRemoval(this.autoRemoved);
        }
        conInfo.setPooledConnect(this.ejbObjects.size() + this.connectPool.available());
        conInfo.setActiveConnect(this.ejbObjects.size());
        conInfo.setPooledThread(this.beanInfo.getThreadPoolMax());
        conInfo.setActiveThread(this.getActiveThreadNum());
    }

    public void beforeStatistic() {
        if (logger.isLoggable(JeusMessage_EJB4._3402_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3402_LEVEL, "EntityContainer", "beforeStatistic", JeusMessage_EJB4._3402);
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.engineType != 3) {
            this.totalEJBBeanCount.set((long)(this.ejbObjects.size() + this.ejbBeanPool.available()));
            long active = (long)this.ejbObjects.size() - this.passivatedBeanCount.getCurrent();
            this.activeEJBBeanCount.set(active > 0L ? active : 0L);
        } else {
            this.totalEJBBeanCount.set((long)(this.numActiveBean + this.ejbBeanPool.available()));
            this.activeEJBBeanCount.set((long)this.numActiveBean);
        }
        this.totalEJBObjectCount.set((long)(this.ejbObjects.size() + this.connectPool.available()));
        this.activeEJBObjectCount.set((long)this.ejbObjects.size());
        this.totalThreadCount.set((long)this.beanInfo.getThreadPoolMax());
        this.activeThreadCount.set((long)this.getActiveThreadNum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterCompletion(EJBObject ejbObject, Transaction tx, boolean committed) {
        EJBEntityObjectImpl ejbObj;
        if (logger.isLoggable(JeusMessage_EJB4._3406_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3406_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3406, new Object[]{ejbObject, tx});
        }
        if ((ejbObj = (EJBEntityObjectImpl)ejbObject).isCreateException()) {
            if (!logger.isLoggable(JeusMessage_EJB4._3407_LEVEL)) return;
            logger.logp(JeusMessage_EJB4._3407_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3407);
            return;
        }
        EntityContextImpl ejbCon = null;
        EJBEntityObjectImpl eJBEntityObjectImpl = ejbObj;
        synchronized (eJBEntityObjectImpl) {
            block56: {
                try {
                    block57: {
                        block59: {
                            if (this.engineType != 3) {
                                try {
                                    if (!committed) {
                                        if (logger.isLoggable(JeusMessage_EJB4._3408_LEVEL)) {
                                            logger.logp(JeusMessage_EJB4._3408_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3408);
                                        }
                                        if (ejbObj.isRemoved()) {
                                            if (logger.isLoggable(JeusMessage_EJB4._3409_LEVEL)) {
                                                logger.logp(JeusMessage_EJB4._3409_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3409);
                                            }
                                            ejbObj.setIsRemoved(false);
                                            break block56;
                                        }
                                        if (ejbObj.isCreatedInTx()) {
                                            if (logger.isLoggable(JeusMessage_EJB4._3410_LEVEL)) {
                                                logger.logp(JeusMessage_EJB4._3410_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3410);
                                            }
                                            if (logger.isLoggable(JeusMessage_EJB4._3411_LEVEL)) {
                                                logger.logp(JeusMessage_EJB4._3411_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3411);
                                            }
                                            if (this.ejbObjects != null) {
                                                this.ejbObjects.removeElement(ejbObj);
                                            }
                                            ejbObj.setIsRemoved(true);
                                            try {
                                                ejbObj.unexport();
                                            }
                                            catch (Throwable t) {
                                                if (!logger.isLoggable(JeusMessage_EJB4._3412_LEVEL)) return;
                                                logger.logp(JeusMessage_EJB4._3412_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3412, t);
                                            }
                                            break block56;
                                        } else {
                                            if (this.engineType != 1) return;
                                            if (ejbObj.isPassivated()) return;
                                            if (logger.isLoggable(JeusMessage_EJB4._3413_LEVEL)) {
                                                logger.logp(JeusMessage_EJB4._3413_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3413);
                                            }
                                            ejbCon = (EntityContextImpl)ejbObj.getContext();
                                            ejbCon.syncRequired = true;
                                            ejbCon.setIsModified(false);
                                        }
                                        break block56;
                                    }
                                    if (logger.isLoggable(JeusMessage_EJB4._3414_LEVEL)) {
                                        logger.logp(JeusMessage_EJB4._3414_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3414);
                                    }
                                    if (ejbObj.isCreatedInTx()) {
                                        if (logger.isLoggable(JeusMessage_EJB4._3415_LEVEL)) {
                                            logger.logp(JeusMessage_EJB4._3415_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3415);
                                        }
                                        ejbObj.setCreatedInTx(false);
                                    }
                                    if (!ejbObj.isRemoved()) return;
                                    if (ejbObj.isInvoking()) return;
                                    if (logger.isLoggable(JeusMessage_EJB4._3416_LEVEL)) {
                                        logger.logp(JeusMessage_EJB4._3416_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3416);
                                    }
                                    if (logger.isLoggable(JeusMessage_EJB4._3417_LEVEL)) {
                                        logger.logp(JeusMessage_EJB4._3417_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3417);
                                    }
                                    if (this.ejbObjects != null) {
                                        this.ejbObjects.removeElement(ejbObj);
                                    }
                                    ejbObj.unexport();
                                    break block56;
                                }
                                finally {
                                    this.releaseSingleObject(ejbObj);
                                }
                            }
                            if (committed) break block59;
                            if (logger.isLoggable(JeusMessage_EJB4._3418_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3418_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3418);
                            }
                            if (ejbObj.isRemoved()) {
                                if (logger.isLoggable(JeusMessage_EJB4._3419_LEVEL)) {
                                    logger.logp(JeusMessage_EJB4._3419_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3419);
                                }
                                ejbObj.setIsRemoved(false);
                                break block57;
                            } else if (ejbObj.isCreatedInTx()) {
                                if (logger.isLoggable(JeusMessage_EJB4._3420_LEVEL)) {
                                    logger.logp(JeusMessage_EJB4._3420_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3420);
                                }
                                if (logger.isLoggable(JeusMessage_EJB4._3421_LEVEL)) {
                                    logger.logp(JeusMessage_EJB4._3421_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3421);
                                }
                                if (this.ejbObjects != null) {
                                    this.ejbObjects.removeElement(ejbObj);
                                }
                                ejbObj.setIsRemoved(true);
                                try {
                                    ejbObj.unexport();
                                }
                                catch (Throwable t) {
                                    if (logger.isLoggable(JeusMessage_EJB4._3422_LEVEL)) {
                                        logger.logp(JeusMessage_EJB4._3422_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3422, t);
                                    }
                                    break block57;
                                }
                            }
                            break block57;
                        }
                        if (logger.isLoggable(JeusMessage_EJB4._3423_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3423_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3423);
                        }
                        if (ejbObj.isCreatedInTx()) {
                            if (logger.isLoggable(JeusMessage_EJB4._3424_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3424_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3424);
                            }
                            ejbObj.setCreatedInTx(false);
                        }
                        if (ejbObj.isRemoved() && !ejbObj.isInvoking() && ((EJBEntityMObjectImpl)ejbObj).numContexts() == 0) {
                            if (logger.isLoggable(JeusMessage_EJB4._3425_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3425_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3425);
                            }
                            if (logger.isLoggable(JeusMessage_EJB4._3426_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3426_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3426);
                            }
                            if (this.ejbObjects != null) {
                                this.ejbObjects.removeElement(ejbObj);
                            }
                            ejbObj.unexport();
                        }
                    }
                    ejbCon = (EntityContextImpl)((EJBEntityMObjectImpl)ejbObj).disconnectContext(tx);
                    if (ejbCon == null) return;
                    if (ejbCon == EJBEntityMObjectImpl.passivatedContext) return;
                    if (logger.isLoggable(JeusMessage_EJB4._3427_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3427_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3427);
                    }
                    ejbCon.setEJBObject(null);
                    if (!ejbObj.isRemoved()) {
                        try {
                            ExecutionContext.push(this.getContextMap());
                            TMService.associateNullTransaction();
                            this.callEjbPassivate(ejbCon);
                        }
                        finally {
                            ExecutionContext.pop();
                        }
                    }
                    if (logger.isLoggable(JeusMessage_EJB4._3428_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3428_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3428);
                    }
                    if (this.ejbBeanPool == null) return;
                    this.ejbBeanPool.putObject(ejbCon);
                }
                catch (Throwable ex) {
                    if (!logger.isLoggable(JeusMessage_EJB4._3429_LEVEL)) return;
                    logger.logp(JeusMessage_EJB4._3429_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3429, new Object[]{ejbObject, tx}, ex);
                }
                finally {
                    ejbObj.setCommitting(false);
                    if (ejbCon != null) {
                        ejbCon.setCommitting(false);
                    }
                    this.afterEJBTransaction(committed);
                }
            }
            return;
        }
    }

    private void releaseSingleObject(EJBEntityObjectImpl ejbObj) {
        if (logger.isLoggable(JeusMessage_EJB4._3430_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3430_LEVEL, "EntityContainer", "releaseSingleObject", JeusMessage_EJB4._3430);
        }
        ejbObj.setTransaction(null);
        ejbObj.notifyLock();
    }

    protected void postInvokeTx(RemoteRequest request) throws RemoteException {
        try {
            Throwable exception = request.exception;
            if (exception instanceof RuntimeException || exception instanceof RemoteException || exception instanceof Error) {
                if (request.tx == null) {
                    return;
                }
                if (request.tx == TMService.nullTransaction) {
                    this.processExceptionInNullTx(exception, request);
                } else if (request.tx.equals(request.callerTx)) {
                    this.processExceptionInClientTx(exception, request);
                } else {
                    this.processExceptionInNullTx(exception, request);
                }
            } else if (exception instanceof CreateException) {
                EJBEntityObjectImpl ejbObj = (EJBEntityObjectImpl)request.ejbObject;
                this.destroyInstance(ejbObj, request.tx);
                ejbObj.setCreateException();
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB4._3437_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3437_LEVEL, "EntityContainer", "postInvokeTx", JeusMessage_EJB4._3437, ex);
            }
            throw new ContainerException(JeusMessage_EJB4._3437, ex);
        }
    }

    protected abstract void processExceptionInClientTx(Throwable var1, RemoteRequest var2);

    protected abstract void processExceptionInNullTx(Throwable var1, RemoteRequest var2);

    /*
     * Unable to fully structure code
     */
    protected void postTxFilter(RemoteRequest request) throws RemoteException {
        block62: {
            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3438_LEVEL)) {
                EntityContainer.logger.logp(JeusMessage_EJB4._3438_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3438);
            }
            try {
                exception = request.exception;
                if (exception != null) {
                    if (request.tx == null) {
                        if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3439_LEVEL)) {
                            EntityContainer.logger.logp(JeusMessage_EJB4._3439_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3439);
                        }
                    } else if (request.tx == TMService.nullTransaction) {
                        if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3440_LEVEL)) {
                            EntityContainer.logger.logp(JeusMessage_EJB4._3440_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3440);
                        }
                        if (request.callerTx != null) {
                            TMService.associateTransactionContext(request.callerTx);
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3442_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3442_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3442);
                            }
                        }
                    } else if (request.tx.equals(request.callerTx)) {
                        if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3443_LEVEL)) {
                            EntityContainer.logger.logp(JeusMessage_EJB4._3443_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3443);
                        }
                        if (exception instanceof RuntimeException || exception instanceof RemoteException || exception instanceof Error) {
                            request.tx.setRollbackOnly();
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3445_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3445_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3445);
                            }
                        }
                    } else {
                        if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3446_LEVEL)) {
                            EntityContainer.logger.logp(JeusMessage_EJB4._3446_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3446);
                        }
                        if (exception instanceof RuntimeException || exception instanceof RemoteException || exception instanceof Error) {
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3447_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3447_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3447);
                            }
                            request.tx.rollback();
                        } else if (request.tx.getStatus() == 1) {
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3448_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3448_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3448);
                            }
                            request.tx.rollback();
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3449_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3449_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3449);
                            }
                        } else {
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3450_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3450_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3450);
                            }
                            request.tx.commit();
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3451_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3451_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3451);
                            }
                        }
                        if (request.callerTx != null) {
                            TMService.associateTransactionContext(request.callerTx);
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3453_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3453_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3453);
                            }
                        }
                    }
                    break block62;
                }
                if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3454_LEVEL)) {
                    EntityContainer.logger.logp(JeusMessage_EJB4._3454_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3454);
                }
                switch (request.txAttr) {
                    case 0: {
                        if (request.callerTx != null) {
                            TMService.associateTransactionContext(request.callerTx);
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3457_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3457_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3457);
                                ** break;
                            }
                        }
lbl59:
                        // 5 sources

                        break;
                    }
                    case 1: {
                        if (request.callerTx == null) {
                            if (request.tx.getStatus() == 1) {
                                request.tx.rollback();
                                if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3459_LEVEL)) {
                                    EntityContainer.logger.logp(JeusMessage_EJB4._3459_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3459);
                                    ** break;
                                }
lbl67:
                                // 3 sources

                            } else {
                                request.tx.commit();
                                if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3461_LEVEL)) {
                                    EntityContainer.logger.logp(JeusMessage_EJB4._3461_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3461);
                                    ** break;
                                }
                            }
                        }
lbl72:
                        // 5 sources

                        break;
                    }
                    case 2: {
                        ** break;
lbl75:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        if (request.tx.getStatus() == 1) {
                            request.tx.rollback();
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3463_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3463_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3463);
                            }
                        } else {
                            request.tx.commit();
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3465_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3465_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3465);
                            }
                        }
                        if (request.callerTx != null) {
                            TMService.associateTransactionContext(request.callerTx);
                            if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3467_LEVEL)) {
                                EntityContainer.logger.logp(JeusMessage_EJB4._3467_LEVEL, "EntityContainer", "postTxFilter", JeusMessage_EJB4._3467);
                                ** break;
                            }
                        }
lbl90:
                        // 5 sources

                        break;
                    }
                    case 4: {
                        ** break;
lbl93:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        ** break;
lbl96:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new ContainerException(JeusMessage_EJB4._3468, TransactionInfo.state[request.txAttr]);
                    }
                }
            }
            catch (Throwable ex) {
                throw new ContainerException(JeusMessage_EJB4._3469, ex);
            }
            finally {
                if (this.needCompletionForNullTransaction(request)) {
                    if (request.callerTx != null) {
                        TMService.associateNullTransaction();
                    }
                    try {
                        this.beforeCompletion(request.ejbObject, TMService.nullTransaction, false);
                    }
                    catch (Throwable throwable) {
                        throw new JeusRuntimeException(throwable);
                    }
                    this.afterCompletion(request.ejbObject, TMService.nullTransaction, true);
                    if (request.callerTx != null) {
                        TMService.associateTransactionContext(request.callerTx);
                    }
                }
            }
        }
        if (EntityContainer.logger.isLoggable(JeusMessage_EJB4._3470_LEVEL)) {
            EntityContainer.logger.logp(JeusMessage_EJB4._3470_LEVEL, "EntityContainer", "afterCompletion", JeusMessage_EJB4._3470);
        }
    }

    protected abstract boolean needCompletionForNullTransaction(RemoteRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(RemoteRequest request) {
        try {
            block48: {
                EJBEntityObjectImpl ejbObj;
                block47: {
                    if (logger.isLoggable(JeusMessage_EJB4._3471_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3471_LEVEL, "EntityContainer", "postInvoke", JeusMessage_EJB4._3471);
                    }
                    EntityContainer.popEJBContext();
                    ExecutionContextStack.pop();
                    InvocationManager.postInvoke();
                    ejbObj = (EJBEntityObjectImpl)request.ejbObject;
                    EJBContextImpl context = request.ejbContext;
                    if (request.methodType == 4 && context != null) {
                        context.setStatus(BeanState.NONE);
                    }
                    try {
                        try {
                            if (!this.delayUpdateUntilTx) {
                                this.flush(ejbObj, request.tx);
                            }
                        }
                        catch (Throwable e) {
                            request.exception = new ContainerException("Exception occurred during flushing to DB", e);
                        }
                        if (request.exception != null) {
                            if (logger.isLoggable(JeusMessage_EJB4._3474_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3474_LEVEL, "EntityContainer", "postInvoke", JeusMessage_EJB4._3474);
                            }
                            if (logger.isLoggable(JeusMessage_EJB5._3507_LEVEL)) {
                                logger.logp(JeusMessage_EJB5._3507_LEVEL, "EntityContainer", "postInvoke", JeusMessage_EJB5._3507, request.exception);
                            }
                            this.postInvokeTx(request);
                        }
                    }
                    catch (Throwable ex) {
                        if (logger.isLoggable(JeusMessage_EJB4._3475_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3475_LEVEL, "EntityContainer", "postInvoke", JeusMessage_EJB4._3475, ex);
                        }
                        if (request.exception != null) break block47;
                        request.exception = ex;
                    }
                }
                try {
                    EJBEntityObjectImpl ex;
                    if (request.exception != null) {
                        ex = ejbObj;
                        synchronized (ex) {
                            if (this.engineType != 3) {
                                ejbObj.setIsInvoking(false);
                            } else {
                                ((EntityContextImpl)request.ejbContext).setIsInvoking(false);
                                ejbObj.setIsInvoking(false);
                            }
                            break block48;
                        }
                    }
                    if (this.engineType != 3) {
                        if (!ejbObj.isRemoved()) {
                            ejbObj.setLastAccessTime(System.currentTimeMillis());
                        }
                        ex = ejbObj;
                        synchronized (ex) {
                            ejbObj.setIsInvoking(false);
                            break block48;
                        }
                    }
                    EntityContextImpl ejbCon = (EntityContextImpl)request.ejbContext;
                    if (!ejbObj.isRemoved()) {
                        long currentTime = System.currentTimeMillis();
                        ejbCon.setLastAccessTime(currentTime);
                        ejbObj.setLastAccessTime(currentTime);
                    }
                    EJBEntityObjectImpl eJBEntityObjectImpl = ejbObj;
                    synchronized (eJBEntityObjectImpl) {
                        ejbCon.setIsInvoking(false);
                        ejbObj.setIsInvoking(false);
                    }
                }
                catch (Throwable ex) {
                    if (logger.isLoggable(JeusMessage_EJB4._3477_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3477_LEVEL, "EntityContainer", "postInvoke", JeusMessage_EJB4._3477, ex);
                    }
                }
                finally {
                    block49: {
                        try {
                            this.postTxFilter(request);
                        }
                        catch (Throwable ex) {
                            if (logger.isLoggable(JeusMessage_EJB4._3478_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3478_LEVEL, "EntityContainer", "postInvoke", JeusMessage_EJB4._3478, ex);
                            }
                            if (request.exception != null) break block49;
                            request.exception = ex;
                        }
                    }
                }
            }
            if (this.engine.isUserLoggingOn() && request.exception != null) {
                try {
                    UserLogger.notifyEvent(this.engine.getName() + " " + this.ejbId, request.exception);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (this.exportIIOP && EntityContainer.isIIOP() && request.exception != null) {
                this.throwMappedException(request.exception);
            }
        }
        finally {
            this.endAccess();
        }
        if (logger.isLoggable(JeusMessage_EJB4._3481_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3481_LEVEL, "EntityContainer", "postInvoke", JeusMessage_EJB4._3481);
        }
    }

    protected abstract void initCMFields(RemoteRequest var1) throws Throwable;

    protected abstract void setTxToObject(RemoteRequest var1) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvokeHome(RemoteRequest request) throws Throwable {
        if (logger.isLoggable(JeusMessage_EJB4._3482_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3482_LEVEL, "EntityContainer", "preInvokeHome", JeusMessage_EJB4._3482);
        }
        this.startAccess();
        try {
            this.preTxFilter(request);
            this.setTxToObject(request);
            Object object = this.statSync;
            synchronized (object) {
                ++this.numRequest;
                this.requestCount.increase();
            }
            if (request.methodType == 4) {
                this.preInvokeTx(request, false, false);
            } else if (request.methodType == 1) {
                object = this.statSync;
                synchronized (object) {
                    this.readyCountStat.increase();
                    this.pooledCountStat.decrease();
                }
            }
            this.setContextToRequest(request);
            this.setContextStatus(request);
            this.initCMFields(request);
            if (request.isIncludeUpdates) {
                ((TransactionImpl)request.tx).flush();
            }
        }
        finally {
            EntityContainer.pushEJBContext(request.ejbContext);
            InvocationManager.preInvoke(false);
            ExecutionContextStack.push(this.getContextMap());
        }
        if (logger.isLoggable(JeusMessage_EJB4._3484_LEVEL)) {
            logger.logp(JeusMessage_EJB4._3484_LEVEL, "EntityContainer", "preInvokeHome", JeusMessage_EJB4._3484);
        }
    }

    protected abstract void setContextToRequest(RemoteRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvokeHome(RemoteRequest request) throws RemoteException {
        block31: {
            try {
                EJBEntityObjectImpl ejbObj;
                block28: {
                    if (logger.isLoggable(JeusMessage_EJB4._3485_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3485_LEVEL, "EntityContainer", "postInvokeHome", JeusMessage_EJB4._3485);
                    }
                    EntityContainer.popEJBContext();
                    ExecutionContextStack.pop();
                    InvocationManager.postInvoke();
                    ejbObj = (EJBEntityObjectImpl)request.ejbObject;
                    try {
                        this.postInvokeTx(request);
                    }
                    catch (Throwable ex) {
                        if (logger.isLoggable(JeusMessage_EJB4._3486_LEVEL)) {
                            logger.logp(JeusMessage_EJB4._3486_LEVEL, "EntityContainer", "postInvokeHome", JeusMessage_EJB4._3486, ex);
                        }
                        if (request.exception != null) break block28;
                        request.exception = ex;
                    }
                }
                try {
                    if (this.handleObjectAfterInvokeHome(request, ejbObj)) {
                        return;
                    }
                }
                catch (Throwable ex) {
                    if (logger.isLoggable(JeusMessage_EJB4._3487_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3487_LEVEL, "EntityContainer", "postInvokeHome", JeusMessage_EJB4._3487, ex);
                    }
                }
                finally {
                    block30: {
                        try {
                            this.postTxFilter(request);
                        }
                        catch (Throwable ex) {
                            if (logger.isLoggable(JeusMessage_EJB4._3488_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3488_LEVEL, "EntityContainer", "postInvokeHome", JeusMessage_EJB4._3488, ex);
                            }
                            if (request.exception != null) break block30;
                            request.exception = ex;
                        }
                    }
                }
                if (request.exception == null) break block31;
                if (this.engine.isUserLoggingOn()) {
                    try {
                        UserLogger.notifyEvent(this.engine.getName() + " " + this.ejbId, request.exception);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.exportIIOP && EntityContainer.isIIOP()) {
                    this.throwMappedException(request.exception);
                }
            }
            finally {
                this.endAccess();
            }
        }
    }

    protected abstract boolean handleObjectAfterInvokeHome(RemoteRequest var1, EJBEntityObjectImpl var2);

    protected abstract boolean needToStoreForBeforeCompletion(EntityContextImpl var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion(EJBObject ejbObject, Transaction tx, boolean throwException) {
        block25: {
            EJBEntityObjectImpl ejbObj;
            if (logger.isLoggable(JeusMessage_EJB4._3491_LEVEL)) {
                logger.logp(JeusMessage_EJB4._3491_LEVEL, "EntityContainer", "beforeCompletion", JeusMessage_EJB4._3491);
            }
            if ((ejbObj = (EJBEntityObjectImpl)ejbObject).isCreateException()) {
                if (logger.isLoggable(JeusMessage_EJB4._3492_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3492_LEVEL, "EntityContainer", "beforeCompletion", JeusMessage_EJB4._3492);
                }
                return;
            }
            try {
                EntityContextImpl ejbCon = this.engineType != 3 ? (EntityContextImpl)ejbObj.checkContext() : ((EJBEntityMObjectImpl)ejbObj).checkContext(tx);
                EJBEntityObjectImpl eJBEntityObjectImpl = ejbObj;
                synchronized (eJBEntityObjectImpl) {
                    ejbObj.setCommitting(true);
                    if (ejbCon != null) {
                        ejbCon.setCommitting(true);
                    }
                }
                if (ejbCon == null || ejbCon == EJBEntityMObjectImpl.passivatedContext) {
                    if (logger.isLoggable(JeusMessage_EJB4._3493_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3493_LEVEL, "EntityContainer", "beforeCompletion", JeusMessage_EJB4._3493);
                    }
                    return;
                }
                if (!this.needToStoreForBeforeCompletion(ejbCon)) break block25;
                try {
                    ExecutionContext.push(this.getContextMap());
                    EntityContainer.pushEJBContext(ejbCon);
                    Object[] args = EJBServerUtils.null_objects;
                    EnterpriseBean ejbBean = ejbCon.ejbBean;
                    EJBSecurity.setEJBSecurityContext(this.securityPolicyID, ejbBean, args, null);
                    if (this.isUseAccessControl) {
                        EJBSecurity.runEJBBusinessCode(ejbBean, this.methodEjbStoreObj, args);
                    } else {
                        ((javax.ejb.EntityBean)ejbBean).ejbStore();
                    }
                    if (logger.isLoggable(JeusMessage_EJB4._3495_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3495_LEVEL, "EntityContainer", "beforeCompletion", JeusMessage_EJB4._3495);
                    }
                    this.cmEJBStore((javax.ejb.EntityBean)ejbCon.ejbBean, tx);
                    ejbCon.setIsModified(false);
                }
                catch (Throwable t) {
                    if (logger.isLoggable(JeusMessage_EJB4._3496_LEVEL)) {
                        logger.logp(JeusMessage_EJB4._3496_LEVEL, "EntityContainer", "beforeCompletion", JeusMessage_EJB4._3496);
                    }
                    this.destroyInstance((EJBEntityObjectImpl)ejbObject, tx);
                    try {
                        if (tx != TMService.nullTransaction) {
                            if (logger.isLoggable(JeusMessage_EJB4._3497_LEVEL)) {
                                logger.logp(JeusMessage_EJB4._3497_LEVEL, "EntityContainer", "beforeCompletion", JeusMessage_EJB4._3497);
                            }
                            tx.setRollbackOnly();
                        }
                    }
                    catch (Throwable t1) {
                        // empty catch block
                    }
                    throw t;
                }
                finally {
                    EJBSecurity.clearEJBSecurityContext();
                    EntityContainer.popEJBContext();
                    ExecutionContext.pop();
                }
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_EJB4._3498_LEVEL)) {
                    logger.logp(JeusMessage_EJB4._3498_LEVEL, "EntityContainer", "beforeCompletion", JeusMessage_EJB4._3498, ex);
                }
                if (!throwException) break block25;
                throw new RuntimeException(ex);
            }
        }
    }

    protected void initInvokeTimer(RemoteRequest request, TimerState timerState) throws Throwable {
        Object primaryKey = timerState.getPrimaryKey();
        if (timerLogger.isLoggable(JeusMessage_EJB4._3499_LEVEL)) {
            timerLogger.logp(JeusMessage_EJB4._3499_LEVEL, "EntityContainer", "initInvokeTimer", JeusMessage_EJB4._3499, primaryKey);
        }
        if (primaryKey != null) {
            request.ejbObject = (EJBObjectImpl)this.getEJBObjectOfInternal(primaryKey, false, true);
            if (request.ejbObject == null) {
                EJBContextImpl ejbContext;
                request.ejbObject = this.getByPrimaryKeyInternal(request, primaryKey);
                request.ejbContext = ejbContext = this.connectContext(request.ejbObject, txManager.getTransaction());
            }
        }
        if (request.ejbObject == null) {
            throw new JeusRuntimeException(JeusMessage_EJB5._3501, (Object)primaryKey.toString());
        }
    }

    protected abstract EJBObjectImpl getByPrimaryKeyInternal(RemoteRequest var1, Object var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeoutMethodInvoke(RemoteRequest request, Object[] args) throws Throwable {
        EJBContextImpl context = this.engineType == 3 ? request.ejbContext : request.ejbObject.getContext();
        try {
            context.setStatus(BeanState.TIMEOUT);
            if (this.runAsSubject != null) {
                EJBSecurity.setEJBRunAsIdentity(this.runAsSubject);
            }
            if (this.isUseAccessControl) {
                EJBSecurity.runEJBBusinessCode(context.ejbBean, this.ejbTimeoutMethod, args);
            } else {
                this.ejbTimeoutMethod.invoke((Object)context.ejbBean, args);
            }
            if (timerLogger.isLoggable(JeusMessage_EJB5._3504_LEVEL)) {
                timerLogger.logp(JeusMessage_EJB5._3504_LEVEL, "EntityContainer", "timeoutMethodInvoke", JeusMessage_EJB5._3504);
            }
        }
        finally {
            if (this.runAsSubject != null) {
                EJBSecurity.clearEJBRunAsIdentity();
            }
            context.setStatus(BeanState.READY);
        }
    }

    public void setBeanModel(EJB mo) {
        super.setBeanModel(mo);
        mo.setStatistic((StatisticImpl)this.readyCountStat);
        mo.setStatistic((StatisticImpl)this.pooledCountStat);
        mo.setStatistic((StatisticImpl)this.passivatedBeanCount);
        mo.setStatistic((StatisticImpl)this.autoRemovedEJBObjectCount);
        mo.setStatistic((StatisticImpl)this.totalEJBBeanCount);
        mo.setStatistic((StatisticImpl)this.activeEJBBeanCount);
        mo.setStatistic((StatisticImpl)this.totalEJBObjectCount);
        mo.setStatistic((StatisticImpl)this.activeEJBObjectCount);
        mo.setStatistic((StatisticImpl)this.totalThreadCount);
        mo.setStatistic((StatisticImpl)this.activeThreadCount);
    }

    private class ObjectPoolController
    implements InstantRecyclerControlable {
        private ObjectPoolController() {
        }

        public Object createPoolElement() throws ContainerException {
            return EntityContainer.this.internalCreateEJBObject();
        }

        public void handleIncomingObjectAtCleared(Object obj) throws ContainerException {
        }

        public Object beforeShrink() {
            return null;
        }

        public void afterShrink(Object shrinkState) {
        }

        public void beforeRemove(Object ejbCon) {
        }

        public Exception throwException(Throwable ex) {
            return null;
        }
    }

    private class BeanPoolController
    implements InstantRecyclerControlable {
        private BeanPoolController() {
        }

        public Object createPoolElement() throws ContainerException {
            return EntityContainer.this.internalCreateEJBBean(null);
        }

        public void handleIncomingObjectAtCleared(Object obj) throws RemoteException {
            EntityContainer.this.callUnsetEntityContext((EntityContextImpl)obj);
        }

        public Object beforeShrink() {
            return TMService.suspendCurrentTransaction();
        }

        public void afterShrink(Object shrinkState) {
            TMService.resumeCurrentTransaction((GTID)shrinkState);
        }

        public void beforeRemove(Object ejbCon) throws Throwable {
            EntityContainer.this.callUnsetEntityContext((EntityContextImpl)ejbCon);
        }

        public Exception throwException(Throwable ex) {
            return new JeusException(JeusMessage_EJB5._3506, ex);
        }
    }
}

