/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.rmi.RemoteException;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.InstantRecyclerControlable;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB5;

public class InstantRecycler {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.container.cache");
    private Object[] objects;
    private InstantRecyclerControlable container;
    private int available;
    private int size;
    private int min;
    private int max;
    private boolean cleared;
    private Object shrinkState;
    private long resizingPeriod;
    private long lastResizingTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstantRecycler(int min, int max, long resizingPeriod, InstantRecyclerControlable con) throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB5._3801_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3801_LEVEL, "InstantRecycler", "<init>", JeusMessage_EJB5._3801, new Object[]{String.valueOf(min), String.valueOf(max)});
        }
        this.cleared = false;
        this.objects = new Object[max];
        this.max = max;
        this.available = 0;
        this.container = con;
        this.resizingPeriod = resizingPeriod;
        this.min = min;
        try {
            for (int i = 0; i < min; ++i) {
                this.objects[this.available] = con.createPoolElement();
                ++this.available;
            }
        }
        finally {
            this.size = this.available;
        }
        if (logger.isLoggable(JeusMessage_EJB5._3802_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3802_LEVEL, "InstantRecycler", "<init>", JeusMessage_EJB5._3802);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(Object obj) throws RemoteException {
        if (logger.isLoggable(JeusMessage_EJB5._3803_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3803_LEVEL, "InstantRecycler", "putObject", JeusMessage_EJB5._3803, obj);
        }
        InstantRecycler instantRecycler = this;
        synchronized (instantRecycler) {
            if (this.cleared || this.available >= this.max) {
                --this.size;
            } else {
                this.objects[this.available] = obj;
                ++this.available;
                return;
            }
        }
        this.container.handleIncomingObjectAtCleared(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putObjectAtInit(Object obj) {
        if (logger.isLoggable(JeusMessage_EJB5._3804_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3804_LEVEL, "InstantRecycler", "putObjectAtInit", JeusMessage_EJB5._3804, obj);
        }
        InstantRecycler instantRecycler = this;
        synchronized (instantRecycler) {
            this.objects[this.available] = obj;
            ++this.available;
            ++this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws ContainerException {
        if (logger.isLoggable(JeusMessage_EJB5._3805_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3805_LEVEL, "InstantRecycler", "getObject", JeusMessage_EJB5._3805);
        }
        InstantRecycler instantRecycler = this;
        synchronized (instantRecycler) {
            this.checkCleared();
            if (this.available > 0) {
                --this.available;
                Object result = this.objects[this.available];
                this.objects[this.available] = null;
                return result;
            }
            ++this.size;
        }
        return this.container.createPoolElement();
    }

    private void checkCleared() throws ContainerException {
        if (this.cleared) {
            if (logger.isLoggable(JeusMessage_EJB5._3806_LEVEL)) {
                logger.logp(JeusMessage_EJB5._3806_LEVEL, "InstantRecycler", "checkCleared", JeusMessage_EJB5._3806);
            }
            throw new ContainerException(JeusMessage_EJB5._3806);
        }
    }

    public int size() {
        return this.size;
    }

    public int available() {
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryShrink() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastResizingTime < this.resizingPeriod) {
            return;
        }
        this.lastResizingTime = currentTime;
        Object shrinkStatus = this.container.beforeShrink();
        try {
            InstantRecycler instantRecycler = this;
            synchronized (instantRecycler) {
                while (this.available > this.min) {
                    try {
                        this.removeOneElement();
                    }
                    catch (Throwable e) {
                        this.container.throwException(e);
                    }
                }
            }
        }
        finally {
            this.container.afterShrink(shrinkStatus);
        }
    }

    private void removeOneElement() throws Throwable {
        if (logger.isLoggable(JeusMessage_EJB5._3807_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3807_LEVEL, "InstantRecycler", "removeOneElement", JeusMessage_EJB5._3807);
        }
        --this.available;
        --this.size;
        Object ejbCon = this.objects[this.available];
        this.objects[this.available] = null;
        this.container.beforeRemove(ejbCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (logger.isLoggable(JeusMessage_EJB5._3808_LEVEL)) {
            logger.logp(JeusMessage_EJB5._3808_LEVEL, "InstantRecycler", "clear", JeusMessage_EJB5._3808);
        }
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            this.shrinkState = this.container.beforeShrink();
            try {
                this.cleared = true;
                while (this.available > 0) {
                    try {
                        this.removeOneElement();
                    }
                    catch (Throwable ex) {
                        this.container.throwException(ex);
                    }
                }
            }
            finally {
                this.container.afterShrink(this.shrinkState);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

