/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import jeus.ejb.EJBServerUtils;
import jeus.ejb.bean.objectbase.EJBHomeImpl;
import jeus.ejb.bean.objectbase.EJBLocalHomeImpl;
import jeus.ejb.bean.objectbase.IIOPHome;
import jeus.ejb.container.Container;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container.OTSPolicyImpl;
import jeus.ejb.container.RMIExporter;
import jeus.ejb.container3.ConfigurationException;
import jeus.ejb.container3.SessionEntityContainer;
import jeus.ejb.ejbserver.EJBORBManager;
import jeus.ejb.interop.csi.EJBCSIPolicyImpl;
import jeus.ejb.metadata.EntityBeanInfo;
import jeus.jndi.jns.local.JNSLocal;
import jeus.security.base.Subject;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB3;
import jeus.xml.binding.jeusDD.SecurityInteropType;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POA;

public abstract class InterfaceContainer
extends Container {
    public InterfaceContainer(EntityBeanInfo dd, Map transactionInfo, ArchiveArrayClassLoader loader, String securityDomain) throws ContainerException {
        super(dd, transactionInfo, loader, securityDomain);
        try {
            String jndiName;
            this.clusterDesc = this.deployD.getClusterDesc();
            boolean bl = this.isClustered = this.clusterDesc != null && this.clusterDesc.isEnableClustering() != false;
            assert (this.beanInfo != null);
            if (this.beanInfo.hasRemoteView()) {
                jndiName = EJBServerUtils.getRemoteViewJndiName(this.beanInfo);
                if (jndiName == null) {
                    throw new ConfigurationException("Could not determine the remote JNDI export name (export name is required) for " + this.beanInfo.getBeanName());
                }
                this.exportName = jndiName;
                this.exportPort = this.deployD.getExportPort();
                this.exportIIOP = this.deployD.getExportIIOP();
                this.isLocalInvocationOptimized = this.deployD.isLocalInvocationOptimized();
                this.isHttpInvocation = this.deployD.isInvocationWithHttp();
                if (this.isHttpInvocation) {
                    this.httpContext = this.deployD.getHttpURL();
                    this.httpPort = this.deployD.getHttpPort();
                }
                this.rmiExporter = new RMIExporter(this);
                this.rmiExporter.setUseJeusRmi(this.deployD.useJeusRmi());
            }
            if (this.beanInfo.hasLocalView()) {
                jndiName = EJBServerUtils.getLocalViewJndiName(this.beanInfo);
                if (jndiName == null) {
                    throw new ConfigurationException("Could not determine the local JNDI export name (export name is required) for " + this.beanInfo.getBeanName());
                }
                this.localExportName = jndiName;
            }
            this.singleVMOnly = this.deployD.isSingleVMOnly();
            if (this.exportIIOP) {
                String poaName = this.moduleName + "_" + this.beanName;
                ArrayList<OTSPolicyImpl> policyList = new ArrayList<OTSPolicyImpl>();
                SecurityInteropType ejbcsiDescriptor = this.deployD.getEJBCSIDescriptor();
                if (ejbcsiDescriptor != null) {
                    InterfaceContainer.setSecurityPolicy(ejbcsiDescriptor, poaName, policyList, this.runAsSubject);
                }
                policyList.add(new OTSPolicyImpl());
                this.initPOA(poaName, policyList.toArray(new Policy[0]));
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB3._2852, ex);
        }
    }

    public static void setSecurityPolicy(SecurityInteropType ejbcsiDescriptor, String poaName, ArrayList policyList, Subject runAsSubject) throws ContainerException {
        if (!EJBORBManager.isEnableInterop()) {
            if (logger.isLoggable(JeusMessage_EJB3._2851_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2851_LEVEL, "Container", "<init>", JeusMessage_EJB3._2851);
            }
            throw new ContainerException(JeusMessage_EJB3._2851);
        }
        EJBORBManager.addEJBCSIDescriptor(poaName, ejbcsiDescriptor);
        policyList.add(new EJBCSIPolicyImpl(poaName));
        SessionEntityContainer.checkZeroPortPolicy(ejbcsiDescriptor, policyList);
    }

    private void initPOA(String poaName, Policy[] tpolicy) throws Exception {
        if (logger.isLoggable(JeusMessage_EJB3._2853_LEVEL)) {
            logger.logp(JeusMessage_EJB3._2853_LEVEL, "Container", "initPOA", JeusMessage_EJB3._2853);
        }
        POA rootPOA = EJBORBManager.getRootPOA();
        this.ejbPOA = rootPOA.create_POA(poaName, null, tpolicy);
        ((POA)this.ejbPOA).the_POAManager().activate();
    }

    protected void preStartService() throws ContainerException {
        super.preStartService();
        this.initEJBBeanInfo(this.transactionInfo);
        this.initEJBObjectInfo();
        this.initEJBHomeInfo();
    }

    protected final void initEJBHomeInfo() throws ContainerException {
        String ejbHomeImplClassName = this.deployD.getEJBHomeImplClassName();
        Class<?> ejbHomeImplIIOPClass = null;
        if (ejbHomeImplClassName != null) {
            try {
                this.ejbHomeImplClass = this.loader.loadClass(this.deployD.getEJBHomeImplClassName());
                if (this.exportIIOP) {
                    ejbHomeImplIIOPClass = this.loader.loadClass(this.deployD.getIIOPEJBHomeImplClassName());
                }
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2874, (Throwable)ex);
            }
            String ejbHomeClassName = this.deployD.getEJBHomeClassName();
            if (ejbHomeClassName != null) {
                try {
                    this.ejbHomeClass = this.loader.loadClass(ejbHomeClassName);
                }
                catch (ClassNotFoundException ex) {
                    throw new ContainerException(JeusMessage_EJB3._2877, (Throwable)ex);
                }
                try {
                    this.ejbHomeImpl = (EJBHomeImpl)this.ejbHomeImplClass.newInstance();
                    this.ejbHomeImpl.setContainer(this);
                    if (this.deployD.getExportIiopType() == null || !this.deployD.getExportIiopType().isOnlyIiop().booleanValue()) {
                        this.ejbHomeImpl.export();
                        if (this.isHttpInvocation) {
                            if (logger.isLoggable(JeusMessage_EJB3._2881_LEVEL)) {
                                logger.logp(JeusMessage_EJB3._2881_LEVEL, "Container", "initEJBHomeInfo", JeusMessage_EJB3._2881);
                            }
                        } else if (logger.isLoggable(JeusMessage_EJB3._2883_LEVEL)) {
                            logger.logp(JeusMessage_EJB3._2883_LEVEL, "Container", "initEJBHomeInfo", JeusMessage_EJB3._2883);
                        }
                    }
                    if (this.exportIIOP) {
                        Constructor<?> constructor = ejbHomeImplIIOPClass.getConstructor(this.ejbHomeImplClass);
                        IIOPHome ejbHomeImplIIOPImpl = (IIOPHome)constructor.newInstance(this.ejbHomeImpl);
                        ejbHomeImplIIOPImpl.export();
                        this.ejbHomeImpl.setIIOPHomeImpl(ejbHomeImplIIOPImpl);
                        if (logger.isLoggable(JeusMessage_EJB11._7187_LEVEL)) {
                            logger.logp(JeusMessage_EJB11._7187_LEVEL, "Container", "initEJBHomeInfo", JeusMessage_EJB11._7187);
                        }
                    }
                }
                catch (Exception e) {
                    throw new ContainerException(JeusMessage_EJB3._2884, (Throwable)e);
                }
            }
        }
        if (this.deployD.getEJBHomeClassName() != null && this.isLocalInvocationOptimized || this.deployD.getEJBLocalHomeClassName() != null) {
            if (this.deployD.getEJBLocalHomeClassName() == null) {
                if (logger.isLoggable(JeusMessage_EJB3._2885_LEVEL)) {
                    logger.logp(JeusMessage_EJB3._2885_LEVEL, "Container", "initEJBHomeInfo", JeusMessage_EJB3._2885);
                }
            } else if (logger.isLoggable(JeusMessage_EJB3._2886_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2886_LEVEL, "Container", "initEJBHomeInfo", JeusMessage_EJB3._2886);
            }
            try {
                this.ejbLocalizedHomeImpl = (EJBHomeImpl)this.ejbHomeImplClass.newInstance();
                this.ejbLocalizedHomeImpl.setContainer(this);
                this.ejbLocalizedHomeImpl.setRemoteEJBHome(this.ejbHomeImpl);
            }
            catch (Exception e) {
                throw new ContainerException(JeusMessage_EJB3._2887, (Throwable)e);
            }
            if (logger.isLoggable(JeusMessage_EJB3._2888_LEVEL)) {
                logger.logp(JeusMessage_EJB3._2888_LEVEL, "Container", "initEJBHomeInfo", JeusMessage_EJB3._2888);
            }
        }
        String localHomeClassName = this.deployD.getEJBLocalHomeClassName();
        String localHomeImplClassName = this.deployD.getEJBLocalHomeImplClassName();
        if (localHomeClassName != null) {
            try {
                this.ejbLocalHomeImplClass = this.loader.loadClass(localHomeImplClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2891, (Throwable)ex);
            }
            try {
                this.ejbLocalHomeClass = this.loader.loadClass(this.deployD.getEJBLocalHomeClassName());
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2894, (Throwable)ex);
            }
            try {
                this.ejbLocalHomeImpl = (EJBLocalHomeImpl)this.ejbLocalHomeImplClass.newInstance();
                this.ejbLocalizedHomeImpl.setEJBLocalHomeImpl(this.ejbLocalHomeImpl);
                this.ejbLocalHomeImpl.setDelegate(this.ejbLocalizedHomeImpl);
                this.ejbLocalHomeImpl._setContainer(this);
            }
            catch (Exception e) {
                throw new ContainerException(JeusMessage_EJB3._2897, (Throwable)e);
            }
        }
    }

    public String getExportURL() throws UnknownHostException {
        return JNSLocal.getClusterInfo();
    }

    protected final void initEJBObjectInfo() throws ContainerException {
        String ejbObjectImplClassName = this.deployD.getEJBObjectImplClassName();
        try {
            if (this.deployD.getEJBHomeClassName() != null || this.deployD.getEJBLocalHomeClassName() != null) {
                this.ejbObjectImplClass = this.loader.loadClass(ejbObjectImplClassName);
                if (this.exportIIOP) {
                    this.ejbObjectImplIIOPClass = this.loader.loadClass(this.deployD.getIIOPEJBObjectImplClassName());
                }
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ContainerException(JeusMessage_EJB3._2906, (Throwable)ex);
        }
        if (this.deployD.getEJBHomeClassName() != null) {
            String ejbObjectClassName = this.deployD.getEJBObjectClassName();
            try {
                this.ejbObjectClass = this.loader.loadClass(ejbObjectClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2909, (Throwable)ex);
            }
        }
        if (this.deployD.getEJBLocalHomeClassName() != null) {
            String ejbLocalObjectImplClassName = this.deployD.getEJBLocalObjectImplClassName();
            try {
                this.ejbLocalObjectImplClass = this.loader.loadClass(ejbLocalObjectImplClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2912, (Throwable)ex);
            }
            String ejbLocalObjectClassName = this.deployD.getEJBLocalObjectClassName();
            try {
                this.ejbLocalObjectClass = this.loader.loadClass(ejbLocalObjectClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ContainerException(JeusMessage_EJB3._2915, (Throwable)ex);
            }
        }
    }

    public String getEJBObjectName() {
        return this.ejbObjectClass.getName();
    }
}

