/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.util.Date;
import javax.transaction.Synchronization;
import jeus.ejb.container.TimerContainer;
import jeus.ejb.container.TimerState;
import jeus.transaction.TxStatus;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB10;

public class TimerSynch
implements Synchronization {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.timer");
    public static final int CREATE = 0;
    public static final int CANCEL = 1;
    private Long timerId;
    private int state;
    private Date timeout;
    private static final String[] stateString = new String[]{"CREATE", "CANCEL"};

    public TimerSynch(Long timerId, int state, Date timeout) {
        if (logger.isLoggable(JeusMessage_EJB10._6552_LEVEL)) {
            logger.log(JeusMessage_EJB10._6552_LEVEL, JeusMessage_EJB10._6552, new Object[]{stateString[state], timerId});
        }
        this.timerId = timerId;
        this.state = state;
        this.timeout = timeout;
    }

    public void afterCompletion(int status) {
        if (logger.isLoggable(JeusMessage_EJB10._6551_LEVEL)) {
            logger.log(JeusMessage_EJB10._6551_LEVEL, JeusMessage_EJB10._6551, new Object[]{stateString[this.state], this.timerId, TxStatus.getState(status)});
        }
        TimerContainer timerContainer = TimerContainer.currentTimerContainer();
        switch (this.state) {
            case 0: {
                TimerState timerState = timerContainer.getTimerState(this.timerId);
                if (timerState == null) break;
                if (status == 3) {
                    timerContainer.setCommitted(this.timerId);
                    timerContainer.scheduleTask(this.timerId, this.timeout);
                    break;
                }
                timerContainer.expungeTimer(this.timerId);
                break;
            }
            case 1: {
                if (status == 4) {
                    timerContainer.setCommitted(this.timerId);
                    if (this.timeout == null) break;
                    timerContainer.scheduleTask(this.timerId, this.timeout);
                    break;
                }
                timerContainer.expungeTimer(this.timerId);
            }
        }
    }

    public void beforeCompletion() {
    }
}

