/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import jeus.ejb.EJBLoggers;
import jeus.ejb.util.LeftTime;
import jeus.util.logging.JeusLogger;

public class TransactionAssociationManager {
    private static final JeusLogger logger = EJBLoggers.getLogger("jeus.ejb.container");
    private final Set<Transaction> transactions = new HashSet<Transaction>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition emptyCondition = this.lock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateTransaction(Transaction tx) {
        block9: {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "try to associate tx {0} with tx association manager", (Object)tx);
            }
            this.lock.lock();
            try {
                if (this.transactions.contains(tx)) break block9;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "try to register new tx {0} with tx association manager", (Object)tx);
                }
                try {
                    tx.registerSynchronization((Synchronization)new Dissociator(tx));
                    this.transactions.add(tx);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "registered dissociator for tx {0} ", (Object)tx);
                    }
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Exception occurred when registering dissociator synchornization for tx " + tx, (Throwable)e);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dissociateTransaction(Transaction tx) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "try to dissociate tx {0} with tx association manager", (Object)tx);
        }
        this.lock.lock();
        try {
            this.transactions.remove(tx);
            if (this.transactions.size() == 0) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "There is no on-going tx. Notify shutdown threads for this to be empty.", (Object)tx);
                }
                this.emptyCondition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitUntilEmpty(long timeoutMillis) throws InterruptedException {
        LeftTime leftTime;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "TransactionAssociationManager - checking if associated tx are empty");
        }
        if (!this.lock.tryLock((leftTime = new LeftTime(timeoutMillis)).leftTime(), TimeUnit.MILLISECONDS)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "TransactionAssociationManager#waitUntilEmpty - locking timed out for");
            }
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "TransactionAssociationManager#waitUntilEmpty - locked");
        }
        try {
            if (this.transactions.size() == 0) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "TransactionAssociationManager#waitUntilEmpty - there is no associated tx");
                }
                boolean bl = true;
                return bl;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "TransactionAssociationManager#waitUntilEmpty - waiting for in-progress tx to complete");
            }
            leftTime.check();
            if (!this.emptyCondition.await(leftTime.leftTime(), TimeUnit.MILLISECONDS)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "TransactionAssociationManager#waitUntilEmpty - condition wait timed out");
                }
                boolean bl = false;
                return bl;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "TransactionAssociationManager#waitUntilEmpty - condition waiting finished");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class Dissociator
    implements Synchronization {
        private Transaction tx;

        Dissociator(Transaction tx) {
            this.tx = tx;
        }

        public void afterCompletion(int status) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "tx dissociator#afterCompletion for tx {0}", (Object)this.tx);
            }
            TransactionAssociationManager.this.dissociateTransaction(this.tx);
        }

        public void beforeCompletion() {
        }
    }
}

