/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.util.Hashtable;
import javax.naming.InitialContext;
import jeus.container.namingenv.DuplicateEntryException;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.InjectionException;
import jeus.container.namingenv.JndiEnvironmentMappingGroup;
import jeus.container.namingenv.NamingEnvManager;
import jeus.container.namingenv.NamingEnvironment;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container3.BaseBeanContainer;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.InterceptorInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.management.j2ee.EJBModule;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB3;
import jeus.webservices.api.EWSProvider;
import jeus.xml.binding.jeusDD.JeusBeanType;

public class EJBEnvironment {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb");
    protected BaseBeanContainer container;
    protected BeanInfo beanInfo;
    protected NamingEnvManager namingEnvManager;
    private String envRoot;
    private boolean isEnvRootUsed;
    private ClassLoader loader;

    public EJBEnvironment(BaseBeanContainer container, String envRoot) throws EJBDeploymentException {
        this.container = container;
        this.beanInfo = container.getBeanInfo();
        this.envRoot = envRoot;
        this.loader = container.getClassLoader();
    }

    public void init() throws EJBDeploymentException {
        this.namingEnvManager = new NamingEnvManager();
        this.namingEnvManager.setEnvRoot(this.envRoot);
        try {
            NamingEnvironment namingEnv = this.beanInfo.getBeanNamingEnvironment();
            InterceptorInfo[] interceptors = this.container.getUserInterceptorManager().getInterceptorInfos();
            if (interceptors != null) {
                for (int i = 0; i < interceptors.length; ++i) {
                    NamingEnvironment env = interceptors[i].getNamingEnvironment();
                    if (env == null) continue;
                    namingEnv.mergeWith(env);
                }
            }
            this.namingEnvManager.setNamingEnvironment(namingEnv);
        }
        catch (DuplicateEntryException ex) {
            throw new EJBDeploymentException(ex.getMessage(), ex);
        }
    }

    public void registerEntries() throws ContainerException {
        ModuleInfo moduleInfo = this.beanInfo.getModuleInfo();
        EJBModule thisModule = moduleInfo.getModule();
        try {
            boolean isJaxWsServiceRef;
            JeusBeanType jeusBean = this.beanInfo.getJeusBeanType();
            JndiEnvironmentMappingGroup mapping = new JndiEnvironmentMappingGroup();
            mapping.setSimpleEnvMapping(jeusBean.getEnv());
            mapping.setEjbRefMapping(jeusBean.getEjbRef());
            mapping.setResRefMapping(jeusBean.getResRef());
            mapping.setResEnvMapping(jeusBean.getResEnvRef());
            mapping.setMessageDistinationMapping(jeusBean.getMessageDestinationRef());
            boolean bl = isJaxWsServiceRef = moduleInfo.getEjbVersion() > 2.1;
            if (isJaxWsServiceRef) {
                mapping.setServiceRefMapping(jeusBean.getServiceRef());
            }
            EnvironmentContext envContext = new EnvironmentContext(thisModule, mapping);
            envContext.setContextData("BeanInfo", this.beanInfo);
            this.namingEnvManager.bindAllEntries(envContext);
            if (!isJaxWsServiceRef) {
                Hashtable<String, String> envs = new Hashtable<String, String>();
                envs.put("jeus.jndi.jns.localbindings", "true");
                envs.put("jeus.jndi.jns.forcedbindings", "true");
                InitialContext ctx = new InitialContext(envs);
                EWSProvider provider = EWSProvider.getProvider();
                if (provider != null && provider.bindServiceRefs(ctx, this.envRoot, this.beanInfo.getServiceRefPairs(), this.loader)) {
                    this.isEnvRootUsed = true;
                    this.container.setIsWebserviceConsumer(true);
                }
                ctx.close();
            }
        }
        catch (Throwable ex) {
            String err = "Registering environments and resources Failed:EJB=" + this.beanInfo.getBeanName();
            throw new ContainerException(err, ex);
        }
    }

    public void resolveInjections(EJBContextImpl ejbContext) throws InjectionException {
        Class beanClass = this.beanInfo.getBeanClass();
        Object bean = ejbContext.getBean();
        this.namingEnvManager.resolveInjections(beanClass, bean);
        Object[] interceptors = ejbContext.getInterceptorInstances();
        if (interceptors != null) {
            for (Object interceptor : interceptors) {
                this.namingEnvManager.resolveInjections(interceptor.getClass(), interceptor);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB12._9023_LEVEL)) {
            logger.log(JeusMessage_EJB12._9023_LEVEL, JeusMessage_EJB12._9023, (Object)beanClass.getName());
        }
    }

    public void unregisterEntries() {
        block2: {
            try {
                this.namingEnvManager.unbindAllEntries();
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB3._2966_LEVEL)) break block2;
                logger.logp(JeusMessage_EJB3._2966_LEVEL, "Container", "unregisterEnvironments", JeusMessage_EJB3._2966, ex);
            }
        }
    }

    NamingEnvManager getNamingEnvManager() {
        return this.namingEnvManager;
    }
}

