/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import jeus.ejb.BeanState;
import jeus.ejb.baseimpl.EJBSessionIfObject;
import jeus.ejb.baseimpl.SessionContextImpl;
import jeus.ejb.container3.ExceptionMapper;
import jeus.ejb.container3.SessionContainer;
import jeus.ejb.container3.StatefulSessionContainer;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.Invocation;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.server.enginecontainer.InvocationManager;

public class SessionInterceptor
implements Interceptor {
    protected SessionContainer container;
    protected SessionBeanInfo beanInfo;
    protected boolean isStateful;

    public SessionInterceptor(SessionContainer container) {
        this.container = container;
        this.beanInfo = (SessionBeanInfo)container.getBeanInfo();
        this.isStateful = container.isStateful();
    }

    public String getName() {
        return "Business method interceptor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Exception {
        Object result = null;
        SessionContextImpl context = null;
        Method method = invocation.getMethod();
        try {
            boolean isContextPushed;
            block24: {
                Object caller = invocation.getCaller();
                if (caller instanceof EJBSessionIfObject) {
                    context = this.container.getSessionContext((EJBSessionIfObject)caller);
                    if (this.beanInfo.isStateful() && this.beanInfo.isRemoveMethod(method)) {
                        invocation.isRemoveMethod = true;
                    }
                } else {
                    context = this.container.getSessionContext(null);
                    context.setStatus(BeanState.WEBENDPOINT);
                }
                isContextPushed = false;
                boolean isPreInvoked = false;
                try {
                    this.container.pushExecutionContext(context);
                    isContextPushed = true;
                    Object bean = context.getBean();
                    invocation.setInstance(bean);
                    invocation.setEJBContext(context);
                    InvocationManager.preInvoke(!this.isStateful);
                    isPreInvoked = true;
                    result = invocation.invokeNext();
                    Object var10_10 = null;
                    if (!isPreInvoked) break block24;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (isPreInvoked) {
                        InvocationManager.postInvoke();
                    }
                    if (invocation.isRemoveMethod && context.isToBeRemoved()) {
                        try {
                            this.container.internalRemoveObject(context);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (isContextPushed) {
                        this.container.popExecutionContext();
                    }
                    if (this.isStateful) {
                        if (!(context == null || invocation.isRemoveMethod && context.isToBeRemoved())) {
                            ((StatefulSessionContainer)this.container).executeSessionReplication(context.getSessionID(), method);
                        }
                    } else if (context != null) {
                        this.container.putSessionContext(context);
                    }
                    throw throwable;
                }
                InvocationManager.postInvoke();
            }
            if (invocation.isRemoveMethod && context.isToBeRemoved()) {
                try {
                    this.container.internalRemoveObject(context);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (isContextPushed) {
                this.container.popExecutionContext();
            }
            if (this.isStateful) {
                if (!(context == null || invocation.isRemoveMethod && context.isToBeRemoved())) {
                    ((StatefulSessionContainer)this.container).executeSessionReplication(context.getSessionID(), method);
                }
            } else if (context != null) {
                this.container.putSessionContext(context);
            }
        }
        catch (Exception ex) {
            if ((ex instanceof RuntimeException || ex instanceof RemoteException) && !this.beanInfo.getModuleInfo().isAppException(ex)) {
                throw ExceptionMapper.mapSystemException(invocation, ex);
            }
            throw ex;
        }
        return result;
    }
}

