/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.container3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.SessionSynchronization;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import javax.transaction.Transaction;
import jeus.ejb.BeanState;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBStatus;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.baseimpl.EJBIfObject;
import jeus.ejb.baseimpl.EJBIfObjectType;
import jeus.ejb.baseimpl.EJBObjectBase;
import jeus.ejb.baseimpl.EJBSessionIfObject;
import jeus.ejb.baseimpl.SessionContextImpl;
import jeus.ejb.bean.objectbase.IIOPObject;
import jeus.ejb.container.ContainerException;
import jeus.ejb.container3.RedeliverTimerInterceptor;
import jeus.ejb.container3.SLSBTimerInterceptor;
import jeus.ejb.container3.SecurityInterceptor;
import jeus.ejb.container3.SessionContainer;
import jeus.ejb.container3.SessionIfObjectPool;
import jeus.ejb.container3.SessionInterceptor;
import jeus.ejb.container3.StatelessTxInterceptor;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.InvocationType;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.util.InstancePoolHandler;
import jeus.ejb.util.SimpleInstancePool;
import jeus.management.j2ee.EJB;
import jeus.management.j2ee.StatelessSessionBean;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.transaction.GTID;
import jeus.transaction.TMService;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.message.JeusMessage_EJB6;
import jeus.util.message.JeusMessage_EJB7;
import jeus.webservices.spi.EWSProvider;

public class StatelessSessionContainer
extends SessionContainer {
    static final String SLSB_SESSION_ID = "";

    public StatelessSessionContainer(SessionBeanInfo beanInfo, ArchiveArrayClassLoader loader, String securityDomain) throws EJBDeploymentException, ContainerException {
        super(beanInfo, loader, securityDomain);
        if (SessionSynchronization.class.isAssignableFrom(this.beanClass)) {
            throw new EJBDeploymentException("it is not allowed to implement javax.ejb.SessionSynchronization interface in stateless session ejb.");
        }
        try {
            Method ejbCreate = this.beanClass.getMethod("ejbCreate", new Class[0]);
            beanInfo.getBeanClassInterceptorInfo().addCallbackMethod(CallbackType.POST_CONSTRUCT, ejbCreate);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    public EJB createMBean(ObjectName parent) throws InstanceAlreadyExistsException {
        StatelessSessionBean mo = (StatelessSessionBean)StatelessSessionBean.createMBean(this.beanName, parent, this);
        this.setBeanModel(mo);
        return mo;
    }

    protected void startService() throws ContainerException {
        super.startService();
        try {
            this.initializeMetaData(null, true, true);
            this.initDurableTimers(this.loader);
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB7._4654, ex);
        }
    }

    public boolean isWebserviceProvider() {
        return this.beanInfo.getServiceEndpointClassName() != null;
    }

    protected void initializePool() throws ContainerException {
        super.initializePool();
        try {
            EWSProvider provider;
            if (this.ejbObjectImplClass != null) {
                this.ejbSessionObjectPool = new SessionIfObjectPool(this, false, this.ejbObjectImplClass);
            }
            if (this.ejbLocalObjectImplClass != null) {
                this.ejbLocalSessionObjectPool = new SessionIfObjectPool(this, false, this.ejbLocalObjectImplClass);
            }
            if (this.beanInfo.hasBusinessView()) {
                this.bizObjectPool = new SessionIfObjectPool(this, false, BusinessObjectHandler.class);
            }
            if ((provider = EWSProvider.getProvider()) != null) {
                provider.registerEJBEndpoint(this);
            }
        }
        catch (Throwable ex) {
            throw new ContainerException(JeusMessage_EJB7._4667, ex);
        }
        this.beanContextPool = new SimpleInstancePool();
        int initSize = this.beanInfo.getEJBBeanPoolSize();
        int spareSize = this.beanInfo.getEJBBeanPoolSize();
        int maxSpare = this.beanInfo.getEJBBeanPoolMax();
        int maxSize = Integer.MAX_VALUE;
        this.beanContextPool.initialize(SessionContextImpl.class, initSize, spareSize, maxSpare, maxSize, new BeanInstancePoolHandler());
    }

    protected void initInterceptors() throws ContainerException {
        ArrayList<Interceptor> itxList = new ArrayList<Interceptor>();
        itxList.add(new SessionInterceptor(this));
        SecurityInterceptor securityItx = new SecurityInterceptor(this);
        itxList.add(securityItx);
        StatelessTxInterceptor txItx = new StatelessTxInterceptor(this);
        itxList.add(txItx);
        EWSProvider provider = EWSProvider.getProvider();
        if (provider != null) {
            provider.addInterceptor(this, itxList);
        }
        if (this.userInterceptorManager != null) {
            itxList.add(this.userInterceptorManager);
        }
        this.interceptorTable.put(InvocationType.BUSINESS_METHOD, itxList.toArray(new Interceptor[itxList.size()]));
        if (this.isTimedObject()) {
            ArrayList<Interceptor> timeoutInterceptors = new ArrayList<Interceptor>();
            timeoutInterceptors.add(new SLSBTimerInterceptor(this));
            timeoutInterceptors.add(securityItx);
            timeoutInterceptors.add(txItx);
            timeoutInterceptors.add(new RedeliverTimerInterceptor(this));
            this.interceptorTable.put(InvocationType.TIMEOUT_METHOD, timeoutInterceptors.toArray(new Interceptor[timeoutInterceptors.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EJBIfObject createObject(EJBIfObjectType type, Method createMethod, Object[] args) throws Exception {
        this.startAccess();
        try {
            Object ejbObject;
            switch (type) {
                case EJBOBJECT: {
                    ejbObject = this.ejbSessionObjectPool.create(SLSB_SESSION_ID);
                    EJBObjectBase base = (EJBObjectBase)ejbObject;
                    if (!this.exportIIOP || base.getIIOPObjectImpl() != null) break;
                    Constructor constructor = this.ejbObjectImplIIOPClass.getConstructor(this.ejbObjectImplClass);
                    IIOPObject ejbObjectImplIIOPImpl = (IIOPObject)constructor.newInstance(ejbObject);
                    base.setIIOPObjectImpl(ejbObjectImplIIOPImpl);
                    break;
                }
                case EJBLOCALOBJECT: {
                    ejbObject = this.ejbLocalSessionObjectPool.create(SLSB_SESSION_ID);
                    break;
                }
                case BUSINESSOBJECT: {
                    ejbObject = this.bizObjectPool.create(SLSB_SESSION_ID);
                    break;
                }
                default: {
                    throw new Exception("Not implemented for " + type.name());
                }
            }
            Object t = ejbObject;
            return t;
        }
        finally {
            this.endAccess();
        }
    }

    public void removeObject(EJBIfObject ejbObject) throws Exception {
        this.removeCount.increase();
    }

    public void removeObjectWithHandle(Handle handle) throws Exception {
        this.removeCount.increase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionContextImpl createBean() throws Exception {
        SessionContextImpl context = null;
        try {
            context = this.newBeanContext();
            context.setSessionID(SLSB_SESSION_ID);
            EWSProvider provider = EWSProvider.getProvider();
            if (provider != null) {
                provider.doInjection(context, this.beanInfo);
            }
            this.pushExecutionContext(context);
            try {
                this.invokeCallback(CallbackType.POST_CONSTRUCT, context);
                this.createCount.increase();
                this.methodReadyCount.increase();
            }
            finally {
                this.popExecutionContext();
            }
            context.setStatus(BeanState.READY);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new ContainerException(JeusMessage_EJB6._4241, ex);
        }
        return context;
    }

    protected SessionContextImpl getSessionContext(EJBSessionIfObject ifobject) {
        SessionContextImpl context = (SessionContextImpl)this.beanContextPool.fetch();
        if (context == null) {
            throw new EJBException("Could not fetch bean instance - pool is full or destroyed");
        }
        context.setStatus(BeanState.READY);
        context.setEJBSessionIfObject(ifobject);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putSessionContext(SessionContextImpl context) {
        if (context != null) {
            if (this.beanContextPool != null) {
                context.reset();
                this.beanContextPool.putback(context);
            }
            if (logger.isLoggable(JeusMessage_EJB7._4693_LEVEL)) {
                logger.logp(JeusMessage_EJB7._4693_LEVEL, "StatelessSessionContainer", "finishProcessingRequest", JeusMessage_EJB7._4693);
            }
        }
    }

    protected void undeploy() {
        if (logger.isLoggable(JeusMessage_EJB7._4681_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4681_LEVEL, "StatelessSessionContainer", "undeploy", JeusMessage_EJB7._4681);
        }
        if (logger.isLoggable(JeusMessage_EJB7._4682_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4682_LEVEL, "StatelessSessionContainer", "undeploy", JeusMessage_EJB7._4682);
        }
        try {
            if (this.beanContextPool != null) {
                this.beanContextPool.clear(false);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            EWSProvider provider = EWSProvider.getProvider();
            if (provider != null) {
                provider.unregisterEJBEndpoint(this.beanInfo);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            super.undeploy();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (logger.isLoggable(JeusMessage_EJB7._4684_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4684_LEVEL, "StatelessSessionContainer", "undeploy", JeusMessage_EJB7._4684);
        }
    }

    public boolean isStateful() {
        return false;
    }

    public void afterCompletion(EJBContextImpl ejbObject, Transaction tx, boolean committed) {
    }

    public void txTimeOut(EJBObject ejbObj, Transaction tx, int status) {
    }

    public void setBeanModel(EJB mo) {
        super.setBeanModel(mo);
        mo.setStatistic((StatisticImpl)this.totalEJBBeanCount);
        mo.setStatistic((StatisticImpl)this.activeEJBBeanCount);
        mo.setStatistic((StatisticImpl)this.totalThreadCount);
        mo.setStatistic((StatisticImpl)this.activeThreadCount);
    }

    public void beforeStatistic() {
        if (this.getStatus() != EJBStatus.RUNNING) {
            return;
        }
        this.totalEJBBeanCount.set((long)this.beanContextPool.size());
        this.activeEJBBeanCount.set((long)(this.beanContextPool.size() - this.beanContextPool.available()));
        this.totalThreadCount.set((long)this.beanInfo.getThreadPoolMax());
        this.activeThreadCount.set((long)this.getActiveThreadNum());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanInstancePoolHandler
    implements InstancePoolHandler<SessionContextImpl> {
        private BeanInstancePoolHandler() {
        }

        @Override
        public SessionContextImpl createInstance() throws Exception {
            return StatelessSessionContainer.this.createBean();
        }

        @Override
        public void afterCreateInstance(SessionContextImpl object) throws Exception {
        }

        @Override
        public Object beforeRemoveInstances() {
            return TMService.suspendCurrentTransaction();
        }

        @Override
        public void beforeRemoveInstance(SessionContextImpl object) {
            try {
                StatelessSessionContainer.this.removeBean(object);
            }
            catch (EJBException ex) {
                logger.log(JeusMessage_EJB12._9056_LEVEL, JeusMessage_EJB12._9056, (Throwable)ex);
            }
        }

        @Override
        public void afterRemoveInstances(Object userData) {
            TMService.resumeCurrentTransaction((GTID)userData);
        }
    }
}

