/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.generator.CodeGenerationException;
import jeus.ejb.generator.EJBClassGenerator;
import jeus.ejb.generator.MethodInfo;
import jeus.ejb.metadata.BeanInfo;
import jeus.util.codegen.ClassWriter;
import jeus.util.codegen.CodeUtil;
import jeus.util.codegen.MethodWriter;

public abstract class HomeImplGenerator
extends EJBClassGenerator {
    protected boolean remote;
    protected String homeClassName;
    protected Class homeClass;

    protected HomeImplGenerator(FileArchive archive, ClassLoader loader, BeanInfo beanInfo) {
        super(archive, loader, beanInfo);
    }

    protected void init(boolean remote, String homeClassName, String baseClassName) throws CodeGenerationException {
        this.remote = remote;
        this.homeClassName = homeClassName;
        this.baseClassName = baseClassName;
        try {
            this.packageName = CodeUtil.getPackageName(homeClassName);
            String moduleName = this.beanInfo.getModuleInfo().getModuleName();
            String prefix = CodeUtil.getSimpleClassName(homeClassName);
            String postfix = "Impl";
            this.implClassName = HomeImplGenerator.constructClassName(moduleName, this.packageName, prefix, postfix);
            this.fullImplClassName = CodeUtil.getFullClassName(this.packageName, this.implClassName);
            this.homeClass = this.loader.loadClass(homeClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new CodeGenerationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws CodeGenerationException, IOException {
        Class baseIf;
        String[] interfaces = this.getInterfaces();
        int modifiers = 17;
        ClassWriter classWriter = new ClassWriter(this.packageName, modifiers, this.implClassName, this.baseClassName, interfaces);
        classWriter.addHeadComment("// This is generated source. DO NOT MODIFY THIS.");
        classWriter.addDefaultConstructor();
        Class clazz = baseIf = this.remote ? EJBHome.class : EJBLocalHome.class;
        if (!baseIf.isAssignableFrom(this.homeClass)) {
            String errmsg = this.homeClass.getName() + " should extend " + baseIf.getName();
            throw new CodeGenerationException(errmsg);
        }
        Method[] methods = this.getUserDefinedMethods(baseIf, this.homeClass);
        int count = 0;
        for (Method method : methods) {
            this.writeUserDefinedMethod(classWriter, method, count);
            ++count;
        }
        this.writeOtherMethods(classWriter);
        OutputStream output = null;
        try {
            output = this.makeFileOf(this.fullImplClassName);
            classWriter.writeCode(output);
            output.flush();
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public String[] getInterfaces() {
        return new String[]{this.homeClassName};
    }

    protected abstract void writeUserDefinedMethod(ClassWriter var1, Method var2, int var3) throws CodeGenerationException;

    protected abstract void writeOtherMethods(ClassWriter var1) throws CodeGenerationException;

    protected void validateUserDefinedMethod(Method method) throws CodeGenerationException {
        Class<?>[] exceptions;
        for (Class<?> ex : exceptions = method.getExceptionTypes()) {
            if (Exception.class.isAssignableFrom(ex)) continue;
            String error = method + " should only throw Exception or its subclass";
            throw new CodeGenerationException(error);
        }
    }

    protected void writeCreateMethod(ClassWriter cw, Method method, int count, Class unexpectedException) throws CodeGenerationException {
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        String returnClassName = CodeUtil.getClassName(returnType);
        String methodID = "$method_" + count;
        this.writeMethodField(cw, methodID, this.fullImplClassName, new MethodInfo(method));
        MethodWriter mw = cw.addMethod(1, method);
        mw.wtry();
        String[] params = CodeUtil.nameParameters(paramTypes);
        String paramList = CodeUtil.makeCommaList(params);
        mw.wln("Object[] $params = new Object[]{" + paramList + "};");
        mw.wln("return (" + returnClassName + ") super._create(" + methodID + ", $params);");
        Vector<Class> catchList = this.computeUniqueCatchList(method.getExceptionTypes());
        mw.wcatch("java.lang.Exception ex");
        mw.wln("// rethrow runtime exceptions and any checked exceptions");
        Enumeration<Class> enumeration = catchList.elements();
        while (enumeration.hasMoreElements()) {
            Class ex = enumeration.nextElement();
            mw.wln("if(ex instanceof " + ex.getName() + ") throw (" + ex.getName() + ")ex;");
        }
        mw.wln("throw new " + unexpectedException.getName() + "(\"Unexpected exception\", ex);");
        mw.wtryend();
    }
}

