/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.generator;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import jeus.util.codegen.CodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo {
    private Method originalMethod;
    private String declaration;
    private int modifiers;
    private Class returnType;
    private String name;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;

    private MethodInfo() {
    }

    public MethodInfo(Method method) {
        this.originalMethod = method;
        this.modifiers = method.getModifiers();
        this.returnType = method.getReturnType();
        this.name = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.exceptionTypes = method.getExceptionTypes();
    }

    public boolean isSameReturnType(Method method) {
        return this.getReturnType().equals(method.getReturnType());
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public Method getOriginalMethod() {
        return this.originalMethod;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getSignature() {
        Class[] parameters = this.getParameterTypes();
        String sig = CodeUtil.getClassName(this.getReturnType()) + " " + this.getName() + "(";
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                sig = sig + ", ";
            }
            sig = sig + CodeUtil.getClassName(parameters[i]);
        }
        sig = sig + ")";
        return sig;
    }

    public String getMethodDeclaration() {
        if (this.declaration == null) {
            String name = this.getName() + "(";
            Class[] args = this.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    name = name + ",";
                }
                name = name + MethodInfo.getString(args[i]);
            }
            this.declaration = name + ")";
        }
        return this.declaration;
    }

    private static String getString(Class cl) {
        String st = "";
        while (cl.isArray()) {
            st = st + "[]";
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            if (cl == Boolean.TYPE) {
                st = "boolean" + st;
            } else if (cl == Byte.TYPE) {
                st = "byte" + st;
            } else if (cl == Character.TYPE) {
                st = "char" + st;
            } else if (cl == Short.TYPE) {
                st = "short" + st;
            } else if (cl == Integer.TYPE) {
                st = "int" + st;
            } else if (cl == Long.TYPE) {
                st = "long" + st;
            } else if (cl == Float.TYPE) {
                st = "float" + st;
            } else if (cl == Double.TYPE) {
                st = "double" + st;
            }
        } else {
            st = cl.getName() + st;
        }
        return st;
    }

    public MethodInfo mergeWith(MethodInfo other) {
        Vector<Class> legalExceptions = new Vector<Class>();
        this.collectCompatibleExceptions(other.getExceptionTypes(), this.getExceptionTypes(), legalExceptions);
        this.collectCompatibleExceptions(this.getExceptionTypes(), other.getExceptionTypes(), legalExceptions);
        MethodInfo merged = (MethodInfo)this.clone();
        merged.exceptionTypes = legalExceptions.toArray(new Class[legalExceptions.size()]);
        return merged;
    }

    private void collectCompatibleExceptions(Class[] from, Class[] with, List<Class> list) {
        block0: for (Class fromException : from) {
            if (list.contains(fromException)) continue;
            for (Class withException : with) {
                if (!withException.isAssignableFrom(fromException)) continue;
                list.add(fromException);
                continue block0;
            }
        }
    }

    public Object clone() {
        MethodInfo m = new MethodInfo();
        m.modifiers = this.modifiers;
        m.name = this.name;
        m.returnType = this.returnType;
        m.parameterTypes = this.parameterTypes;
        m.exceptionTypes = this.exceptionTypes;
        return m;
    }

    public String toString() {
        return this.returnType + " " + this.getMethodDeclaration();
    }
}

