/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.generator.CodeGenerationException;
import jeus.ejb.generator.EJBClassGenerator;
import jeus.ejb.metadata.BeanInfo;
import jeus.util.codegen.ClassWriter;
import jeus.util.codegen.CodeUtil;

public abstract class ObjectImplGenerator
extends EJBClassGenerator {
    protected boolean remote;
    protected String ejbObjectClassName;
    protected Class ejbObjectClass;

    protected ObjectImplGenerator(FileArchive archive, ClassLoader loader, BeanInfo beanInfo) throws CodeGenerationException {
        super(archive, loader, beanInfo);
    }

    protected void init(boolean remote, String ejbObjectClassName, String baseClassName) throws CodeGenerationException {
        this.remote = remote;
        this.ejbObjectClassName = ejbObjectClassName;
        this.baseClassName = baseClassName;
        try {
            this.ejbObjectClass = this.loader.loadClass(ejbObjectClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new CodeGenerationException(e);
        }
        this.packageName = CodeUtil.getPackageName(ejbObjectClassName);
        String moduleName = this.beanInfo.getModuleInfo().getModuleName();
        String prefix = CodeUtil.getSimpleClassName(ejbObjectClassName);
        String postfix = "Impl";
        this.implClassName = ObjectImplGenerator.constructClassName(moduleName, this.packageName, prefix, postfix);
        this.fullImplClassName = CodeUtil.getFullClassName(this.packageName, this.implClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws CodeGenerationException, IOException {
        Class baseIf;
        String[] interfaces = new String[]{this.ejbObjectClassName};
        int modifiers = 17;
        ClassWriter classWriter = new ClassWriter(this.packageName, modifiers, this.implClassName, this.baseClassName, interfaces);
        classWriter.addHeadComment("// This is generated source. DO NOT MODIFY THIS.");
        classWriter.addDefaultConstructor();
        Class clazz = baseIf = this.remote ? EJBObject.class : EJBLocalObject.class;
        if (!baseIf.isAssignableFrom(this.ejbObjectClass)) {
            String errmsg = this.ejbObjectClass.getName() + " should extend " + baseIf.getName();
            throw new CodeGenerationException(errmsg);
        }
        Method[] methods = this.getUserDefinedMethods(baseIf, this.ejbObjectClass);
        int count = 0;
        for (Method method : methods) {
            this.writeUserDefinedMethod(classWriter, method, count);
            ++count;
        }
        this.writeOtherMethods(classWriter);
        OutputStream output = null;
        try {
            output = this.makeFileOf(this.fullImplClassName);
            classWriter.writeCode(output);
            output.flush();
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    protected abstract void writeUserDefinedMethod(ClassWriter var1, Method var2, int var3) throws CodeGenerationException;

    protected abstract void writeOtherMethods(ClassWriter var1);
}

