/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.generator;

import java.util.Enumeration;
import java.util.Vector;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.MethodInterfaceType;
import jeus.ejb.generator.CodeGenerationException;
import jeus.ejb.generator.EJBClassGenerator;
import jeus.ejb.generator.MethodInfo;
import jeus.ejb.interceptor.InvocationRequest;
import jeus.ejb.metadata.BeanInfo;
import jeus.util.codegen.ClassWriter;
import jeus.util.codegen.CodeUtil;
import jeus.util.codegen.MethodWriter;

public class SessionImplHelper
extends EJBClassGenerator {
    protected SessionImplHelper(FileArchive archive, ClassLoader loader, BeanInfo beanInfo) {
        super(archive, loader, beanInfo);
    }

    protected void writeBusinessMethod(ClassWriter cw, MethodInfo method, int index, MethodInterfaceType methodIntfType, Class unexpectedException) throws CodeGenerationException {
        for (Class ex : method.getExceptionTypes()) {
            if (Exception.class.isAssignableFrom(ex)) continue;
            String error = method + " should throw java.lang.Exception or its subclass only";
            throw new CodeGenerationException(error);
        }
        Class[] paramTypes = method.getParameterTypes();
        Class returnType = method.getReturnType();
        String methodName = method.getName();
        Class[] exceptionTypes = method.getExceptionTypes();
        String methodVar = "$method_" + index;
        this.writeMethodField(cw, methodVar, this.beanClassName, method);
        MethodWriter mw = cw.addMethod(1, returnType, methodName, paramTypes, exceptionTypes);
        mw.wln("Object $result = null;");
        mw.wtry();
        String[] params = CodeUtil.nameParameters(paramTypes);
        String paramList = CodeUtil.makeCommaList(params);
        mw.wln("Object[] $params = new Object[]{" + paramList + "};");
        mw.wln(InvocationRequest.classname + " $inv = " + InvocationRequest.classname + ".create(null, null, " + methodVar + ", $params);");
        mw.wln("$result = super._invoke($inv);");
        Vector<Class> catchList = this.computeUniqueCatchList(exceptionTypes);
        mw.wcatch("java.lang.Exception ex");
        mw.wln("// rethrow runtime exceptions and any checked exceptions");
        Enumeration<Class> enumeration = catchList.elements();
        while (enumeration.hasMoreElements()) {
            Class ex = enumeration.nextElement();
            mw.wln("if(ex instanceof " + ex.getName() + ") throw (" + ex.getName() + ")ex;");
        }
        mw.wln("throw new " + unexpectedException.getName() + "(\"Unexpected exception\", ex);");
        mw.wtryend();
        if (returnType != null && returnType != Void.TYPE) {
            String type = returnType.isPrimitive() ? CodeUtil.getWrapperClassName(returnType) : CodeUtil.getClassName(returnType);
            mw.wln("return (" + type + ")$result;");
        }
    }
}

