/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import jeus.ejb.MethodInterfaceType;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.interceptor.Interceptor;
import jeus.ejb.interceptor.InvocationRequest;
import jeus.ejb.interceptor.InvocationType;
import jeus.util.logging.JeusLogger;
import jeus.webservices.spi.EWSProvider;

public class Invocation {
    public static final String classname = Invocation.class.getName();
    protected static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb");
    protected InvocationRequest request;
    protected Interceptor[] interceptors;
    protected int next;
    public boolean isRemoveMethod;

    public Invocation(InvocationRequest request) {
        this.request = request;
    }

    public InvocationType getType() {
        return this.request.getType();
    }

    public void initInterceptors(Interceptor[] interceptors) {
        Interceptor[] pre = this.request.getPreInterceptors();
        Interceptor[] post = this.request.getPostInterceptors();
        if (pre != null || post != null) {
            int preSize = pre == null ? 0 : pre.length;
            int postSize = post == null ? 0 : post.length;
            int size = interceptors == null ? 0 : interceptors.length;
            this.interceptors = new Interceptor[preSize + postSize + size];
            if (preSize > 0) {
                System.arraycopy(pre, 0, this.interceptors, 0, preSize);
            }
            if (size > 0) {
                System.arraycopy(interceptors, 0, this.interceptors, preSize, size);
            }
            if (postSize > 0) {
                System.arraycopy(post, 0, this.interceptors, preSize + size, postSize);
            }
        } else {
            this.interceptors = interceptors;
        }
        this.next = 0;
    }

    public void setInstance(Object bean) {
        this.request.setInstance(bean);
    }

    public Object getInstance() {
        return this.request.getInstance();
    }

    public Method getMethod() {
        return this.request.getMethod();
    }

    public Object[] getParameters() {
        return this.request.getParameters();
    }

    public void setParameters(Object[] parameters) {
        this.request.setParameters(parameters);
    }

    public Object getContext(Object key) {
        return this.request.getContext(key);
    }

    public void setContext(Object key, Object value) {
        this.request.setContext(key, value);
    }

    public EJBContextImpl getEJBContext() {
        return this.request.getEJBContext();
    }

    public void setEJBContext(EJBContextImpl context) {
        this.request.setEJBContext(context);
    }

    public MethodInterfaceType getMethodInterfaceType() {
        return this.request.getMethodInterfaceType();
    }

    public Object getCaller() {
        return this.request.getCaller();
    }

    public Class getInvokedInterface() {
        return this.request.getInvokedInterface();
    }

    public Map getMessageContext() {
        return this.request.getMessageContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext() throws Exception {
        if (this.interceptors != null && this.next < this.interceptors.length) {
            int current = this.next++;
            try {
                Object object = this.interceptors[current].invoke(this);
                return object;
            }
            finally {
                this.next = current;
            }
        }
        try {
            Object caller = this.getCaller();
            EWSProvider provider = EWSProvider.getProvider();
            if (provider != null && provider.invokeJeusEjbProvider(caller, this)) {
                return null;
            }
            return this.getMethod().invoke(this.getInstance(), this.getParameters());
        }
        catch (InvocationTargetException ex) {
            Throwable th = ex.getTargetException();
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            th.printStackTrace();
            return null;
        }
    }
}

