/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBException;
import javax.interceptor.InvocationContext;
import jeus.ejb.EJBLoggers;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.interceptor.Invocation;
import jeus.ejb.interceptor.InvocationChain;
import jeus.util.ClassUtil;
import jeus.util.ReflectionUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationContextImpl
implements InvocationContext {
    protected static JeusLogger logger = EJBLoggers.logger;
    protected Object bean;
    protected Method method;
    protected Object[] parameters;
    protected Map<String, Object> contextData;
    protected InvocationChain invChain;
    protected int invocationLength;
    protected EJBContextImpl beanContext;
    protected Object[] interceptorInstances;
    protected int pos;
    protected Invocation systemInvocation;

    protected InvocationContextImpl() {
    }

    public InvocationContextImpl(EJBContextImpl ejbContext, Method method, Object[] params, InvocationChain chain, Invocation invocation) {
        assert (ejbContext != null);
        this.beanContext = ejbContext;
        this.bean = ejbContext.getBean();
        this.method = method;
        this.parameters = params;
        this.invChain = chain;
        this.systemInvocation = invocation;
        if (invocation != null) {
            this.contextData = invocation.getMessageContext();
        }
        this.invocationLength = chain.size();
        this.interceptorInstances = ejbContext.getInterceptorInstances();
    }

    public Object getTarget() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] params) {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        if (params == null && paramTypes.length != 0) {
            throw new IllegalArgumentException("Wrong number of parameters");
        }
        if (params.length != paramTypes.length) {
            throw new IllegalArgumentException("Wrong number of parameters");
        }
        int index = 0;
        for (Class<?> type : paramTypes) {
            Class<?> actual = params[index].getClass();
            if (type.isPrimitive()) {
                Class wrapperCls = ClassUtil.getWrapperClass(type);
                if (wrapperCls != actual) {
                    String err = "Parameter type mismatch: params[" + index + "] is " + actual.getName() + ", but the expected type is " + type.getName();
                    throw new IllegalArgumentException(err);
                }
            } else if (!type.isAssignableFrom(actual)) {
                String err = "Parameter type mismatch: params[" + index + "] is " + actual.getName() + ", but the expected type is " + type.getName();
                throw new IllegalArgumentException(err);
            }
            ++index;
        }
        this.parameters = params;
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    public Object proceed() throws Exception {
        if (this.pos < this.invocationLength) {
            int index = this.invChain.getInterceptorIndex(this.pos);
            Object interceptor = index == -1 ? this.bean : this.interceptorInstances[index];
            assert (interceptor != null);
            Method method = this.invChain.getMethod(this.pos);
            try {
                ++this.pos;
                if (!method.isAccessible()) {
                    ReflectionUtils.setAccessible(method, true);
                }
                if (logger.isLoggable(JeusMessage_EJB12._9064_LEVEL)) {
                    logger.log(JeusMessage_EJB12._9064_LEVEL, JeusMessage_EJB12._9064, (Object)method.toString());
                }
                Object object = method.invoke(interceptor, this);
                return object;
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                th.printStackTrace();
                Object var6_10 = null;
                return var6_10;
            }
            catch (Exception ex) {
                throw new EJBException("System exception in calling interceptor method", ex);
            }
            finally {
                --this.pos;
            }
        }
        if (this.systemInvocation != null) {
            this.systemInvocation.setParameters(this.parameters);
            return this.systemInvocation.invokeNext();
        }
        try {
            if (logger.isLoggable(JeusMessage_EJB12._9065_LEVEL)) {
                logger.log(JeusMessage_EJB12._9065_LEVEL, JeusMessage_EJB12._9065, (Object)this.method.toString());
            }
            return this.method.invoke(this.bean, this.parameters);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }
}

