/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.csi;

import java.io.IOException;
import jeus.ejb.interop.csi.CSIException;
import jeus.ejb.interop.csi.GSSUPExportName;
import jeus.util.message.JeusMessage_EJB11;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class GSSUPInitialToken {
    private static ObjectIdentifier GSSUP_MECH_OID = null;
    private String username = "";
    private String scope = "";
    private String password = "";
    private byte[] target_name = new byte[0];
    private byte[] token;

    public GSSUPInitialToken(ORB orb, Codec codec, String username, String scope, String password, byte[] target_name) throws Exception {
        this.username = username;
        this.scope = scope;
        this.password = password;
        this.target_name = target_name;
        String scopedName = GSSUPExportName.addEscape(username);
        if (!scope.equals("")) {
            scopedName = scopedName + "@" + GSSUPExportName.addEscape(scope);
        }
        byte[] name_utf8 = scopedName.getBytes("UTF8");
        byte[] password_utf8 = password.getBytes("UTF8");
        InitialContextToken inctxToken = new InitialContextToken(name_utf8, password_utf8, target_name);
        Any a = orb.create_any();
        InitialContextTokenHelper.insert(a, inctxToken);
        byte[] encoded_token = codec.encode_value(a);
        DerOutputStream dos = new DerOutputStream();
        dos.putOID(GSSUP_MECH_OID);
        byte[] deroid = dos.toByteArray();
        this.token = new byte[1 + this.getDERLengthSize(deroid.length + encoded_token.length) + deroid.length + encoded_token.length];
        int index = 0;
        this.token[index++] = 96;
        index = this.writeDERLength(this.token, index, deroid.length + encoded_token.length);
        System.arraycopy(deroid, 0, this.token, index, deroid.length);
        System.arraycopy(encoded_token, 0, this.token, index += deroid.length, encoded_token.length);
    }

    private int getDERLengthSize(int len) {
        if (len < 128) {
            return 1;
        }
        if (len < 256) {
            return 2;
        }
        if (len < 65536) {
            return 3;
        }
        if (len < 0x1000000) {
            return 4;
        }
        return 5;
    }

    private int writeDERLength(byte[] token, int index, int len) {
        if (len < 128) {
            token[index++] = (byte)len;
        } else {
            token[index++] = (byte)(this.getDERLengthSize(len) + 127);
            if (len >= 0x1000000) {
                token[index++] = (byte)(len >> 24);
            }
            if (len >= 65536) {
                token[index++] = (byte)(len >> 16 & 0xFF);
            }
            if (len >= 256) {
                token[index++] = (byte)(len >> 8 & 0xFF);
            }
            token[index++] = (byte)(len & 0xFF);
        }
        return index;
    }

    private int readDERLength(byte[] token, int index) {
        int sf;
        int ret = 0;
        if (((sf = token[index++]) & 0x80) == 128) {
            for (int num_octets = sf & 0x7F; num_octets != 0; --num_octets) {
                ret = (ret << 8) + (token[index++] & 0xFF);
            }
        } else {
            ret = sf;
        }
        return ret;
    }

    public GSSUPInitialToken(ORB orb, Codec codec, byte[] token) throws Exception {
        int at_idx;
        int toklen;
        this.token = token;
        int index = 0;
        if (token[index++] != 96) {
            throw new CSIException(JeusMessage_EJB11._7099);
        }
        if (token[index += this.getDERLengthSize(toklen = this.readDERLength(token, index))] != 6) {
            throw new CSIException(JeusMessage_EJB11._7099);
        }
        byte[] buf = new byte[token.length - index];
        System.arraycopy(token, index, buf, 0, token.length - index);
        DerInputStream dis = new DerInputStream(buf);
        ObjectIdentifier mechoid = dis.getOID();
        if (!mechoid.equals(GSSUP_MECH_OID)) {
            throw new CSIException(JeusMessage_EJB11._7099);
        }
        int mechoidlen = this.readDERLength(token, index + 1);
        index = index + 1 + this.getDERLengthSize(mechoidlen) + mechoidlen;
        byte[] encoded_token = new byte[token.length - index];
        System.arraycopy(token, index, encoded_token, 0, token.length - index);
        Any a = orb.create_any();
        a = codec.decode_value(encoded_token, InitialContextTokenHelper.type());
        InitialContextToken inctxToken = InitialContextTokenHelper.extract(a);
        byte[] name_utf8 = inctxToken.username;
        byte[] password_utf8 = inctxToken.password;
        this.target_name = inctxToken.target_name;
        String scopedName = new String(name_utf8, "UTF8");
        this.password = new String(password_utf8, "UTF8");
        int from_idx = 0;
        while ((at_idx = scopedName.indexOf(64)) != -1) {
            if (at_idx == 0) {
                this.scope = scopedName.substring(1);
                break;
            }
            if (scopedName.charAt(at_idx - 1) != '\\') {
                this.username = scopedName.substring(0, at_idx);
                this.scope = scopedName.substring(at_idx + 1);
                break;
            }
            from_idx = at_idx + 1;
        }
        if (this.username.equals("") && this.scope.equals("")) {
            this.username = scopedName;
        }
        this.username = GSSUPExportName.removeExcape(this.username);
        this.scope = GSSUPExportName.removeExcape(this.scope);
    }

    public String getUsername() {
        return this.username;
    }

    public String getScope() {
        return this.scope;
    }

    public String getScopedUsername() {
        if (this.scope.equals("")) {
            return this.username;
        }
        return this.username + "@" + this.scope;
    }

    public String getPassword() {
        return this.password;
    }

    public byte[] getToken() {
        return this.token;
    }

    static {
        try {
            GSSUP_MECH_OID = new ObjectIdentifier("oid:2.23.130.1.1.1".substring("oid:2.23.130.1.1.1".indexOf(58) + 1));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

