/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.interop.csi;

import com.sun.corba.ee.spi.legacy.connection.Connection;
import com.sun.corba.ee.spi.legacy.interceptor.RequestInfoExt;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import jeus.ejb.ejbserver.EJBORBManager;
import jeus.ejb.interop.ORBReceiver;
import jeus.ejb.interop.csi.CSIException;
import jeus.ejb.interop.csi.GSSUPExportName;
import jeus.ejb.interop.csi.GSSUPInitialToken;
import jeus.ejb.interop.csi.login.AnonymousCredential;
import jeus.ejb.interop.csi.login.PasswordCredential;
import jeus.ejb.interop.csi.login.X509CertificateCredential;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.Subject;
import jeus.security.container.ejb.EJBSecurity;
import jeus.security.resource.PrincipalImpl;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSI.X501DistinguishedNameHelper;
import org.omg.CSI.X509CertificateChainHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public class ServerSideRequestInterceptorFor5
extends LocalObject
implements ServerRequestInterceptor,
ORBReceiver {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.interop.csi");
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;
    private static final int INVALID_EVIDENCE = 1;
    private static final int INVALID_MECHANISM = 2;
    private static final int NO_CONTEXT = 4;
    private static String name = "csi.ServerSideRequestInterceptor";
    private Codec codec;
    private ORB orb;
    private ThreadLocal isLogined = new ThreadLocal();

    public ServerSideRequestInterceptorFor5(Codec codec) {
        this.codec = codec;
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public String name() {
        return name;
    }

    public void destroy() {
    }

    private SASContextBody createContextError(int status) {
        byte[] error_token = new byte[]{};
        ContextError ce = new ContextError(0L, status, 1, error_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.error_msg(ce);
        return sasctxtbody;
    }

    private SASContextBody createCompleteEstablishContext() {
        byte[] final_context_token = new byte[]{};
        CompleteEstablishContext cec = new CompleteEstablishContext(0L, false, final_context_token);
        SASContextBody sasctxtbody = new SASContextBody();
        sasctxtbody.complete_msg(cec);
        return sasctxtbody;
    }

    private ServiceContext createSvcContext(SASContextBody sasctxtbody) throws Exception {
        Any a = this.orb.create_any();
        SASContextBodyHelper.insert(a, sasctxtbody);
        byte[] cdr_encoded_saselm = this.codec.encode_value(a);
        ServiceContext sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        return sc;
    }

    private Principal getIdentityToken(Subject subj, IdentityToken idtok, Set publicCreds) throws Exception {
        switch (idtok.discriminator()) {
            case 0: {
                return null;
            }
            case 1: {
                this.addCredentialToSet(publicCreds, new AnonymousCredential());
                return new PrincipalImpl(AnonymousSubject.ANONYMOUS_PRINCIPAL_NAME);
            }
            case 8: {
                Any any = this.codec.decode_value(idtok.dn(), X501DistinguishedNameHelper.type());
                byte[] derenc = X501DistinguishedNameHelper.extract(any);
                X500Name xName = new X500Name(derenc);
                this.addCredentialToSet(publicCreds, xName);
                return xName;
            }
            case 4: {
                Any any = this.codec.decode_value(idtok.certificate_chain(), X509CertificateChainHelper.type());
                byte[] derenc = X509CertificateChainHelper.extract(any);
                DerInputStream din = new DerInputStream(derenc);
                DerValue[] derval = din.getSequence(1);
                X509Certificate[] certchain = new X509CertImpl[derval.length];
                for (int i = 0; i < certchain.length; ++i) {
                    certchain[i] = new X509CertImpl(derval[i]);
                }
                X509CertificateCredential certcred = new X509CertificateCredential(certchain);
                this.addCredentialToSet(publicCreds, certcred);
                return certchain[0].getSubjectDN();
            }
            case 2: {
                Any any = this.codec.decode_value(idtok.principal_name(), GSS_NT_ExportedNameHelper.type());
                byte[] expname = GSS_NT_ExportedNameHelper.extract(any);
                GSSUPExportName gssName = new GSSUPExportName(expname);
                this.addCredentialToSet(publicCreds, gssName);
                return gssName;
            }
        }
        throw new CSIException(JeusMessage_EJB11._7100);
    }

    private void addCredentialToSet(Set creds, Object cred) throws Exception {
        AddCredentialAction action = new AddCredentialAction(creds, cred);
        AccessController.doPrivileged(action);
    }

    private Principal getClientToken(Subject subj, byte[] authtok, Set privateCreds) throws Exception {
        GSSUPInitialToken token = new GSSUPInitialToken(this.orb, this.codec, authtok);
        this.authenticate(token.getUsername(), token.getPassword(), token.getScope());
        PasswordCredential cred = new PasswordCredential(token.getUsername(), token.getPassword(), token.getScope());
        this.addCredentialToSet(privateCreds, cred);
        return new PrincipalImpl(token.getUsername());
    }

    public Principal getTransportPrincipal(Subject subj, ServerRequestInfo ri, Set publicCreds) throws Exception {
        InetAddress adrs;
        Connection con = ((RequestInfoExt)ri).connection();
        Socket soc = con.getSocket();
        if (soc instanceof SSLSocket) {
            SSLSocket sslSoc = (SSLSocket)con.getSocket();
            SSLSession ses = sslSoc.getSession();
            Certificate[] chain = null;
            try {
                chain = ses.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
            if (chain != null) {
                X509Certificate[] certchain = new X509Certificate[chain.length];
                for (int i = 0; i < chain.length; ++i) {
                    certchain[i] = (X509Certificate)chain[i];
                }
                X509CertificateCredential certcred = new X509CertificateCredential(certchain);
                this.addCredentialToSet(publicCreds, certcred);
                X509Certificate cert = certchain[0];
                return cert.getSubjectDN();
            }
        }
        if (EJBORBManager.isTrustedHost((adrs = soc.getInetAddress()).getHostAddress())) {
            this.addCredentialToSet(publicCreds, new AnonymousCredential());
            return new PrincipalImpl(AnonymousSubject.ANONYMOUS_PRINCIPAL_NAME);
        }
        throw new CSIException(JeusMessage_EJB11._7101, adrs.getHostAddress());
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        int error_status = 2;
        try {
            Principal jeusPrincipal;
            ServiceContext sc;
            try {
                sc = ri.get_request_service_context(15);
            }
            catch (BAD_PARAM e) {
                return;
            }
            Any SasAny = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
            SASContextBody sasctxbody = SASContextBodyHelper.extract(SasAny);
            Principal clientPrin = null;
            Principal identityPrin = null;
            Subject subj = new Subject(SecurityInstaller.getDefaultDomainName());
            Set privateCreds = subj.getPrivateCredentials();
            Set publicCreds = subj.getPublicCredentials();
            Set principals = subj.getPrincipals();
            switch (sasctxbody.discriminator()) {
                case 5: {
                    error_status = 4;
                    throw new CSIException(JeusMessage_EJB11._7102);
                }
                case 0: {
                    EstablishContext ec = sasctxbody.establish_msg();
                    if (ec.client_authentication_token != null && ec.client_authentication_token.length != 0) {
                        try {
                            clientPrin = this.getClientToken(subj, ec.client_authentication_token, privateCreds);
                        }
                        catch (Throwable t) {
                            error_status = 1;
                            throw t;
                        }
                    }
                    if (ec.identity_token == null) break;
                    try {
                        identityPrin = this.getIdentityToken(subj, ec.identity_token, publicCreds);
                        break;
                    }
                    catch (Throwable t) {
                        error_status = 1;
                        throw t;
                    }
                }
                default: {
                    throw new CSIException(JeusMessage_EJB11._7103);
                }
            }
            if (identityPrin != null) {
                jeusPrincipal = identityPrin;
            } else if (clientPrin != null) {
                jeusPrincipal = clientPrin;
            } else {
                Principal transportPrin;
                try {
                    transportPrin = this.getTransportPrincipal(subj, ri, publicCreds);
                }
                catch (Throwable t) {
                    error_status = 1;
                    throw t;
                }
                jeusPrincipal = transportPrin;
            }
            this.addCredentialToSet(principals, jeusPrincipal);
            subj.setMainPrincipal(jeusPrincipal);
            sasctxbody = this.createCompleteEstablishContext();
            sc = this.createSvcContext(sasctxbody);
            ri.add_reply_service_context(sc, true);
            this.setSecurityContext(subj);
        }
        catch (Throwable t) {
            block22: {
                if (logger.isLoggable(JeusMessage_EJB11._7104_LEVEL)) {
                    logger.log(JeusMessage_EJB11._7104_LEVEL, JeusMessage_EJB11._7104, t);
                }
                try {
                    SASContextBody sasctxbody = this.createContextError(error_status);
                    ServiceContext sc = this.createSvcContext(sasctxbody);
                    ri.add_reply_service_context(sc, true);
                }
                catch (Throwable e) {
                    if (!logger.isLoggable(JeusMessage_EJB11._7105_LEVEL)) break block22;
                    logger.log(JeusMessage_EJB11._7105_LEVEL, JeusMessage_EJB11._7105, e);
                }
            }
            throw new NO_PERMISSION();
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo ri) {
        block2: {
            try {
                this.unsetSecurityContext();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_EJB11._7106_LEVEL)) break block2;
                logger.log(JeusMessage_EJB11._7106_LEVEL, JeusMessage_EJB11._7106, t);
            }
        }
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        block2: {
            try {
                this.unsetSecurityContext();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_EJB11._7107_LEVEL)) break block2;
                logger.log(JeusMessage_EJB11._7107_LEVEL, JeusMessage_EJB11._7107, t);
            }
        }
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        block2: {
            try {
                this.unsetSecurityContext();
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_EJB11._7108_LEVEL)) break block2;
                logger.log(JeusMessage_EJB11._7108_LEVEL, JeusMessage_EJB11._7108, t);
            }
        }
    }

    private void authenticate(String username, String password, String realm) throws Exception {
        EJBSecurity.authenticate(Subject.makeSubject(SecurityInstaller.getDefaultDomainName(), username, password), false);
    }

    private void setSecurityContext(Subject subj) throws Exception {
        LoginService.login(subj, true);
        this.isLogined.set(Boolean.TRUE);
    }

    private void unsetSecurityContext() throws Exception {
        if (this.isLogined.get() != null) {
            LoginService.logout();
            this.isLogined.set(null);
        }
    }

    public static class AddCredentialAction
    implements PrivilegedAction {
        private Set creds;
        private Object cred;

        public AddCredentialAction(Set creds, Object cred) {
            this.creds = creds;
            this.cred = cred;
        }

        public Object run() {
            this.creds.add(this.cred);
            return null;
        }
    }
}

