/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import jeus.ejb.EJBLoggers;
import jeus.ejb.io.SerializableObjectFactory;
import jeus.util.logging.JeusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBObjectInputStream
extends ObjectInputStream {
    protected static JeusLogger logger = EJBLoggers.logger;
    protected ClassLoader loader;

    public EJBObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.enableResolveObject(true);
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        Object result = obj instanceof SerializableObjectFactory ? ((SerializableObjectFactory)obj).createObject() : obj;
        return result;
    }

    public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return Class.forName(desc.getName(), false, this.loader);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, this.loader);
            if ((cl.getModifiers() & 1) == 0) {
                return super.resolveProxyClass(interfaces);
            }
            classObjs[i] = cl;
        }
        try {
            return Proxy.getProxyClass(this.loader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

