/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jeus.container.namingenv.NamingEnvironment;
import jeus.ejb.interceptor.CallbackType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorInfo {
    private Class interceptorClass;
    private NamingEnvironment namingEnvironment;
    private Map<CallbackType, Set<Method>> callbackMethods = new HashMap<CallbackType, Set<Method>>();
    private Map<CallbackType, List<Method>> orderedCallbackMethods = new HashMap<CallbackType, List<Method>>();
    private Set<Method> aroundInvokeMethods;
    private List<Method> orderedAroundInvokeMethods;
    private int boundCount;

    public InterceptorInfo(Class cls) {
        this.interceptorClass = cls;
    }

    public Class getInterceptorClass() {
        return this.interceptorClass;
    }

    public void addCallbackMethod(CallbackType type, Method method) {
        Set<Method> methods = this.getCallbackMethods(type);
        methods.add(method);
    }

    public void addAroundInvokeMethod(Method method) {
        Set<Method> aroundInvokeMethods = this.getAroundInvokeMethods();
        aroundInvokeMethods.add(method);
    }

    public boolean hasAroundInvokeMethods() {
        return this.aroundInvokeMethods != null && this.aroundInvokeMethods.size() > 0;
    }

    public boolean hasCallbackMethods(CallbackType type) {
        Set<Method> set = this.callbackMethods.get((Object)type);
        return set != null && set.size() > 0;
    }

    public Set<Method> getAroundInvokeMethods() {
        if (this.aroundInvokeMethods == null) {
            this.aroundInvokeMethods = new HashSet<Method>();
        }
        return this.aroundInvokeMethods;
    }

    public Set<Method> getCallbackMethods(CallbackType type) {
        Set<Method> set = this.callbackMethods.get((Object)type);
        if (set == null) {
            set = new HashSet<Method>();
            this.callbackMethods.put(type, set);
        }
        return set;
    }

    public List<Method> getOrderedAroundInvokeMethods() {
        if (this.orderedAroundInvokeMethods == null) {
            this.orderedAroundInvokeMethods = this.orderMethods(this.getAroundInvokeMethods());
        }
        return Collections.unmodifiableList(this.orderedAroundInvokeMethods);
    }

    public List<Method> getOrderedCallbackMethods(CallbackType type) {
        List<Method> ordered = this.orderedCallbackMethods.get((Object)type);
        if (ordered == null) {
            ordered = this.orderMethods(this.getCallbackMethods(type));
            this.orderedCallbackMethods.put(type, ordered);
        }
        return Collections.unmodifiableList(ordered);
    }

    private List<Method> orderMethods(Set<Method> methods) {
        LinkedList<Method> list = new LinkedList<Method>();
        if (methods.size() == 0) {
            return list;
        }
        HashMap map = new HashMap();
        for (Method m : methods) {
            map.put(m.getDeclaringClass(), m);
        }
        for (Class next = this.interceptorClass; next != Object.class; next = next.getSuperclass()) {
            Method m;
            m = (Method)map.get(next);
            if (m == null) continue;
            list.addFirst(m);
        }
        return list;
    }

    public NamingEnvironment getNamingEnvironment() {
        return this.namingEnvironment;
    }

    public void setNamingEnvironment(NamingEnvironment namingEnvironment) {
        this.namingEnvironment = namingEnvironment;
    }

    public boolean isBound() {
        return this.boundCount > 0;
    }

    public void setIsBound(boolean flag) {
        this.boundCount = flag ? ++this.boundCount : --this.boundCount;
        assert (this.boundCount >= 0);
    }

    public int hashCode() {
        return this.interceptorClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof InterceptorInfo) {
            return this.interceptorClass == ((InterceptorInfo)obj).interceptorClass;
        }
        return false;
    }

    public String toString() {
        return this.interceptorClass.getName();
    }
}

