/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.ejb.ApplicationException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttributeType;
import javax.xml.bind.JAXBException;
import jeus.deploy.InvalidAnnotationException;
import jeus.deploy.InvalidDescriptorException;
import jeus.deploy.JeusDeploymentException;
import jeus.deploy.archivist.FileArchive;
import jeus.ejb.EnterpriseBeanType;
import jeus.ejb.SessionType;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.EntityBeanInfo;
import jeus.ejb.metadata.InterceptorBindingInfo;
import jeus.ejb.metadata.InterceptorInfo;
import jeus.ejb.metadata.MessageDrivenBeanInfo;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.metadata.annotation.EJBAnnotationProcessor;
import jeus.ejb.metadata.descriptor.EJBDescProcessor;
import jeus.ejb.metadata.descriptor.EntityDescProcessor;
import jeus.ejb.metadata.descriptor.MDBDescProcessor;
import jeus.ejb.metadata.descriptor.SessionDescProcessor;
import jeus.ejb.util.MethodTable;
import jeus.management.j2ee.DeploymentContext;
import jeus.management.j2ee.EJBModule;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB12;
import jeus.webservices.spi.EWSProvider;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.RelationPair;
import jeus.xml.binding.j2ee.ContainerTransactionType;
import jeus.xml.binding.j2ee.EjbJarType;
import jeus.xml.binding.j2ee.EjbLocalRefType;
import jeus.xml.binding.j2ee.EjbRelationType;
import jeus.xml.binding.j2ee.EnterpriseBeansType;
import jeus.xml.binding.j2ee.EntityBeanType;
import jeus.xml.binding.j2ee.ExcludeListType;
import jeus.xml.binding.j2ee.MessageDrivenBeanType;
import jeus.xml.binding.j2ee.MethodPermissionType;
import jeus.xml.binding.j2ee.RelationshipsType;
import jeus.xml.binding.j2ee.SecurityRoleType;
import jeus.xml.binding.j2ee.SessionBeanType;
import jeus.xml.binding.jeusDD.EjbRelationMapType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.TransAttributeType;
import jeus.xml.binding.webservicesHelper.WebservicesPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleInfo {
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb");
    private static ObjectFactory jeusDDObjectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
    protected EJBModule module;
    protected String appName;
    protected String moduleName;
    private String moduleDomain;
    protected List<BeanInfo> beanList;
    protected Map<String, BeanInfo> beanMap;
    protected List<RelationPair> relationList;
    protected EjbJarType ejbJar;
    protected JeusEjbDdType ejbDD;
    protected boolean metadataComplete;
    private static final double DEFAULT_EJBSPEC_VERSION = 3.0;
    protected double ejbVersion = 3.0;
    protected String securityDomain;
    protected List<SecurityRoleType> securityRoles;
    protected List<MethodPermissionType> methodPermissions;
    protected ExcludeListType excludeList;
    protected List<ContainerTransactionType> containerTransactions;
    protected String clientJar;
    private Map<String, Boolean> appExceptionMap = Collections.EMPTY_MAP;
    private final Map<Class, InterceptorInfo> interceptors = new HashMap<Class, InterceptorInfo>();
    private InterceptorBindingInfo defaultInterceptorBinding;
    protected WebservicesPair webservicesPair;
    protected Map<String, String> messageDestinationList = new HashMap<String, String>();
    protected ClassLoader loader;

    public ClassLoader getLoader() {
        return this.loader;
    }

    protected ModuleInfo(String moduleName) {
        this.appName = moduleName;
        this.moduleName = moduleName;
    }

    public static ModuleInfo create(String moduleName, FileArchive moduleHome, ClassLoader loader, EjbJarType ejbJar, JeusEjbDdType ejbDD, String moduleDomain, String securityDomainName) throws JeusDeploymentException {
        try {
            ModuleInfo moduleInfo = new ModuleInfo(moduleName);
            DeploymentContext dc = DeploymentContext.currentContext();
            moduleInfo.module = (EJBModule)dc.getJ2EEModule();
            moduleInfo.moduleDomain = moduleDomain;
            moduleInfo.securityDomain = securityDomainName;
            moduleInfo.loader = loader;
            moduleInfo.ejbJar = ejbJar;
            assert (ejbDD != null);
            moduleInfo.ejbDD = ejbDD;
            HashMap<String, JeusBeanType> jeusBeanMap = EJBDescProcessor.getJeusBeanMap(ejbDD);
            Map<String, BeanInfo> beanMap = ModuleInfo.processMetadata(ejbJar, moduleInfo, moduleHome, loader, jeusBeanMap);
            moduleInfo.beanMap = beanMap;
            moduleInfo.beanList = new Vector<BeanInfo>();
            for (BeanInfo beaninfo : beanMap.values()) {
                moduleInfo.beanList.add(beaninfo);
            }
            List<RelationPair> relationList = ejbJar != null ? ModuleInfo.pairRelation(ejbJar.getRelationships(), ejbDD.getEjbRelationMap()) : Collections.EMPTY_LIST;
            moduleInfo.relationList = relationList;
            return moduleInfo;
        }
        catch (JeusDeploymentException ex) {
            ex.setModuleName(moduleName);
            throw ex;
        }
    }

    public static Map<String, BeanInfo> processMetadata(EjbJarType ejbJar, ModuleInfo moduleInfo, FileArchive moduleHome, ClassLoader loader, HashMap<String, JeusBeanType> jeusBeanMap) throws JeusDeploymentException {
        HashMap<String, BeanInfo> beanMap = new HashMap<String, BeanInfo>();
        moduleInfo.ejbVersion = 3.0;
        boolean metadataComplete = false;
        if (ejbJar != null) {
            String version = ejbJar.getVersion();
            if (version != null && (version.equals("2.1") || version.equals("2.0"))) {
                moduleInfo.ejbVersion = Double.parseDouble(version);
                metadataComplete = true;
                ejbJar.setMetadataComplete(true);
            } else if (ejbJar.isSetMetadataComplete() && ejbJar.isMetadataComplete()) {
                metadataComplete = true;
            }
            ModuleInfo.readBeanListFromDD(ejbJar, moduleInfo, beanMap, jeusBeanMap);
        }
        moduleInfo.metadataComplete = metadataComplete;
        if (!metadataComplete) {
            ModuleInfo.readAnnotations(moduleInfo, moduleHome, loader, beanMap, jeusBeanMap);
        }
        if (ejbJar != null) {
            ModuleInfo.readEjbJarDescriptor(ejbJar, loader, moduleInfo, beanMap, jeusBeanMap);
        }
        for (BeanInfo beanInfo : beanMap.values()) {
            MethodTable mdTable;
            try {
                ModuleInfo.validateInterface(beanInfo, loader);
            }
            catch (InvalidDescriptorException e) {
                e.setModuleName(moduleInfo.getModuleName());
                e.setComponentName(beanInfo.getBeanName());
                throw e;
            }
            String ejbName = beanInfo.getBeanName();
            JeusBeanType jeusBean = jeusBeanMap.get(ejbName);
            if (jeusBean == null) {
                jeusBean = ModuleInfo.createJeusBean(beanInfo);
            } else {
                jeusBeanMap.remove(ejbName);
                EJBDescProcessor.processClusteringMetadata(jeusBean, beanInfo, loader);
            }
            if (logger.isLoggable(Level.FINEST) && !(mdTable = beanInfo.getReplicationModeOfMethods()).isEmpty() && logger.isLoggable(JeusMessage_EJB12._9092_LEVEL)) {
                logger.log(JeusMessage_EJB12._9092_LEVEL, JeusMessage_EJB12._9092, new Object[]{beanInfo.getBeanName(), mdTable.toString()});
            }
            beanInfo.setJeusBean(jeusBean);
        }
        if (jeusBeanMap.size() > 0) {
            String ejbName = jeusBeanMap.keySet().iterator().next();
            throw new InvalidDescriptorException("Unknown " + ejbName + " jeus-bean declaration in jeus-ejb-dd.xml", moduleInfo.getModuleName(), ejbName);
        }
        return beanMap;
    }

    private static void validateInterface(BeanInfo beanInfo, ClassLoader classLoader) throws InvalidDescriptorException, InvalidAnnotationException {
        boolean hasHome = ModuleInfo.validateEjb2Interface(classLoader, beanInfo.getEJBHomeClassName(), EJBHome.class) || ModuleInfo.validateEjb2Interface(classLoader, beanInfo.getEJBLocalHomeClassName(), EJBLocalHome.class);
        boolean hasComponent = ModuleInfo.validateEjb2Interface(classLoader, beanInfo.getEJBObjectClassName(), EJBObject.class) || ModuleInfo.validateEjb2Interface(classLoader, beanInfo.getEJBLocalObjectClassName(), EJBLocalObject.class);
        boolean hasRemoteBusiness = false;
        boolean hasLocalBusiness = false;
        if (beanInfo instanceof SessionBeanInfo) {
            for (Class remote : ((SessionBeanInfo)beanInfo).getRemoteBusinessInterfaces()) {
                if (EJBObject.class.isAssignableFrom(remote)) {
                    throw new InvalidDescriptorException("Remote business inteface should not implements or extends javax.ejb.EJBObject : " + remote.getName());
                }
                if (!Modifier.isAbstract(remote.getModifiers())) continue;
                hasRemoteBusiness = true;
            }
            for (Class local : ((SessionBeanInfo)beanInfo).getLocalBusinessInterfaces()) {
                if (EJBLocalObject.class.isAssignableFrom(local)) {
                    throw new InvalidDescriptorException("Local business inteface should not implements or extends javax.ejb.EJBLocalObject : " + local.getName());
                }
                hasLocalBusiness = true;
            }
            for (Class remote : ((SessionBeanInfo)beanInfo).getRemoteBusinessInterfaces()) {
                for (Class local : ((SessionBeanInfo)beanInfo).getLocalBusinessInterfaces()) {
                    if (!local.getName().equals(remote.getName())) continue;
                    throw new InvalidDescriptorException("A business inteface can not be remote business interface and local business interface : " + local.getName());
                }
            }
        }
        if (hasComponent && !hasHome) {
            throw new InvalidDescriptorException("A component interface needs a home interface. There is no home interface corresponding the component interface.");
        }
        if (!hasComponent && hasHome) {
            throw new InvalidDescriptorException("A home interface needs a component interface. There is no component interface corresponding the home interface.");
        }
        if (beanInfo instanceof SessionBeanInfo && !hasLocalBusiness && !hasRemoteBusiness && !hasComponent) {
            EWSProvider ews = EWSProvider.getProvider();
            if (ews != null && ews.isWebServiceEndpoint((SessionBeanInfo)beanInfo)) {
                return;
            }
            throw new InvalidDescriptorException("Bean[name=" + beanInfo.getBeanName() + " is not webservice endpoint and there are no business interface or component interface");
        }
    }

    private static boolean validateEjb2Interface(ClassLoader classLoader, String interfaceName, Class requiredInterface) throws InvalidDescriptorException {
        Class<?> interfaceClass;
        if (interfaceName == null) {
            return false;
        }
        try {
            interfaceClass = classLoader.loadClass(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidDescriptorException(interfaceName + " does not exist");
        }
        if (!requiredInterface.isAssignableFrom(interfaceClass)) {
            throw new InvalidDescriptorException(interfaceName + " should implement " + requiredInterface.getName());
        }
        return true;
    }

    private static void readBeanListFromDD(EjbJarType ejbJar, ModuleInfo moduleInfo, Map<String, BeanInfo> beanMap, HashMap<String, JeusBeanType> jeusBeanMap) throws InvalidDescriptorException {
        ClassLoader loader = moduleInfo.getLoader();
        EnterpriseBeansType enterpriseBeans = ejbJar.getEnterpriseBeans();
        if (enterpriseBeans != null) {
            for (Object jarBean : enterpriseBeans.getSessionOrEntityOrMessageDriven()) {
                String ejbClassName;
                Class<?> ejbClass;
                SessionBeanType bean;
                BeanInfo beanInfo = null;
                String ejbName = null;
                if (jarBean instanceof SessionBeanType) {
                    bean = (SessionBeanType)jarBean;
                    ejbName = bean.getEjbName().getValue().trim();
                    ejbClass = null;
                    if (bean.isSetEjbClass()) {
                        ejbClassName = bean.getEjbClass().getValue().trim();
                        try {
                            ejbClass = loader.loadClass(ejbClassName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new InvalidDescriptorException("there is no " + ejbClassName + " class", moduleInfo.getModuleName(), ejbName);
                        }
                    }
                    SessionType type = null;
                    if (bean.isSetSessionType()) {
                        type = bean.getSessionType().getValue().trim().equals("Stateful") ? SessionType.STATEFUL : SessionType.STATELESS;
                    }
                    beanInfo = new SessionBeanInfo(ejbName, ejbClass, type);
                } else if (jarBean instanceof MessageDrivenBeanType) {
                    bean = (MessageDrivenBeanType)jarBean;
                    ejbName = bean.getEjbName().getValue();
                    ejbClass = null;
                    if (bean.isSetEjbClass()) {
                        ejbClassName = bean.getEjbClass().getValue().trim();
                        try {
                            ejbClass = loader.loadClass(ejbClassName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new InvalidDescriptorException("there is no " + ejbClassName + " class", moduleInfo.getModuleName(), ejbName);
                        }
                    }
                    beanInfo = new MessageDrivenBeanInfo(ejbName, ejbClass);
                } else if (jarBean instanceof EntityBeanType) {
                    bean = (EntityBeanType)jarBean;
                    ejbName = bean.getEjbName().getValue();
                    ejbClass = null;
                    if (bean.isSetEjbClass()) {
                        ejbClassName = bean.getEjbClass().getValue().trim();
                        try {
                            ejbClass = loader.loadClass(ejbClassName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new InvalidDescriptorException("there is no " + ejbClassName + " class", moduleInfo.getModuleName(), ejbName);
                        }
                    }
                    beanInfo = new EntityBeanInfo(ejbName, ejbClass);
                }
                if (beanInfo == null) continue;
                if (beanMap.containsKey(ejbName)) {
                    throw new InvalidDescriptorException("EJB name duplication error: '" + ejbName + "'", moduleInfo.getModuleName(), ejbName);
                }
                beanInfo.setModuleInfo(moduleInfo);
                beanMap.put(ejbName, beanInfo);
            }
        }
    }

    private static void readAnnotations(ModuleInfo moduleInfo, FileArchive moduleHome, ClassLoader loader, Map<String, BeanInfo> beanMap, Map<String, JeusBeanType> jeusBeanMap) throws InvalidAnnotationException, JeusDeploymentException {
        Class<?> cls;
        Enumeration e = moduleHome.entries();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            if (!entry.endsWith(".class")) continue;
            try {
                EnterpriseBeanType beanType;
                String name;
                String className = entry.substring(0, entry.lastIndexOf(".class")).replace('/', '.');
                cls = loader.loadClass(className);
                SessionType sessionType = null;
                Stateless annotation = cls.getAnnotation(Stateless.class);
                if (annotation != null) {
                    name = annotation.name();
                    beanType = EnterpriseBeanType.SESSION;
                    sessionType = SessionType.STATELESS;
                } else {
                    annotation = cls.getAnnotation(Stateful.class);
                    if (annotation != null) {
                        name = ((Stateful)annotation).name();
                        beanType = EnterpriseBeanType.SESSION;
                        sessionType = SessionType.STATEFUL;
                    } else {
                        annotation = cls.getAnnotation(MessageDriven.class);
                        if (annotation == null) continue;
                        name = ((MessageDriven)annotation).name();
                        beanType = EnterpriseBeanType.MESSAGE_DRIVEN;
                    }
                }
                name = EJBAnnotationProcessor.determineBeanName(name, cls);
                BeanInfo beanInfo = beanMap.get(name);
                if (beanInfo == null) {
                    switch (beanType) {
                        case SESSION: {
                            beanInfo = new SessionBeanInfo(name, cls, sessionType);
                            break;
                        }
                        case MESSAGE_DRIVEN: {
                            beanInfo = new MessageDrivenBeanInfo(name, cls);
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    beanInfo.setModuleInfo(moduleInfo);
                    beanMap.put(name, beanInfo);
                    continue;
                }
                if (beanInfo.getBeanClass() == null) {
                    beanInfo.setBeanClass(cls);
                }
                if (beanType == EnterpriseBeanType.SESSION && ((SessionBeanInfo)beanInfo).getSessionType() == null) {
                    ((SessionBeanInfo)beanInfo).setSessionType(sessionType);
                }
                if (beanInfo.getBeanClass() == cls) continue;
                String msg = "EJB name duplication error: '" + name + "' at " + cls.getName();
                throw new InvalidAnnotationException(msg);
            }
            catch (ClassNotFoundException ex) {
            }
        }
        for (BeanInfo beanInfo : beanMap.values()) {
            cls = beanInfo.getBeanClass();
            if (cls == null) {
                throw new InvalidAnnotationException("ejb-class is not defined for the " + beanInfo.getBeanName());
            }
            String ejbName = beanInfo.getBeanName();
            JeusBeanType jeusBean = jeusBeanMap.get(ejbName);
            beanInfo.setJeusBean(jeusBean);
            EJBAnnotationProcessor ejbAnnProcessor = EJBAnnotationProcessor.getProcessor(moduleInfo, beanInfo);
            if (ejbAnnProcessor == null) continue;
            if (logger.isLoggable(JeusMessage_EJB12._9093_LEVEL)) {
                logger.log(JeusMessage_EJB12._9093_LEVEL, JeusMessage_EJB12._9093, (Object)cls.getName());
            }
            ejbAnnProcessor.process(cls);
        }
    }

    private static void readEjbJarDescriptor(EjbJarType ejbJar, ClassLoader loader, ModuleInfo moduleInfo, Map<String, BeanInfo> beanMap, HashMap<String, JeusBeanType> jeusBeanMap) throws JeusDeploymentException {
        if (logger.isLoggable(JeusMessage_EJB12._9094_LEVEL)) {
            logger.log(JeusMessage_EJB12._9094_LEVEL, JeusMessage_EJB12._9094, (Object)moduleInfo.getModuleName());
        }
        boolean isFull = moduleInfo.metadataComplete;
        EJBDescProcessor ejbDescProcessor = new EJBDescProcessor(moduleInfo);
        SessionDescProcessor sessionDescProcessor = new SessionDescProcessor(moduleInfo);
        MDBDescProcessor mdbDescProcessor = new MDBDescProcessor(moduleInfo);
        EntityDescProcessor entityDescProcessor = new EntityDescProcessor(moduleInfo);
        EnterpriseBeansType enterpriseBeans = ejbJar.getEnterpriseBeans();
        if (enterpriseBeans != null) {
            String ejbName = null;
            for (Object jarBean : enterpriseBeans.getSessionOrEntityOrMessageDriven()) {
                try {
                    BeanInfo beanInfo;
                    SessionBeanType bean;
                    if (jarBean instanceof SessionBeanType) {
                        bean = (SessionBeanType)jarBean;
                        ejbName = bean.getEjbName().getValue();
                        beanInfo = beanMap.get(ejbName);
                        sessionDescProcessor.process(bean, (SessionBeanInfo)beanInfo);
                        continue;
                    }
                    if (jarBean instanceof MessageDrivenBeanType) {
                        bean = (MessageDrivenBeanType)jarBean;
                        ejbName = bean.getEjbName().getValue();
                        beanInfo = beanMap.get(ejbName);
                        mdbDescProcessor.process((MessageDrivenBeanType)bean, (MessageDrivenBeanInfo)beanInfo);
                        continue;
                    }
                    if (!(jarBean instanceof EntityBeanType)) continue;
                    bean = (EntityBeanType)jarBean;
                    ejbName = bean.getEjbName().getValue();
                    beanInfo = beanMap.get(ejbName);
                    JeusBeanType jeusBean = jeusBeanMap.get(ejbName);
                    if (jeusBean == null) {
                        jeusBean = ModuleInfo.createJeusBean(beanInfo);
                        jeusBeanMap.put(ejbName, jeusBean);
                    }
                    entityDescProcessor.process((EntityBeanType)bean, (EntityBeanInfo)beanInfo, jeusBean);
                }
                catch (InvalidDescriptorException e) {
                    e.setModuleName(moduleInfo.getModuleName());
                    e.setComponentName(ejbName);
                    throw e;
                }
            }
        } else if (isFull) {
            throw new InvalidDescriptorException("There is no enterprise-beans", moduleInfo.getModuleName(), null);
        }
        ejbDescProcessor.process(ejbJar, beanMap);
    }

    private static JeusBeanType createJeusBean(BeanInfo beanInfo) {
        JeusBeanType jeusBean = null;
        try {
            jeusBean = jeusDDObjectFactory.createJeusBeanType();
            jeusBean.setEjbName(beanInfo.getBeanName());
            jeusBean.fillDefault();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return jeusBean;
    }

    private static List<RelationPair> pairRelation(RelationshipsType jarRelationType, List<EjbRelationMapType> ddRelations) throws InvalidDescriptorException {
        ArrayList<RelationPair> relationList = new ArrayList<RelationPair>();
        if (jarRelationType == null) {
            return relationList;
        }
        HashMap<String, EjbRelationMapType> ddRelationMap = new HashMap<String, EjbRelationMapType>();
        if (ddRelations != null) {
            for (EjbRelationMapType jeusRelationType : ddRelations) {
                String relationName = jeusRelationType.getRelationName();
                EjbRelationMapType bean = ddRelationMap.put(relationName, jeusRelationType);
                if (bean == null) continue;
                throw new InvalidDescriptorException("duplicated relation description in jeus-ejb-dd.xml : " + jeusRelationType.getRelationName());
            }
        }
        List jarRelations = jarRelationType.getEjbRelation();
        for (EjbRelationType relationType : jarRelations) {
            jeus.xml.binding.j2ee.String relationNameType = relationType.getEjbRelationName();
            try {
                if (relationNameType != null) {
                    String relationName = relationNameType.getValue();
                    EjbRelationMapType jeusRelation = (EjbRelationMapType)ddRelationMap.get(relationName);
                    relationList.add(RelationPair.createRelationPair(relationType, jeusRelation));
                    ddRelationMap.remove(relationName);
                    continue;
                }
                relationList.add(RelationPair.createRelationPair(relationType, null));
            }
            catch (JAXBException e) {
                throw new InvalidDescriptorException(e);
            }
        }
        if (ddRelationMap.size() > 0) {
            throw new InvalidDescriptorException("there are redundent relation descriptions in jeus-ejb-dd.xml");
        }
        return relationList;
    }

    public EJBModule getModule() {
        return this.module;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getAppName() {
        return this.appName;
    }

    public List<BeanInfo> getBeanList() {
        return this.beanList;
    }

    public List<RelationPair> getRelationPairList() {
        return this.relationList;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public WebservicesPair getWebservicesPair() {
        return this.webservicesPair;
    }

    public void setWebservicesPair(WebservicesPair webservicesPair) {
        this.webservicesPair = webservicesPair;
    }

    public boolean isFastDeploy() {
        return this.ejbDD.getModuleInfo().isFastDeploy();
    }

    public boolean isKeepGenerated() {
        return this.ejbDD.getModuleInfo().isKeepGenerated();
    }

    public TransactionAttributeType getUnspecifiedTransactionType() {
        TransAttributeType txAttrType = this.ejbDD.getModuleInfo().getUnspecifiedContainerTransaction();
        if (txAttrType == null) {
            return null;
        }
        switch (txAttrType) {
            case NOT_SUPPORTED: {
                return TransactionAttributeType.NOT_SUPPORTED;
            }
            case SUPPORTS: {
                return TransactionAttributeType.SUPPORTS;
            }
            case REQUIRED: {
                return TransactionAttributeType.REQUIRED;
            }
            case REQUIRES_NEW: {
                return TransactionAttributeType.REQUIRES_NEW;
            }
            case MANDATORY: {
                return TransactionAttributeType.MANDATORY;
            }
            case NEVER: {
                return TransactionAttributeType.NEVER;
            }
        }
        assert (false);
        return null;
    }

    public String getClientJarName() {
        return this.clientJar;
    }

    public List<SecurityRoleType> getSecurityRoles() {
        if (this.securityRoles == null) {
            return Collections.EMPTY_LIST;
        }
        return this.securityRoles;
    }

    public List<MethodPermissionType> getMethodPermission() {
        if (this.methodPermissions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.methodPermissions;
    }

    public ExcludeListType getExcludeList() {
        return this.excludeList;
    }

    public List<ContainerTransactionType> getContainerTransaction() {
        if (this.containerTransactions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.containerTransactions;
    }

    public void setClientJar(String clientJar) {
        this.clientJar = clientJar;
    }

    public void setContainerTransactions(List<ContainerTransactionType> containerTransactions) {
        this.containerTransactions = containerTransactions;
    }

    public void setExcludeList(ExcludeListType excludeList) {
        this.excludeList = excludeList;
    }

    public void setMethodPermissions(List<MethodPermissionType> methodPermissions) {
        this.methodPermissions = methodPermissions;
    }

    public void setSecurityRoles(List<SecurityRoleType> securityRoles) {
        this.securityRoles = securityRoles;
    }

    public void putInterceptorInfo(Class interceptorClass, InterceptorInfo info) {
        this.interceptors.put(interceptorClass, info);
    }

    public InterceptorInfo getInterceptorInfo(Class interceptorClass) {
        return this.interceptors.get(interceptorClass);
    }

    public Collection<InterceptorInfo> getInterceptorInfos() {
        return Collections.unmodifiableCollection(this.interceptors.values());
    }

    public InterceptorBindingInfo getDefaultInterceptorBinding() {
        return this.defaultInterceptorBinding;
    }

    public void setDefaultInterceptorBinding(InterceptorBindingInfo binding) {
        this.defaultInterceptorBinding = binding;
    }

    public EjbJarType getStandardDD() {
        return this.ejbJar;
    }

    public JeusEjbDdType getRuntimeDD() {
        return this.ejbDD;
    }

    public BeanInfo getBeanInfo(String beanName) {
        return this.beanMap.get(beanName);
    }

    public String getMessageDestinationJndiName(String destName) {
        String jndiName;
        JndiRefType type = this.ejbDD.getMessageDestination();
        if (type != null) {
            List messageDestinationList = type.getJndiInfo();
            for (Object aMessageDestinationList : messageDestinationList) {
                JndiInfoType messageDestinationType = (JndiInfoType)aMessageDestinationList;
                if (!destName.equals(messageDestinationType.getRefName().trim()) || (jndiName = messageDestinationType.getExportName().trim()).equals("")) continue;
                return jndiName;
            }
        }
        jndiName = this.messageDestinationList.get(destName);
        return jndiName;
    }

    public void setModuleDomain(String moduleDomain) {
        this.moduleDomain = moduleDomain;
    }

    public String getModuleDomain() {
        return this.moduleDomain;
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public double getEjbVersion() {
        return this.ejbVersion;
    }

    public void setApplicationExceptionMap(Map<String, Boolean> map) {
        this.appExceptionMap = map;
    }

    public boolean isAppException(Throwable exception) {
        Boolean rollback = this.appExceptionMap.get(exception.getClass().getName());
        if (rollback != null) {
            return true;
        }
        if (!this.metadataComplete) {
            return exception.getClass().isAnnotationPresent(ApplicationException.class);
        }
        return false;
    }

    public boolean getAppExceptionRollbackRequired(Throwable exception) {
        ApplicationException appEx;
        Boolean rollback = this.appExceptionMap.get(exception.getClass().getName());
        if (rollback != null) {
            return rollback;
        }
        if (!this.metadataComplete && (appEx = exception.getClass().getAnnotation(ApplicationException.class)) != null) {
            return appEx.rollback();
        }
        return false;
    }

    public List<BeanPair> getBeanPairList() {
        ArrayList<BeanPair> beanPairList = new ArrayList<BeanPair>();
        for (BeanInfo beanInfo : this.beanList) {
            if (!(beanInfo instanceof EntityBeanInfo)) continue;
            beanPairList.add(((EntityBeanInfo)beanInfo).getBeanPair());
        }
        return beanPairList;
    }

    public String getLocalExportName(EjbLocalRefType ejbRefType) {
        String home = ejbRefType.getLocalHome().getValue();
        String remote = ejbRefType.getLocal().getValue();
        for (BeanInfo beanInfo : this.beanList) {
            String ejbLocalHomeClassName = beanInfo.getEJBLocalHomeClassName();
            if (ejbLocalHomeClassName == null || !ejbLocalHomeClassName.equals(home) || !beanInfo.getEJBLocalObjectClassName().equals(remote)) continue;
            return beanInfo.getLocalExportName();
        }
        return null;
    }

    public void addMessageDestination(String name, String mappedName) {
        this.messageDestinationList.put(name, mappedName);
    }

    public List<BeanInfo> getAllModule() {
        return this.beanList;
    }

    public String getArchiveUri() {
        return this.module.getRootArchive().getArchiveUri();
    }
}

