/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.TransactionAttributeType;
import jeus.ejb.MethodInterfaceType;

public class TxAttrTable {
    protected TransactionAttributeType defaultAttribute;
    protected Map<String, TransactionAttributeType> methodAttrMap = new HashMap<String, TransactionAttributeType>();

    public TxAttrTable(TransactionAttributeType defaultAttribute) {
        this.defaultAttribute = defaultAttribute;
    }

    public void set(MethodInterfaceType methodIntf, TransactionAttributeType txAttr) {
        this.set(null, null, methodIntf, txAttr);
    }

    public void set(String name, MethodInterfaceType methodIntf, TransactionAttributeType txAttr) {
        this.set(name, null, methodIntf, txAttr);
    }

    public void set(String name, Class[] paramTypes, MethodInterfaceType methodIntf, TransactionAttributeType txAttr) {
        String key = this.makeKey(name, paramTypes, methodIntf);
        this.methodAttrMap.put(key, txAttr);
    }

    public void remove(String name, Class[] paramTypes, MethodInterfaceType methodIntf) {
        if (name == null && paramTypes == null) {
            if (methodIntf == null) {
                this.methodAttrMap.clear();
            } else {
                this.removeEntryFromMethodAttrMap(methodIntf.name());
            }
        } else if (name != null && paramTypes == null) {
            if (methodIntf == null) {
                this.removeEntryFromMethodAttrMap(name);
            } else {
                this.removeEntryFromMethodAttrMap(name + "/" + methodIntf.name());
            }
        } else if (name == null && paramTypes != null) {
            StringBuffer pramSig = new StringBuffer();
            pramSig.append("(");
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    pramSig.append(",");
                }
                pramSig.append(paramTypes[i].getName());
            }
            pramSig.append(")");
            if (methodIntf != null) {
                pramSig.append("/").append(methodIntf.name());
            }
            this.removeEntryFromMethodAttrMap(pramSig.toString());
        }
    }

    private void removeEntryFromMethodAttrMap(String key) {
        Iterator<Map.Entry<String, TransactionAttributeType>> iterator = this.methodAttrMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, TransactionAttributeType> entry = iterator.next();
            String aKey = entry.getKey();
            if (aKey.indexOf(key) <= -1) continue;
            iterator.remove();
        }
    }

    public TransactionAttributeType get(Method m, MethodInterfaceType methodIntf) {
        String key;
        TransactionAttributeType txAttr;
        if (methodIntf != null && (txAttr = this.methodAttrMap.get(key = this.makeKey(m.getName(), m.getParameterTypes(), methodIntf))) != null) {
            return txAttr;
        }
        key = this.makeKey(m.getName(), m.getParameterTypes(), null);
        txAttr = this.methodAttrMap.get(key);
        if (txAttr != null) {
            return txAttr;
        }
        if (methodIntf != null && (txAttr = this.methodAttrMap.get(key = this.makeKey(m.getName(), null, methodIntf))) != null) {
            return txAttr;
        }
        key = this.makeKey(m.getName(), null, null);
        txAttr = this.methodAttrMap.get(key);
        if (txAttr != null) {
            return txAttr;
        }
        if (methodIntf != null && (txAttr = this.methodAttrMap.get(key = this.makeKey(null, null, methodIntf))) != null) {
            return txAttr;
        }
        key = this.makeKey(null, null, null);
        txAttr = this.methodAttrMap.get(key);
        if (txAttr != null) {
            return txAttr;
        }
        return this.defaultAttribute;
    }

    private String makeKey(String name, Class[] paramTypes, MethodInterfaceType methodIntf) {
        StringBuffer buf = new StringBuffer();
        if (name == null) {
            buf.append("*");
        } else {
            buf.append(name);
            buf.append("(");
            if (paramTypes == null) {
                buf.append("*");
            } else {
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append(paramTypes[i].getName());
                }
            }
            buf.append(")");
        }
        if (methodIntf != null) {
            buf.append("/").append(methodIntf.name());
        }
        return buf.toString();
    }
}

