/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.AroundInvoke;
import jeus.container.annotation.AnnotationProcessor;
import jeus.deploy.InvalidAnnotationException;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.metadata.InterceptorInfo;

public class InterceptorAnnotationProcessor
implements AnnotationProcessor {
    private InterceptorInfo interceptorInfo;

    public InterceptorAnnotationProcessor(Class cls) {
        this.interceptorInfo = new InterceptorInfo(cls);
    }

    public InterceptorInfo getInterceptorInfo() {
        return this.interceptorInfo;
    }

    public void processClass(Class cls) throws InvalidAnnotationException {
    }

    public void processField(Field field) throws InvalidAnnotationException {
    }

    public void processConstructor(Constructor constructor) throws InvalidAnnotationException {
    }

    public void processMethod(Method m) throws InvalidAnnotationException {
        if (m.isAnnotationPresent(AroundInvoke.class)) {
            this.interceptorInfo.addAroundInvokeMethod(m);
        }
        if (m.isAnnotationPresent(PostConstruct.class)) {
            this.interceptorInfo.addCallbackMethod(CallbackType.POST_CONSTRUCT, m);
        }
        if (m.isAnnotationPresent(PreDestroy.class)) {
            this.interceptorInfo.addCallbackMethod(CallbackType.PRE_DESTROY, m);
        }
        if (m.isAnnotationPresent(PrePassivate.class)) {
            this.interceptorInfo.addCallbackMethod(CallbackType.PRE_PASSIVATE, m);
        }
        if (m.isAnnotationPresent(PostActivate.class)) {
            this.interceptorInfo.addCallbackMethod(CallbackType.POST_ACTIVATE, m);
        }
    }

    public void processFinished() {
    }
}

