/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata.annotation;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import jeus.deploy.InvalidAnnotationException;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.MessageDrivenBeanInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.metadata.annotation.EJBAnnotationProcessor;
import jeus.util.StringUtil;

public class MDBAnnotationProcessor
extends EJBAnnotationProcessor {
    public MDBAnnotationProcessor(ModuleInfo moduleInfo, BeanInfo beanInfo) {
        super(moduleInfo, beanInfo);
        this.securityProcessor.setIgnoreMethodLevel(true);
    }

    public void processClass(Class cls) throws InvalidAnnotationException {
        assert (this.beanInfo != null);
        MessageDrivenBeanInfo mdbInfo = (MessageDrivenBeanInfo)this.beanInfo;
        MessageDriven messageDriven = cls.getAnnotation(MessageDriven.class);
        if (messageDriven != null) {
            Class listener = messageDriven.messageListenerInterface();
            if (listener != null && listener != Object.class) {
                mdbInfo.setListenerInterface(listener);
            }
            for (ActivationConfigProperty prop : messageDriven.activationConfig()) {
                mdbInfo.addActivationConfigProperty(prop.propertyName(), prop.propertyValue());
            }
            String mappedName = messageDriven.mappedName();
            if (!StringUtil.isNullOrEmpty((String)mappedName)) {
                mdbInfo.setMappedJndiName(mappedName.trim());
            }
        }
        this.processInterceptors(cls, this.beanInfo);
        this.processTransactionManagement(cls, this.beanInfo);
    }
}

