/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.metadata.descriptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Timer;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.InvocationContext;
import jeus.container.namingenv.EnvironmentDescriptorProcessor;
import jeus.container.namingenv.JndiEnvironmentRefsGroup;
import jeus.container.namingenv.NamingEnvironment;
import jeus.deploy.InvalidDescriptorException;
import jeus.deploy.JeusDeploymentException;
import jeus.ejb.EnterpriseBeanType;
import jeus.ejb.MethodInterfaceType;
import jeus.ejb.ReplicationMode;
import jeus.ejb.interceptor.CallbackType;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.EJBMetadataProcessor;
import jeus.ejb.metadata.EntityBeanInfo;
import jeus.ejb.metadata.InterceptorBindingInfo;
import jeus.ejb.metadata.InterceptorInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.util.MethodTable;
import jeus.util.StringUtil;
import jeus.xml.binding.j2ee.ApplicationExceptionType;
import jeus.xml.binding.j2ee.AroundInvokeType;
import jeus.xml.binding.j2ee.AssemblyDescriptorType;
import jeus.xml.binding.j2ee.ContainerTransactionType;
import jeus.xml.binding.j2ee.EjbJarType;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.InterceptorBindingType;
import jeus.xml.binding.j2ee.InterceptorType;
import jeus.xml.binding.j2ee.InterceptorsType;
import jeus.xml.binding.j2ee.JavaTypeType;
import jeus.xml.binding.j2ee.LifecycleCallbackType;
import jeus.xml.binding.j2ee.MessageDestinationType;
import jeus.xml.binding.j2ee.MethodIntfType;
import jeus.xml.binding.j2ee.MethodParamsType;
import jeus.xml.binding.j2ee.MethodType;
import jeus.xml.binding.j2ee.NamedMethodType;
import jeus.xml.binding.j2ee.PathType;
import jeus.xml.binding.j2ee.TransAttributeType;
import jeus.xml.binding.j2ee.TransactionTypeType;
import jeus.xml.binding.jeusDD.BeanlistType;
import jeus.xml.binding.jeusDD.ClusteringType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;
import jeus.xml.binding.jeusDD.MethodParamType;
import jeus.xml.binding.jeusDD.ReplicationMethodsType;
import jeus.xml.binding.jeusDD.ReplicationModeType;
import jeus.xml.binding.jeusDD.ReplicationOfMethodType;
import jeus.xml.binding.jeusDD.ReplicationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBDescProcessor
extends EJBMetadataProcessor {
    protected ModuleInfo moduleInfo;
    protected ClassLoader loader;

    public EJBDescProcessor(ModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
        this.loader = moduleInfo.getLoader();
    }

    public ModuleInfo process(EjbJarType ejbJar, Map<String, BeanInfo> beanMap) throws JeusDeploymentException {
        PathType ejbClientJar;
        AssemblyDescriptorType assemblyDescriptor;
        InterceptorsType interceptors = ejbJar.getInterceptors();
        if (interceptors != null) {
            this.processInterceptors(interceptors, this.moduleInfo);
        }
        if ((assemblyDescriptor = ejbJar.getAssemblyDescriptor()) != null) {
            this.moduleInfo.setSecurityRoles(assemblyDescriptor.getSecurityRole());
            this.moduleInfo.setMethodPermissions(assemblyDescriptor.getMethodPermission());
            List containerTransactions = assemblyDescriptor.getContainerTransaction();
            this.moduleInfo.setContainerTransactions(containerTransactions);
            this.processContainerTransactions(containerTransactions, beanMap);
            List interceptorBindingList = assemblyDescriptor.getInterceptorBinding();
            this.processInterceptorBindings(interceptorBindingList, this.moduleInfo, beanMap);
            List msgDestList = assemblyDescriptor.getMessageDestination();
            for (MessageDestinationType msgDest : msgDestList) {
                String name = msgDest.getMessageDestinationName().getValue();
                String mappedName = null;
                if (msgDest.isSetMappedName()) {
                    mappedName = msgDest.getMappedName().getValue();
                }
                this.moduleInfo.addMessageDestination(name, mappedName);
            }
            this.moduleInfo.setExcludeList(assemblyDescriptor.getExcludeList());
            List appExceptionList = assemblyDescriptor.getApplicationException();
            if (appExceptionList.size() > 0) {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                for (ApplicationExceptionType applicationExceptionType : appExceptionList) {
                    boolean rollback = false;
                    if (applicationExceptionType.isSetRollback()) {
                        rollback = applicationExceptionType.getRollback().isValue();
                    }
                    map.put(applicationExceptionType.getExceptionClass().getValue(), rollback);
                }
                this.moduleInfo.setApplicationExceptionMap(map);
            }
        }
        if ((ejbClientJar = ejbJar.getEjbClientJar()) != null) {
            this.moduleInfo.setClientJar(ejbClientJar.getValue());
        }
        return this.moduleInfo;
    }

    /*
     * Unable to fully structure code
     */
    private void processInterceptorBindings(List<InterceptorBindingType> interceptorBindingList, ModuleInfo moduleInfo, Map<String, BeanInfo> beanMap) throws JeusDeploymentException {
        for (InterceptorBindingType interceptorBinding : interceptorBindingList) {
            ejbName = interceptorBinding.getEjbName().getValue().trim();
            fullOrder = false;
            if (interceptorBinding.isSetInterceptorOrder()) {
                classList = interceptorBinding.getInterceptorOrder().getInterceptorClass();
                fullOrder = true;
            } else {
                classList = interceptorBinding.getInterceptorClass();
            }
            if (ejbName.equals("*")) {
                binding = new InterceptorBindingInfo();
                this.addInterceptorList(classList, moduleInfo, binding);
                moduleInfo.setDefaultInterceptorBinding(binding);
                continue;
            }
            beanInfo = beanMap.get(ejbName);
            if (beanInfo == null) {
                throw new InvalidDescriptorException("ejbName " + ejbName + " is invalid", moduleInfo.getModuleName(), ejbName);
            }
            binding = null;
            if (interceptorBinding.isSetMethod()) {
                try {
                    method = this.getMethod(beanInfo.getBeanClass(), interceptorBinding.getMethod());
                    binding = beanInfo.getMethodInterceptorBinding(method);
                    if (binding != null) ** GOTO lbl32
                    binding = new InterceptorBindingInfo();
                    beanInfo.setMethodInterceptorBinding(method, binding);
                }
                catch (NoSuchMethodException e) {
                    throw new InvalidDescriptorException(e, moduleInfo.getModuleName(), ejbName);
                }
            } else {
                binding = beanInfo.getClassInterceptorBinding();
                if (binding == null) {
                    binding = new InterceptorBindingInfo();
                    beanInfo.setClassInterceptorBinding(binding);
                }
            }
lbl32:
            // 5 sources

            if (fullOrder) {
                binding.setFullOrder(true);
                binding.resetInterceptorList();
            }
            this.addInterceptorList(classList, moduleInfo, binding);
            if (interceptorBinding.isSetExcludeDefaultInterceptors()) {
                binding.setExcludeDefaultInterceptors(interceptorBinding.getExcludeDefaultInterceptors().isValue());
            }
            if (!interceptorBinding.isSetExcludeClassInterceptors()) continue;
            binding.setExcludeClassInterceptors(interceptorBinding.getExcludeClassInterceptors().isValue());
        }
    }

    private void addInterceptorList(List<FullyQualifiedClassType> classList, ModuleInfo moduleInfo, InterceptorBindingInfo binding) throws JeusDeploymentException {
        boolean metadataComplete = moduleInfo.isMetadataComplete();
        try {
            for (FullyQualifiedClassType clsType : classList) {
                Class cls = this.getClassOf(clsType);
                InterceptorInfo info = moduleInfo.getInterceptorInfo(cls);
                if (info == null) {
                    info = this.composeInterceptorInfo(cls, metadataComplete);
                    moduleInfo.putInterceptorInfo(cls, info);
                }
                binding.addInterceptor(info);
            }
        }
        catch (ClassNotFoundException e) {
            throw new InvalidDescriptorException(e, moduleInfo.getModuleName());
        }
    }

    private void processInterceptors(InterceptorsType interceptors, ModuleInfo moduleInfo) throws JeusDeploymentException {
        boolean full = moduleInfo.isMetadataComplete();
        List interceptorList = interceptors.getInterceptor();
        for (InterceptorType interceptor : interceptorList) {
            try {
                Class cls = this.getClassOf(interceptor.getInterceptorClass());
                InterceptorInfo info = moduleInfo.getInterceptorInfo(cls);
                if (info == null) {
                    info = full ? new InterceptorInfo(cls) : this.composeInterceptorInfo(cls, false);
                    moduleInfo.putInterceptorInfo(cls, info);
                }
                if (interceptor.isSetAroundInvoke()) {
                    this.processAroundInvokeMethod(interceptor.getAroundInvoke(), cls, info);
                }
                if (interceptor.isSetPostConstruct()) {
                    this.processLifecycleCallbackMethod(CallbackType.POST_CONSTRUCT, interceptor.getPostConstruct(), new Class[]{InvocationContext.class}, cls, info);
                }
                if (interceptor.isSetPreDestroy()) {
                    this.processLifecycleCallbackMethod(CallbackType.PRE_DESTROY, interceptor.getPreDestroy(), new Class[]{InvocationContext.class}, cls, info);
                }
                if (interceptor.isSetPostActivate()) {
                    this.processLifecycleCallbackMethod(CallbackType.POST_ACTIVATE, interceptor.getPostActivate(), new Class[]{InvocationContext.class}, cls, info);
                }
                if (interceptor.isSetPrePassivate()) {
                    this.processLifecycleCallbackMethod(CallbackType.PRE_PASSIVATE, interceptor.getPrePassivate(), new Class[]{InvocationContext.class}, cls, info);
                }
                NamingEnvironment env = info.getNamingEnvironment();
                JndiEnvironmentRefsGroup envRefs = new JndiEnvironmentRefsGroup();
                envRefs.simpleEnvEntryList = interceptor.getEnvEntry();
                envRefs.ejbRefList = interceptor.getEjbRef();
                envRefs.ejbLocalRefList = interceptor.getEjbLocalRef();
                envRefs.serviceRefList = interceptor.getServiceRef();
                envRefs.resourceRefList = interceptor.getResourceRef();
                envRefs.resourceEnvRefList = interceptor.getResourceEnvRef();
                envRefs.messageDestinationRefList = interceptor.getMessageDestinationRef();
                envRefs.persistenceContextRefList = interceptor.getPersistenceContextRef();
                envRefs.persistenceUnitRefList = interceptor.getPersistenceUnitRef();
                EnvironmentDescriptorProcessor envProcessor = new EnvironmentDescriptorProcessor(env, this.loader);
                try {
                    envProcessor.process(envRefs);
                    info.setNamingEnvironment(envProcessor.getNamingEnvironment());
                }
                catch (InvalidDescriptorException e) {
                    throw new InvalidDescriptorException(e.getMessage(), e, moduleInfo.getModuleName());
                }
            }
            catch (ClassNotFoundException e) {
                throw new InvalidDescriptorException(e, moduleInfo.getModuleName());
            }
        }
    }

    private void processContainerTransactions(List<ContainerTransactionType> containerTransactions, Map<String, BeanInfo> beanMap) throws InvalidDescriptorException {
        if (containerTransactions == null) {
            return;
        }
        for (ContainerTransactionType containerTx : containerTransactions) {
            TransactionAttributeType txAttr = this.getTransactionAttribute(containerTx.getTransAttribute());
            List methods = containerTx.getMethod();
            for (MethodType method : methods) {
                try {
                    String ejbName = method.getEjbName().getValue().trim();
                    BeanInfo beanInfo = beanMap.get(ejbName);
                    if (beanInfo == null) {
                        throw new InvalidDescriptorException("Unknown ejb-name '" + ejbName + "' in container-transaction", ejbName);
                    }
                    if (beanInfo instanceof EntityBeanInfo || beanInfo.isBeanManagedTx()) continue;
                    String name = method.getMethodName().getValue();
                    if (name.equals("*")) {
                        name = null;
                    }
                    MethodInterfaceType methodIntf = this.getMethodInterfaceType(method.getMethodIntf());
                    Class[] paramTypes = this.getMethodParameters(method.getMethodParams());
                    if (name == null || paramTypes == null) {
                        beanInfo.getTxAttrTable().remove(name, paramTypes, methodIntf);
                    }
                    beanInfo.getTxAttrTable().set(name, paramTypes, methodIntf, txAttr);
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidDescriptorException(e);
                }
            }
        }
    }

    protected TransactionAttributeType getTransactionAttribute(TransAttributeType transAttrType) {
        if (transAttrType != null) {
            String transAttr = transAttrType.getValue();
            if (transAttr.equals("NotSupported")) {
                return TransactionAttributeType.NOT_SUPPORTED;
            }
            if (transAttr.equals("Supports")) {
                return TransactionAttributeType.SUPPORTS;
            }
            if (transAttr.equals("Required")) {
                return TransactionAttributeType.REQUIRED;
            }
            if (transAttr.equals("RequiresNew")) {
                return TransactionAttributeType.REQUIRES_NEW;
            }
            if (transAttr.equals("Mandatory")) {
                return TransactionAttributeType.MANDATORY;
            }
            if (transAttr.equals("Never")) {
                return TransactionAttributeType.NEVER;
            }
        }
        return null;
    }

    protected MethodInterfaceType getMethodInterfaceType(MethodIntfType methodIntf) {
        if (methodIntf != null) {
            return MethodInterfaceType.valueOf(methodIntf.getValue());
        }
        return null;
    }

    protected Method getMethod(Class cls, NamedMethodType namedMethod) throws NoSuchMethodException {
        try {
            String name = namedMethod.getMethodName().getValue().trim();
            MethodParamsType methodParams = namedMethod.getMethodParams();
            if (methodParams != null) {
                Class[] paramTypes = this.getMethodParameters(methodParams);
                return cls.getMethod(name, paramTypes);
            }
            for (Method method : cls.getMethods()) {
                if (!name.equals(method.getName())) continue;
                return method;
            }
            throw new NoSuchMethodException("There is no " + name + "(...) method in the " + cls.getName());
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchMethodException(e.getMessage());
        }
    }

    protected Method getMethod(Class cls, NamedMethodType namedMethod, Class[] paramTypesHint) throws NoSuchMethodException {
        try {
            String name = namedMethod.getMethodName().getValue().trim();
            MethodParamsType methodParams = namedMethod.getMethodParams();
            if (methodParams != null) {
                Class[] paramTypes = this.getMethodParameters(methodParams);
                return cls.getMethod(name, paramTypes);
            }
            assert (paramTypesHint != null);
            return cls.getMethod(name, paramTypesHint);
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchMethodException(e.getMessage());
        }
    }

    protected Class[] getMethodParameters(MethodParamsType params) throws ClassNotFoundException {
        Class[] paramTypes = null;
        if (params != null) {
            List paramsList = params.getMethodParam();
            paramTypes = new Class[paramsList.size()];
            for (int i = 0; i < paramTypes.length; ++i) {
                String paramClass = ((JavaTypeType)paramsList.get(i)).getValue().trim();
                paramTypes[i] = StringUtil.getClassFromString((String)paramClass, (ClassLoader)this.loader);
            }
        }
        return paramTypes;
    }

    protected Class getPrimitiveType(String className) {
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }

    protected Class getClassOf(FullyQualifiedClassType classType) throws ClassNotFoundException {
        return Class.forName(classType.getValue().trim(), false, this.loader);
    }

    protected String[] getClassNamesOf(List<FullyQualifiedClassType> list) {
        if (list != null && list.size() > 0) {
            String[] classes = new String[list.size()];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = list.get(i).getValue();
            }
            return classes;
        }
        return null;
    }

    protected Class[] getClassesOf(List<FullyQualifiedClassType> list) throws ClassNotFoundException {
        if (list != null && list.size() > 0) {
            Class[] classes = new Class[list.size()];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = Class.forName(list.get(i).getValue().trim(), false, this.loader);
            }
            return classes;
        }
        return null;
    }

    protected void processTransactionType(TransactionTypeType txType, BeanInfo beanInfo) {
        if (txType != null) {
            beanInfo.setBeanManagedTx(txType.getValue().equals("Bean"));
        }
    }

    protected void processTimeoutMethod(NamedMethodType method, Class ejbClass, BeanInfo beanInfo) throws InvalidDescriptorException {
        if (method != null) {
            try {
                Method m = this.getMethod(ejbClass, method, new Class[]{Timer.class});
                if (!this.isValidTimeoutMethod(m)) {
                    throw new InvalidDescriptorException("Invalid Timeout method", beanInfo.getModuleName(), beanInfo.getBeanName());
                }
                beanInfo.setTimeoutMethod(m);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidDescriptorException("there is no such method", beanInfo.getModuleName(), beanInfo.getBeanName());
            }
        }
    }

    protected void processLifecycleCallbackMethod(CallbackType type, List<LifecycleCallbackType> callbacks, Class[] methodParamTypes, Class defaultCls, InterceptorInfo info) throws InvalidDescriptorException {
        for (LifecycleCallbackType callback : callbacks) {
            try {
                Class cls = defaultCls;
                if (callback.isSetLifecycleCallbackClass()) {
                    cls = this.getClassOf(callback.getLifecycleCallbackClass());
                }
                String methodName = callback.getLifecycleCallbackMethod().getValue().trim();
                Method method = cls.getDeclaredMethod(methodName, methodParamTypes);
                info.addCallbackMethod(type, method);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidDescriptorException(e);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidDescriptorException(e);
            }
        }
    }

    protected void processAroundInvokeMethod(List<AroundInvokeType> aroundInvokes, Class defaultCls, InterceptorInfo info) throws InvalidDescriptorException {
        for (AroundInvokeType aroundInvoke : aroundInvokes) {
            try {
                Class cls = defaultCls;
                if (aroundInvoke.isSetClazz()) {
                    cls = this.getClassOf(aroundInvoke.getClazz());
                }
                String methodName = aroundInvoke.getMethodName().getValue().trim();
                Method method = cls.getDeclaredMethod(methodName, InvocationContext.class);
                info.addAroundInvokeMethod(method);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidDescriptorException(e);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidDescriptorException(e);
            }
        }
    }

    public static HashMap<String, JeusBeanType> getJeusBeanMap(JeusEjbDdType ejbDD) throws InvalidDescriptorException {
        HashMap<String, JeusBeanType> jeusBeanMap = new HashMap<String, JeusBeanType>();
        BeanlistType beanlist = ejbDD.getBeanlist();
        if (beanlist != null) {
            List jeusBeans = beanlist.getJeusBean();
            for (JeusBeanType jeusBean : jeusBeans) {
                String ejbName = jeusBean.getEjbName();
                if (jeusBeanMap.put(ejbName, jeusBean) == null) continue;
                throw new InvalidDescriptorException("duplicated bean ejb-name in jeus-ejb-dd.xml", ejbName);
            }
        }
        return jeusBeanMap;
    }

    public static void processClusteringMetadata(JeusBeanType jeusBean, BeanInfo beanInfo, ClassLoader loader) throws JeusDeploymentException {
        if (beanInfo.getEJBType() != EnterpriseBeanType.SESSION) {
            return;
        }
        ClusteringType cluster = jeusBean.getClustering();
        if (cluster != null && cluster.isSetEnableClustering() && !cluster.isEnableClustering().booleanValue()) {
            beanInfo.setClustered(false);
            return;
        }
        if (cluster != null && cluster.isEnableClustering().booleanValue()) {
            List methods;
            if (cluster.isSetCreateIdempotent()) {
                beanInfo.getHomeIdempotentMethods().add("create", null, cluster.isCreateIdempotent());
            } else if (!beanInfo.isClustered() && ((SessionBeanInfo)beanInfo).isStateless()) {
                beanInfo.getHomeIdempotentMethods().add("create", null, Boolean.TRUE);
            }
            if (cluster.isSetEjbRemoteIdempotentMethod()) {
                methods = cluster.getEjbRemoteIdempotentMethod();
                EJBDescProcessor.processIdempotentMetadata(methods, loader, beanInfo.getRemoteIdempotentMethods(), Boolean.TRUE);
            }
            if (cluster.isSetEjbRemoteIdempotentExcludeMethod()) {
                methods = cluster.getEjbRemoteIdempotentExcludeMethod();
                EJBDescProcessor.processIdempotentMetadata(methods, loader, beanInfo.getRemoteIdempotentMethods(), Boolean.FALSE);
            }
            if (cluster.isSetEjbHomeIdempotentMethod()) {
                methods = cluster.getEjbHomeIdempotentMethod();
                EJBDescProcessor.processIdempotentMetadata(methods, loader, beanInfo.getHomeIdempotentMethods(), Boolean.TRUE);
            }
            if (cluster.isSetEjbHomeIdempotentExcludeMethod()) {
                methods = cluster.getEjbHomeIdempotentExcludeMethod();
                EJBDescProcessor.processIdempotentMetadata(methods, loader, beanInfo.getHomeIdempotentMethods(), Boolean.FALSE);
            }
            if (cluster.isSetReplication()) {
                EJBDescProcessor.processReplicationModeOfMethod(cluster, beanInfo, loader);
            }
            beanInfo.setClustered(true);
        }
    }

    private static void processReplicationModeOfMethod(ClusteringType cluster, BeanInfo beanInfo, ClassLoader loader) throws JeusDeploymentException {
        ReplicationMethodsType methods;
        ReplicationType replicationType = cluster.getReplication();
        MethodTable replicationModeTable = beanInfo.getReplicationModeOfMethods();
        if (replicationType.isSetBeanMode()) {
            beanInfo.setReplicationModeOfBean(EJBDescProcessor.getReplicationMode(replicationType.getBeanMode()));
        }
        MethodTable idempotents = beanInfo.getRemoteIdempotentMethods();
        Set keySet = idempotents.keySet();
        for (Object aKeySet : keySet) {
            String methodIdentifier = (String)aKeySet;
            if (replicationModeTable.getValue(methodIdentifier) != null) continue;
            replicationModeTable.add(methodIdentifier, ReplicationMode.NONE);
        }
        if (replicationType.isSetMethods() && (methods = replicationType.getMethods()).isSetMethod()) {
            String methodName;
            List modeList = methods.getMethod();
            for (ReplicationOfMethodType replicationMode : modeList) {
                methodName = replicationMode.getMethodName();
                if (!methodName.equals("*")) continue;
                replicationModeTable.clear();
                replicationModeTable.add(null, null, EJBDescProcessor.getReplicationMode(replicationMode.getMode()));
                break;
            }
            for (ReplicationOfMethodType replicationMode : modeList) {
                methodName = replicationMode.getMethodName();
                if (methodName.equals("*")) continue;
                ReplicationMode methodMode = EJBDescProcessor.getReplicationMode(replicationMode.getMode());
                jeus.xml.binding.jeusDD.MethodParamsType methodParams = replicationMode.getMethodParams();
                if (methodParams == null) {
                    replicationModeTable.remove(methodName);
                    replicationModeTable.add(methodName, null, methodMode);
                    continue;
                }
                Class[] paramTypes = EJBDescProcessor.getMethodParameters(methodParams, loader, methodName);
                replicationModeTable.remove(methodName, paramTypes);
                replicationModeTable.add(methodName, paramTypes, methodMode);
            }
        }
    }

    private static void processIdempotentMetadata(List<MethodParamType> methods, ClassLoader loader, MethodTable idempotentMethods, Boolean idempotent) throws JeusDeploymentException {
        for (MethodParamType method : methods) {
            String methodName = method.getMethodName();
            jeus.xml.binding.jeusDD.MethodParamsType methodParams = method.getMethodParams();
            if (methodName.equals("*")) {
                idempotentMethods.clear();
                idempotentMethods.add(null, null, idempotent);
                break;
            }
            if (methodParams == null) {
                idempotentMethods.remove(methodName);
                idempotentMethods.add(methodName, null, idempotent);
                continue;
            }
            Class[] paramTypes = EJBDescProcessor.getMethodParameters(methodParams, loader, methodName);
            idempotentMethods.remove(methodName, paramTypes);
            idempotentMethods.add(methodName, paramTypes, idempotent);
        }
    }

    private static ReplicationMode getReplicationMode(ReplicationModeType mode) {
        switch (mode) {
            case SYNC: {
                return ReplicationMode.SYNC;
            }
            case ASYNC: {
                return ReplicationMode.ASYNC;
            }
            case NONE: {
                return ReplicationMode.NONE;
            }
        }
        assert (false) : "Unknown mode " + mode;
        return null;
    }

    private static Class[] getMethodParameters(jeus.xml.binding.jeusDD.MethodParamsType params, ClassLoader loader, String methodName) throws JeusDeploymentException {
        Class[] paramTypes = null;
        try {
            if (params != null) {
                List paramsList = params.getMethodParam();
                paramTypes = new Class[paramsList.size()];
                for (int i = 0; i < paramTypes.length; ++i) {
                    String paramClass = ((String)paramsList.get(i)).trim();
                    paramTypes[i] = StringUtil.getClassFromString((String)paramClass, (ClassLoader)loader);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new JeusDeploymentException("Wrong method-param [" + e.getMessage() + "] of method-name [" + methodName + "] in jeus-ejb-dd.xml" + "; 'method-param' shall be the Java primitive type or valid fully-qualified name.");
        }
        return paramTypes;
    }
}

