/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.persistence.database;

import java.util.ArrayList;
import jeus.ejb.persistence.database.SQLBuilder;
import jeus.ejb.schema.EJBSQLGeneratorException;

public class ExtendedSQLBuilder
extends SQLBuilder {
    String leftTableName;
    String rightTableName;
    ArrayList leftTableColumns = new ArrayList();
    ArrayList rightTableColumns = new ArrayList();
    boolean isRight;
    private String oper;

    public Object clone() {
        ExtendedSQLBuilder builder = (ExtendedSQLBuilder)super.clone();
        builder.leftTableColumns = (ArrayList)this.leftTableColumns.clone();
        builder.rightTableColumns = (ArrayList)this.rightTableColumns.clone();
        return builder;
    }

    protected ExtendedSQLBuilder() {
    }

    public void setTableReferenceForColumns(String lastPathTableReference) {
        if (this.isRight) {
            this.rightTableName = lastPathTableReference;
        } else {
            this.leftTableName = lastPathTableReference;
        }
    }

    public void addColumnNameFollowingTableRef(String columnName) {
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        if (this.isRight) {
            this.rightTableColumns.add(this.rightTableName + "." + columnName + " ");
        } else {
            this.leftTableColumns.add(this.leftTableName + "." + columnName + " ");
        }
    }

    public void addQuestionsToRight() {
        for (int i = 0; i < this.leftTableColumns.size(); ++i) {
            this.rightTableColumns.add("? ");
        }
    }

    public void setOperator(String oper) {
        this.oper = oper;
    }

    public String getSQL() {
        this.generatedSQL.append("( ");
        for (int i = 0; i < this.leftTableColumns.size(); ++i) {
            if (i > 0) {
                this.generatedSQL.append("AND ");
            }
            this.generatedSQL.append(this.leftTableColumns.get(i)).append(this.oper).append(this.rightTableColumns.get(i));
        }
        this.generatedSQL.append(") ");
        return this.generatedSQL.toString();
    }

    public void setRight() {
        this.isRight = true;
    }

    public static SQLBuilder createSQLBuilder(String dbVendor) throws EJBSQLGeneratorException {
        return new ExtendedSQLBuilder();
    }
}

