/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.persistence.database;

import java.util.AbstractList;
import java.util.ArrayList;
import jeus.ejb.persistence.database.CloudscapeSQLBuilder;
import jeus.ejb.persistence.database.DB2SQLBuilder;
import jeus.ejb.persistence.database.InformixSQLBuilder;
import jeus.ejb.persistence.database.MSSqlSQLBuilder;
import jeus.ejb.persistence.database.OracleSQLBuilder;
import jeus.ejb.persistence.database.SybaseSQLBuilder;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.FieldRW;
import jeus.ejb.schema.ejbql.element.EJBQLParseException;
import jeus.util.message.JeusMessage_EJB11;

public class SQLBuilder
implements Cloneable {
    StringBuffer commonWhereClause = new StringBuffer();
    StringBuffer generatedSQL;
    String tableName;
    int[] numElement;
    int currentDepth;
    String markedSQL;
    int markedDepth;
    int prevNumElement;
    static final int TOTAL_DEPTH = 10;
    private int markedNumElement;
    private boolean marked;
    boolean isNeedSeperator = true;
    private boolean isInitialized;

    protected SQLBuilder() {
    }

    public SQLBuilder merge(SQLBuilder builder) {
        this.generatedSQL.append(builder.generatedSQL);
        return this;
    }

    public SQLBuilder merge(String tail) {
        this.generatedSQL.append(tail);
        return this;
    }

    protected void initialize() {
        this.isInitialized = true;
        this.currentDepth = 0;
        this.numElement = new int[10];
        for (int i = 0; i < 10; ++i) {
            this.numElement[i] = 0;
        }
        this.marked = false;
    }

    public void initEmpty() {
        this.initialize();
        this.generatedSQL = new StringBuffer();
    }

    public void addAsteriskToListIfNeeded() {
        if (this.numElement[this.currentDepth] == 0) {
            this.generatedSQL.append("* ");
        }
    }

    public void setCommonWhereClause(ArrayList fieldRWList) {
        this.commonWhereClause = new StringBuffer(" WHERE ");
        for (int i = 0; i < fieldRWList.size(); ++i) {
            if (i > 0) {
                this.commonWhereClause.append(" AND ");
            }
            this.commonWhereClause.append(((CMPFieldRW)fieldRWList.get(i)).getColName()).append(" = ? ");
        }
    }

    public void initCreateTableSQL() {
        this.initialize();
        this.generatedSQL = new StringBuffer("CREATE TABLE ");
    }

    public void setTableName(String tableName) {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(tableName).append(" ");
        this.tableName = tableName;
    }

    public void beginColumnDeclaration() {
        this.beginParenthesis();
    }

    public void beginParenthesis() {
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.stackUp();
        this.generatedSQL.append("( ");
    }

    private void stackUp() {
        ++this.currentDepth;
        this.prevNumElement = this.numElement[this.currentDepth];
        this.numElement[this.currentDepth] = 0;
    }

    public void addColumnDeclaration(String colName, String typeName) {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(colName).append(" ").append(typeName).append(" ");
    }

    public void addNotNullConstraint() {
        this.generatedSQL.append(" NOT NULL ");
    }

    public static SQLBuilder createSQLBuilder(String dbVendor) throws EJBSQLGeneratorException {
        if (dbVendor.equals("oracle")) {
            return new OracleSQLBuilder();
        }
        if (dbVendor.equals("sybase")) {
            return new SybaseSQLBuilder();
        }
        if (dbVendor.equals("mssql")) {
            return new MSSqlSQLBuilder();
        }
        if (dbVendor.equals("db2")) {
            return new DB2SQLBuilder();
        }
        if (dbVendor.equals("cloudscape")) {
            return new CloudscapeSQLBuilder();
        }
        if (dbVendor.equals("informix")) {
            return new InformixSQLBuilder();
        }
        if (dbVendor.equals("mysql") || dbVendor.equals("hsql")) {
            return new SQLBuilder();
        }
        throw new EJBSQLGeneratorException(JeusMessage_EJB11._7126, dbVendor);
    }

    public void beginPrimaryKeyConstraint() {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append(", ");
        }
        this.stackUp();
        this.generatedSQL.append("CONSTRAINT ").append("pk_").append(this.tableName).append(" PRIMARY KEY ( ");
    }

    public void addColumnName(String columnName) {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(columnName).append(" ");
    }

    public void addColumnNameFollowingTableRef(String columnName) {
        if (this.numElement[this.currentDepth] > 0 && this.isNeedSeperator) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(this.tableName).append(".").append(columnName).append(" ");
    }

    public void finishPrimaryKeyConstraint() {
        this.finishParenthesis();
    }

    public void finishParenthesis() {
        --this.currentDepth;
        this.generatedSQL.append(") ");
    }

    public void finishColumnDeclaration() {
        this.finishParenthesis();
    }

    public String getSQL() {
        return this.generatedSQL.toString();
    }

    public void initDeleteTableSQL() {
        this.initialize();
        this.generatedSQL = new StringBuffer("DROP TABLE ");
    }

    public void initInsertSQL() {
        this.initialize();
        this.generatedSQL = new StringBuffer("INSERT INTO ");
    }

    public void beginColumnName() {
        this.beginParenthesis();
    }

    public void addColumnNameByFieldRW(FieldRW[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            String[] colNames = fields[i].getColNames();
            for (int j = 0; j < colNames.length; ++j) {
                String colName = colNames[j];
                if (this.numElement[this.currentDepth] > 0) {
                    this.generatedSQL.append(" , ");
                }
                int n = this.currentDepth;
                this.numElement[n] = this.numElement[n] + 1;
                this.generatedSQL.append(colName).append(" ");
            }
        }
    }

    public void addColumnName(AbstractList columnList) {
        for (int i = 0; i < columnList.size(); ++i) {
            if (this.numElement[this.currentDepth] > 0) {
                this.generatedSQL.append(" , ");
            }
            int n = this.currentDepth;
            this.numElement[n] = this.numElement[n] + 1;
            this.generatedSQL.append(columnList.get(i)).append(" ");
        }
    }

    public void addColumnName(String[] columnList) {
        for (int i = 0; i < columnList.length; ++i) {
            if (this.numElement[this.currentDepth] > 0) {
                this.generatedSQL.append(" , ");
            }
            int n = this.currentDepth;
            this.numElement[n] = this.numElement[n] + 1;
            this.generatedSQL.append(columnList[i]).append(" ");
        }
    }

    public void addColumnNameByFieldRW(ArrayList fieldList) {
        for (int i = 0; i < fieldList.size(); ++i) {
            CMPFieldRW field = (CMPFieldRW)fieldList.get(i);
            if (this.numElement[this.currentDepth] > 0) {
                this.generatedSQL.append(", ");
            }
            int n = this.currentDepth;
            this.numElement[n] = this.numElement[n] + 1;
            this.generatedSQL.append(field.getColName()).append(" ");
        }
    }

    public void finishColumnName() {
        this.finishParenthesis();
    }

    public void beginValues() {
        this.stackUp();
        this.generatedSQL.append("VALUES ( ");
    }

    public void addValueList(int repeat, String value) {
        for (int i = 0; i < repeat; ++i) {
            if (this.numElement[this.currentDepth] > 0) {
                this.generatedSQL.append(",  ");
            }
            this.generatedSQL.append(value);
            int n = this.currentDepth;
            this.numElement[n] = this.numElement[n] + 1;
        }
    }

    public void finishValues() {
        this.finishParenthesis();
    }

    public void initSelectSQL() {
        this.initialize();
        this.generatedSQL = new StringBuffer("SELECT ");
    }

    public void beginFromClause() {
        this.stackUp();
        this.generatedSQL.append("FROM ");
    }

    public void addCommonWhereClause() {
        this.generatedSQL.append(this.commonWhereClause);
    }

    public void addForUpdate() {
        this.generatedSQL.append("FOR UPDATE");
    }

    public void initDeleteSQL() {
        this.initialize();
        this.generatedSQL = new StringBuffer("DELETE FROM ");
    }

    public void beginWhereClause() {
        this.stackUp();
        this.generatedSQL.append("WHERE ");
    }

    public void addWhereQuestion(AbstractList columnList) {
        for (int j = 0; j < columnList.size(); ++j) {
            if (this.numElement[this.currentDepth] > 0) {
                this.generatedSQL.append(" AND ");
            }
            this.generatedSQL.append(columnList.get(j)).append(" = ?");
            int n = this.currentDepth;
            this.numElement[n] = this.numElement[n] + 1;
        }
    }

    public void addWhereQuestion(String[] columnList) {
        for (int j = 0; j < columnList.length; ++j) {
            if (this.numElement[this.currentDepth] > 0) {
                this.generatedSQL.append(" AND ");
            }
            this.generatedSQL.append(columnList[j]).append(" = ?");
            int n = this.currentDepth;
            this.numElement[n] = this.numElement[n] + 1;
        }
    }

    public void initUpdateSQL() {
        this.initialize();
        this.generatedSQL = new StringBuffer("UPDATE ");
    }

    public void beginSetClause() {
        this.stackUp();
        this.generatedSQL.append("SET ");
    }

    public void addSetColumn(String columnName) {
        if (this.numElement[this.currentDepth] > 0 && this.isNeedSeperator) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(columnName).append(" = ? ");
    }

    public void addSetColumn(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (this.numElement[this.currentDepth] > 0) {
                this.generatedSQL.append(", ");
            }
            int n = this.currentDepth;
            this.numElement[n] = this.numElement[n] + 1;
            this.generatedSQL.append(columnNames[i]).append(" = ? ");
        }
    }

    public void addQuestionValues() {
        for (int i = 0; i < this.prevNumElement; ++i) {
            if (i > 0) {
                this.generatedSQL.append(", ");
            }
            this.generatedSQL.append("? ");
        }
    }

    public void mark() {
        this.markedDepth = this.currentDepth;
        this.markedNumElement = this.numElement[this.currentDepth];
        this.markedSQL = this.generatedSQL.toString();
        this.marked = true;
    }

    public void reset() {
        if (this.marked) {
            this.currentDepth = this.markedDepth;
            this.numElement[this.currentDepth] = this.markedNumElement;
            this.generatedSQL = new StringBuffer(this.markedSQL);
        }
    }

    public void addString(String string) {
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(string).append(" ");
    }

    public void finishFromClause() {
        --this.currentDepth;
    }

    public void finishSetClause() {
        --this.currentDepth;
    }

    public void finishWhereClause() {
        --this.currentDepth;
    }

    public int getCurrentElement() {
        return this.numElement[this.currentDepth];
    }

    public Object clone() {
        try {
            SQLBuilder builder = (SQLBuilder)super.clone();
            builder.numElement = new int[this.numElement.length];
            System.arraycopy(this.numElement, 0, builder.numElement, 0, this.numElement.length);
            builder.commonWhereClause = new StringBuffer(this.commonWhereClause.toString());
            if (this.generatedSQL != null) {
                builder.generatedSQL = new StringBuffer(this.generatedSQL.toString());
            }
            return builder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addSetColumn(String colName, String value) {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(colName).append(" = ").append(value).append(" ");
    }

    public void addTableName(String tableName, String newVarName) {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(tableName).append(" ").append(newVarName).append(" ");
    }

    public void addDistinct() {
        this.generatedSQL.append("DISTINCT ");
    }

    public void beginANDCondition() {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append("AND ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.beginParenthesis();
    }

    public void finishANDCondition() {
        this.finishParenthesis();
    }

    public void addANDEqualCondition(String myTableRefName, String myColumnName, String pairTableRefName, String pairColumnName) {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append("AND ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(myTableRefName).append(".").append(myColumnName).append(" = ").append(pairTableRefName).append(".").append(pairColumnName).append(" ");
    }

    public void setTableReferenceForColumns(String lastPathTableReference) {
        this.tableName = lastPathTableReference;
    }

    public void beginORCondition() {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append("OR ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.beginParenthesis();
    }

    public void finishORCondition() {
        this.finishParenthesis();
    }

    public void addCondition(String relationCondition) {
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(relationCondition).append(" ");
    }

    public void beginInCondition(String sql, boolean isNot) {
        this.generatedSQL.append(sql);
        if (isNot) {
            this.generatedSQL.append("NOT IN ");
        } else {
            this.generatedSQL.append("IN ");
        }
        this.beginParenthesis();
    }

    public void addInParameter(String sql) {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(sql).append(" ");
    }

    public void finishInCondition() {
        this.finishParenthesis();
    }

    public void beginLikeCondition(String sql, boolean not) {
        if (not) {
            this.generatedSQL.append(sql).append(" NOT LIKE ");
        } else {
            this.generatedSQL.append(sql).append(" LIKE ");
        }
        this.stackUp();
    }

    public void addLikePattern(String sql) {
        this.generatedSQL.append(sql).append(" ");
    }

    public void addLikeEscape(String sql) {
        this.generatedSQL.append("ESCAPE ").append(sql).append(" ");
    }

    public void finishLikeCondition() {
        --this.currentDepth;
    }

    public void addLiteral(String value) {
        if (this.numElement[this.currentDepth] > 0 && this.isNeedSeperator) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(value).append(" ");
    }

    public void addInputParam(boolean isInteger) {
        this.generatedSQL.append("? ");
    }

    public void addInputParam() {
        this.generatedSQL.append("? ");
    }

    public void addComparisonCondition(String valueString, String typeString, String exprString) {
        this.generatedSQL.append(valueString).append(typeString).append(exprString).append(" ");
    }

    public void beginNotCondition() {
        this.generatedSQL.append("NOT ");
        this.beginParenthesis();
    }

    public void finishNotCondition() {
        this.finishParenthesis();
    }

    public void beginFunc(String funcName) {
        this.isNeedSeperator = false;
        this.generatedSQL.append(funcName);
        this.beginParenthesis();
    }

    public void finishFunc() {
        this.isNeedSeperator = true;
        this.finishParenthesis();
    }

    public void addBetweenExpr(String s1, String s2, String s3, boolean isNot) {
        this.generatedSQL.append(s1);
        if (isNot) {
            this.generatedSQL.append("NOT BETWEEN ");
        } else {
            this.generatedSQL.append("BETWEEN ");
        }
        this.generatedSQL.append(s2).append(" AND ").append(s3).append(" ");
    }

    public void addUnaryExpr(String sql, String typeString) {
        this.generatedSQL.append(typeString).append(sql).append(" ");
    }

    public void beginModFunc() {
        this.beginFunc("MOD");
    }

    public void finishModFunc() {
        this.finishParenthesis();
    }

    public void beginSubstringFunc() {
        this.beginFunc("SUBSTRING");
    }

    public void finishSubstringFunc() {
        this.finishParenthesis();
    }

    public void beginLocateFunc() throws EJBQLParseException {
        this.beginFunc("LOCATE");
    }

    public void finishLocateFunc() {
        this.finishParenthesis();
    }

    public void beginConcatFunc() {
        this.beginFunc("CONCAT");
    }

    public void finishConcatFunc() {
        this.finishParenthesis();
    }

    public void beginCountFunc() {
        this.beginFunc("COUNT");
    }

    public void finishCountFunc() {
        this.finishParenthesis();
    }

    public void beginAggregationFuncation(String funcName) {
        this.generatedSQL.append(funcName);
        this.beginParenthesis();
    }

    public void finishAggregationFuncation() {
        this.finishParenthesis();
    }

    public void beginOrderByClause() {
        this.stackUp();
        this.generatedSQL.append("ORDER BY ");
    }

    public void addOrderByItem(String sql, boolean desc) {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(sql).append(desc ? " DESC " : " ASC ");
    }

    public void finishOrderByClause() {
        --this.currentDepth;
    }

    public void beginExistsCondition(boolean isNot) {
        this.stackUp();
        if (isNot) {
            this.generatedSQL.append("NOT EXISTS ");
        } else {
            this.generatedSQL.append("EXISTS ");
        }
    }

    public void addSubSelectQuery(String subSQL) {
        this.generatedSQL.append("( ").append(subSQL).append(" ) ");
    }

    public void finishExistsCondition() {
        --this.currentDepth;
    }

    public void addIsNullCondition(String sql) {
        this.generatedSQL.append(sql).append(" IS NULL ");
    }

    public void afterSubstringFuncParam1() {
        this.generatedSQL.append(", ");
    }

    public void afterSubstringFuncParam2() {
        this.generatedSQL.append(", ");
    }

    public void afterConcatFuncParam() {
        this.generatedSQL.append(", ");
    }

    public void afterLocateFuncParam1() {
        this.generatedSQL.append(", ");
    }

    public void afterLocateFuncParam2() {
        this.generatedSQL.append(", ");
    }

    public void afterModFuncParam() {
        this.generatedSQL.append(", ");
    }

    public void beginNotExistsCondition() {
        this.stackUp();
        this.generatedSQL.append("NOT EXISTS ");
    }

    public void finishNotExistsCondition() {
        --this.currentDepth;
    }

    public void beginORConditionByUser() {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append("OR ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.stackUp();
    }

    public void finishORConditionByUser() {
        --this.currentDepth;
    }

    public void beginANDConditionByUser() {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append("AND ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.stackUp();
    }

    public void finishANDConditionByUser() {
        --this.currentDepth;
    }

    public void beginGroupByClause() {
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append("GROUP BY ");
        this.stackUp();
    }

    public void addGroupByItem(String sql) {
        if (this.numElement[this.currentDepth] > 0) {
            this.generatedSQL.append(", ");
        }
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append(sql).append(" ");
    }

    public void finishGroupByClause() {
        --this.currentDepth;
    }

    public void beginHavingClause() {
        int n = this.currentDepth;
        this.numElement[n] = this.numElement[n] + 1;
        this.generatedSQL.append("HAVING ");
        this.stackUp();
    }

    public void finishHavingClause() {
        --this.currentDepth;
    }

    public void beginUniqueCondition(boolean not) {
        this.stackUp();
        if (not) {
            this.generatedSQL.append("NOT EXISTS ");
        } else {
            this.generatedSQL.append("EXISTS ");
        }
    }

    public void finishUniqueCondition() {
        --this.currentDepth;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void addSelectHint(String sql) {
        this.generatedSQL.append(sql).append(" ");
    }

    public void setAsAutoGeneratedPrimaryKeyColumn() {
    }

    public void addBoolean(boolean value) {
        if (value) {
            this.generatedSQL.append("1 ");
        } else {
            this.generatedSQL.append("0 ");
        }
    }
}

