/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jeus.ejb.container.CMEntityContainer;
import jeus.ejb.container.ContainerException;
import jeus.ejb.persistence.database.PLConnection;
import jeus.ejb.schema.ClassFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB9;
import jeus.xml.binding.ejbHelper.EJBDescriptorValidationException;

public abstract class EJBFinder {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.schema.finder");
    protected String findByPrimaryKeySQL;
    public ClassFieldRW[] pkeyClassFieldRWs;
    public Method[] findMethods;
    public boolean isPkeyField;
    public Class pkeyClass;
    protected CMEntityContainer container;

    public abstract Object find(Connection var1, String var2, Object[] var3, boolean var4, boolean var5, int var6) throws Exception;

    public abstract void initFinder(EJBSQLGenerator var1) throws EJBSQLGeneratorException, EJBDescriptorValidationException;

    public abstract void setContainer(CMEntityContainer var1);

    protected void writePreparedSelectSQL(EJBSQLGenerator generator) {
        generator.sqlBuilder.initSelectSQL();
        generator.sqlBuilder.addColumnNameByFieldRW(generator.cmPkeyFieldRWs);
        generator.sqlBuilder.beginFromClause();
        generator.sqlBuilder.setTableName(generator.tableName);
        generator.sqlBuilder.finishFromClause();
        generator.sqlBuilder.mark();
    }

    public boolean checkForPrimaryKeyExistence(Object pkey, Connection con) throws ContainerException {
        boolean ret;
        try {
            PreparedStatement stat = ((PLConnection)con).prepareStatementWithType(this.findByPrimaryKeySQL, this.pkeyClassFieldRWs);
            if (this.isPkeyField) {
                this.pkeyClassFieldRWs[0].setToDBStatement(pkey, stat, 1);
            } else {
                for (int i = 0; i < this.pkeyClassFieldRWs.length; ++i) {
                    this.pkeyClassFieldRWs[i].setToDBStatement(pkey, stat, i + 1);
                }
            }
            ResultSet result = stat.executeQuery();
            ret = result.next();
            result.close();
            stat.close();
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB9._5501_LEVEL)) {
                logger.logp(JeusMessage_EJB9._5501_LEVEL, "EJBFinder", "checkForPrimaryKeyExistence", JeusMessage_EJB9._5501, pkey, ex);
            }
            throw new ContainerException(JeusMessage_EJB9._5501, pkey.toString(), ex);
        }
        return ret;
    }
}

