/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.ejbql;

import java.util.ArrayList;
import javax.ejb.EJBLocalObject;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.CMRFieldRW;
import jeus.ejb.schema.ClassFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.FieldRW;
import jeus.ejb.schema.cmp20.EJBQLHandler;
import jeus.ejb.schema.ejbql.EJBQLValidationException;
import jeus.ejb.schema.ejbql.NavigationInfo;
import jeus.ejb.schema.ejbql.VariableInfo;
import jeus.ejb.schema.ejbql.Visitor;
import jeus.ejb.schema.ejbql.element.AbstractSchemaName;
import jeus.ejb.schema.ejbql.element.AggregationFuncExpr;
import jeus.ejb.schema.ejbql.element.BetweenExpr;
import jeus.ejb.schema.ejbql.element.BinaryOperation;
import jeus.ejb.schema.ejbql.element.BinaryOperationExpr;
import jeus.ejb.schema.ejbql.element.BinaryOperator;
import jeus.ejb.schema.ejbql.element.BooleanLiteral;
import jeus.ejb.schema.ejbql.element.CMPField;
import jeus.ejb.schema.ejbql.element.CMPPathExpr;
import jeus.ejb.schema.ejbql.element.CMRField;
import jeus.ejb.schema.ejbql.element.CollectionMemberDecl;
import jeus.ejb.schema.ejbql.element.CollectionMemberExpr;
import jeus.ejb.schema.ejbql.element.CollectionValuedCMRField;
import jeus.ejb.schema.ejbql.element.CollectionValuedPathExpr;
import jeus.ejb.schema.ejbql.element.ComparisonExpr;
import jeus.ejb.schema.ejbql.element.ConcatFunc;
import jeus.ejb.schema.ejbql.element.ConditionalExprsWithLogicalOperator;
import jeus.ejb.schema.ejbql.element.CountFuncExpr;
import jeus.ejb.schema.ejbql.element.DoubleNumericLiteral;
import jeus.ejb.schema.ejbql.element.EJBQLParseException;
import jeus.ejb.schema.ejbql.element.EJBQLQuery;
import jeus.ejb.schema.ejbql.element.EJBQLSubQuery;
import jeus.ejb.schema.ejbql.element.EmptyCollectionComparisonExpr;
import jeus.ejb.schema.ejbql.element.ExistsExpr;
import jeus.ejb.schema.ejbql.element.Expression;
import jeus.ejb.schema.ejbql.element.Field;
import jeus.ejb.schema.ejbql.element.FloatNumericLiteral;
import jeus.ejb.schema.ejbql.element.FromClause;
import jeus.ejb.schema.ejbql.element.FunctionExpr;
import jeus.ejb.schema.ejbql.element.GroupByClause;
import jeus.ejb.schema.ejbql.element.HavingClause;
import jeus.ejb.schema.ejbql.element.IdentificationVar;
import jeus.ejb.schema.ejbql.element.IdentificationVarDecl;
import jeus.ejb.schema.ejbql.element.InExpr;
import jeus.ejb.schema.ejbql.element.InputParam;
import jeus.ejb.schema.ejbql.element.IntegerNumericLiteral;
import jeus.ejb.schema.ejbql.element.LikeExpr;
import jeus.ejb.schema.ejbql.element.Literal;
import jeus.ejb.schema.ejbql.element.LocateFunc;
import jeus.ejb.schema.ejbql.element.LongNumericLiteral;
import jeus.ejb.schema.ejbql.element.ModFunc;
import jeus.ejb.schema.ejbql.element.NewIdentificationVar;
import jeus.ejb.schema.ejbql.element.NullComparisonExpr;
import jeus.ejb.schema.ejbql.element.OrderByClause;
import jeus.ejb.schema.ejbql.element.OrderByItem;
import jeus.ejb.schema.ejbql.element.PathExpression;
import jeus.ejb.schema.ejbql.element.RangeVarDecl;
import jeus.ejb.schema.ejbql.element.SelectClause;
import jeus.ejb.schema.ejbql.element.SelectClauseForSubQuery;
import jeus.ejb.schema.ejbql.element.SelectHint;
import jeus.ejb.schema.ejbql.element.SingleValuedCMRField;
import jeus.ejb.schema.ejbql.element.SingleValuedCMRPathExpr;
import jeus.ejb.schema.ejbql.element.SingleValuedField;
import jeus.ejb.schema.ejbql.element.SingleValuedPathExpr;
import jeus.ejb.schema.ejbql.element.StringLiteral;
import jeus.ejb.schema.ejbql.element.SubstringFunc;
import jeus.ejb.schema.ejbql.element.UnaryArithmeticFunc;
import jeus.ejb.schema.ejbql.element.UnaryExpr;
import jeus.ejb.schema.ejbql.element.UnaryOperator;
import jeus.ejb.schema.ejbql.element.UniqueExpr;
import jeus.ejb.schema.ejbql.element.WhereClause;
import jeus.xml.binding.ejbHelper.RelationshipRolePair;

public class ValidationVisitor
extends Visitor {
    private EJBQLHandler handler;
    private EJBQLQuery query;
    private int check_parameterNum;
    private String check_funcName;
    private boolean isValidate = true;

    public ValidationVisitor(EJBQLQuery sentence, EJBQLHandler handler) {
        this.handler = handler;
        this.query = sentence;
    }

    public void validate() throws EJBQLParseException {
        this.query.accept(this);
    }

    public void visitEJBQLQuery(EJBQLQuery query) throws EJBQLParseException {
        query.from.accept(this);
        query.select.accept(this);
        if (query.where != null) {
            query.where.accept(this);
        }
        if (query.orderBy != null) {
            query.orderBy.accept(this);
        }
        if (query.groupBy != null) {
            query.groupBy.accept(this);
        }
        if (query.selectHint != null) {
            query.selectHint.accept(this);
        }
    }

    public void visitFromClause(FromClause from) throws EJBQLParseException {
        IdentificationVarDecl[] varDecls = from.getVarDecls();
        for (int i = 0; i < varDecls.length; ++i) {
            varDecls[i].accept(this);
        }
    }

    public void visitRangeVarDecl(RangeVarDecl varDecl) throws EJBQLParseException {
        varDecl.schemaName.accept(this);
        varDecl.var.accept(this);
        this.initVariableInfo(varDecl, varDecl.schemaName.beanSchema, null, varDecl.var.newVarName);
    }

    private void initVariableInfo(IdentificationVarDecl varDecl, BeanSchema variableBeanSchema, NavigationInfo info, String varName) {
        VariableInfo variableInfo = varDecl.var.getVariableInfo();
        variableInfo.setVariableDecl(varDecl);
        variableInfo.setBeanSchema(variableBeanSchema);
        variableInfo.setTableReferenceForVariable(info, varName);
        variableInfo.setTableReference(varName);
    }

    public void visitAbstractSchemaName(AbstractSchemaName abstractSchemaName) throws EJBQLValidationException {
        abstractSchemaName.beanSchema = this.handler.mSchema.getBeanSchemaForAbstractSchemaName(abstractSchemaName.schemaName);
        if (abstractSchemaName.beanSchema == null) {
            throw new EJBQLValidationException("The abstract schema " + abstractSchemaName.schemaName + "is not exists");
        }
    }

    public void visitNewIdentificationVar(NewIdentificationVar newVar) throws EJBQLValidationException {
        VariableInfo varInfo = this.query.getVariableInfo(newVar.newVarName);
        if (varInfo != null) {
            throw new EJBQLValidationException("The declared identification Variable " + newVar.newVarName + " is already declared");
        }
        if (this.handler.mSchema.isAbstractSchemaName(newVar.newVarName)) {
            throw new EJBQLValidationException("The declared identification Variable " + newVar.newVarName + " is one of abstract-schema-name ignoring case");
        }
        if (this.handler.mSchema.isBeanName(newVar.newVarName)) {
            throw new EJBQLValidationException("The declared identification Variable " + newVar.newVarName + " is one of ejb-bean name ignoring case");
        }
        varInfo = new VariableInfo();
        newVar.setVariableInfo(varInfo);
        this.query.putVariableInfo(newVar.newVarName, varInfo);
    }

    public void visitCollectionMemberDecl(CollectionMemberDecl varDecl) throws EJBQLParseException {
        ((CollectionValuedCMRField)varDecl.expr.field).setNotBranchField();
        varDecl.expr.accept(this);
        varDecl.var.accept(this);
        String varName = varDecl.var.newVarName;
        CollectionValuedCMRField field = (CollectionValuedCMRField)varDecl.expr.field;
        field.setTargetTableReference(varName);
        field.setJoinTableReference(varName + "JTRef");
        varDecl.var.getVariableInfo().addBranchField(field);
        this.initVariableInfo(varDecl, field.getTargetBeanSchema(), field.getNavigationInfo(), varName);
    }

    public void visitPathExpression(PathExpression path) throws EJBQLParseException {
        CMRField pathField;
        path.var.accept(this);
        BeanSchema fieldOwner = path.var.getBeanSchema();
        StringBuffer pathString = new StringBuffer(path.var.varName);
        for (int i = 0; i < path.fields.length; ++i) {
            SingleValuedCMRField field = path.fields[i];
            field.setFieldOwnerBeanSchema(fieldOwner);
            field.accept(this);
            pathString.append(".").append(field.fieldName);
            field.setNavigationInfo(pathString.toString());
            if (path.isBranchExpression()) {
                path.var.addBranchField(field);
            }
            fieldOwner = field.getTargetBeanSchema();
        }
        path.field.setFieldOwnerBeanSchema(fieldOwner);
        path.field.accept(this);
        pathString.append(".").append(path.field.fieldName);
        path.field.setNavigationInfo(pathString.toString());
        if (path.isBranchExpression() && path.field.isBranchField() && !(pathField = path.field instanceof SingleValuedField ? (CMRField)((SingleValuedField)path.field).getWrappedField() : (CMRField)path.field).isManagedRelation()) {
            path.var.addBranchField(pathField);
        }
    }

    public void visitIdentificationVar(IdentificationVar var) throws EJBQLValidationException {
        VariableInfo varInfo = this.query.getVariableInfo(var.varName);
        if (varInfo == null) {
            throw new EJBQLValidationException("Identification Variable " + var.varName + " is not declared");
        }
        var.setVariableInfo(varInfo);
    }

    public void visitCMRField(CMRField field) throws EJBQLParseException {
        RelationshipRolePair rd = this.handler.getDescriptorForCMRField(field.getFieldOwnerBeanSchema(), field.fieldName);
        if (rd == null) {
            throw new EJBQLValidationException("The CMR field " + field.fieldName + " does not exist in the bean " + field.getFieldOwnerBeanSchema().getBeanName());
        }
        field.setTargetBeanSchema(this.handler.getBeanSchema(rd.getTargetEJBName()));
        field.setRelationDescriptor(rd);
    }

    public void visitSingleValuedCMRField(SingleValuedCMRField field) throws EJBQLParseException {
        RelationshipRolePair rd = field.getRelationshipDescriptor();
        if (rd.isMultipleRelationType()) {
            throw new EJBQLValidationException("The CMR field " + field.fieldName + " should be single-valued field in the bean " + field.getFieldOwnerBeanSchema().getBeanName());
        }
    }

    public void visitSingleValuedField(SingleValuedField field) throws EJBQLParseException {
        CMPFieldRW fieldRW = this.handler.getCMPField(field.getFieldOwnerBeanSchema(), field.fieldName);
        if (fieldRW != null) {
            CMPField wrapped = new CMPField(field.fieldName);
            wrapped.setFieldOwnerBeanSchema(field.getFieldOwnerBeanSchema());
            wrapped.setCMPFieldRW(fieldRW);
            field.setWrappedField(wrapped);
            return;
        }
        RelationshipRolePair rd = this.handler.getDescriptorForCMRField(field.getFieldOwnerBeanSchema(), field.fieldName);
        if (rd != null) {
            if (rd.isMultipleRelationType()) {
                throw new EJBQLValidationException("The CMR field " + field.fieldName + " should be single-valued field in the bean " + field.getFieldOwnerBeanSchema().getBeanName());
            }
            SingleValuedCMRField wrapped = new SingleValuedCMRField(field.fieldName);
            wrapped.setFieldOwnerBeanSchema(field.getFieldOwnerBeanSchema());
            wrapped.setTargetBeanSchema(this.handler.getBeanSchema(rd.getTargetEJBName()));
            wrapped.setRelationDescriptor(rd);
            field.setWrappedField(wrapped);
            return;
        }
        throw new EJBQLValidationException("The field " + field.fieldName + " does not exist in the bean " + field.getFieldOwnerBeanSchema().getBeanName());
    }

    public void visitCollectionValuedCMRField(CollectionValuedCMRField field) throws EJBQLParseException {
        this.visitCMRField(field);
        RelationshipRolePair rd = field.getRelationshipDescriptor();
        if (rd.isSingleRelation()) {
            throw new EJBQLValidationException("The CMR field " + field.fieldName + " should be collection-valued field in the bean " + field.getFieldOwnerBeanSchema().getBeanName());
        }
    }

    public void visitSelectClause(SelectClause selectClause) throws EJBQLParseException {
        FieldRW frw;
        Expression[] exps;
        if (this.handler.isSet) {
            selectClause.isDistinct = true;
        }
        if ((exps = selectClause.selectColumn).length > 1) {
            for (int i = 0; i < exps.length; ++i) {
                exps[i].accept(this);
                if (exps[i].isBeanType()) {
                    throw new EJBQLValidationException("For a method whose return type is ResultSet, bean type columns are not allowed in select clause");
                }
                if (!(exps[i] instanceof CountFuncExpr)) continue;
                CountFuncExpr expr = (CountFuncExpr)exps[i];
                if (!expr.isDistinct || !expr.isCompoundPrimaryKey()) continue;
                throw new EJBQLValidationException("Do not support for result set type select clause with COUNT function of DISTINCT compound-key bean type");
            }
            if (!this.handler.isResultSet) {
                throw new EJBQLValidationException("The number of columns in select clause should be one except methods of ResultSet return type");
            }
            return;
        }
        Expression expr = exps[0];
        expr.accept(this);
        try {
            if (expr instanceof SingleValuedPathExpr) {
                Field field = ((SingleValuedField)((SingleValuedPathExpr)expr).field).getWrappedField();
                frw = field instanceof CMPField ? this.handler.createCMPFieldRW(((CMPField)field).getCMPFieldRW()) : this.handler.createCMRFieldRW(null, ((CMRField)field).getRelationshipDescriptor().getFieldRW());
            } else if (expr instanceof AggregationFuncExpr) {
                if (this.handler.isCollection || this.handler.isSet) {
                    throw new EJBQLValidationException("If an aggregation function is used in select clause, return type cannot be a Collection or Set instance");
                }
                frw = this.handler.createCMPFieldRW(this.handler.getReturnType());
            } else if (expr instanceof CountFuncExpr) {
                if (this.handler.isCollection || this.handler.isSet) {
                    throw new EJBQLValidationException("If an COUNT function is used in select clause, return type cannot be a Collection or Set instance");
                }
                frw = this.handler.createCMPFieldRW(this.handler.getReturnType());
            } else {
                frw = expr instanceof FunctionExpr ? this.handler.createCMPFieldRW(expr.getCorrespondingJavaClassType()) : this.handler.createCMRFieldRW(((IdentificationVar)expr).getBeanSchema(), null);
            }
        }
        catch (Throwable e) {
            throw new EJBQLValidationException("Error during JDBC type casting", e);
        }
        frw.setCollection(this.handler.isCollection);
        frw.setSet(this.handler.isSet);
        if (frw instanceof CMRFieldRW) {
            ((CMRFieldRW)frw).isFind = this.handler.isFind;
            ((CMRFieldRW)frw).isLocalIntf = !this.handler.isReturnTypeRemote;
        }
        this.query.setOutField(frw);
    }

    public void visitCMPField(CMPField field) throws EJBQLParseException {
        CMPFieldRW fieldRW = this.handler.getCMPField(field.getFieldOwnerBeanSchema(), field.fieldName);
        if (fieldRW == null) {
            throw new EJBQLValidationException("The CMP field " + field.fieldName + " of the bean " + field.getFieldOwnerBeanSchema().getBeanName() + " does not exist");
        }
        field.setCMPFieldRW(fieldRW);
    }

    public void visitAggregationFuncExpr(AggregationFuncExpr expr) throws EJBQLParseException {
        expr.paramExpr.accept(this);
    }

    public void visitWhereClause(WhereClause whereClause) throws EJBQLParseException {
        whereClause.whereConditionExpr.accept(this);
    }

    public void visitComparisonExpr(ComparisonExpr expr) throws EJBQLParseException {
        expr.value.accept(this);
        expr.expr.accept(this);
        if (expr.expr.getType() == 5 || expr.value.getType() == 5) {
            return;
        }
        if (!(expr.value.getType() == expr.expr.getType() || this.isArithmeticType(expr.value.getType()) && this.isArithmeticType(expr.expr.getType()))) {
            throw new EJBQLValidationException("The types of operands is not the same type : " + this.getTypeString(expr.value.getType()) + ", " + this.getTypeString(expr.expr.getType()));
        }
        if ((expr.value.getType() == 1 || expr.value.getType() == 3) && expr.oper != BinaryOperator.EQUAL && expr.oper != BinaryOperator.NOT_EQUAL) {
            throw new EJBQLValidationException("Only equality test is allowed for boolean and entity_bean values");
        }
    }

    public void visitSubstringFunc(SubstringFunc substringFunc) throws EJBQLParseException {
        substringFunc.expr1.accept(this);
        substringFunc.expr2.accept(this);
        substringFunc.expr3.accept(this);
        this.initCheckType("SUBSTRING");
        this.checkType(substringFunc.expr1, 0);
        this.checkType(substringFunc.expr2, 4);
        this.checkType(substringFunc.expr3, 4);
    }

    private boolean isArithmeticType(int type) {
        return type == 4 || type == 7 || type == 9 || type == 8 || type == 6;
    }

    private void checkType(Expression expr1, int typeString) throws EJBQLParseException {
        try {
            int type = expr1.getType();
            if (type == typeString) {
                return;
            }
            if (typeString == 4 && (type == 7 || type == 9 || type == 8 || type == 6)) {
                return;
            }
            StringBuffer errMessage = new StringBuffer("The ");
            if (this.check_parameterNum == 1) {
                errMessage.append("1st ");
            } else if (this.check_parameterNum == 2) {
                errMessage.append("2nd ");
            } else if (this.check_parameterNum == 3) {
                errMessage.append("3rd ");
            } else {
                errMessage.append(this.check_parameterNum).append("th ");
            }
            errMessage.append("parameter of ").append(this.check_funcName).append(" should be ");
            errMessage.append(this.getTypeString(typeString));
            errMessage.append(", the actual type is ");
            errMessage.append(this.getTypeString(type));
            throw new EJBQLValidationException(errMessage.toString());
        }
        finally {
            ++this.check_parameterNum;
        }
    }

    private String getTypeString(int typeString) throws EJBQLValidationException {
        switch (typeString) {
            case 4: {
                return "arithmetic type";
            }
            case 3: {
                return "entity_bean type";
            }
            case 1: {
                return "boolean type";
            }
            case 2: {
                return "datetime type";
            }
            case 0: {
                return "string type";
            }
            case 7: {
                return "BIG INT type";
            }
            case 9: {
                return "double type";
            }
            case 8: {
                return "float type";
            }
            case 6: {
                return "int type";
            }
        }
        throw new EJBQLValidationException("internal exception : unknown type");
    }

    private void initCheckType(String funcName) {
        this.check_funcName = funcName;
        this.check_parameterNum = 1;
    }

    public void visitLocateFunc(LocateFunc locateFunc) throws EJBQLParseException {
        locateFunc.expr1.accept(this);
        locateFunc.expr2.accept(this);
        this.initCheckType("LOCATE");
        this.checkType(locateFunc.expr1, 0);
        this.checkType(locateFunc.expr2, 0);
        if (locateFunc.expr3 != null) {
            locateFunc.expr3.accept(this);
            this.checkType(locateFunc.expr3, 4);
        }
    }

    public void visitUnaryArithmeticFunc(UnaryArithmeticFunc unaryArithmeticFunc) throws EJBQLParseException {
        unaryArithmeticFunc.expr.accept(this);
        this.initCheckType("unary arithmetic function");
        if (unaryArithmeticFunc.oper == UnaryOperator.LENGTH) {
            this.checkType(unaryArithmeticFunc.expr, 0);
        } else {
            this.checkType(unaryArithmeticFunc.expr, 4);
        }
    }

    public void visitModFunc(ModFunc modFunc) throws EJBQLParseException {
        modFunc.target.accept(this);
        modFunc.modSize.accept(this);
        this.initCheckType("MOD");
        this.checkType(modFunc.target, 4);
        this.checkType(modFunc.modSize, 4);
    }

    public void visitConcatFunc(ConcatFunc concatFunc) throws EJBQLParseException {
        concatFunc.expr1.accept(this);
        concatFunc.expr2.accept(this);
        this.initCheckType("CONCAT");
        this.checkType(concatFunc.expr1, 0);
        this.checkType(concatFunc.expr2, 0);
    }

    public void visitUnaryExpr(UnaryExpr unaryExpr) throws EJBQLParseException {
        unaryExpr.expr.accept(this);
        this.initCheckType("unary expression");
        this.checkType(unaryExpr.expr, 4);
    }

    public void visitBinaryOperationExpr(BinaryOperationExpr binaryOperationExpr) throws EJBQLParseException {
        binaryOperationExpr.expr1.accept(this);
        if (binaryOperationExpr.binaryOperations != null) {
            this.initCheckType("binary operation");
            for (int i = 0; i < binaryOperationExpr.binaryOperations.length; ++i) {
                BinaryOperation oper = binaryOperationExpr.binaryOperations[i];
                oper.accept(this);
                this.checkType(oper.expr2, 4);
            }
        }
    }

    public void visitBinaryOperation(BinaryOperation binaryOperation) throws EJBQLParseException {
        binaryOperation.expr2.accept(this);
    }

    public void visitCountFuncExpr(CountFuncExpr countFuncExpr) throws EJBQLParseException {
        if (countFuncExpr.countExpr != null) {
            countFuncExpr.countExpr.accept(this);
            if (countFuncExpr.isDistinct && countFuncExpr.countExpr.isCompoundPrimaryKey()) {
                ((SingleValuedPathExpr)countFuncExpr.countExpr).setNotBranchExpression();
            }
            countFuncExpr.countExpr.accept(this);
        }
    }

    public void visitBooleanLiteral(BooleanLiteral booleanLiteral) throws EJBQLParseException {
    }

    public void visitLongNumericLiteral(LongNumericLiteral longNumericLiteral) throws EJBQLParseException {
    }

    public void visitIntegerNumericLiteral(IntegerNumericLiteral integerNumericLiteral) throws EJBQLParseException {
    }

    public void visitFloatNumericLiteral(FloatNumericLiteral floatNumericLiteral) throws EJBQLParseException {
    }

    public void visitDoubleNumericLiteral(DoubleNumericLiteral doubleNumericLiteral) throws EJBQLParseException {
    }

    public void visitStringLiteral(StringLiteral stringLiteral) throws EJBQLParseException {
    }

    public void visitInputParam(InputParam inputParam) throws EJBQLParseException {
        Class[] args = this.handler.getParameterTypes();
        if (inputParam.index > this.handler.getNumberOfParameters()) {
            throw new EJBQLValidationException("The index of input param " + inputParam.index + " exceeds the number of parameters of the QL method");
        }
        try {
            Class inputClass = args[inputParam.index - 1];
            switch (inputParam.paramType) {
                case 0: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    this.setCMPFieldRWForInput(inputClass, inputParam);
                    inputParam.setCorrespondingParamClass(inputClass);
                    break;
                }
                case 1: {
                    EJBSQLGenerator generator = ((CMRField)((CollectionValuedPathExpr)inputParam.getTypeRefExpr()).field).getTargetBeanSchema().sqlGen;
                    this.setCMRFieldRWForInput(generator, inputParam, inputClass);
                    break;
                }
                case 5: {
                    Expression expr = inputParam.getTypeRefExpr();
                    if (expr instanceof FunctionExpr) {
                        this.setCMPFieldRWForInput(inputClass, inputParam);
                        inputParam.setCorrespondingParamClass(inputClass);
                        break;
                    }
                    if (expr instanceof IdentificationVar) {
                        EJBSQLGenerator generator = ((IdentificationVar)expr).getEJBSQLGenerator();
                        this.setCMRFieldRWForInput(generator, inputParam, inputClass);
                        break;
                    }
                    if (expr instanceof SingleValuedPathExpr) {
                        Field pathField = ((SingleValuedField)((SingleValuedPathExpr)expr).field).getWrappedField();
                        if (pathField instanceof CMPField) {
                            this.setCMPFieldRWForInput(inputClass, inputParam);
                            inputParam.setCorrespondingParamClass(inputClass);
                            break;
                        }
                        EJBSQLGenerator generator = ((CMRField)pathField).getTargetBeanSchema().sqlGen;
                        this.setCMRFieldRWForInput(generator, inputParam, inputClass);
                        break;
                    }
                    if (expr instanceof Literal) {
                        this.setCMPFieldRWForInput(inputClass, inputParam);
                        inputParam.setCorrespondingParamClass(inputClass);
                    }
                    break;
                }
                default: {
                    throw new EJBQLValidationException("Internal error : unknown input type");
                }
            }
        }
        catch (Throwable e) {
            throw new EJBQLValidationException("Error during validation", e);
        }
    }

    private void setCMRFieldRWForInput(EJBSQLGenerator generator, InputParam inputParam, Class inputClass) {
        CMRFieldRW frwR = new CMRFieldRW();
        frwR.keyClass = generator.pkeyClass;
        frwR.keyClassFieldRWs = generator.pkeyClassFieldRWs.toArray(ClassFieldRW.dummyArray);
        frwR.isLocalIntf = EJBLocalObject.class.isAssignableFrom(inputClass);
        this.query.addInputParamIndex(inputParam.index, frwR);
    }

    private void setCMPFieldRWForInput(Class inputClass, InputParam inputParam) throws EJBSQLGeneratorException {
        CMPFieldRW frwP = this.handler.createCMPFieldRW(inputClass);
        this.query.addInputParamIndex(inputParam.index, frwP);
    }

    public void visitCollectionMemberExpr(CollectionMemberExpr collectionMemberExpr) throws EJBQLParseException {
        collectionMemberExpr.collection.setNotBranchExpression();
        if (collectionMemberExpr.target instanceof SingleValuedCMRPathExpr) {
            ((SingleValuedCMRPathExpr)collectionMemberExpr.target).setNotBranchExpression();
        }
        collectionMemberExpr.collection.accept(this);
        collectionMemberExpr.target.accept(this);
    }

    public void visitEmptyCollectionComparisonExpr(EmptyCollectionComparisonExpr expr) throws EJBQLParseException {
        expr.expr.setNotBranchExpression();
        expr.expr.accept(this);
    }

    public void visitNullComparisonExpr(NullComparisonExpr nullComparisonExpr) throws EJBQLParseException {
        if (nullComparisonExpr.expr instanceof SingleValuedPathExpr) {
            boolean isFKeyInBeanTable;
            SingleValuedPathExpr pathExpr = (SingleValuedPathExpr)nullComparisonExpr.expr;
            pathExpr.setNotBranchExpression();
            pathExpr.accept(this);
            Field pathField = ((SingleValuedField)pathExpr.field).getWrappedField();
            boolean bl = isFKeyInBeanTable = pathField instanceof CMPField || ((CMRField)pathField).getRelationshipDescriptor().isManagedOneToOneType();
            if (isFKeyInBeanTable) {
                ((SingleValuedPathExpr)nullComparisonExpr.expr).setBranchExpression();
                pathExpr.accept(this);
            }
        } else {
            nullComparisonExpr.expr.accept(this);
        }
    }

    public void visitBetweenExpr(BetweenExpr betweenExpr) throws EJBQLParseException {
        betweenExpr.target.accept(this);
        betweenExpr.fromRange.accept(this);
        betweenExpr.toRange.accept(this);
        this.initCheckType("between expression");
        if (betweenExpr.target.getType() == 0) {
            this.checkType(betweenExpr.fromRange, 0);
            this.checkType(betweenExpr.toRange, 0);
        } else {
            this.checkType(betweenExpr.target, 4);
            this.checkType(betweenExpr.fromRange, 4);
            this.checkType(betweenExpr.toRange, 4);
        }
    }

    public void visitInExpr(InExpr inExpr) throws EJBQLParseException {
        inExpr.target.accept(this);
        if (inExpr.target.isBeanType()) {
            if (inExpr.target.isCompoundPrimaryKey()) {
                throw new EJBQLParseException("The bean of IN operator has compound primary key and it is not supported");
            }
            if (inExpr.elementsInSet.length > 1) {
                throw new EJBQLParseException("SingleValuedCMRPath expression or IdentificationVar expression is only used with subquery for IN operator");
            }
        }
        for (int i = 0; i < inExpr.elementsInSet.length; ++i) {
            inExpr.elementsInSet[i].accept(this);
            if (inExpr.target.isBeanType() && !(inExpr.elementsInSet[0] instanceof EJBQLSubQuery)) {
                throw new EJBQLParseException("SingleValuedCMRPath expression or IdentificationVar expression is only used with subquery for IN operator");
            }
            if (inExpr.elementsInSet[i] instanceof InputParam || inExpr.target.getType() == inExpr.elementsInSet[i].getType()) continue;
            throw new EJBQLParseException("The type of value in IN condition is not the same with that of operand");
        }
    }

    public void visitLikeExpr(LikeExpr likeExpr) throws EJBQLParseException {
        likeExpr.target.accept(this);
        likeExpr.pattern.accept(this);
        if (likeExpr.escapeLiteral != null) {
            likeExpr.escapeLiteral.accept(this);
        }
    }

    public void visitOrderByClause(OrderByClause orderByClause) throws EJBQLParseException {
        for (int i = 0; i < orderByClause.orderByItems.length; ++i) {
            orderByClause.orderByItems[i].accept(this);
        }
    }

    public void visitOrderByItem(OrderByItem orderByItem) throws EJBQLParseException {
        orderByItem.expr.accept(this);
        Expression[] exprs = this.query.select.selectColumn;
        if (exprs.length == 1) {
            if (exprs[0] instanceof AggregationFuncExpr) {
                throw new EJBQLValidationException("The select clause of a query using order by clause should not use aggregation function");
            }
            NavigationInfo info = exprs[0] instanceof SingleValuedPathExpr ? ((SingleValuedPathExpr)exprs[0]).getLastPathNavigationInfo() : ((IdentificationVar)exprs[0]).getNavigationInfo();
            if (!info.equals(orderByItem.expr.getLastPathNavigationInfo())) {
                throw new EJBQLValidationException("The order-by item should be an orderable cmp-field of the entity bean abstract schema type value used by the select clause");
            }
            if (exprs[0].containsExpression(orderByItem.expr)) {
                orderByItem.setAppearsInSelectClause();
            }
        }
    }

    public void visitEJBQLSubQuery(EJBQLSubQuery ejbqlSubQuery) throws EJBQLParseException {
        ejbqlSubQuery.setOuterQuery(this.query);
        this.query = ejbqlSubQuery;
        this.visitEJBQLQuery(ejbqlSubQuery);
        this.query = ejbqlSubQuery.getOuterQuery();
    }

    public void visitSelectClauseForSubQuery(SelectClauseForSubQuery selectClauseForSubQuery) throws EJBQLParseException {
        Expression expr = selectClauseForSubQuery.selectColumn[0];
        expr.accept(this);
        ((EJBQLSubQuery)this.query).setExpressionType(expr.getType());
        if (expr.isBeanType()) {
            EJBSQLGenerator generator;
            if (expr instanceof SingleValuedPathExpr) {
                CMRField field = (CMRField)((SingleValuedField)((SingleValuedPathExpr)expr).field).getWrappedField();
                generator = field.getTargetBeanSchema().sqlGen;
            } else {
                generator = ((IdentificationVar)expr).getBeanSchema().sqlGen;
            }
            if (generator.pkeyClassFieldRWs.size() > 1) {
                throw new EJBQLValidationException("If the return type of subquery is bean type, only a bean with simple primary key is allowed in select clause of subquery");
            }
        }
    }

    public void visitExistsExpr(ExistsExpr existsExpr) throws EJBQLParseException {
        existsExpr.subQuery.accept(this);
    }

    public void visitGroupByClause(GroupByClause groupByClause) throws EJBQLParseException {
        int i;
        ArrayList<Expression> selectPathExprList = new ArrayList<Expression>();
        for (int j = 0; j < this.query.select.selectColumn.length; ++j) {
            Expression selectExp = this.query.select.selectColumn[j];
            if (!selectExp.isBeanType()) {
                if (!(selectExp instanceof SingleValuedPathExpr)) continue;
                selectPathExprList.add(selectExp);
                continue;
            }
            throw new EJBQLValidationException("The select clause should not contain bean type expression when using group by clause");
        }
        for (i = 0; i < groupByClause.pathExprs.length; ++i) {
            groupByClause.pathExprs[i].accept(this);
        }
        for (i = 0; i < selectPathExprList.size(); ++i) {
            CMPField field = (CMPField)((SingleValuedField)((SingleValuedPathExpr)selectPathExprList.get((int)i)).field).getWrappedField();
            NavigationInfo info = field.getNavigationInfo();
            boolean sameExprFound = false;
            for (int j = 0; j < groupByClause.pathExprs.length; ++j) {
                CMPPathExpr groupExp = groupByClause.pathExprs[j];
                if (!info.equals(groupExp.getNavigationInfo())) continue;
                sameExprFound = true;
                break;
            }
            if (sameExprFound) continue;
            throw new EJBQLValidationException("The select clause should contain the same expression with that of group by clause : " + field.getNavigationInfo());
        }
        if (groupByClause.havingClause != null) {
            groupByClause.havingClause.accept(this);
        }
    }

    public void visitHavingClause(HavingClause havingClause) throws EJBQLParseException {
        havingClause.expr.accept(this);
    }

    public void visitUniqueExpr(UniqueExpr uniqueExpr) throws EJBQLParseException {
        uniqueExpr.subQuery.accept(this);
    }

    public void visitSelectHint(SelectHint selectHint) throws EJBQLParseException {
        selectHint.hint.accept(this);
        if (!selectHint.hint.isEnclosedBySingleQuote()) {
            throw new EJBQLValidationException("A select hint should be enclosed by single quotes");
        }
    }

    public void visitConditionalExprWithLogicalOperator(ConditionalExprsWithLogicalOperator expr) throws EJBQLParseException {
        for (int i = 0; i < expr.conditionalExprs.length; ++i) {
            expr.conditionalExprs[i].accept(this);
        }
    }

    public void validate(boolean b) throws EJBQLParseException {
        this.isValidate = b;
        this.validate();
    }
}

