/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.schema.ejbql.element;

import java.util.ArrayList;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.CMPFieldRW;
import jeus.ejb.schema.EJBSQLGenerator;
import jeus.ejb.schema.ejbql.NavigationInfo;
import jeus.ejb.schema.ejbql.VariableInfo;
import jeus.ejb.schema.ejbql.Visitor;
import jeus.ejb.schema.ejbql.element.CMPField;
import jeus.ejb.schema.ejbql.element.CMPPathExpr;
import jeus.ejb.schema.ejbql.element.CMRField;
import jeus.ejb.schema.ejbql.element.EJBQLParseException;
import jeus.ejb.schema.ejbql.element.Expression;
import jeus.ejb.schema.ejbql.element.ExpressionValue;

public class IdentificationVar
extends Expression
implements ExpressionValue {
    public String varName;
    private VariableInfo variableInfo;

    public IdentificationVar(String image) {
        this.varName = image;
    }

    public void accept(Visitor visitor) throws EJBQLParseException {
        visitor.visitIdentificationVar(this);
    }

    public void setVariableInfo(VariableInfo varInfo) {
        this.variableInfo = varInfo;
    }

    public VariableInfo getVariableInfo() {
        return this.variableInfo;
    }

    public BeanSchema getBeanSchema() {
        return this.variableInfo.getBeanSchema();
    }

    public void addBranchField(CMRField field) {
        this.variableInfo.addBranchField(field);
    }

    public String getTableReference() {
        return this.variableInfo.getTableReference();
    }

    public EJBSQLGenerator getEJBSQLGenerator() {
        return this.variableInfo.getBeanSchema().sqlGen;
    }

    public boolean isBeanType() {
        return true;
    }

    public int getType() {
        return 3;
    }

    public boolean isCompoundPrimaryKey() {
        return this.variableInfo.getBeanSchema().sqlGen.cmPkeyFieldRWs.size() > 1;
    }

    public Object clone() {
        try {
            IdentificationVar var = (IdentificationVar)super.clone();
            var.variableInfo = (VariableInfo)this.variableInfo.clone();
            return var;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public NavigationInfo getNavigationInfo() {
        return this.variableInfo.getNavigationInfo();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IdentificationVar)) {
            return false;
        }
        return this.varName.equals(((IdentificationVar)obj).varName);
    }

    public boolean containsExpression(CMPPathExpr expr) {
        CMPField field = (CMPField)expr.field;
        BeanSchema beanSchema = this.getBeanSchema();
        if (!field.fieldOwner.equals(beanSchema)) {
            return false;
        }
        ArrayList pKeyFieldRWs = beanSchema.sqlGen.cmPkeyFieldRWs;
        String colName = field.getCMPFieldRW().getColName();
        for (int i = 0; i < pKeyFieldRWs.size(); ++i) {
            if (!colName.equals(((CMPFieldRW)pKeyFieldRWs.get(i)).getColName())) continue;
            return true;
        }
        return false;
    }
}

