/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.io.File;
import java.util.ArrayList;
import jeus.ejb.util.JavaCompiler;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.ArrayUtil;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.properties.JeusAppProperties;
import jeus.util.properties.JeusAppPropertyValues;

public class EJBCompiler {
    public static final boolean isBatch = JeusAppProperties.APP_COMPILER_MODE.equalsIgnoreCase("batch");
    private String[] commonArgs;
    public static final int COMPILE_PKEY = 1;
    public static final int COMPILE_IIOP = 2;
    public static final int COMPILE_IIOP_POA = 3;
    public static final int COMPILE_INTERFACE = 4;
    public static final int COMPILE_BASE = 5;
    public static final int COMPILE_LOCAL = 6;
    public static final int COMPILE_RMI = 7;
    private boolean isKeepGenerated;
    private ArrayList iiopList = new ArrayList();
    private ArrayList iiopPoaList = new ArrayList();
    private ArrayList compileClassList = new ArrayList();
    private String[] rmiCommonArgs;
    private String outputDir;
    private String classpath;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.compiler");

    public void init(String classpath, String outputDir, boolean isKeepGenerated, ArchiveArrayClassLoader loader) {
        if (JeusAppProperties.APP_COMPILER_CLASSPATH != null) {
            classpath = classpath + File.pathSeparator + JeusAppProperties.APP_COMPILER_CLASSPATH;
        }
        this.commonArgs = new String[]{"-classpath", classpath, "-g", "-d", outputDir, "-nowarn"};
        this.rmiCommonArgs = this.commonArgs;
        this.outputDir = outputDir;
        this.classpath = classpath;
        if (JeusAppProperties.APP_COMPILER_OPTION != null) {
            this.commonArgs = (String[])ArrayUtil.concatArrays((Object[])this.commonArgs, (Object[])JeusAppPropertyValues.APP_COMPILE_ARGS);
        }
        this.isKeepGenerated = isKeepGenerated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() throws JeusException, ClassNotFoundException {
        if (isBatch && this.compileClassList.size() > 0) {
            if (logger.isLoggable(JeusMessage_EJB11._7050_LEVEL)) {
                logger.log(JeusMessage_EJB11._7050_LEVEL, JeusMessage_EJB11._7050);
            }
            Object[] sources = this.getStringArray(this.compileClassList);
            try {
                if (sources.length > 0) {
                    JavaCompiler.compile((String[])ArrayUtil.concatArrays((Object[])this.commonArgs, (Object[])sources));
                }
            }
            finally {
                if (!this.isKeepGenerated) {
                    this.cleanup_application((String[])sources);
                }
            }
        }
    }

    private String[] getStringArray(ArrayList list) {
        Object[][] strings = (String[][])list.toArray((T[])new String[list.size()][]);
        return (String[])ArrayUtil.concatArrays((Object[][])strings);
    }

    public void addCompile(int type, String[] sourceFileNames, String[] classes, boolean force) throws JeusException, ClassNotFoundException {
        if (!force && isBatch) {
            for (int i = 0; i < this.compileClassList.size(); ++i) {
                Object[] strings = (String[])this.compileClassList.get(i);
                if (!ArrayUtil.isSameArray((Object[])sourceFileNames, (Object[])strings)) continue;
                return;
            }
            this.compileClassList.add(sourceFileNames);
        } else {
            if (logger.isLoggable(JeusMessage_EJB11._7050_LEVEL)) {
                logger.log(JeusMessage_EJB11._7050_LEVEL, JeusMessage_EJB11._7050);
            }
            JavaCompiler.compile((String[])ArrayUtil.concatArrays((Object[])this.commonArgs, (Object[])sourceFileNames));
            if (!this.isKeepGenerated) {
                this.cleanup_application(sourceFileNames);
            }
        }
    }

    private void cleanup_application(String[] file) {
        for (int i = 0; i < file.length; ++i) {
            new File(file[i]).delete();
        }
    }

    public boolean hasOffendingPrefix(String p) {
        return p.startsWith("java.") || p.equals("java") || p.startsWith("com.sun.") || p.equals("com.sun") || p.startsWith("net.jini.") || p.equals("net.jini") || p.startsWith("jini.") || p.equals("jini") || p.startsWith("javax.") || p.equals("javax");
    }

    private String[] makeIIOPArgs(String[] classes, boolean isPoa) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-iiop");
        argList.add("-always");
        if (isPoa) {
            argList.add("-poa");
        }
        if (this.isKeepGenerated) {
            argList.add("-keep");
        }
        return (String[])ArrayUtil.concatArrays((Object[][])new String[][]{this.rmiCommonArgs, argList.toArray(new String[argList.size()]), classes});
    }

    public String getOutputDirectory() {
        return this.outputDir;
    }

    public String getClassPath() {
        return this.classpath;
    }

    public boolean getIsKeepGenerated() {
        return this.isKeepGenerated;
    }
}

