/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import jeus.util.JeusException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB10;
import jeus.util.message.JeusMessage_EJB12;
import jeus.util.properties.JeusEJBProperties;

public class EJBRMISocketFactory
extends RMISocketFactory {
    private static RMISocketFactory factory = RMISocketFactory.getDefaultSocketFactory();
    private int timeout = -1;
    private int backlogQ = 1024;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.rmi");

    public EJBRMISocketFactory() throws JeusException {
        try {
            String to = JeusEJBProperties.JEUS_EJB_OPERATION_TIMEOUT;
            if (to != null) {
                this.timeout = Integer.parseInt(to);
            }
            if (logger.isLoggable(JeusMessage_EJB12._9097_LEVEL)) {
                logger.log(JeusMessage_EJB12._9097_LEVEL, JeusMessage_EJB12._9097, (Object)this.timeout);
            }
        }
        catch (Throwable ex) {
            throw new JeusException(JeusMessage_EJB10._6001, ex);
        }
    }

    public EJBRMISocketFactory(int timeout) throws JeusException {
        this.timeout = timeout;
    }

    public Socket createSocket(String host, int port) throws IOException {
        if (logger.isLoggable(JeusMessage_EJB12._9098_LEVEL)) {
            logger.log(JeusMessage_EJB12._9098_LEVEL, JeusMessage_EJB12._9098, new Object[]{host, port});
        }
        try {
            Socket soc = factory.createSocket(host, port);
            if (this.timeout != -1) {
                soc.setSoTimeout(this.timeout);
            }
            return soc;
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_EJB12._9099_LEVEL)) {
                logger.log(JeusMessage_EJB12._9099_LEVEL, JeusMessage_EJB12._9099, new Object[]{host, port}, (Throwable)ex);
            }
            throw ex;
        }
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        if (logger.isLoggable(JeusMessage_EJB12._9100_LEVEL)) {
            logger.log(JeusMessage_EJB12._9100_LEVEL, JeusMessage_EJB12._9100, new Object[]{port, this.backlogQ});
        }
        try {
            return new ServerSocket(port, this.backlogQ);
        }
        catch (IOException ex) {
            if (logger.isLoggable(JeusMessage_EJB12._9101_LEVEL)) {
                logger.log(JeusMessage_EJB12._9101_LEVEL, JeusMessage_EJB12._9101, new Object[]{port, this.backlogQ}, (Throwable)ex);
            }
            throw ex;
        }
    }
}

