/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodConvertor {
    public static Vector getMethodTable(Class cl) {
        Method[] methods = cl.getDeclaredMethods();
        Vector<String> name = new Vector<String>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            name.add(MethodConvertor.getMethodDeclaration(methods[i]));
        }
        return name;
    }

    public static String getMethodDeclaration(Method m) {
        String name = m.getName() + "(";
        Class<?>[] args = m.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                name = name + ",";
            }
            name = name + MethodConvertor.getString(args[i]);
        }
        return name + ")";
    }

    public static String getMethodParamToken(String methodName, List<String> paramList) {
        StringBuffer name = new StringBuffer(methodName);
        for (int i = 0; i < paramList.size(); ++i) {
            name.append(" ").append(paramList.get(i));
        }
        return name.toString();
    }

    public static String getMethodParamToken(Method m) {
        StringBuffer name = new StringBuffer(m.getName());
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            name.append(" ").append(MethodConvertor.translateToParamType(params[i]));
        }
        return name.toString();
    }

    private static String getString(Class cl) {
        String st = new String();
        while (cl.isArray()) {
            st = st + "[]";
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            if (cl == Boolean.TYPE) {
                st = "boolean" + st;
            } else if (cl == Byte.TYPE) {
                st = "byte" + st;
            } else if (cl == Character.TYPE) {
                st = "char" + st;
            } else if (cl == Short.TYPE) {
                st = "short" + st;
            } else if (cl == Integer.TYPE) {
                st = "int" + st;
            } else if (cl == Long.TYPE) {
                st = "long" + st;
            } else if (cl == Float.TYPE) {
                st = "float" + st;
            } else if (cl == Double.TYPE) {
                st = "double" + st;
            }
        } else {
            st = cl.getName() + st;
        }
        return st;
    }

    public static String removeSlash(String name) {
        String result = name;
        while (true) {
            int idx1 = result.indexOf("/");
            int idx2 = result.indexOf(":");
            int idx = idx2 == -1 ? idx1 : (idx1 == -1 ? idx2 : (idx1 < idx2 ? idx1 : idx2));
            if (idx == -1) {
                return result;
            }
            result = result.substring(0, idx) + (result.length() - 1 == idx ? "" : result.substring(idx + 1));
        }
    }

    public static String translateToParamType(Class paramClass) {
        String classString = paramClass.getName();
        char[] className = classString.toCharArray();
        if (className[0] == '[') {
            int arrayCount = 1;
            for (int i = 1; i < className.length; ++i) {
                char c = className[i];
                if (c == '[') {
                    ++arrayCount;
                    continue;
                }
                if (c == 'B') {
                    return MethodConvertor.makeParameterType("byte", arrayCount);
                }
                if (c == 'C') {
                    return MethodConvertor.makeParameterType("char", arrayCount);
                }
                if (c == 'D') {
                    return MethodConvertor.makeParameterType("double", arrayCount);
                }
                if (c == 'F') {
                    return MethodConvertor.makeParameterType("float", arrayCount);
                }
                if (c == 'I') {
                    return MethodConvertor.makeParameterType("int", arrayCount);
                }
                if (c == 'J') {
                    return MethodConvertor.makeParameterType("long", arrayCount);
                }
                if (c == 'L') {
                    return MethodConvertor.makeParameterType(classString.substring(i + 1, classString.length() - 1), arrayCount);
                }
                if (c == 'S') {
                    return MethodConvertor.makeParameterType("short", arrayCount);
                }
                if (c != 'Z') continue;
                return MethodConvertor.makeParameterType("boolean", arrayCount);
            }
            throw new IllegalStateException("No V");
        }
        return classString;
    }

    private static String makeParameterType(String s, int arrayCount) {
        StringBuffer type = new StringBuffer(s);
        while (arrayCount > 0) {
            type.append("[]");
            --arrayCount;
        }
        return type.toString();
    }
}

