/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jeus.ejb.ejbserver.EJBServerException;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB8;
import jeus.util.properties.JeusAppProperties;

public class StringUtil {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.util");

    public static Object getObjectFromString(Class cl, String s) throws EJBServerException {
        if (cl.isArray()) {
            return StringUtil.getArrayObjectFromString(cl, s);
        }
        if (cl != String.class) {
            s = s.trim();
        }
        if (cl == Boolean.TYPE) {
            return Boolean.valueOf(s);
        }
        if (cl == Byte.TYPE) {
            return new Byte(s);
        }
        if (cl == Character.TYPE) {
            if (s.length() > 1) {
                throw new EJBServerException(JeusMessage_EJB8._5090, s);
            }
            return new Character(s.charAt(0));
        }
        if (cl == Short.TYPE) {
            return new Short(s);
        }
        if (cl == Integer.TYPE) {
            return new Integer(s);
        }
        if (cl == Long.TYPE) {
            return new Long(s);
        }
        if (cl == Float.TYPE) {
            return new Float(s);
        }
        if (cl == Double.TYPE) {
            return new Double(s);
        }
        if (cl == String.class) {
            return s;
        }
        throw new EJBServerException(JeusMessage_EJB8._5091, cl.toString());
    }

    public static Object[] getArgumentObjectsFromString(Class[] argTypes, List argsString) throws EJBServerException {
        if (argsString.size() != argTypes.length) {
            throw new JeusRuntimeException("The number of arguments does not equal to the number of argument of the method");
        }
        Object[] ret = new Object[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            Class argType = argTypes[i];
            String argValue = (String)argsString.get(i);
            ret[i] = StringUtil.getObjectFromString(argType, argValue);
        }
        return ret;
    }

    private static Object getArrayObjectFromString(Class argType, String argValue) throws EJBServerException {
        int startIndex = argValue.indexOf(123);
        int lastIndex = argValue.lastIndexOf(125);
        if (startIndex < 0 || lastIndex < 0) {
            throw new JeusRuntimeException("The argument is not a proper array expression : " + argValue);
        }
        String innerArray = argValue.substring(startIndex + 1, lastIndex);
        Class<?> elementType = argType.getComponentType();
        if (elementType.isArray()) {
            throw new JeusRuntimeException("Does not support for two or more dimensional array : " + argValue);
        }
        StringTokenizer tokenizer = new StringTokenizer(innerArray, ",");
        ArrayList<Object> array = new ArrayList<Object>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            array.add(StringUtil.getObjectFromString(elementType, token));
        }
        return array.toArray((Object[])Array.newInstance(elementType, array.size()));
    }

    public static String getStringFromInputStream(Process p) throws IOException {
        BufferedInputStream input = new BufferedInputStream(p.getInputStream(), 51200);
        BufferedInputStream errInput = new BufferedInputStream(p.getErrorStream(), 51200);
        StringBuffer strBuffer = new StringBuffer();
        byte[] buffer = new byte[51200];
        int retryCount = 0;
        while (true) {
            String msg;
            int available;
            if ((available = ((InputStream)input).available()) > 0) {
                int len = ((InputStream)input).read(buffer, 0, available);
                msg = new String(buffer, 0, len);
                strBuffer.append(msg);
                retryCount = 0;
            } else {
                available = ((InputStream)errInput).available();
                if (available > 0) {
                    int len = ((InputStream)errInput).read(buffer, 0, available);
                    msg = new String(buffer, 0, len);
                    strBuffer.append(msg);
                    retryCount = 0;
                } else {
                    ++retryCount;
                }
            }
            if (retryCount <= 0) continue;
            try {
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    throw new JeusException("Execution terminated abnormally : " + strBuffer.toString());
                }
            }
            catch (IllegalThreadStateException ex) {
                if ((long)retryCount > JeusAppProperties.EJB_REMOTE_COMPILE_WAIT_COUNT) {
                    if (logger.isLoggable(JeusMessage_EJB11._7190_LEVEL)) {
                        logger.log(JeusMessage_EJB11._7190_LEVEL, JeusMessage_EJB11._7190, (Object)String.valueOf(JeusAppProperties.EJB_REMOTE_COMPILE_WAIT_COUNT));
                    }
                    p.destroy();
                    strBuffer.append("The compiler process is forcely destroyed because of long silence");
                    break;
                }
                try {
                    Thread.sleep(JeusAppProperties.EJB_REMOTE_COMPILE_FLUSH_PERIOD);
                }
                catch (InterruptedException e) {}
                continue;
            }
            break;
        }
        return strBuffer.toString();
    }
}

