/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.webserver;

import java.io.File;
import java.net.Socket;
import jeus.ejb.webserver.WebServerException;
import jeus.util.logging.JeusLogger;

public abstract class RequestHandler {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.ejb.webserver");

    private File getRealPath(String requestURI) {
        String classPath = null;
        requestURI = requestURI.substring(requestURI.indexOf(47, 1));
        boolean isJarFtp = requestURI.endsWith(".jar");
        int pos = requestURI.lastIndexOf("___");
        if (pos != -1) {
            if (!isJarFtp) {
                int classNameSeparator = requestURI.indexOf("/", pos);
                classPath = requestURI.substring(classNameSeparator + 1);
                requestURI = requestURI.substring(0, pos);
            } else {
                requestURI = requestURI.substring(0, pos) + ".jar";
            }
        }
        String path = requestURI;
        if (classPath != null) {
            path = path + "/" + classPath;
        }
        File file = new File(path);
        return file;
    }

    public void processRequest() throws WebServerException {
        String requestURI = this.readRequest();
        File file = this.getRealPath(requestURI);
        this.writeResponse(file);
        this.finish();
    }

    public abstract void setSocket(Socket var1) throws WebServerException;

    protected abstract String readRequest() throws WebServerException;

    protected abstract void writeResponse(File var1) throws WebServerException;

    protected abstract void finish() throws WebServerException;
}

