/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import jeus.jdbc.common.JeusPooledConnection;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.ConnectionPoolManager;
import jeus.jdbc.connectionpool.DataSourceFailedException;
import jeus.jdbc.connectionpool.DataSourceWrapper;
import jeus.jdbc.connectionpool.WaitTimeoutException;
import jeus.jdbc.datasource.ClusterDSBindInfo;
import jeus.jdbc.datasource.DataSourceConstants;
import jeus.jdbc.info.ClusterDataSourceInfo;
import jeus.jndi.jns.common.PropertyReference;
import jeus.jndi.objectfactory.SerializableRefAddr;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class ClusteredConnectionPool
implements Referenceable {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    private final Vector<String> dsNameList = new Vector();
    private Hashtable env = new Hashtable();
    private Reference ref = null;
    private ClusterDataSourceInfo poolInfo;
    private DataSourceWrapper dataSourceForInfo = null;
    private DataSourceWrapper currentDataSource = null;
    private int currentTarget;
    private ReentrantReadWriteLock clusteringLock = new ReentrantReadWriteLock();

    public ClusteredConnectionPool(ClusterDSBindInfo info) {
        this.poolInfo = new ClusterDataSourceInfo(info);
    }

    public ClusteredConnectionPool() {
    }

    public void initialize(Reference ref, Hashtable env) throws ConnectionPoolException {
        this.env = env;
        this.poolInfo = (ClusterDataSourceInfo)ref.get(0).getContent();
        StringTokenizer st = new StringTokenizer(this.poolInfo.getDataSourceList(), ",");
        while (st.hasMoreTokens()) {
            String dsName = st.nextToken();
            this.dsNameList.add(dsName.trim());
        }
        for (int i = 0; i < this.dsNameList.size(); ++i) {
            DataSourceWrapper ds = this.getTargetDataSource(i);
            if (ds == null) continue;
            this.dataSourceForInfo = ds;
            this.currentDataSource = ds;
            break;
        }
        if (this.currentDataSource == null) {
            if (logger.isLoggable(JeusMessage_JDBC._321_LEVEL)) {
                logger.logp(JeusMessage_JDBC._321_LEVEL, "ClusteredConnectionPool", "initialize", JeusMessage_JDBC._321, (Object)this.poolInfo.getExportName());
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._321, (Object)this.poolInfo.getExportName()));
        }
        if (this.poolInfo.isPreConn()) {
            this.preMakeConnectionFromPool();
        }
    }

    private void preMakeConnectionFromPool() {
        InitialContext ctx;
        try {
            ctx = new InitialContext(this.env);
        }
        catch (NamingException e) {
            if (logger.isLoggable(JeusMessage_JDBC._300_LEVEL)) {
                logger.logp(JeusMessage_JDBC._300_LEVEL, "ClusteredConnectionPool", "preMakeConnectionFromPool", JeusMessage_JDBC._300, (Throwable)e);
            }
            return;
        }
        for (String dsName : this.dsNameList) {
            try {
                ctx.lookup(dsName);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_JDBC._301_LEVEL)) continue;
                logger.logp(JeusMessage_JDBC._301_LEVEL, "ClusteredConnectionPool", "preMakeConnectionFromPool", JeusMessage_JDBC._301, (Object)dsName, t);
            }
        }
    }

    private DataSourceWrapper getTargetDataSource(int target) {
        DataSourceWrapper dataSource;
        InitialContext ctx;
        try {
            ctx = new InitialContext(this.env);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JDBC._300_LEVEL)) {
                logger.logp(JeusMessage_JDBC._300_LEVEL, "ClusteredConnectionPool", "getDataSource", JeusMessage_JDBC._300, t);
            }
            return null;
        }
        String dataSourceName = this.dsNameList.get(target);
        try {
            Object result = ctx.lookup(dataSourceName);
            if (!(result instanceof DataSourceWrapper)) {
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._302, (Object[])new Object[]{dataSourceName, result}));
            }
            dataSource = (DataSourceWrapper)result;
        }
        catch (Throwable th) {
            if (logger.isLoggable(JeusMessage_JDBC._301_LEVEL)) {
                logger.logp(JeusMessage_JDBC._301_LEVEL, "ClusteredConnectionPool", "getDataSource", JeusMessage_JDBC._301, (Object)dataSourceName, th);
            }
            dataSource = null;
        }
        return dataSource;
    }

    public Connection getConnection(String username, String password, boolean shareable) throws SQLException {
        if (this.poolInfo.useLoadBalancing()) {
            return null;
        }
        if (this.poolInfo.useFailback()) {
            return this.getConnectionForFailoverAndFailback(username, password, shareable);
        }
        return this.getConnectionForFailoverOnly(username, password, shareable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnectionForFailoverOnly(String username, String password, boolean shareable) throws SQLException {
        this.clusteringLock.readLock().lock();
        ConnectionPoolImpl pool = this.currentDataSource.getConnectionPool();
        int target = this.currentTarget;
        try {
            Connection connection = pool.getConnection(username, password, shareable);
            return connection;
        }
        catch (Throwable th) {
            if (th instanceof WaitTimeoutException) {
                throw new SQLException(th.getMessage());
            }
            this.clusteringLock.readLock().unlock();
            this.clusteringLock.writeLock().lock();
            try {
                int index = target;
                while (true) {
                    index = index == this.dsNameList.size() - 1 ? 0 : ++index;
                    if (target == index) {
                        break;
                    }
                    DataSourceWrapper ds = this.getTargetDataSource(index);
                    if (ds == null || ds.getConnectionPool().isFailed()) continue;
                    try {
                        Connection con = ds.getConnection(username, password);
                        logger.log(JeusMessage_JDBC._324_LEVEL, JeusMessage_JDBC._324, (Object)this.currentDataSource.toString());
                        this.currentDataSource = ds;
                        this.currentTarget = index;
                        Connection connection = con;
                        return connection;
                    }
                    catch (Throwable th2) {
                        if (th2 instanceof WaitTimeoutException) {
                            throw new SQLException(th2.getMessage());
                        }
                        logger.logp(JeusMessage_JDBC._303_LEVEL, "ClusteredConnectionPool", "getAlternativeConnection", JeusMessage_JDBC._303, (Object)this.currentDataSource.getConnectionPool().getExportName(), th2);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.clusteringLock.readLock().lock();
                this.clusteringLock.writeLock().unlock();
            }
        }
        finally {
            this.clusteringLock.readLock().unlock();
        }
        throw new DataSourceFailedException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._304));
    }

    private Connection getConnectionForFailoverAndFailback(String username, String password, boolean shareable) throws SQLException {
        for (int i = 0; i < this.dsNameList.size(); ++i) {
            String dataSourceName = this.dsNameList.get(i);
            try {
                ConnectionPoolImpl pool = ConnectionPoolManager.getConnectionPool(dataSourceName);
                if (pool == null) {
                    DataSourceWrapper dataSource = this.getTargetDataSource(i);
                    if (dataSource == null) continue;
                    pool = dataSource.getConnectionPool();
                }
                if (pool == null || pool.isFailed()) continue;
                return pool.getConnection(username, password, shareable);
            }
            catch (Throwable th) {
                if (th instanceof WaitTimeoutException) {
                    throw new SQLException(th.getMessage());
                }
                logger.logp(JeusMessage_JDBC._305_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._305, (Object)dataSourceName);
                logger.logp(JeusMessage_JDBC._322_LEVEL, "ClusteredConnectionPool", "getConnection", JeusMessage_JDBC._322, (Object)dataSourceName, th);
            }
        }
        throw new DataSourceFailedException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._304));
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSourceForInfo.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSourceForInfo.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSourceForInfo.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.dataSourceForInfo.getLoginTimeout();
    }

    String getExportName() {
        return this.poolInfo.getExportName();
    }

    int getType() {
        return this.dataSourceForInfo.getType();
    }

    String getDriverVendorName() {
        return this.dataSourceForInfo.getDriverVendorName();
    }

    public Reference getReference() throws NamingException {
        if (this.ref == null) {
            this.ref = new PropertyReference(this.getClass().getName(), DataSourceConstants.CLUSTER_FACTORY_CLASSNAME, null);
            this.ref.add(0, new SerializableRefAddr("clustered_connectionpool_info", this.poolInfo));
        }
        return this.ref;
    }

    String getDataSourceList() {
        return this.poolInfo.getDataSourceList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failbackManually() throws ConnectionPoolException {
        block16: {
            if (this.poolInfo.useLoadBalancing()) {
                throw new ConnectionPoolException(JeusMessage_JDBC._63);
            }
            JeusPooledConnection testCon = null;
            if (this.poolInfo.useFailback()) {
                DataSourceWrapper primaryDataSource = this.getTargetDataSource(0);
                if (primaryDataSource != null) {
                    if (primaryDataSource.getConnectionPool().isFailed()) {
                        try {
                            testCon = primaryDataSource.getConnectionPool().createNewPooledConnection();
                            assert (testCon != null);
                            primaryDataSource.getConnectionPool().returnPooledConnectionDirectly(testCon);
                            primaryDataSource.getConnectionPool().changeFailedState(true, false);
                            return;
                        }
                        catch (SQLException e) {
                            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._305, (Object)this.dsNameList.get(0)), (Throwable)e);
                        }
                    }
                    throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._39, (Object)this.poolInfo.getExportName()));
                }
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._301, (Object)this.dsNameList.get(0)));
            }
            this.clusteringLock.writeLock().lock();
            int prevTarget = this.currentTarget;
            DataSourceWrapper prevDataSource = null;
            try {
                if (this.currentTarget != 0) {
                    prevDataSource = this.currentDataSource;
                    this.currentDataSource = this.getTargetDataSource(0);
                    if (this.currentDataSource != null) {
                        try {
                            testCon = this.currentDataSource.getConnectionPool().createNewPooledConnection();
                            assert (testCon != null);
                            this.currentDataSource.getConnectionPool().returnPooledConnectionDirectly(testCon);
                            this.currentTarget = 0;
                            break block16;
                        }
                        catch (SQLException e) {
                            if (prevDataSource != null) {
                                this.currentTarget = prevTarget;
                                this.currentDataSource = prevDataSource;
                            }
                            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._305, (Object)this.dsNameList.get(0)), (Throwable)e);
                        }
                    }
                    throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._301, (Object)this.dsNameList.get(0)));
                }
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._39, (Object)this.poolInfo.getExportName()));
            }
            finally {
                this.clusteringLock.writeLock().unlock();
            }
        }
    }
}

