/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import jeus.jdbc.connectionpool.ConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.ConnectionPoolInitializer;
import jeus.jdbc.info.CPInfo;
import jeus.jdbc.info.ConnectionPoolInfo;
import jeus.transaction.RecoveryThread;
import jeus.transaction.TMCommonService;
import jeus.transaction.logging.JEUSXAResourceFactory;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class ConnectionPoolManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    public static final Object sync = new Object();
    private static final Hashtable<String, ConnectionPoolImpl> pools = new Hashtable(10);
    private static ConnectionPoolInitializer poolInitializer;

    public static ConnectionPoolImpl createConnectionPool(Reference ref, Hashtable env) throws ConnectionPoolException {
        ConnectionPoolInfo poolInfo = (ConnectionPoolInfo)ref.get(0).getContent();
        String exportName = poolInfo.getExportName();
        try {
            ConnectionPoolImpl pool = pools.get(exportName);
            if (pool != null) {
                return pool;
            }
            return ConnectionPoolManager.innerCreateConnectionPool(ref, poolInfo, exportName, env);
        }
        catch (ConnectionPoolException t) {
            if (logger.isLoggable(JeusMessage_JDBC._99_LEVEL)) {
                logger.logp(JeusMessage_JDBC._99_LEVEL, "ConnectionPoolManager", "createConnectionPool", JeusMessage_JDBC._99, (Object)exportName);
            }
            throw t;
        }
    }

    public static ConnectionPoolImpl removeConnectionPool(String exportName) {
        return pools.remove(exportName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionPoolImpl innerCreateConnectionPool(Reference ref, ConnectionPoolInfo info, String exportName, Hashtable env) throws ConnectionPoolException {
        ConnectionPoolImpl pool;
        Object object = sync;
        synchronized (object) {
            pool = pools.get(exportName);
            if (pool != null) {
                return pool;
            }
            String className = ref.getClassName();
            try {
                pool = (ConnectionPoolImpl)Class.forName(className).newInstance();
                pool.initialize(ref, env);
                if (poolInitializer != null) {
                    poolInitializer.init(pool);
                }
            }
            catch (Throwable e) {
                if (logger.isLoggable(JeusMessage_JDBC._314_LEVEL)) {
                    logger.logp(JeusMessage_JDBC._314_LEVEL, "ConnectionPoolManager", "innerCreateConnectionPool", JeusMessage_JDBC._314, (Object)exportName);
                }
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._314, (Object)exportName), e);
            }
            pools.put(exportName, pool);
        }
        if (info.getPoolType() == 2) {
            try {
                TMCommonService.registerDataSource(ref, exportName);
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_JDBC._18_LEVEL)) {
                    logger.logp(JeusMessage_JDBC._18_LEVEL, "ConnectionPoolManager", "innerCreateConnectionPool", JeusMessage_JDBC._18, (Object)exportName);
                }
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._18, (Object)exportName), ex);
            }
        }
        return pool;
    }

    public static ConnectionPoolImpl getConnectionPool(String exportName) {
        return pools.get(exportName);
    }

    public static XAConnection getControlSession(Reference ref) throws ConnectionPoolException {
        ConnectionPoolInfo obj = (ConnectionPoolInfo)ref.get(0).getContent();
        XADataSource src = (XADataSource)ConnectionPoolManager.getDataSourceFromReference(obj.getDataSourceReference());
        try {
            return src.getXAConnection();
        }
        catch (Throwable ex) {
            logger.logp(JeusMessage_JDBC._5_LEVEL, "ConnectionPoolManager", "getControlSession", JeusMessage_JDBC._5);
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._5), ex);
        }
    }

    public static void timeout() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh(String poolName) throws ConnectionPoolException {
        Object object = sync;
        synchronized (object) {
            ConnectionPoolImpl pool = pools.get(poolName);
            if (pool == null) {
                if (logger.isLoggable(JeusMessage_JDBC._19_LEVEL)) {
                    logger.logp(JeusMessage_JDBC._19_LEVEL, "ConnectionPoolManager", "enableCP", JeusMessage_JDBC._19, (Object)poolName);
                }
                throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._19, (Object)poolName));
            }
            try {
                pool.refresh();
            }
            catch (Exception e) {
                throw new ConnectionPoolException("refresh failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Object object = sync;
        synchronized (object) {
            Enumeration<ConnectionPoolImpl> e = pools.elements();
            while (e.hasMoreElements()) {
                ConnectionPool pool = e.nextElement();
                pool.destroy();
                if (poolInitializer == null) continue;
                poolInitializer.destroy(pool);
            }
            pools.clear();
        }
    }

    public static Object getDataSourceFromReference(Reference ref) throws ConnectionPoolException {
        String classurl = ref.getFactoryClassLocation();
        String classname = ref.getFactoryClassName();
        try {
            Class<?> factorycl;
            if (classurl == null) {
                factorycl = JeusRootClassLoader.loader.loadClass(classname);
            } else {
                URL[] srcURL = new URL[]{new URL(ref.getFactoryClassLocation())};
                factorycl = new URLClassLoader(srcURL).loadClass(classname);
            }
            ObjectFactory factory = (ObjectFactory)factorycl.newInstance();
            return factory.getObjectInstance(ref, null, null, null);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_JDBC._6_LEVEL)) {
                logger.logp(JeusMessage_JDBC._6_LEVEL, "ConnectionPoolManager", "getDataSourceFromReference", JeusMessage_JDBC._6);
            }
            throw new ConnectionPoolException(JeusMessage_JDBC._6, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CPInfo[] getCPInfo() {
        if (logger.isLoggable(JeusMessage_JDBC._315_LEVEL)) {
            logger.log(JeusMessage_JDBC._315_LEVEL, JeusMessage_JDBC._315);
        }
        Hashtable<String, ConnectionPoolImpl> hashtable = pools;
        synchronized (hashtable) {
            CPInfo[] info = new CPInfo[pools.size()];
            int i = 0;
            Enumeration<String> e = pools.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                info[i] = ((ConnectionPool)pools.get(key)).getCPInfo();
                info[i].setName(key);
                ++i;
            }
            return info;
        }
    }

    public static void enableCP(String cpname) throws RemoteException {
        ConnectionPool pool;
        if (logger.isLoggable(JeusMessage_JDBC._316_LEVEL)) {
            logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._316);
        }
        if ((pool = (ConnectionPool)pools.get(cpname)) == null) {
            if (logger.isLoggable(JeusMessage_JDBC._19_LEVEL)) {
                logger.logp(JeusMessage_JDBC._19_LEVEL, "ConnectionPoolManager", "enableCP", JeusMessage_JDBC._19, (Object)cpname);
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._19, (Object)cpname));
        }
        pool.enable();
    }

    public static void disableCP(String cpname) throws RemoteException {
        ConnectionPool pool;
        if (logger.isLoggable(JeusMessage_JDBC._317_LEVEL)) {
            logger.log(JeusMessage_JDBC._317_LEVEL, JeusMessage_JDBC._317);
        }
        if ((pool = (ConnectionPool)pools.get(cpname)) == null) {
            if (logger.isLoggable(JeusMessage_JDBC._19_LEVEL)) {
                logger.logp(JeusMessage_JDBC._19_LEVEL, "ConnectionPoolManager", "disableCP", JeusMessage_JDBC._19, (Object)cpname);
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._19, (Object)cpname));
        }
        pool.disable();
    }

    public static void shrinkCP(String cpname) throws RemoteException {
        ConnectionPool pool;
        if (logger.isLoggable(JeusMessage_JDBC._318_LEVEL)) {
            logger.log(JeusMessage_JDBC._318_LEVEL, JeusMessage_JDBC._318);
        }
        if ((pool = (ConnectionPool)pools.get(cpname)) == null) {
            if (logger.isLoggable(JeusMessage_JDBC._19_LEVEL)) {
                logger.logp(JeusMessage_JDBC._19_LEVEL, "ConnectionPoolManager", "shrinkCP", JeusMessage_JDBC._19, (Object)cpname);
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._19, (Object)cpname));
        }
        pool.forcedShrink();
    }

    public static void resyncCP(String cpname) throws RemoteException {
        if (logger.isLoggable(JeusMessage_JDBC._319_LEVEL)) {
            logger.log(JeusMessage_JDBC._319_LEVEL, JeusMessage_JDBC._319);
        }
        ConnectionPool pool = pools.get(cpname);
        try {
            if (pool == null) {
                throw new RemoteException("To resync datasource, the datasource should be initiated.");
            }
            if (pool.getType() != 2) {
                return;
            }
            Reference ref = pool.getReference();
            RecoveryThread t = new RecoveryThread(new JEUSXAResourceFactory(ref));
            t.setDaemon(true);
            t.start();
            if (logger.isLoggable(JeusMessage_JDBC._94_LEVEL)) {
                logger.log(JeusMessage_JDBC._94_LEVEL, JeusMessage_JDBC._94, (Object)cpname);
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JDBC._95_LEVEL)) {
                logger.logp(JeusMessage_JDBC._95_LEVEL, "ConnectionPoolManager", "resyncCP", JeusMessage_JDBC._95, (Object)cpname);
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._95, (Object)cpname), t);
        }
    }

    public static void updateCP(String cpname, Hashtable properties) throws RemoteException {
        ConnectionPool pool;
        if (logger.isLoggable(JeusMessage_JDBC._320_LEVEL)) {
            logger.log(JeusMessage_JDBC._320_LEVEL, JeusMessage_JDBC._320);
        }
        if ((pool = (ConnectionPool)pools.get(cpname)) == null) {
            if (logger.isLoggable(JeusMessage_JDBC._19_LEVEL)) {
                logger.logp(JeusMessage_JDBC._19_LEVEL, "ConnectionPoolManager", "updateCP", JeusMessage_JDBC._19, (Object)cpname);
            }
            throw new ConnectionPoolException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._19, (Object)cpname));
        }
        pool.update(properties);
    }

    public static void enableAll() {
        logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._316);
        ConnectionPool[] poolList = pools.values().toArray(new ConnectionPool[pools.size()]);
        for (int i = 0; i < poolList.length; ++i) {
            poolList[i].enable();
        }
    }

    public static void disableAll() {
        logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._317);
        ConnectionPool[] poolList = pools.values().toArray(new ConnectionPool[pools.size()]);
        for (int i = 0; i < poolList.length; ++i) {
            poolList[i].disable();
        }
    }

    public static void shrinkAll() {
        logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._318);
        ConnectionPool[] poolList = pools.values().toArray(new ConnectionPool[pools.size()]);
        for (int i = 0; i < poolList.length; ++i) {
            poolList[i].forcedShrink();
        }
    }

    public static void resyncAll() throws RemoteException {
        logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._319);
        ConnectionPool[] poolList = pools.values().toArray(new ConnectionPool[pools.size()]);
        for (int i = 0; i < poolList.length; ++i) {
            ConnectionPoolManager.resyncCP(poolList[i].getExportName());
        }
    }

    public static String[] updateAll(Hashtable properties) {
        logger.log(JeusMessage_JDBC._316_LEVEL, JeusMessage_JDBC._320);
        ArrayList<String> failed = new ArrayList<String>();
        ConnectionPool[] poolList = pools.values().toArray(new ConnectionPool[pools.size()]);
        for (int i = 0; i < poolList.length; ++i) {
            try {
                poolList[i].update(properties);
                continue;
            }
            catch (ConnectionPoolException e) {
                failed.add(poolList[i].getExportName());
            }
        }
        return failed.toArray(new String[failed.size()]);
    }

    public static void setPoolInitializer(ConnectionPoolInitializer serverConnectionPoolInitializer) {
        poolInitializer = serverConnectionPoolInitializer;
    }
}

