/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.sql.SQLException;
import jeus.jdbc.common.JeusConnectionImpl;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.trace.ManagedResource;

public class JDBCResource
implements ManagedResource {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus");
    private final JeusConnectionImpl connection;

    public JDBCResource(JeusConnectionImpl connection) {
        this.connection = connection;
    }

    public void close() throws SQLException {
        if (!this.connection.isClosed()) {
            if (logger.isLoggable(JeusMessage_Manager1._410_LEVEL)) {
                logger.log(JeusMessage_Manager1._410_LEVEL, JeusMessage_Manager1._410, (Object)this.connection.toString());
            }
            this.connection.close();
        }
    }

    public String toString() {
        StringBuffer strBuffer = new StringBuffer(256);
        strBuffer.append(this.connection.toString());
        Throwable trace = this.connection.getConnectionTrace();
        if (trace != null) {
            strBuffer.append(ConnectionPoolImpl.getConnectionTraceAsString(trace));
        }
        return strBuffer.toString();
    }
}

