/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.connectionpool;

import java.io.IOException;
import javax.annotation.Resource;
import jeus.ejb.io.SerializableObjectFactory;
import jeus.jdbc.connectionpool.ClusterDataSourceFactory;
import jeus.jdbc.connectionpool.ClusterDataSourceWrapper;
import jeus.jdbc.connectionpool.ClusteredConnectionPool;
import jeus.jdbc.connectionpool.ConnectionPoolImpl;
import jeus.jdbc.connectionpool.ConnectionPoolManager;
import jeus.jdbc.connectionpool.DataSourceWrapper;

public class SerializableDataSourceFactory
implements SerializableObjectFactory {
    private static final long serialVersionUID = 60L;
    private boolean isClustered;
    private String exportName;
    private boolean shareable;
    private Resource.AuthenticationType resAuthType;

    public SerializableDataSourceFactory(DataSourceWrapper obj) {
        this.exportName = obj.getConnectionPool().getExportName();
        this.shareable = obj.isShareable();
        this.resAuthType = obj.getAuthenticationType();
    }

    public SerializableDataSourceFactory(ClusterDataSourceWrapper obj) {
        this.exportName = obj.getConnectionPool().getExportName();
        this.isClustered = true;
    }

    public Object createObject() throws IOException {
        if (this.isClustered) {
            ClusteredConnectionPool cp = ClusterDataSourceFactory.getClusteredConnectionPool(this.exportName);
            return new ClusterDataSourceWrapper(cp, this.shareable, this.resAuthType);
        }
        ConnectionPoolImpl cp = ConnectionPoolManager.getConnectionPool(this.exportName);
        return new DataSourceWrapper(cp, this.shareable, this.resAuthType);
    }
}

