/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.datasource;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import jeus.descriptor.jeusserver.ConnectorProperty;
import jeus.jdbc.common.DBMSType;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JDBC;

public class DBDSBindInfo
implements Serializable {
    private static final long serialVersionUID = 60L;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jdbc");
    public static final int DS = 0;
    public static final int CPDS = 1;
    public static final int XADS = 2;
    public static final int LOCALXADS = 3;
    public static final int CLUSTER = 4;
    private String vendor = "";
    private String exportName = "";
    private String dataSourceClassName = "";
    public Vector properties = new Vector();
    private int datasourceType;
    private int min = 2;
    private int max = 10;
    private int step = 1;
    private long resizingPeriod = 1800000L;
    private long idleTimeout;
    private boolean waiting;
    private long waitingTime = 10000L;
    private boolean delegationRequired;
    private String nullTxDelegate = "";
    private int maxUseCount;
    private boolean dbaRequired;
    private String dbaDelegate = "";
    private int dbaTO = -1;
    private String checkQuery;
    private String backupDeletage = "";
    private int stmtCachingSize = -1;
    private int fetchSize = -1;
    private boolean useAutoCommitSetting;
    private boolean autoCommitValue;
    private String checkQueryClass;
    private long checkQueryPeriod;
    private String userName;
    private long stmtQueryTo = 0L;
    private boolean useConnectionTrace;
    private long nonValidationInterval;
    private boolean keepConnectionHandleOpen;
    public static final String PR_DATABASE_NAME = "DatabaseName";
    public static final String PR_DATA_SOURCE_NAME = "DataSourceName";
    public static final String PR_SERVICE_NAME = "ServiceName";
    public static final String PR_DESCRIPTION = "Description";
    public static final String PR_NETWORK_PROTOCOL = "NetworkProtocol";
    public static final String PR_PASSWORD = "Password";
    public static final String PR_PORT_NUMBER = "PortNumber";
    public static final String PR_SERVER_NAME = "ServerName";
    public static final String PR_USER = "User";
    public static final String PR_DRIVER_TYPE = "DriverType";

    public void validate() throws JeusException {
        if (this.exportName.equals("")) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._44);
            }
            throw new JeusException(JeusMessage_JDBC._44);
        }
        if (this.vendor.equals("")) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._45, (Object)this.exportName);
            }
            throw new JeusException(JeusMessage_JDBC._45, (Object)this.exportName);
        }
        if (this.dataSourceClassName.equals("")) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._100, (Object)this.exportName);
            }
            throw new JeusException(JeusMessage_JDBC._100, (Object)this.exportName);
        }
        DBMSType dbmsType = DBMSType.getType(this.vendor);
        if (dbmsType == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._46, (Object[])new String[]{this.exportName, this.vendor});
            }
            throw new JeusException(JeusMessage_JDBC._46, (Object[])new String[]{this.exportName, this.vendor});
        }
        Enumeration e = this.properties.elements();
        while (e.hasMoreElements()) {
            ((ConnectorProperty)e.nextElement()).validate();
        }
        if (this.min < 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._47, (Object[])new String[]{this.exportName, Integer.toString(this.min)});
            }
            throw new JeusException(JeusMessage_JDBC._47, (Object[])new String[]{this.exportName, Integer.toString(this.min)});
        }
        if (0 >= this.max || this.min > this.max) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._48, (Object[])new String[]{this.exportName, Integer.toString(this.max)});
            }
            throw new JeusException(JeusMessage_JDBC._48, (Object[])new String[]{this.exportName, Integer.toString(this.max)});
        }
        if (this.step == 0) {
            if (this.min != this.max) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._56, (Object[])new String[]{this.exportName, Integer.toString(this.step)});
                }
                throw new JeusException(JeusMessage_JDBC._56, (Object[])new String[]{this.exportName, Integer.toString(this.step)});
            }
        } else if (this.step < 1 || this.step > this.max) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._49, (Object[])new String[]{this.exportName, Integer.toString(this.step)});
            }
            throw new JeusException(JeusMessage_JDBC._49, (Object[])new String[]{this.exportName, Integer.toString(this.step)});
        }
        if (this.resizingPeriod < 0L) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._50, (Object[])new String[]{this.exportName, Long.toString(this.resizingPeriod)});
            }
            throw new JeusException(JeusMessage_JDBC._50, (Object[])new String[]{this.exportName, Long.toString(this.resizingPeriod)});
        }
        if (this.resizingPeriod < 1000L) {
            if (logger.isLoggable(JeusMessage_JDBC._57_LEVEL)) {
                logger.logp(JeusMessage_JDBC._57_LEVEL, "DBDSBindInfo", "validate", JeusMessage_JDBC._57, (Object[])new String[]{this.exportName});
            }
            this.resizingPeriod = 1000L;
        }
        if (this.waiting && this.waitingTime < 0L) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._51, (Object[])new String[]{this.exportName, Long.toString(this.waitingTime)});
            }
            throw new JeusException(JeusMessage_JDBC._51, (Object[])new String[]{this.exportName, Long.toString(this.waitingTime)});
        }
        if (this.maxUseCount < 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "DBDSBindInfo", "validate", JeusMessage_JDBC._53, (Object[])new String[]{this.exportName, Integer.toString(this.maxUseCount)});
            }
            throw new JeusException(JeusMessage_JDBC._53, (Object[])new String[]{this.exportName, Integer.toString(this.maxUseCount)});
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String s) {
        this.vendor = s;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String s) {
        this.exportName = s;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String s) {
        this.dataSourceClassName = s;
    }

    public int getDataSourceType() {
        return this.datasourceType;
    }

    public void setDataSourceType(int t) {
        this.datasourceType = t;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int i) {
        this.min = i;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int i) {
        this.max = i;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int i) {
        this.step = i;
    }

    public long getResizingPeriod() {
        return this.resizingPeriod;
    }

    public void setResizingPeriod(long l) {
        this.resizingPeriod = l;
    }

    public boolean getWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean b) {
        this.waiting = b;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(long l) {
        this.waitingTime = l;
    }

    public boolean isDelegationRequired() {
        return this.delegationRequired;
    }

    public void setDelegationRequired(boolean b) {
        this.delegationRequired = b;
    }

    public String getNullTxDelegate() {
        return this.nullTxDelegate;
    }

    public void setNullTxDelegate(String s) {
        this.nullTxDelegate = s;
    }

    public void setMaxUseCount(int count) {
        this.maxUseCount = count;
    }

    public int getMaxUseCount() {
        return this.maxUseCount;
    }

    public boolean isDBARequired() {
        return this.dbaRequired;
    }

    public void setDBARequired(boolean b) {
        this.dbaRequired = b;
    }

    public String getDBADelegate() {
        return this.dbaDelegate;
    }

    public void setDBADelegate(String s) {
        this.dbaDelegate = s;
    }

    public void setCheckQuery(String s) {
        this.checkQuery = s;
    }

    public String getCheckQuery() {
        if (this.checkQuery != null && this.checkQuery.equals("")) {
            this.checkQuery = null;
        }
        return this.checkQuery;
    }

    public int getDbaTO() {
        return this.dbaTO;
    }

    public void setDbaTO(int dbaTO) {
        this.dbaTO = dbaTO;
    }

    public String getBackupDelegate() {
        return this.backupDeletage;
    }

    public void setBackupDelegate(String a) {
        this.backupDeletage = a;
    }

    public void setStmtCachingSize(int b) {
        this.stmtCachingSize = b;
    }

    public int getStmtCachingSize() {
        return this.stmtCachingSize;
    }

    public String toString() {
        return this.exportName + "(" + this.dataSourceClassName + ")";
    }

    public void setDataSourceType(String value) {
        this.datasourceType = DBDSBindInfo.getDataSourceType(value);
    }

    public static int getDataSourceType(String value) {
        if (value != null && value.equalsIgnoreCase("DataSource")) {
            return 0;
        }
        if (value != null && value.equalsIgnoreCase("ConnectionPoolDataSource")) {
            return 1;
        }
        if (value != null && value.equalsIgnoreCase("XADataSource")) {
            return 2;
        }
        if (value != null && value.equalsIgnoreCase("LocalXADataSource")) {
            return 3;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, "DBDSBindInfo", "getDataSourceType", JeusMessage_JDBC._331);
        }
        throw new JeusRuntimeException(JeusMessage_JDBC._331, (Object)value);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int size) {
        this.fetchSize = size;
    }

    public boolean isUseAutoCommitSetting() {
        return this.useAutoCommitSetting;
    }

    public void setUseAutoCommitSetting(boolean useAutoCommitSetting) {
        this.useAutoCommitSetting = useAutoCommitSetting;
    }

    public void setAutoCommitValue(boolean autoCommitValue) {
        this.autoCommitValue = autoCommitValue;
    }

    public boolean getAutoCommitValue() {
        return this.autoCommitValue;
    }

    public void setCheckQueryClassName(String checkQueryClass) {
        this.checkQueryClass = checkQueryClass;
    }

    public String getCheckQueryClassName() {
        return this.checkQueryClass;
    }

    public void setCheckQueryPeriod(long checkQueryPeriod) {
        this.checkQueryPeriod = checkQueryPeriod;
    }

    public long getCheckQueryPeriod() {
        return this.checkQueryPeriod;
    }

    public void setUser(String user) {
        this.userName = user;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setStmtQueryTimeout(Long stmtQueryTimeout) {
        this.stmtQueryTo = stmtQueryTimeout;
    }

    public long getStmtQueryTimeout() {
        return this.stmtQueryTo;
    }

    public boolean getUseConnectionTrace() {
        return this.useConnectionTrace;
    }

    public void setUseConnectionTrace(boolean useConnectionTrace) {
        this.useConnectionTrace = useConnectionTrace;
    }

    public long getNonValidationInterval() {
        return this.nonValidationInterval;
    }

    public void setNonValidationInterval(long nonValidationInterval) {
        this.nonValidationInterval = nonValidationInterval;
    }

    public boolean isKeepConnectionHandleOpen() {
        return this.keepConnectionHandleOpen;
    }

    public void setKeepConnectionHandleOpen(boolean keepConnectionHandleOpen) {
        this.keepConnectionHandleOpen = keepConnectionHandleOpen;
    }

    public void addDBPropertyValue(String givenName, String value) {
        if (givenName == null || givenName.trim().equals("")) {
            return;
        }
        if (value == null || value.trim().equals("")) {
            return;
        }
        this.addDBPropertyValue(givenName, value, givenName.equals(PR_PORT_NUMBER) ? "java.lang.Integer" : "java.lang.String");
    }

    public void addDBPropertyValue(String givenName, String value, String type) {
        ConnectorProperty citem = new ConnectorProperty();
        citem.setName(givenName);
        citem.setType(type);
        citem.setValue(value);
        this.properties.add(citem);
    }

    public List getProperties() {
        return this.properties;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }
}

