/*
 * Decompiled with CFR 0.152.
 */
package jeus.jdbc.driver.blackbox;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import jeus.jdbc.driver.blackbox.BlackboxPooledConnection;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JDBC;
import jeus.util.properties.JeusJDBCProperties;

public final class BlackboxConnection
implements Connection {
    private Connection con;
    private BlackboxPooledConnection pcon;
    private boolean closed = false;

    public BlackboxConnection(Connection con, BlackboxPooledConnection pcon) {
        this.con = con;
        this.pcon = pcon;
    }

    public Statement createStatement() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.createStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.prepareStatement(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.prepareCall(sql);
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            System.out.println("***** JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE : " + JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE);
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.getAutoCommit();
    }

    public void commit() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.commit();
    }

    public void rollback() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.rollback();
    }

    public synchronized void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.pcon.innerClosed();
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.setTransactionIsolation(level);
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.clearWarnings();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public Map getTypeMap() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.setTypeMap(map);
    }

    public void setHoldability(int holdability) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        this.con.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.closed && !JeusJDBCProperties.ENABLE_USE_AFTER_CLOSE) {
            throw new SQLException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JDBC._213));
        }
        return this.con.prepareStatement(sql, columnNames);
    }

    public void closePhysicalConnection() {
        this.pcon.innerErrorOccurred();
    }
}

